/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import java.util.ArrayList;
import java.util.List;
import minechess.common.AchievementHandler;
import minechess.common.EntityKing;
import minechess.common.EntityKnight;
import minechess.common.EntityPawn;
import minechess.common.EntityPickyXPOrb;
import minechess.common.EntityRook;
import minechess.common.ItemPieceMover;
import minechess.common.MineChess;
import minechess.common.MineChessUtils;
import minechess.common.ai.ChessMove;
import minechess.common.ai.ChessPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class EntityBaseChessPiece
extends EntityLiving {
    private static final ResourceLocation RESOURCE_WHITE_PIECE = new ResourceLocation("chessmod:textures/entities/white.png");
    private static final ResourceLocation RESOURCE_BLACK_PIECE = new ResourceLocation("chessmod:textures/entities/black.png");
    public boolean isBlackTurn = false;
    public boolean firstMove = true;
    public boolean isCapturing = false;
    public boolean enPassantPossibility = false;
    public boolean resignConfirmed = false;
    public boolean computerPiece = false;
    public boolean turnToMobOnDeath = false;
    public boolean solvedPuzzle = true;
    private boolean offsetNeedsUpdate = false;
    public int mateInTimes = -1;
    public int targetX = 0;
    public int targetY = 0;
    public int targetZ = 0;
    public int xOffset = 0;
    public int zOffset = 0;
    public int deathTimer = -1;
    private static final int X_OFFSET_DATAWATCHER_ID = 28;
    private static final int Z_OFFSET_DATAWATCHER_ID = 29;
    private static final int IS_BLACK_DATAWATCHER_ID = 30;
    private EntityPlayer playerLoser = null;
    private float moveSpeed = 0.05f;

    public EntityBaseChessPiece(World par1World) {
        super(par1World);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)new Byte(1));
        this.field_70180_af.func_75682_a(28, (Object)new Integer(this.xOffset));
        this.field_70180_af.func_75682_a(29, (Object)new Integer(this.zOffset));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    public ResourceLocation getTexture() {
        if (this.isBlack()) {
            return RESOURCE_BLACK_PIECE;
        }
        return RESOURCE_WHITE_PIECE;
    }

    public void func_70626_be() {
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.moveSpeed = 0.1f;
        this.offsetNeedsUpdate = true;
    }

    public void setPositionAndOffset(double x, double y, double z) {
        this.func_70107_b(x, y, z);
        this.xOffset = MathHelper.func_76128_c((double)x);
        this.zOffset = MathHelper.func_76128_c((double)z);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76355_l() == "outOfWorld") {
            return super.func_70097_a(par1DamageSource, par2);
        }
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void setIsBlack(boolean isBlack) {
        this.field_70180_af.func_75692_b(30, (Object)new Byte((byte)(isBlack ? 1 : 0)));
    }

    public boolean isBlack() {
        return this.field_70180_af.func_75683_a(30) == 1;
    }

    public int getXOffset() {
        return this.field_70180_af.func_75679_c(28);
    }

    public int getZOffset() {
        return this.field_70180_af.func_75679_c(29);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("isBlackTurn", this.isBlackTurn);
        compound.func_74757_a("isBlack", this.isBlack());
        compound.func_74757_a("isCapturing", this.isCapturing);
        compound.func_74757_a("firstMove", this.firstMove);
        compound.func_74757_a("enPasse", this.enPassantPossibility);
        compound.func_74757_a("computerPiece", this.computerPiece);
        compound.func_74757_a("solvedPuzzle", this.solvedPuzzle);
        compound.func_74768_a("targetX", this.targetX);
        compound.func_74768_a("targetY", this.targetY);
        compound.func_74768_a("targetZ", this.targetZ);
        compound.func_74768_a("xOffset", this.xOffset);
        compound.func_74768_a("zOffset", this.zOffset);
        compound.func_74768_a("deathTimer", this.deathTimer);
        compound.func_74768_a("mateInTimes", this.mateInTimes);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.isBlackTurn = compound.func_74767_n("isBlackTurn");
        this.firstMove = compound.func_74767_n("firstMove");
        this.isCapturing = compound.func_74767_n("isCapturing");
        this.enPassantPossibility = compound.func_74767_n("enPasse");
        this.computerPiece = compound.func_74767_n("computerPiece");
        this.solvedPuzzle = compound.func_74767_n("solvedPuzzle");
        this.targetX = compound.func_74762_e("targetX");
        this.targetY = compound.func_74762_e("targetY");
        this.targetZ = compound.func_74762_e("targetZ");
        this.xOffset = compound.func_74762_e("xOffset");
        this.zOffset = compound.func_74762_e("zOffset");
        this.setIsBlack(compound.func_74767_n("isBlack"));
        this.deathTimer = compound.func_74762_e("deathTimer");
        this.mateInTimes = compound.func_74762_e("mateInTimes");
    }

    public void setTargetPosition(int x, int z) {
        this.targetX = x;
        this.targetY = (int)this.field_70163_u;
        this.targetZ = z;
    }

    public int[] getTargetPosition() {
        int[] target = new int[]{this.targetX, this.targetZ};
        return target;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == MineChess.itemPieceMover && player.field_71071_by.func_70448_g().func_77960_j() < 2) {
            EntityBaseChessPiece entitySelected = ItemPieceMover.getEntitySelected(player.field_70170_p, player.func_71045_bC());
            if (entitySelected != null && this.isBlack() ^ entitySelected.isBlack()) {
                if (!this.field_70170_p.field_72995_K) {
                    if (!this.getEnemyPiece().computerPiece) {
                        this.setLosingPlayer(player, this.isBlack());
                    }
                    entitySelected.tryToGoTo(this.targetX, this.targetZ, player);
                }
            } else {
                if (player.field_71071_by.func_70448_g().func_77960_j() == 0 && this.isBlack() || player.field_71071_by.func_70448_g().func_77960_j() == 1 && !this.isBlack()) {
                    if (this.computerPiece && !this.field_70170_p.field_72995_K) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.error.computerPiece", EnumChatFormatting.RED.toString());
                        return false;
                    }
                    if (!this.field_70170_p.field_72995_K && this instanceof EntityKing && player.func_70093_af()) {
                        if (this.resignConfirmed) {
                            this.setLosingPlayer(player, true);
                            this.setLosingPlayer(player, false);
                            MineChessUtils.sendUnlocalizedMessage(player, "message.player.youSurrender" + (this.isBlack() ? "WhiteWon" : "BlackWon"), EnumChatFormatting.RED.toString());
                            this.sendChatToNearbyPlayers(player, "message.broadcast." + (this.isBlack() ? "blackSurrender" : "whiteSurrender"), EnumChatFormatting.DARK_GREEN.toString());
                            this.setDeathTimer(!this.isBlack());
                        } else {
                            MineChessUtils.sendUnlocalizedMessage(player, "message.player.confirmSurrender");
                            this.resignConfirmed = true;
                        }
                        return false;
                    }
                    this.resignConfirmed = false;
                    if (!this.field_70170_p.field_72995_K) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.player.selectPiece", EnumChatFormatting.DARK_AQUA.toString(), "entity." + EntityList.func_75621_b((Entity)this) + ".name");
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.updateClient(this.getValidMoves(), player, this.func_145782_y());
                    }
                    return false;
                }
                if (!this.field_70170_p.field_72995_K) {
                    MineChessUtils.sendUnlocalizedMessage(player, "message.error.notYourPiece", EnumChatFormatting.RED.toString());
                }
            }
        } else if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() == MineChess.itemPieceMover && player.field_71071_by.func_70448_g().func_77960_j() == 4) {
            if (!this.computerPiece) {
                EntityBaseChessPiece enemy = this.getEnemyPiece();
                if (enemy != null && enemy.mateInTimes < 0) {
                    this.setMateTimes(-1);
                    this.setComputerPiece(true);
                    if (!this.field_70170_p.field_72995_K) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.player.transform" + (this.isBlack() ? "BlackAI" : "WhiteAI"), EnumChatFormatting.DARK_BLUE.toString());
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    MineChessUtils.sendUnlocalizedMessage(player, "message.error.aiPuzzle", EnumChatFormatting.RED.toString());
                }
            } else if (!this.field_70170_p.field_72995_K) {
                MineChessUtils.sendUnlocalizedMessage(player, "message.error.alreadyAI", EnumChatFormatting.RED.toString());
            }
        } else if (!this.field_70170_p.field_72995_K) {
            MineChessUtils.sendUnlocalizedMessage(player, "message.error.noPieceMover", EnumChatFormatting.RED.toString());
        }
        return false;
    }

    public void setLosingPlayer(EntityPlayer player, boolean isBlack) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            if (pieces.get(i).isBlack() != isBlack) continue;
            pieces.get((int)i).playerLoser = player;
        }
    }

    private void updateClient(List<int[]> validMoves, EntityPlayer player, int entityID) {
        ItemPieceMover.setEntitySelected(entityID, player.func_71045_bC());
        ItemPieceMover.setRenderTiles(validMoves, this.targetY - 1, player.func_71045_bC());
    }

    public void sendChatToNearbyPlayers(EntityPlayer playerToExclude, String chatMessage) {
        this.sendChatToNearbyPlayers(playerToExclude, chatMessage, EnumChatFormatting.WHITE.toString());
    }

    private List<EntityPlayer> getNearbyPlayers() {
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(this.xOffset - 5), (double)((int)this.field_70163_u - 5), (double)(this.zOffset - 5), (double)(this.xOffset + 13), (double)(this.field_70163_u + 8.0), (double)(this.zOffset + 13));
        return this.field_70170_p.func_72872_a(EntityPlayer.class, bbBox);
    }

    public void sendChatToNearbyPlayers(EntityPlayer playerToExclude, String chatMessage, String ... replacements) {
        List<EntityPlayer> players = this.getNearbyPlayers();
        for (int i = 0; i < players.size(); ++i) {
            if (playerToExclude != null && players.get(i) == playerToExclude) continue;
            MineChessUtils.sendUnlocalizedMessage(players.get(i), chatMessage, replacements);
        }
    }

    public boolean tryToGoTo(int x, int z, EntityPlayer player) {
        if (this.field_70128_L) {
            MineChessUtils.sendUnlocalizedMessage(player, "message.error.pieceCaptured", EnumChatFormatting.RED.toString());
            return false;
        }
        if (this.isPawnAwaitingPromotion()) {
            if (player != null) {
                MineChessUtils.sendUnlocalizedMessage(player, "message.error.pawnAwaitingPromotion", EnumChatFormatting.RED.toString());
            }
        } else if (this.isBlack() == this.isBlackTurn && !this.isPieceCapturing()) {
            if (this.canGoTo(x, z, true, player)) {
                EntityBaseChessPiece pieceToBeCaptured = this.getPieceAt(x, z);
                int oldX = this.targetX;
                int oldZ = this.targetZ;
                this.setTargetPosition(x, z);
                if (pieceToBeCaptured != null) {
                    pieceToBeCaptured.setTargetPosition(10, 10);
                }
                boolean kingInDanger = this.isKingInDanger(this.isBlack(), true);
                if (pieceToBeCaptured != null) {
                    pieceToBeCaptured.setTargetPosition(x, z);
                }
                if (kingInDanger) {
                    this.setTargetPosition(oldX, oldZ);
                    this.isCapturing = false;
                    if (player != null) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.error.kingInCheck", EnumChatFormatting.RED.toString());
                    }
                    return false;
                }
                if (!this.handleCastling(player)) {
                    this.setTargetPosition(oldX, oldZ);
                    return false;
                }
                this.clearEnPassant();
                this.enPassantPossibility = this instanceof EntityPawn && this.firstMove && (this.targetZ == 3 || this.targetZ == 4);
                this.firstMove = false;
                if (this instanceof EntityKnight) {
                    this.field_70181_x = 0.8;
                }
                if (player != null) {
                    MineChessUtils.sendUnlocalizedMessage(player, "message.player.movePiece", EnumChatFormatting.DARK_GREEN.toString(), "entity." + EntityList.func_75621_b((Entity)this) + ".name", this.getColumnName(x) + (z + 1));
                    AchievementHandler.giveAchievement(player, "movePiece");
                }
                this.sendChatToNearbyPlayers(player, "message.broadcast.move" + (this.isBlack() ? "BlackPiece" : "WhitePiece"), EnumChatFormatting.DARK_GREEN.toString(), "entity." + EntityList.func_75621_b((Entity)this) + ".name", this.getColumnName(x) + (z + 1));
                if (!this.isCapturing) {
                    this.handleAfterTurn(player);
                }
                return true;
            }
        } else if (player != null) {
            MineChessUtils.sendUnlocalizedMessage(player, "message.error." + (this.isBlackTurn ? "blacksTurn" : "whitesTurn"), EnumChatFormatting.RED.toString());
        }
        return false;
    }

    protected void handleAfterTurn(EntityPlayer player) {
        if (!this.isPawnAwaitingPromotion()) {
            int movesAvailable;
            List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
            EntityKing king = null;
            for (EntityBaseChessPiece piece : pieces) {
                if (!(piece instanceof EntityKing) || !piece.isBlack()) continue;
                king = (EntityKing)piece;
                break;
            }
            if (king != null) {
                ChessPosition curPos = new ChessPosition(this);
                king.lastPositions.add(curPos);
            }
            if ((movesAvailable = this.isGameOver()) == 0) {
                if (this.isKingInDanger(!this.isBlack(), false)) {
                    if (player != null) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.broadcast.checkmate", EnumChatFormatting.BLUE.toString());
                        AchievementHandler.giveAchievement(player, "checkmate");
                    }
                    for (EntityPlayer nearbyPlayer : this.getNearbyPlayers()) {
                        if (nearbyPlayer == player) continue;
                        AchievementHandler.giveAchievement(nearbyPlayer, "lose");
                    }
                    this.sendChatToNearbyPlayers(player, "message.broadcast.checkmate", EnumChatFormatting.DARK_RED.toString());
                } else {
                    if (player != null) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.broadcast.stalemate", EnumChatFormatting.BLUE.toString());
                    }
                    for (EntityPlayer nearbyPlayer : this.getNearbyPlayers()) {
                        AchievementHandler.giveAchievement(nearbyPlayer, "stalemate");
                    }
                    this.sendChatToNearbyPlayers(player, "message.broadcast.stalemate", EnumChatFormatting.DARK_RED.toString());
                }
                this.setDeathTimer(this.isBlack());
            } else if (this.isKingInDanger(!this.isBlack(), false)) {
                if (player != null) {
                    MineChessUtils.sendUnlocalizedMessage(player, "message.broadcast.check", EnumChatFormatting.YELLOW.toString());
                    AchievementHandler.giveAchievement(player, "check");
                }
                this.sendChatToNearbyPlayers(player, "message.broadcast.check", EnumChatFormatting.RED.toString());
            }
            if (king != null) {
                king.checkForDraw(true);
            }
            this.switchTurns();
            this.handlePuzzles(player);
        }
    }

    private EntityBaseChessPiece getPieceAt(int x, int z) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (EntityBaseChessPiece piece : pieces) {
            if (piece.targetX != x || piece.targetZ != z) continue;
            return piece;
        }
        return null;
    }

    protected boolean isPieceCapturing() {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (EntityBaseChessPiece piece : pieces) {
            if (!piece.isCapturing) continue;
            return true;
        }
        return false;
    }

    protected boolean isPawnAwaitingPromotion() {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (EntityBaseChessPiece piece : pieces) {
            if (piece.field_70128_L || !(piece instanceof EntityPawn) || piece.targetZ % 7 != 0) continue;
            return true;
        }
        return false;
    }

    private void handlePuzzles(EntityPlayer player) {
        EntityBaseChessPiece enemy = this.getEnemyPiece();
        if (enemy != null && enemy.computerPiece) {
            List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
            for (int i = 0; i < pieces.size(); ++i) {
                List<int[]> moves;
                if (enemy.isBlack() != pieces.get(i).isBlack() || (moves = pieces.get(i).getValidMoves()).size() <= 0) continue;
                if (this.mateInTimes == 1) {
                    this.setDeathTimer(enemy.isBlack());
                    this.setPuzzleFail();
                    MineChessUtils.onPuzzleFail(this.field_70170_p, player, this, this.xOffset, this.targetY, this.zOffset, this.field_70146_Z);
                }
                --this.mateInTimes;
                this.setMateTimes(this.mateInTimes);
                return;
            }
            if (player != null && this.deathTimer > 0) {
                AchievementHandler.giveAchievement(player, "puzzleWin");
            }
        }
    }

    public void setMateTimes(int mateInTime) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            pieces.get((int)i).mateInTimes = mateInTime;
        }
    }

    public void setPuzzleFail() {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            pieces.get((int)i).solvedPuzzle = false;
        }
    }

    public void setComputerPiece(boolean isComputer) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            if (pieces.get(i).isBlack() != this.isBlack()) continue;
            pieces.get((int)i).computerPiece = isComputer;
        }
    }

    public void setDeathTimer(boolean winnerIsBlack) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            pieces.get((int)i).deathTimer = this.field_70146_Z.nextInt(100) + (winnerIsBlack ^ pieces.get(i).isBlack() ? (pieces.get(i) instanceof EntityKing ? 0 : 120) : 160);
        }
    }

    private boolean handleCastling(EntityPlayer player) {
        if (!(this instanceof EntityKing) || !this.firstMove) {
            return true;
        }
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (int i = 0; i < pieces.size(); ++i) {
            if (!(pieces.get(i) instanceof EntityRook) || this.isBlack() != pieces.get(i).isBlack()) continue;
            if (pieces.get((int)i).targetX == 0 && this.targetX == 1) {
                this.targetX = 3;
                if (this.isKingInDanger(this.isBlack(), false)) {
                    if (player != null) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.error.kingInCheck", EnumChatFormatting.RED.toString());
                    }
                    return false;
                }
                this.targetX = 2;
                if (this.isKingInDanger(this.isBlack(), true)) {
                    if (player != null) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.error.kingCheckCastling", EnumChatFormatting.RED.toString());
                    }
                    return false;
                }
                this.targetX = 1;
                pieces.get((int)i).targetX = 2;
                pieces.get((int)i).firstMove = false;
                pieces.get((int)i).field_70181_x = 0.8;
                continue;
            }
            if (pieces.get((int)i).targetX != 7 || this.targetX != 5) continue;
            this.targetX = 3;
            if (this.isKingInDanger(this.isBlack(), false)) {
                if (player != null) {
                    MineChessUtils.sendUnlocalizedMessage(player, "message.error.kingInCheck", EnumChatFormatting.RED.toString());
                }
                return false;
            }
            this.targetX = 4;
            if (this.isKingInDanger(this.isBlack(), true)) {
                if (player != null) {
                    MineChessUtils.sendUnlocalizedMessage(player, "message.error.kingCheckCastling", EnumChatFormatting.RED.toString());
                }
                return false;
            }
            this.targetX = 5;
            pieces.get((int)i).targetX = 4;
            pieces.get((int)i).firstMove = false;
            pieces.get((int)i).field_70181_x = 0.8;
        }
        if (player != null && this.targetX == 5 || this.targetX == 1) {
            AchievementHandler.giveAchievement(player, "castling");
        }
        return true;
    }

    public String getColumnName(int x) {
        switch (x) {
            case 0: {
                return "H";
            }
            case 1: {
                return "G";
            }
            case 2: {
                return "F";
            }
            case 3: {
                return "E";
            }
            case 4: {
                return "D";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "B";
            }
        }
        return "A";
    }

    public boolean canGoTo(int x, int z, boolean setCaptureIfneccessary, EntityPlayer player) {
        List<int[]> possibleMoves = this.getPossibleMoves();
        if (possibleMoves == null) {
            return false;
        }
        for (int i = 0; i < possibleMoves.size(); ++i) {
            if (possibleMoves.get(i)[0] != x || possibleMoves.get(i)[1] != z || this.isPieceInBetween(x, z) && !(this instanceof EntityKnight) || x == this.targetX && z == this.targetZ) continue;
            List<EntityBaseChessPiece> chessPieces = this.getChessPieces(true);
            for (int j = 0; j < chessPieces.size(); ++j) {
                if (chessPieces.get(j).getTargetPosition()[0] == x && chessPieces.get(j).getTargetPosition()[1] == z) {
                    if (chessPieces.get(j).isBlack() != this.isBlack()) {
                        if (setCaptureIfneccessary) {
                            this.isCapturing = true;
                        }
                        return true;
                    }
                    if (player != null) {
                        MineChessUtils.sendUnlocalizedMessage(player, "message.error.ownPieceInWay", EnumChatFormatting.RED.toString());
                    }
                    return false;
                }
                if (!(this instanceof EntityPawn) || !chessPieces.get((int)j).enPassantPossibility || chessPieces.get((int)j).targetZ != this.targetZ || chessPieces.get((int)j).targetX != this.targetX - 1 && chessPieces.get((int)j).targetX != this.targetX + 1 || !(chessPieces.get(j).isBlack() ^ this.isBlack()) || this.targetX == x || !setCaptureIfneccessary) continue;
                chessPieces.get(j).func_70076_C();
                if (player == null) continue;
                AchievementHandler.giveAchievement(player, "enPassant");
            }
            return true;
        }
        if (player != null) {
            MineChessUtils.sendUnlocalizedMessage(player, "message.error.movementRuleBlocks", EnumChatFormatting.RED.toString());
        }
        return false;
    }

    private boolean isPieceInBetween(int x, int z) {
        List<EntityBaseChessPiece> chessPieces = this.getChessPieces(true);
        int checkingX = this.targetX;
        int checkingZ = this.targetZ;
        while (checkingX != x || checkingZ != z) {
            for (int i = 0; i < chessPieces.size(); ++i) {
                if (chessPieces.get(i).getTargetPosition()[0] != checkingX || chessPieces.get(i).getTargetPosition()[1] != checkingZ || checkingX == this.targetX && checkingZ == this.targetZ || checkingX == x && checkingZ == z) continue;
                return true;
            }
            if (checkingX < x) {
                ++checkingX;
            }
            if (checkingX > x) {
                --checkingX;
            }
            if (checkingZ < z) {
                ++checkingZ;
            }
            if (checkingZ <= z) continue;
            --checkingZ;
        }
        return false;
    }

    public boolean canCaptureKing(boolean kingIsBlack) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            int[] kingPos;
            if (!(pieces.get(i) instanceof EntityKing) || pieces.get(i).isBlack() != kingIsBlack || !this.canGoTo((kingPos = pieces.get(i).getTargetPosition())[0], kingPos[1], false, null)) continue;
            return true;
        }
        return false;
    }

    public boolean isKingInDanger(boolean isBlack, boolean impliedMove) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (int i = 0; i < pieces.size(); ++i) {
            if (!(pieces.get(i).isBlack() ^ isBlack) || !pieces.get(i).canCaptureKing(isBlack) || pieces.get(i).getTargetPosition()[0] == this.targetX && pieces.get(i).getTargetPosition()[1] == this.targetZ && impliedMove) continue;
            return true;
        }
        return false;
    }

    public List<int[]> getValidMoves() {
        ArrayList<int[]> moves = new ArrayList<int[]>();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!this.canGoTo(i, j, false, null)) continue;
                int oldX = this.targetX;
                int oldZ = this.targetZ;
                EntityBaseChessPiece pieceToBeCaptured = this.getPieceAt(i, j);
                this.targetX = i;
                this.targetZ = j;
                if (pieceToBeCaptured != null) {
                    pieceToBeCaptured.setTargetPosition(10, 10);
                }
                boolean kingInDanger = this.isKingInDanger(this.isBlack(), true);
                if (pieceToBeCaptured != null) {
                    pieceToBeCaptured.setTargetPosition(i, j);
                }
                this.targetX = oldX;
                this.targetZ = oldZ;
                if (kingInDanger) continue;
                int[] move = new int[]{i, j};
                moves.add(move);
            }
        }
        return moves;
    }

    public EntityBaseChessPiece getEnemyPiece() {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (int i = 0; i < pieces.size(); ++i) {
            if (!(pieces.get(i).isBlack() ^ this.isBlack())) continue;
            return pieces.get(i);
        }
        return null;
    }

    public int isGameOver() {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        int totalValidMoves = 0;
        for (int i = 0; i < pieces.size(); ++i) {
            if (!(pieces.get(i).isBlack() ^ this.isBlack())) continue;
            totalValidMoves += pieces.get(i).getValidMoves().size();
        }
        return totalValidMoves;
    }

    public abstract List<int[]> getPossibleMoves();

    public void switchTurns() {
        boolean turn = !this.isBlackTurn;
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            pieces.get((int)i).isBlackTurn = turn;
        }
    }

    public void clearEnPassant() {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(false);
        for (int i = 0; i < pieces.size(); ++i) {
            pieces.get((int)i).enPassantPossibility = false;
        }
    }

    public List<EntityBaseChessPiece> getChessPieces(boolean filterToBeCapturedPieces) {
        AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(this.xOffset - 1), (double)((int)this.field_70163_u - 1), (double)(this.zOffset - 1), (double)(this.xOffset + 8), (double)(this.field_70163_u + 2.0), (double)(this.zOffset + 8));
        List pieces = this.field_70170_p.func_72872_a(EntityBaseChessPiece.class, bbBox);
        this.filterPieces(pieces, filterToBeCapturedPieces);
        return pieces;
    }

    private void filterPieces(List<EntityBaseChessPiece> pieces, boolean filterToBeCapturedPieces) {
        for (int i = 0; i < pieces.size(); ++i) {
            if (pieces.get((int)i).field_70729_aU || pieces.get((int)i).xOffset != this.xOffset || pieces.get((int)i).zOffset != this.zOffset) {
                pieces.remove(i);
                this.filterPieces(pieces, filterToBeCapturedPieces);
                return;
            }
            if (!pieces.get((int)i).isCapturing || !filterToBeCapturedPieces) continue;
            for (int j = 0; j < pieces.size(); ++j) {
                if (pieces.get((int)i).targetX != pieces.get((int)j).targetX || pieces.get((int)i).targetZ != pieces.get((int)j).targetZ || pieces.get(i) == pieces.get(j)) continue;
                pieces.remove(j);
                this.filterPieces(pieces, filterToBeCapturedPieces);
                return;
            }
        }
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K) {
            int i;
            if (this.offsetNeedsUpdate) {
                this.field_70180_af.func_75692_b(28, (Object)new Integer(this.xOffset));
                this.field_70180_af.func_75692_b(29, (Object)new Integer(this.zOffset));
                this.offsetNeedsUpdate = false;
            }
            if (this.deathTimer > 0) {
                --this.deathTimer;
                if (this.turnToMobOnDeath && this.field_70146_Z.nextInt(40) == 0) {
                    int iterations = this.field_70146_Z.nextInt(3) + 3;
                    for (i = 0; i < iterations; ++i) {
                        MineChessUtils.spawnParticle("flame", this.field_70170_p, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.5, this.field_70161_v, this.field_70146_Z.nextDouble() / 10.0 - 0.05, this.field_70146_Z.nextDouble() / 10.0 - 0.05, this.field_70146_Z.nextDouble() / 10.0 - 0.05);
                    }
                }
            } else if (this.deathTimer == 0) {
                if (this.turnToMobOnDeath) {
                    if (!this.field_70170_p.field_72995_K) {
                        Entity mob = this.getMob();
                        mob.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        this.field_70170_p.func_72838_d(mob);
                        this.func_70106_y();
                        this.field_70170_p.func_72889_a((EntityPlayer)null, 1009, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                        for (i = 0; i < 40; ++i) {
                            MineChessUtils.spawnParticle("flame", this.field_70170_p, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.5, this.field_70161_v, this.field_70146_Z.nextDouble() / 10.0 - 0.05, this.field_70146_Z.nextDouble() / 10.0 - 0.05, this.field_70146_Z.nextDouble() / 10.0 - 0.05);
                        }
                    }
                } else {
                    this.func_70076_C();
                }
            }
            int xCoord = this.targetX + this.xOffset;
            int zCoord = this.targetZ + this.zOffset;
            if ((double)xCoord + 0.5 > this.field_70165_t + 0.1) {
                this.field_70159_w = this.moveSpeed;
            } else if ((double)xCoord + 0.5 < this.field_70165_t - 0.1) {
                this.field_70159_w = -this.moveSpeed;
            }
            if ((double)zCoord + 0.5 > this.field_70161_v + 0.1) {
                this.field_70179_y = this.moveSpeed;
            } else if ((double)zCoord + 0.5 < this.field_70161_v - 0.1) {
                this.field_70179_y = -this.moveSpeed;
            }
            if (this.func_70011_f(xCoord, this.targetY, zCoord) < 1.0) {
                if (this.isCapturing) {
                    List<EntityBaseChessPiece> chessPieces = this.getChessPieces(false);
                    for (int i2 = 0; i2 < chessPieces.size(); ++i2) {
                        if (chessPieces.get(i2).getTargetPosition()[0] != this.targetX || chessPieces.get(i2).getTargetPosition()[1] != this.targetZ || chessPieces.get(i2) == this) continue;
                        if (chessPieces.get(i2) instanceof EntityKing) {
                            this.setDeathTimer(this.isBlack());
                            if (this.playerLoser != null) {
                                MineChessUtils.sendUnlocalizedMessage(this.playerLoser, "message.error.bugReport.capturedKing", EnumChatFormatting.RED.toString());
                            }
                        }
                        chessPieces.get(i2).func_70076_C();
                        break;
                    }
                    this.handleAfterTurn(this.playerLoser);
                    this.isCapturing = false;
                }
                this.moveSpeed = 0.05f;
            } else {
                this.moveSpeed = 0.1f;
            }
        }
        super.func_70030_z();
        this.field_70761_aq = this.field_70177_z = this.isBlack() ? 180.0f : 0.0f;
    }

    public void executeMove(ChessMove move) {
        if (move != null) {
            EntityBaseChessPiece piece = this.getPieceAt(move.from % 10, move.from / 10);
            if (piece != null) {
                if (piece.tryToGoTo(move.to % 10, move.to / 10, null)) {
                    return;
                }
            } else {
                System.err.println("[Chess AI --> board] No piece (or white piece) found at " + move.from % 10 + ", " + move.from / 10);
            }
        }
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (EntityBaseChessPiece piece : pieces) {
            List<int[]> moves;
            if (piece.isBlack() != this.isBlack() || (moves = this.getValidMoves()).size() <= 0) continue;
            piece.tryToGoTo(moves.get(0)[0], moves.get(0)[1], null);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.sendChatToNearbyPlayers(null, "message.error.bugReport.aiWrongMove", EnumChatFormatting.RED.toString());
        }
        this.setComputerPiece(false);
    }

    public abstract Entity getMob();

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K && this.solvedPuzzle) {
            EntityPickyXPOrb xpOrb = new EntityPickyXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, this.playerLoser);
            this.field_70170_p.func_72838_d((Entity)xpOrb);
        }
    }

    public void func_70076_C() {
        super.func_70076_C();
    }
}

