/*
 * Decompiled with CFR 0.152.
 */
package minechess.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import minechess.common.EntityBaseChessPiece;
import minechess.common.ItemPieceMover;
import minechess.common.MineChess;
import minechess.common.MineChessUtils;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MineChessDrawBlockHighlightHandler {
    public static int pulse = 0;
    private static boolean doInc = true;
    private static float pulseTransparency;

    @SubscribeEvent
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        block11: {
            block12: {
                if (event.currentItem == null || !MineChess.configRenderMovement || event.currentItem.func_77973_b() != MineChess.itemPieceMover) break block11;
                if (event.currentItem.func_77960_j() >= 2) break block12;
                EntityBaseChessPiece entitySelected = ItemPieceMover.getEntitySelected(event.player.field_70170_p, event.currentItem);
                if (entitySelected == null) break block11;
                pulseTransparency = (float)MineChessDrawBlockHighlightHandler.getPulseValue() * 0.75f / 3000.0f;
                int renderHeight = ItemPieceMover.getRenderHeight(event.currentItem);
                for (int[] tile : ItemPieceMover.getRenderTiles(event.currentItem)) {
                    try {
                        MineChessDrawBlockHighlightHandler.highlightTile(event.player, tile[0] + entitySelected.getXOffset(), renderHeight, tile[1] + entitySelected.getZOffset(), event.partialTicks);
                    }
                    catch (Exception e) {}
                }
                break block11;
            }
            if (event.currentItem.func_77960_j() == 2) {
                pulseTransparency = (float)MineChessDrawBlockHighlightHandler.getPulseValue() * 0.75f / 3000.0f;
                int orientation = MineChessUtils.determineOrientation(event.player);
                int startX = event.target.field_72311_b;
                int startZ = event.target.field_72309_d;
                switch (orientation) {
                    case 0: {
                        startX -= 7;
                        break;
                    }
                    case 1: {
                        startX -= 7;
                        startZ -= 7;
                        break;
                    }
                    case 2: {
                        startZ -= 7;
                    }
                }
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        MineChessDrawBlockHighlightHandler.highlightTile(event.player, startX + i, event.target.field_72312_c, startZ + j, event.partialTicks);
                    }
                }
            }
        }
    }

    public static void highlightTile(EntityPlayer player, double x, double y, double z, float partialTicks) {
        x += 0.5;
        y += 0.5;
        z += 0.5;
        double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        float xScale = 1.0f;
        float yScale = 1.0f;
        float zScale = 1.0f;
        float xShift = 0.0f;
        float yShift = 0.01f;
        float zShift = 0.0f;
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2884);
        for (int i = 4; i < 5; ++i) {
            ForgeDirection forgeDir = ForgeDirection.getOrientation((int)i);
            int zCorrection = i == 2 ? -1 : 1;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-iPX + x + (double)xShift), (double)(-iPY + y + (double)yShift), (double)(-iPZ + z + (double)zShift));
            GL11.glScalef((float)(1.0f * xScale), (float)(1.0f * yScale), (float)(1.0f * zScale));
            GL11.glRotatef((float)90.0f, (float)forgeDir.offsetX, (float)forgeDir.offsetY, (float)forgeDir.offsetZ);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(0.5f * (float)zCorrection));
            GL11.glClear((int)256);
            MineChessDrawBlockHighlightHandler.drawQuad(-0.5f, -0.5f, 1.0f, 1.0f, 0.0);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)true);
    }

    private static int getPulseValue() {
        pulse = doInc ? (pulse += 40) : (pulse -= 40);
        if (pulse >= 3000) {
            doInc = false;
        }
        if (pulse <= 1500) {
            doInc = true;
        }
        return pulse;
    }

    public static void drawQuad(float x, float y, float width, float height, double zLevel) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)5.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)pulseTransparency);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)(x + 0.0f), (double)(y + height), zLevel);
        tessellator.func_78377_a((double)(x + width), (double)(y + height), zLevel);
        tessellator.func_78377_a((double)(x + width), (double)(y + 0.0f), zLevel);
        tessellator.func_78377_a((double)(x + 0.0f), (double)(y + 0.0f), zLevel);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
    }
}

