/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.entities.IHungryAnimal;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatBlock;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatItem;
import oortcloud.hungryanimals.potion.ModPotions;

public class EntityHungryChicken
extends EntityChicken
implements IHungryAnimal {
    public double hunger;
    public double excretion;
    public static double maxhunger;
    public static final double default_hungerRate = 0.002;
    public static final double default_courtshipProbability = 0.0025;
    public static final double default_courtshipHunger = 0.8;
    public static final double default_grassHunger = 5.0;
    public static final double default_excretionConstant = 0.02;
    public static final double default_maxhunger = 150.0;
    public static final double default_courtshipPrice = 7.5;
    public static final double default_childPrice = 37.5;
    public static final String[] default_foodList;
    public static final double[] default_hungerList;
    public static double hungerRate;
    public static double courtshipPrice;
    public static double courtshipProbability;
    public static double courtshipHunger;
    public static double grassHunger;
    public static double excretionConstant;
    public static double childPrice;
    public static HashMap<String, Double> foodMap;

    public EntityHungryChicken(World world) {
        super(world);
        this.hunger = maxhunger / 2.0;
        ArrayList<EntityAIBase> delEntries = new ArrayList<EntityAIBase>();
        for (Object e : this.field_70714_bg.field_75782_a) {
            if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a instanceof EntityAITempt) {
                delEntries.add(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
            if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a instanceof EntityAIFollowParent) {
                delEntries.add(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
            if (!(((EntityAITasks.EntityAITaskEntry)e).field_75733_a instanceof EntityAIWander)) continue;
            delEntries.add(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
        }
        for (Object e : delEntries) {
            this.field_70714_bg.func_85156_a((EntityAIBase)e);
        }
        for (String string : foodMap.keySet()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, (Item)Item.field_150901_e.func_82594_a(string), false));
        }
        for (String string : foodMap.keySet()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveToEatItem((IHungryAnimal)this, 1.0, (Item)Item.field_150901_e.func_82594_a(string)));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveToEatBlock((IHungryAnimal)this, 1.0, (Block)Blocks.field_150329_H));
    }

    public EntityHungryChicken(EntityChicken entity) {
        super(entity.field_70170_p);
        for (Object e : this.field_70714_bg.field_75782_a) {
            if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a instanceof EntityAITempt) {
                this.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
            if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a instanceof EntityAIFollowParent) {
                this.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
            if (!(((EntityAITasks.EntityAITaskEntry)e).field_75733_a instanceof EntityAIWander)) continue;
            this.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
        }
        for (String string : foodMap.keySet()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, (Item)Item.field_150901_e.func_82594_a(string), false));
        }
        for (String string : foodMap.keySet()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveToEatItem((IHungryAnimal)this, 1.0, (Item)Item.field_150901_e.func_82594_a(string)));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveToEatBlock((IHungryAnimal)this, 1.0, (Block)Blocks.field_150329_H));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70628_a(boolean isHitByPlayer, int looting) {
        int k;
        int j = this.field_70146_Z.nextInt(2) + 2 + this.field_70146_Z.nextInt(1 + looting);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151008_G, 1);
        }
        j = this.field_70146_Z.nextInt(2) + 2 + this.field_70146_Z.nextInt(1 + looting);
        if (this.func_70027_ad()) {
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151077_bg, 1);
            }
        } else {
            for (k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151076_bf, 1);
            }
        }
    }

    public EntityHungryChicken createChild(EntityAgeable p_90011_1_) {
        this.subHunger(childPrice);
        return new EntityHungryChicken(this.field_70170_p);
    }

    @Override
    public void addHunger(double value) {
        this.hunger += value;
        if (this.hunger > maxhunger) {
            this.hunger = maxhunger;
        }
    }

    @Override
    public void subHunger(double value) {
        this.hunger -= value;
        if (this.hunger <= 0.0) {
            this.hunger = 0.0;
        }
        this.excretion += value * excretionConstant;
    }

    @Override
    public void eatFoodBonus(Item item) {
        if (item == null) {
            return;
        }
        this.addHunger(foodMap.get(Item.field_150901_e.func_148750_c((Object)item)));
    }

    public void func_70615_aA() {
        this.addHunger(grassHunger);
    }

    public boolean func_70085_c(EntityPlayer entity) {
        ItemStack stack = entity.func_71045_bC();
        if (stack == null) {
            return super.func_70085_c(entity);
        }
        Item item = stack.func_77973_b();
        String name = Item.field_150901_e.func_148750_c((Object)item);
        if (this.canEat(name)) {
            this.addHunger(foodMap.get(name));
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        if (this.func_70644_a(ModPotions.potionDisease) && (item == ItemBlock.func_150898_a((Block)Blocks.field_150337_Q) || item == ItemBlock.func_150898_a((Block)Blocks.field_150338_P))) {
            this.func_82170_o(ModPotions.potionDisease.field_76415_H);
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        return super.func_70085_c(entity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            double vel = !this.field_70160_al ? this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y : 0.0;
            vel = 20.0 * Math.sqrt(vel);
            this.subHunger(hungerRate * (1.0 + vel / 2.0));
            if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                if (this.getHungry() > courtshipHunger) {
                    if (this.func_70681_au().nextDouble() < courtshipProbability) {
                        this.func_146082_f(null);
                        this.subHunger(courtshipPrice);
                    }
                }
            }
            if (this.excretion > 1.0) {
                this.excretion -= 1.0;
                int x = (int)this.field_70165_t;
                int y = (int)this.field_70163_u;
                int z = (int)this.field_70161_v;
                Block block = this.field_70170_p.func_147439_a(x, y, z);
                int meta = this.field_70170_p.func_72805_g(x, y, z);
                if (block.equals(ModBlocks.excreta) && BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta) < 4) {
                    this.field_70170_p.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(BlockExcreta.getNumberOfExcreta(meta) + 1, BlockExcreta.getNumberOfManure(meta)), 2);
                } else if (BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta) != 4 && (block.isAir((IBlockAccess)this.field_70170_p, x, y, z) || block.isReplaceable((IBlockAccess)this.field_70170_p, x, y, z))) {
                    this.field_70170_p.func_147465_d(x, y, z, ModBlocks.excreta, BlockExcreta.getMetaOfExcretaAndManure(1, 0), 2);
                }
            }
            if (this.getHungry() == 0.0) {
                this.onStarve();
            }
        }
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.hunger = tag.func_74760_g("hunger");
        this.excretion = tag.func_74760_g("excretion");
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74780_a("hunger", this.hunger);
        tag.func_74780_a("excretion", this.excretion);
    }

    @Override
    public double getHungry() {
        return Math.max(0.0, this.hunger / maxhunger);
    }

    @Override
    public boolean canEat(String food) {
        if (food.equals("grass")) {
            return grassHunger + this.hunger < maxhunger;
        }
        if (foodMap.containsKey(food)) {
            double value = foodMap.get(food);
            return value + this.hunger < maxhunger;
        }
        return false;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return false;
    }

    public boolean func_70094_T() {
        for (int i = 0; i < 8; ++i) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            int j = MathHelper.func_76128_c((double)(this.field_70165_t + (double)f));
            if (!this.field_70170_p.func_147439_a(j, k = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e() + (double)f1)), l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)f2))).func_149721_r()) continue;
            if (this.field_70170_p.func_147439_a(j, k, l).equals(ModBlocks.excreta)) {
                double height = this.field_70163_u + (double)this.func_70047_e() + (double)f1 - (double)k;
                int meta = this.field_70170_p.func_72805_g(j, k, l);
                double excreta = (double)(BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta)) * 0.25;
                return excreta > height;
            }
            return true;
        }
        return false;
    }

    public float func_70783_a(int x, int y, int z) {
        if (this.field_70170_p.func_147439_a(x, y, z).equals(ModBlocks.excreta)) {
            return -1.0f;
        }
        if (this.field_70170_p.func_147439_a(x, y, z).equals(Blocks.field_150329_H)) {
            return 10.0f;
        }
        return 1.0f;
    }

    @Override
    public double getBMR() {
        return hungerRate;
    }

    public void onStarve() {
        this.func_70097_a(DamageSource.field_76366_f, 0.5f);
    }

    static {
        default_foodList = new String[]{Item.field_150901_e.func_148750_c((Object)Items.field_151014_N), Item.field_150901_e.func_148750_c((Object)Items.field_151080_bb), Item.field_150901_e.func_148750_c((Object)Items.field_151081_bc)};
        default_hungerList = new double[]{25.0, 25.0, 25.0};
        foodMap = new HashMap();
    }
}

