/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import oortcloud.hungryanimals.animals.ExtendedPropertiesHungryAnimal;
import oortcloud.hungryanimals.animals.ExtendedPropertiesHungryChicken;
import oortcloud.hungryanimals.animals.ExtendedPropertiesHungryCow;
import oortcloud.hungryanimals.animals.ExtendedPropertiesHungryPig;
import oortcloud.hungryanimals.animals.ExtendedPropertiesHungrySheep;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.BlockNiterBed;
import oortcloud.hungryanimals.core.handler.FMLEventHandler;

public class ConfigurationHandler {
    public static Configuration config;
    public static final String CATEGORY_Chicken = "chicken";
    public static final String CATEGORY_Cow = "cow";
    public static final String CATEGORY_Mooshroom = "mooshroom";
    public static final String CATEGORY_Pig = "pig";
    public static final String CATEGORY_Sheep = "sheep";
    public static final String CATEGORY_Block = "block";
    public static final String KEY_hunger_bmr = "Hunger Rate";
    public static final String KEY_courtship_hunger = "Courtship Price";
    public static final String KEY_courtship_probability = "Courtship Probability";
    public static final String KEY_courtship_hungerCondition = "Courtship Hunger";
    public static final String KEY_excretion_factor = "Excretion Constant";
    public static final String KEY_foodList = "byFood Rate";
    public static final String KEY_blockList = "byBlock Rate";
    public static final String KEY_fermetationProbability = "Fermentation Probability";
    public static final String KEY_erosionProbability = "Erosion Probability";
    public static final String KEY_fertilizationProbability = "Fertilization Probability";
    public static final String KEY_ripeningProbability = "Ripening Probability";
    public static final String KEY_diseaseProbability = "Disease Probability";
    public static final String KEY_hunger_max = "Max Hunger";
    public static final String KEY_child_hunger = "Child Price";
    public static final String KEY_milk_hunger = "Hunger needs for milk";
    public static final String KEY_milk_delay = "Delay to produce milk";
    public static final String KEY_wool_hunger = "Hunger needs for wool";
    public static final String KEY_wool_delay = "Delay to produce wool";
    public static final String KEY_grassProbability = "Grass Probability";

    public static void init(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
    }

    public static void sync() {
        ExtendedPropertiesHungryChicken.default_hunger_bmr = config.get(CATEGORY_Chicken, KEY_hunger_bmr, 0.002).getDouble();
        ExtendedPropertiesHungryCow.default_hunger_bmr = config.get(CATEGORY_Cow, KEY_hunger_bmr, 0.005).getDouble();
        ExtendedPropertiesHungryPig.default_hunger_bmr = config.get(CATEGORY_Pig, KEY_hunger_bmr, 0.004).getDouble();
        ExtendedPropertiesHungrySheep.default_hunger_bmr = config.get(CATEGORY_Sheep, KEY_hunger_bmr, 0.004).getDouble();
        ExtendedPropertiesHungryChicken.default_hunger_max = config.get(CATEGORY_Chicken, KEY_hunger_max, 150).getDouble();
        ExtendedPropertiesHungryCow.default_hunger_max = config.get(CATEGORY_Cow, KEY_hunger_max, 500).getDouble();
        ExtendedPropertiesHungryPig.default_hunger_max = config.get(CATEGORY_Pig, KEY_hunger_max, 400).getDouble();
        ExtendedPropertiesHungrySheep.default_hunger_max = config.get(CATEGORY_Sheep, KEY_hunger_max, 400).getDouble();
        ExtendedPropertiesHungryChicken.default_courtship_hunger = config.get(CATEGORY_Chicken, KEY_courtship_hunger, ExtendedPropertiesHungryChicken.default_hunger_max / 20.0).getDouble();
        ExtendedPropertiesHungryCow.default_courtship_hunger = config.get(CATEGORY_Cow, KEY_courtship_hunger, ExtendedPropertiesHungryCow.default_hunger_max / 20.0).getDouble();
        ExtendedPropertiesHungryPig.default_courtship_hunger = config.get(CATEGORY_Pig, KEY_courtship_hunger, ExtendedPropertiesHungryPig.default_hunger_max / 20.0).getDouble();
        ExtendedPropertiesHungrySheep.default_courtship_hunger = config.get(CATEGORY_Sheep, KEY_courtship_hunger, ExtendedPropertiesHungrySheep.default_hunger_max / 20.0).getDouble();
        ExtendedPropertiesHungryChicken.default_courtship_probability = config.get(CATEGORY_Chicken, KEY_courtship_probability, 0.0025).getDouble();
        ExtendedPropertiesHungryCow.default_courtship_probability = config.get(CATEGORY_Cow, KEY_courtship_probability, 0.0025).getDouble();
        ExtendedPropertiesHungryPig.default_courtship_probability = config.get(CATEGORY_Pig, KEY_courtship_probability, 0.0025).getDouble();
        ExtendedPropertiesHungrySheep.default_courtship_probability = config.get(CATEGORY_Sheep, KEY_courtship_probability, 0.0025).getDouble();
        ExtendedPropertiesHungryChicken.default_courtship_hungerCondition = config.get(CATEGORY_Chicken, KEY_courtship_hungerCondition, 0.8).getDouble();
        ExtendedPropertiesHungryCow.default_courtship_hungerCondition = config.get(CATEGORY_Cow, KEY_courtship_hungerCondition, 0.8).getDouble();
        ExtendedPropertiesHungryPig.default_courtship_hungerCondition = config.get(CATEGORY_Pig, KEY_courtship_hungerCondition, 0.8).getDouble();
        ExtendedPropertiesHungrySheep.default_courtship_hungerCondition = config.get(CATEGORY_Sheep, KEY_courtship_hungerCondition, 0.8).getDouble();
        ExtendedPropertiesHungryChicken.default_excretion_factor = config.get(CATEGORY_Chicken, KEY_excretion_factor, 0.02).getDouble();
        ExtendedPropertiesHungryCow.default_excretion_factor = config.get(CATEGORY_Cow, KEY_excretion_factor, 0.02).getDouble();
        ExtendedPropertiesHungryPig.default_excretion_factor = config.get(CATEGORY_Pig, KEY_excretion_factor, 0.02).getDouble();
        ExtendedPropertiesHungrySheep.default_excretion_factor = config.get(CATEGORY_Sheep, KEY_excretion_factor, 0.02).getDouble();
        ExtendedPropertiesHungryChicken.default_child_hunger = config.get(CATEGORY_Chicken, KEY_child_hunger, ExtendedPropertiesHungryChicken.default_hunger_max / 4.0).getDouble();
        ExtendedPropertiesHungryCow.default_child_hunger = config.get(CATEGORY_Cow, KEY_child_hunger, ExtendedPropertiesHungryCow.default_hunger_max / 4.0).getDouble();
        ExtendedPropertiesHungryPig.default_child_hunger = config.get(CATEGORY_Pig, KEY_child_hunger, ExtendedPropertiesHungryPig.default_hunger_max / 4.0).getDouble();
        ExtendedPropertiesHungrySheep.default_child_hunger = config.get(CATEGORY_Sheep, KEY_child_hunger, ExtendedPropertiesHungrySheep.default_hunger_max / 4.0).getDouble();
        ExtendedPropertiesHungryCow.default_milk_delay = config.get(CATEGORY_Cow, KEY_milk_delay, 6000).getInt();
        ExtendedPropertiesHungryCow.default_milk_hunger = config.get(CATEGORY_Cow, KEY_milk_hunger, ExtendedPropertiesHungryCow.default_hunger_max / 20.0).getDouble();
        ExtendedPropertiesHungrySheep.default_wool_delay = config.get(CATEGORY_Sheep, KEY_wool_delay, 6000).getInt();
        ExtendedPropertiesHungrySheep.default_wool_hunger = config.get(CATEGORY_Sheep, KEY_wool_hunger, ExtendedPropertiesHungrySheep.default_hunger_max / 20.0).getDouble();
        BlockExcreta.fermetationProbability = config.get(CATEGORY_Block, KEY_fermetationProbability, 0.05).getDouble();
        BlockExcreta.erosionProbability = config.get(CATEGORY_Block, KEY_erosionProbability, 0.025).getDouble();
        BlockExcreta.fertilizationProbability = config.get(CATEGORY_Block, KEY_fertilizationProbability, 0.2).getDouble();
        BlockExcreta.diseaseProbability = config.get(CATEGORY_Block, KEY_diseaseProbability, 0.05).getDouble();
        BlockNiterBed.ripeningProbability = config.get(CATEGORY_Block, KEY_ripeningProbability, 0.1).getDouble();
        FMLEventHandler.grassProbability = config.get(CATEGORY_Block, KEY_grassProbability, 0.1).getDouble();
        ConfigurationHandler.ByFoodRate(new String[]{Item.field_150901_e.func_148750_c((Object)Items.field_151014_N) + " 25.0", Item.field_150901_e.func_148750_c((Object)Items.field_151080_bb) + " 25.0", Item.field_150901_e.func_148750_c((Object)Items.field_151081_bc) + " 25.0"}, CATEGORY_Chicken, ExtendedPropertiesHungryChicken.class);
        ConfigurationHandler.ByBlockRate(new String[]{Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + " 15.0"}, CATEGORY_Chicken, ExtendedPropertiesHungryChicken.class);
        ConfigurationHandler.ByFoodRate(new String[]{Item.field_150901_e.func_148750_c((Object)Items.field_151015_O) + " 50.0", Item.field_150901_e.func_148750_c((Object)Items.field_151120_aE) + " 20.0"}, CATEGORY_Cow, ExtendedPropertiesHungryCow.class);
        ConfigurationHandler.ByBlockRate(new String[]{Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + " 15.0"}, CATEGORY_Cow, ExtendedPropertiesHungryCow.class);
        ConfigurationHandler.ByFoodRate(new String[]{Item.field_150901_e.func_148750_c((Object)Items.field_151172_bF) + " 40.0", Item.field_150901_e.func_148750_c((Object)Items.field_151078_bh) + " 15.0"}, CATEGORY_Pig, ExtendedPropertiesHungryPig.class);
        ConfigurationHandler.ByBlockRate(new String[]{Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + " 15.0"}, CATEGORY_Pig, ExtendedPropertiesHungryPig.class);
        ConfigurationHandler.ByFoodRate(new String[]{Item.field_150901_e.func_148750_c((Object)Items.field_151015_O) + " 50.0", Item.field_150901_e.func_148750_c((Object)Items.field_151120_aE) + " 20.0"}, CATEGORY_Sheep, ExtendedPropertiesHungrySheep.class);
        ConfigurationHandler.ByBlockRate(new String[]{Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + " 15.0"}, CATEGORY_Sheep, ExtendedPropertiesHungrySheep.class);
        config.save();
    }

    private static void ByFoodRate(String[] defaultfood, String category, Class<? extends ExtendedPropertiesHungryAnimal> target) {
        String[] food;
        for (String i : food = config.get(category, KEY_foodList, defaultfood).getStringList()) {
            String[] split = i.split(" ");
            if (split.length == 2) {
                Item itemFood = (Item)Item.field_150901_e.func_82594_a(split[0]);
                double hunger = Double.parseDouble(split[1]);
                try {
                    ((HashMap)target.getField("default_hunger_food").get(target)).put(itemFood, hunger);
                }
                catch (Exception e) {
                    System.out.println("\"" + i + "\" is not added. Format error");
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("\"" + i + "\" is not added. Format error");
        }
    }

    private static void ByBlockRate(String[] defaultBlock, String category, Class<? extends ExtendedPropertiesHungryAnimal> target) {
        String[] block;
        for (String i : block = config.get(category, KEY_blockList, defaultBlock).getStringList()) {
            String[] split = i.split(" ");
            if (split.length == 2) {
                Block blockFood = (Block)Block.field_149771_c.func_82594_a(split[0]);
                double hunger = Double.parseDouble(split[1]);
                try {
                    ((HashMap)target.getField("default_hunger_block").get(target)).put(blockFood, hunger);
                }
                catch (Exception e) {
                    System.out.println("\"" + i + "\" is not added. Format error");
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("\"" + i + "\" is not added. Format error");
        }
    }
}

