/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.animals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.entities.ai.EntityAIAvoidPlayer;
import oortcloud.hungryanimals.entities.ai.EntityAIMateModified;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatBlock;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatItem;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToFoodBox;
import oortcloud.hungryanimals.potion.ModPotions;

public class ExtendedPropertiesHungryAnimal
implements IExtendedEntityProperties {
    protected static String key = "ExtendedPropertiesHungryAnimal";
    public double hunger_max;
    public double hunger_bmr;
    public HashMap<Item, Double> hunger_food = new HashMap();
    public HashMap<Block, Double> hunger_block = new HashMap();
    public double courtship_hunger;
    public double courtship_probability;
    public double courtship_hungerCondition;
    public double excretion_factor;
    public double child_hunger;
    public double taming_factor = 0.998;
    public EntityAnimal entity;
    public World worldObj;
    public double hunger;
    public double excretion;
    public double taming;
    public EntityAIAvoidPlayer ai_avoidPlayer;
    public EntityAIMoveToFoodBox ai_moveToFoodbox;

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        compound.func_74782_a(key, (NBTBase)tag);
        tag.func_74780_a("hunger", this.hunger);
        tag.func_74780_a("excretion", this.excretion);
        tag.func_74780_a("tamedValue", this.taming);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = (NBTTagCompound)compound.func_74781_a(key);
        if (tag != null) {
            this.hunger = tag.func_74769_h("hunger");
            this.excretion = tag.func_74769_h("excretion");
            this.taming = tag.func_74769_h("tamedValue");
        }
    }

    public void init(Entity entity, World world) {
        this.entity = (EntityAnimal)entity;
        this.worldObj = world;
        this.ai_avoidPlayer = new EntityAIAvoidPlayer((EntityCreature)this.entity, this, 2.0);
        this.ai_moveToFoodbox = new EntityAIMoveToFoodBox(this.entity, this, 1.0);
    }

    public void postInit() {
        this.removeAI(new Class[]{EntityAITempt.class, EntityAIFollowParent.class, EntityAIWander.class, EntityAIMate.class, EntityAIPanic.class, EntityAIWatchClosest.class, EntityAILookIdle.class});
        this.entity.field_70714_bg.func_75776_a(1, (EntityAIBase)this.ai_avoidPlayer);
        this.entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateModified(this.entity, this, 2.0));
        this.entity.field_70714_bg.func_75776_a(3, (EntityAIBase)this.ai_moveToFoodbox);
        for (Item i : this.hunger_food.keySet()) {
            this.entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this.entity, 1.5, i, false));
        }
        this.entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveToEatItem((EntityLiving)this.entity, this, 1.5));
        this.entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveToEatBlock(this.entity, this, 1.0));
        this.entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this.entity, 1.0));
        this.entity.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this.entity, EntityPlayer.class, 6.0f));
        this.entity.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this.entity));
        this.applyEntityAttributes();
    }

    protected void applyEntityAttributes() {
    }

    public void dropFewItems(boolean isHitByPlayer, int looting, int special, ArrayList<EntityItem> drops) {
    }

    public double getHungry() {
        return this.hunger / this.hunger_max;
    }

    protected void removeAI(Class[] target) {
        ArrayList<EntityAIBase> removeEntries = new ArrayList<EntityAIBase>();
        for (Object e : this.entity.field_70714_bg.field_75782_a) {
            for (Class j : target) {
                if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a.getClass() != j) continue;
                removeEntries.add(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
        }
        for (Object e : removeEntries) {
            this.entity.field_70714_bg.func_85156_a((EntityAIBase)e);
        }
    }

    public boolean canEatFood(Item food) {
        if (this.hunger_food.containsKey(food)) {
            double value = this.hunger_food.get(food);
            return value + this.hunger < this.hunger_max;
        }
        return false;
    }

    public boolean canEatFood(ItemStack food) {
        return this.canEatFood(food.func_77973_b());
    }

    public boolean canEatBlock(Block block) {
        if (this.hunger_block.containsKey(block)) {
            double value = this.hunger_block.get(block);
            return value + this.hunger < this.hunger_max;
        }
        return false;
    }

    public void addHunger(double value) {
        this.hunger += value;
        if (this.hunger > this.hunger_max) {
            this.hunger = this.hunger_max;
        }
    }

    public void subHunger(double value) {
        this.hunger -= value;
        if (this.hunger <= 0.0) {
            this.hunger = 0.0;
        }
        this.excretion += value * this.excretion_factor;
    }

    public void eatFoodBonus(Item item) {
        if (item == null) {
            return;
        }
        double hunger = this.hunger_food.get(item);
        this.addHunger(hunger);
        if (this.entity.func_70874_b() < 0) {
            int duration = (int)(hunger / this.hunger_bmr);
            this.entity.func_70690_d(new PotionEffect(ModPotions.potionGrowth.field_76415_H, duration, 1, false));
        }
        this.taming += 2.0E-4 / this.hunger_bmr * hunger;
    }

    public void eatBlockBonus(Block block) {
        if (block == null) {
            return;
        }
        double hunger = this.hunger_block.get(block);
        this.addHunger(hunger);
    }

    public void update() {
        if (!this.worldObj.field_72995_K) {
            this.updateHunger();
            this.updateCourtship();
            this.updateExcretion();
            this.updateTaming();
            this.updateRecovery();
            if (this.getHungry() == 0.0) {
                this.onStarve();
            }
        }
    }

    private void updateHunger() {
        this.subHunger(this.hunger_bmr);
    }

    private void updateCourtship() {
        if (this.entity.func_70874_b() == 0 && !this.entity.func_70880_s() && this.getHungry() > this.courtship_hungerCondition && this.entity.func_70681_au().nextDouble() < this.courtship_probability) {
            this.entity.func_146082_f(null);
            this.subHunger(this.courtship_hunger);
        }
    }

    private void updateExcretion() {
        if (this.excretion > 1.0) {
            this.excretion -= 1.0;
            int x = (int)this.entity.field_70165_t;
            int y = (int)this.entity.field_70163_u;
            int z = (int)this.entity.field_70161_v;
            Block block = this.worldObj.func_147439_a(x, y, z);
            int meta = this.worldObj.func_72805_g(x, y, z);
            if (block.equals(ModBlocks.excreta) && BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta) < 4) {
                this.worldObj.func_72921_c(x, y, z, BlockExcreta.getMetaOfExcretaAndManure(BlockExcreta.getNumberOfExcreta(meta) + 1, BlockExcreta.getNumberOfManure(meta)), 2);
            } else if (BlockExcreta.getNumberOfExcreta(meta) + BlockExcreta.getNumberOfManure(meta) != 4 && (block.isAir((IBlockAccess)this.worldObj, x, y, z) || block.isReplaceable((IBlockAccess)this.worldObj, x, y, z))) {
                this.worldObj.func_147465_d(x, y, z, ModBlocks.excreta, BlockExcreta.getMetaOfExcretaAndManure(1, 0), 2);
            }
        }
    }

    private void updateTaming() {
        double radius = 16.0;
        if ((this.worldObj.func_72820_D() + (long)this.entity.func_145782_y()) % 100L == 0L) {
            List players = this.worldObj.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.entity.field_70165_t - radius), (double)(this.entity.field_70163_u - radius), (double)(this.entity.field_70161_v - radius), (double)(this.entity.field_70165_t + radius), (double)(this.entity.field_70163_u + radius), (double)(this.entity.field_70161_v + radius)));
            if (players.isEmpty()) {
                if (this.taming > 0.0) {
                    this.taming *= this.taming_factor;
                }
            } else if (this.taming < 0.0) {
                this.taming *= this.taming_factor;
            }
            this.ai_avoidPlayer.players = players;
        }
    }

    private void updateRecovery() {
        if (this.entity.func_110143_aJ() < this.entity.func_110138_aP() && this.getHungry() > 0.8 && this.worldObj.func_72820_D() % 200L == 0L) {
            this.entity.func_70691_i(1.0f);
            this.subHunger(this.hunger_max / (double)this.entity.func_110138_aP());
        }
    }

    public void onStarve() {
        this.entity.func_70097_a(DamageSource.field_76366_f, 0.5f);
    }

    public void onAttackedByPlayer(float damage, DamageSource source) {
        if (!this.entity.func_85032_ar() && source.func_76364_f() instanceof EntityPlayer) {
            this.taming -= 4.0 / this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * (double)damage;
        }
    }

    public boolean interact(EntityPlayer entity) {
        ItemStack stack = entity.func_71045_bC();
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (this.canEatFood(item) && this.taming >= 1.0) {
            this.eatFoodBonus(item);
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
            }
        } else if (this.entity.func_70644_a(ModPotions.potionDisease) && (item == ItemBlock.func_150898_a((Block)Blocks.field_150337_Q) || item == ItemBlock.func_150898_a((Block)Blocks.field_150338_P))) {
            this.entity.func_82170_o(ModPotions.potionDisease.field_76415_H);
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
            }
        }
        return this.entity.func_70877_b(stack);
    }

    public double getBlockPathWeight(int x, int y, int z) {
        Block block = this.worldObj.func_147439_a(x, y, z);
        if (block.equals(ModBlocks.excreta)) {
            return -1.0;
        }
        if (this.canEatBlock(block)) {
            return this.hunger_block.get(block);
        }
        return 1.0;
    }
}

