/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;

public class SimpleProfiler {
    public static final SimpleProfiler globalProfiler = new SimpleProfiler();
    private int _sectionCount = 0;
    private Section[] _sections = new Section[32];
    private int _openCount = 0;
    private Section[] _openSections = new Section[32];

    private int getSlot(Object key) {
        int slot = Math.abs(key.hashCode()) % this._sections.length;
        while (this._sections[slot] != null && this._sections[slot].key != key) {
            slot = (slot + 1) % this._sections.length;
        }
        return slot;
    }

    private Section getSection(Object key) {
        int var7;
        if (this._sectionCount * 4 > this._sections.length) {
            Section[] slot = this._sections;
            this._sections = new Section[slot.length * 2];
            for (Section s : slot) {
                if (s == null) continue;
                s.slot = this.getSlot(s.key);
                this._sections[s.slot] = s;
            }
        }
        if (this._sections[var7 = this.getSlot(key)] == null) {
            this._sections[var7] = new Section(key, var7, ++this._sectionCount);
        }
        return this._sections[var7];
    }

    public void startSection(Object key) {
        Section section;
        long time = System.nanoTime();
        if (this._openCount > 0) {
            section = this._openSections[this._openCount - 1];
            if (section.running > 0 && --section.running == 0) {
                section.runTime += time;
            }
        }
        section = this.getSection(key);
        ++section.hits;
        if (this._openCount >= this._openSections.length) {
            this._openSections = Arrays.copyOf(this._openSections, this._openCount * 2);
        }
        this._openSections[this._openCount++] = section;
        if (section.running++ == 0) {
            section.runTime -= time;
        }
        if (section.open++ == 0) {
            section.openTime -= time;
        }
    }

    public void pauseSection() {
        if (this._openCount > 0) {
            Section current = this._openSections[this._openCount - 1];
            if (current.running > 0 && --current.running == 0) {
                current.runTime += System.nanoTime();
            }
        }
    }

    public void unpauseSection() {
        if (this._openCount > 0) {
            Section current = this._openSections[this._openCount - 1];
            if (current.running++ == 0) {
                current.runTime -= System.nanoTime();
            }
        }
    }

    public void endSection() {
        long time = System.nanoTime();
        if (this._openCount <= 0) {
            throw new RuntimeException("Open/Close section mismatch.");
        }
        Section section = this._openSections[--this._openCount];
        if (--section.running == 0) {
            section.runTime += time;
        }
        if (--section.open == 0) {
            section.openTime += time;
        }
        if (this._openCount > 0) {
            Section current = this._openSections[this._openCount - 1];
            if (current.running++ == 0) {
                current.runTime -= time;
            }
        }
    }

    public void dumpSections(int sortBy) {
        double maxOpentime = 0.0;
        Vector<Section> sections = new Vector<Section>(this._sectionCount);
        for (Section section : this._sections) {
            if (section == null) continue;
            if ((double)section.openTime > maxOpentime) {
                maxOpentime = section.openTime;
            }
            sections.add(section);
        }
        Section.sortField = sortBy;
        Collections.sort(sections);
        System.out.println("Open Sections (" + this._openCount + ") :");
        for (int i = 0; i < this._openCount; ++i) {
            System.out.println("  " + this._openSections[i].key);
        }
        System.out.format("%40s    %8s          %21s               %21s       \n", "Key", "Hits", "Run Time (us)", "Open Time (us)");
        for (Section s : sections) {
            System.out.format("%40s =  %8d  %12d (%8.0f) (%6.2f%%)  %12d (%8.0f) (%6.2f%%)\n", s.key, s.hits, s.runTime / 1000L, Float.valueOf((float)s.runTime / 1000.0f / (float)s.hits), 100.0 * (double)s.runTime / maxOpentime, s.openTime / 1000L, Float.valueOf((float)s.openTime / 1000.0f / (float)s.hits), 100.0 * (double)s.openTime / maxOpentime);
        }
    }

    public void clear() {
        this._sectionCount = 0;
        Arrays.fill(this._sections, null);
        this._openCount = 0;
        Arrays.fill(this._openSections, null);
    }

    private static class Section
    implements Comparable {
        public final Object key;
        public int slot;
        public int order;
        public int hits;
        public int running;
        public long runTime;
        public int open;
        public long openTime;
        public static int sortField = 2;

        private Section(Object key, int slot, int order) {
            this.key = key;
            this.slot = slot;
            this.order = order;
        }

        public int compareTo(Section compareTo) {
            int mult = (int)Math.signum(sortField);
            switch (Math.abs(sortField)) {
                case 1: {
                    return mult * Double.compare(this.runTime, compareTo.runTime);
                }
                case 2: {
                    return mult * Double.compare(this.openTime, compareTo.openTime);
                }
                case 3: {
                    return mult * Double.compare(this.hits, compareTo.hits);
                }
                case 4: {
                    return mult * Double.compare(this.order, compareTo.order);
                }
            }
            return 0;
        }

        public int compareTo(Object x0) {
            return this.compareTo((Section)x0);
        }
    }
}

