/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Util.GammaFunction;
import java.util.Random;

public class PDist
implements DistributionSettingMap.Copyable<PDist> {
    public float mean;
    public float range;
    public Type type;

    public PDist(float mean, float range, Type type) {
        this.set(mean, range, type);
    }

    public PDist(float mean, float range) {
        this.set(mean, range, Type.uniform);
    }

    public PDist() {
        this.set(0.0f, 0.0f, Type.uniform);
    }

    public PDist(PDist pdist) {
        this.copyFrom(pdist);
    }

    @Override
    public void copyFrom(PDist source) {
        this.mean = source.mean;
        this.range = source.range;
        this.type = source.type;
    }

    public PDist set(float mean, float range, Type type) {
        this.mean = mean;
        this.range = range >= 0.0f ? range : -range;
        this.type = type;
        return this;
    }

    public float getMax() {
        return this.mean + this.range;
    }

    public float getMin() {
        return this.mean - this.range;
    }

    public float getValue(Random rand) {
        if (this.range == 0.0f) {
            return this.mean;
        }
        switch (this.type) {
            case uniform: {
                return (rand.nextFloat() * 2.0f - 1.0f) * this.range + this.mean;
            }
            case normal: {
                float value = (float)rand.nextGaussian() / 2.5f;
                if (value < -1.0f) {
                    value = -1.0f;
                } else if (value > 1.0f) {
                    value = 1.0f;
                }
                return value * this.range + this.mean;
            }
            case inverse: {
                float value = this.inverseGaussian(1.5, 0.2f, rand) / 2.0f;
                if (value > 1.0f) {
                    value = 1.0f;
                }
                if (rand.nextBoolean()) {
                    value *= -1.0f;
                }
                return value * this.range + this.mean;
            }
            case inverseAbs: {
                float value = this.inverseGaussian(1.5, 0.2f, rand) / 2.0f;
                if (value > 1.0f) {
                    value = 1.0f;
                }
                return value * this.range + this.mean;
            }
        }
        return 0.0f;
    }

    private float inverseGaussian(double mu, double lambda, Random rand) {
        double v = rand.nextGaussian();
        v *= v;
        double x = mu + mu * mu * v / (2.0 * lambda) - mu / (2.0 * lambda) * Math.sqrt(4.0 * mu * lambda * v + mu * mu * v * v);
        if (rand.nextDouble() <= mu / (mu + x)) {
            return (float)x;
        }
        return (float)(mu * mu / x);
    }

    public int getIntValue(Random rand) {
        float fval = this.getValue(rand);
        return PDist.roundToInt(fval, rand);
    }

    public static int roundToInt(float fval, Random rand) {
        int ival;
        if ((fval -= (float)(ival = (int)fval)) > 0.0f && fval > rand.nextFloat()) {
            ++ival;
        } else if (fval < 0.0f && -fval > rand.nextFloat()) {
            --ival;
        }
        return ival;
    }

    public float standardize(float x) {
        return (x - this.mean) / this.range;
    }

    public float cdf(float x) {
        switch (this.type) {
            case uniform: {
                return this.standardize(x);
            }
            case normal: {
                float z = this.standardize(x);
                return (float)(1.0 / (1.0 + Math.exp(-0.07056 * Math.pow(z, 3.0) - 1.5976 * (double)z)));
            }
            case inverse: 
            case inverseAbs: {
                float f = Math.abs(this.standardize(x));
                float m = (float)Math.sqrt(1.0f / x);
                return 0.5f * this.erfc(0.316228f * (1.0f - x) * m) + 0.745912f * this.erfc(0.316228f * (1.0f + x) * m);
            }
        }
        return 0.0f;
    }

    private float erfc(float x) {
        return 1.0f - 0.56418f * (float)GammaFunction.incompleteGammaP(0.5, x * x);
    }

    public String toString() {
        return String.format("%f +- %f %s", Float.valueOf(this.mean), Float.valueOf(this.range), this.type.name());
    }

    public static enum Type {
        uniform,
        normal,
        inverse,
        inverseAbs;

    }
}

