/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.CustomOreGenBase;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.GeometryData;
import CustomOreGen.GeometryRequestData;
import CustomOreGen.MystcraftSymbolData;
import CustomOreGen.Server.ConfigErrorDialog;
import CustomOreGen.Server.ConfigOption;
import CustomOreGen.Server.GuiCustomOreGenSettings;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Server.WorldConfig;
import CustomOreGen.Util.CogOreGenEvent;
import CustomOreGen.Util.GeometryStream;
import CustomOreGen.Util.SimpleProfiler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.MinecraftForge;

public class ServerState {
    private static MinecraftServer _server = null;
    private static Map<World, WorldConfig> _worldConfigs = new HashMap<World, WorldConfig>();
    private static Map<Integer, Map<ChunkCoordIntPair, int[]>> _populatedChunks = new HashMap<Integer, Map<ChunkCoordIntPair, int[]>>();
    private static Object _optionsGuiButton = null;
    private static boolean forcingChunk;

    private static boolean isChunkSavedPopulated(World world, int chunkX, int chunkZ) {
        File saveFolder = ServerState.getWorldConfig((World)world).dimensionDir;
        DataInputStream stream = RegionFileCache.func_76549_c((File)saveFolder, (int)chunkX, (int)chunkZ);
        if (stream != null) {
            try {
                NBTTagCompound ex = CompressedStreamTools.func_74794_a((DataInputStream)stream);
                if (ex.func_74764_b("Level") && ex.func_74775_l("Level").func_74767_n("TerrainPopulated")) {
                    return true;
                }
            }
            catch (IOException var6) {
                // empty catch block
            }
        }
        return false;
    }

    public static WorldConfig getWorldConfig(World world) {
        WorldConfig cfg = _worldConfigs.get(world);
        while (cfg == null) {
            try {
                cfg = new WorldConfig(world);
                ServerState.validateOptions(cfg.getConfigOptions(), true);
                ServerState.validateDistributions(cfg.getOreDistributions(), true);
            }
            catch (Exception var4) {
                if (ServerState.onConfigError(var4)) {
                    cfg = null;
                    continue;
                }
                cfg = WorldConfig.createEmptyConfig();
            }
            _worldConfigs.put(world, cfg);
        }
        return cfg;
    }

    public static void clearWorldConfig(World world) {
        _worldConfigs.remove(world);
    }

    public static boolean onConfigError(Throwable error) {
        CustomOreGenBase.log.error("Problem loading world config", error);
        Frame[] frames = Frame.getFrames();
        if (frames != null && frames.length > 0) {
            switch (new ConfigErrorDialog().showDialog(frames[0], error)) {
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        return false;
    }

    public static void validateDistributions(Collection distributions, boolean cull) throws IllegalStateException {
        Iterator it = distributions.iterator();
        while (it.hasNext()) {
            IOreDistribution dist = (IOreDistribution)it.next();
            if (dist.validate() || !cull) continue;
            it.remove();
        }
    }

    public static void validateOptions(Collection options, boolean cull) {
        Iterator it = options.iterator();
        while (it.hasNext()) {
            ConfigOption option = (ConfigOption)it.next();
            if (!cull || !(option instanceof ConfigOption.DisplayGroup)) continue;
            it.remove();
        }
    }

    public static void populateDistributions(Collection<IOreDistribution> distributions, World world, int chunkX, int chunkZ) {
        SimpleProfiler.globalProfiler.startSection("Populate");
        BlockSand.field_149832_M = true;
        world.field_72999_e = true;
        for (IOreDistribution dist : distributions) {
            dist.generate(world, chunkX, chunkZ);
            dist.populate(world, chunkX, chunkZ);
            dist.cull();
        }
        world.field_72999_e = false;
        BlockSand.field_149832_M = false;
        SimpleProfiler.globalProfiler.endSection();
    }

    public static GeometryData getDebuggingGeometryData(GeometryRequestData request) {
        if (_server == null) {
            return null;
        }
        if (request.world == null) {
            return null;
        }
        WorldConfig cfg = ServerState.getWorldConfig(request.world);
        if (!cfg.debuggingMode) {
            return null;
        }
        int geomSize = 0;
        LinkedList<GeometryStream> streams = new LinkedList<GeometryStream>();
        for (IOreDistribution dist : cfg.getOreDistributions()) {
            dist.generate(request.world, request.chunkX, request.chunkZ);
            GeometryStream stream = dist.getDebuggingGeometry(request.world, request.chunkX, request.chunkZ);
            if (stream != null) {
                streams.add(stream);
                geomSize += stream.getStreamDataSize();
            }
            dist.cull();
        }
        return new GeometryData(request, streams);
    }

    public static void onPopulateChunk(World world, int chunkX, int chunkZ, Random rand) {
        WorldConfig cfg = ServerState.getWorldConfig(world);
        int range = (cfg.deferredPopulationRange + 15) / 16;
        for (int iX = chunkX - range; iX <= chunkX + range; ++iX) {
            for (int iZ = chunkZ - range; iZ <= chunkZ + range; ++iZ) {
                if (!ServerState.allNeighborsPopulated(world, iX, iZ, range)) continue;
                ServerState.populateDistributions(cfg.getOreDistributions(), world, iX, iZ);
                MinecraftForge.ORE_GEN_BUS.post((Event)new CogOreGenEvent(world, rand, iX * 16, iZ * 16));
            }
        }
    }

    private static boolean allNeighborsPopulated(World world, int chunkX, int chunkZ, int range) {
        int area = 4 * range * (range + 1) + 1;
        int neighborCount = 0;
        for (int iX = chunkX - range; iX <= chunkX + range; ++iX) {
            for (int iZ = chunkZ - range; iZ <= chunkZ + range; ++iZ) {
                if (!ServerState.chunkHasBeenPopulated(world, iX, iZ)) continue;
                ++neighborCount;
            }
        }
        return neighborCount == area;
    }

    private static boolean chunkHasBeenPopulated(World world, int chunkX, int chunkZ) {
        return ServerState.chunkHasBeenGenerated(world, chunkX, chunkZ) && world.func_72964_e((int)chunkX, (int)chunkZ).field_76646_k;
    }

    private static boolean chunkHasBeenGenerated(World world, int chunkX, int chunkZ) {
        IChunkLoader loader;
        if (world.func_72863_F().func_73149_a(chunkX, chunkZ)) {
            return true;
        }
        if (world.func_72863_F() instanceof ChunkProviderServer && (loader = ((ChunkProviderServer)world.func_72863_F()).field_73247_e) instanceof AnvilChunkLoader) {
            return ((AnvilChunkLoader)loader).chunkExists(world, chunkX, chunkZ);
        }
        return false;
    }

    public static boolean checkIfServerChanged(MinecraftServer currentServer, WorldInfo worldInfo) {
        if (_server == currentServer) {
            return false;
        }
        if (currentServer != null && worldInfo == null) {
            if (currentServer.field_71305_c == null) {
                return false;
            }
            for (WorldServer world : currentServer.field_71305_c) {
                if (world != null) {
                    worldInfo = world.func_72912_H();
                }
                if (worldInfo != null) break;
            }
            if (worldInfo == null) {
                return false;
            }
        }
        ServerState.onServerChanged(currentServer, worldInfo);
        return true;
    }

    public static void onServerChanged(MinecraftServer server, WorldInfo worldInfo) {
        _worldConfigs.clear();
        WorldConfig.loadedOptionOverrides[2] = null;
        WorldConfig.loadedOptionOverrides[1] = null;
        _populatedChunks.clear();
        _server = server;
        CustomOreGenBase.log.debug("Server world changed to " + worldInfo.func_76065_j());
        BiomeGenBase[] worldBaseDir = BiomeGenBase.func_150565_n();
        int saveFormat = worldBaseDir.length;
        File var8 = null;
        ISaveFormat var9 = _server.func_71254_M();
        if (var9 != null && var9 instanceof SaveFormatOld) {
            var8 = ((SaveFormatOld)var9).field_75808_a;
        }
        var8 = new File(var8, _server.func_71270_I());
        WorldConfig var10 = null;
        while (var10 == null) {
            try {
                var10 = new WorldConfig(worldInfo, var8);
                ServerState.validateOptions(var10.getConfigOptions(), false);
                ServerState.validateDistributions(var10.getOreDistributions(), false);
            }
            catch (Exception var7) {
                if (!ServerState.onConfigError(var7)) break;
                var10 = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onWorldCreationMenuTick(GuiCreateWorld gui) {
        if (gui == null) {
            _optionsGuiButton = null;
        } else {
            if (_optionsGuiButton == null) {
                WorldConfig.loadedOptionOverrides[0] = null;
                GuiCustomOreGenSettings button = new GuiCustomOreGenSettings((GuiScreen)gui);
                _optionsGuiButton = new GuiCustomOreGenSettings.GuiOpenMenuButton((GuiScreen)gui, 99, 0, 0, 150, 20, "Custom Ore Generation...", button);
            }
            GuiCustomOreGenSettings.GuiOpenMenuButton button1 = (GuiCustomOreGenSettings.GuiOpenMenuButton)((Object)_optionsGuiButton);
            Collection controlList = (Collection)ReflectionHelper.getPrivateValue(GuiScreen.class, (Object)gui, (int)4);
            if (!controlList.contains((Object)button1)) {
                button1.field_146128_h = (gui.field_146294_l - button1.getWidth()) / 2;
                button1.field_146129_i = 165;
                controlList.add(button1);
            }
            button1.field_146125_m = (Boolean)ReflectionHelper.getPrivateValue(GuiCreateWorld.class, (Object)gui, (int)11) == false;
        }
    }

    public static void onClientLogin(EntityPlayerMP player) {
        if (player.field_70170_p != null && CustomOreGenBase.hasMystcraft()) {
            for (MystcraftSymbolData symbolData : ServerState.getWorldConfig(player.field_70170_p).getMystcraftSymbols()) {
                new CustomPacketPayload(CustomPacketPayload.PayloadType.MystcraftSymbolData, symbolData).sendToClient(player);
            }
        }
    }

    public static void chunkForced(World world, ChunkCoordIntPair location) {
        if (forcingChunk) {
            return;
        }
        forcingChunk = true;
        WorldConfig cfg = ServerState.getWorldConfig(world);
        int radius = (cfg.deferredPopulationRange + 15) / 16;
        for (int cX = location.field_77276_a - radius; cX <= location.field_77276_a + radius; ++cX) {
            for (int cZ = location.field_77275_b - radius; cZ <= location.field_77275_b + radius; ++cZ) {
                if (cX == location.field_77276_a || cZ == location.field_77275_b) continue;
                world.func_72964_e(cX, cZ);
            }
        }
        forcingChunk = false;
    }
}

