/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Server.ServerState;
import CustomOreGen.Util.BiomeDescriptor;
import CustomOreGen.Util.BlockDescriptor;
import CustomOreGen.Util.GeometryStream;
import CustomOreGen.Util.HeightScaledPDist;
import CustomOreGen.Util.IGeometryBuilder;
import CustomOreGen.Util.PDist;
import CustomOreGen.Util.TileEntityHelper;
import CustomOreGen.Util.Transform;
import CustomOreGen.Util.WireframeShapes;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public abstract class MapGenOreDistribution
extends MapGenStructure
implements IOreDistribution {
    @DistributionSettingMap.DistributionSetting(name="Name", inherited=false, info="Descriptive distribution name.")
    public String name;
    @DistributionSettingMap.DistributionSetting(name="DisplayName", inherited=false, info="Distribution name for display in user interfaces.")
    public String displayName;
    @DistributionSettingMap.DistributionSetting(name="Seed", inherited=false, info="Distribution random number seed.")
    public long seed;
    @DistributionSettingMap.DistributionSetting(name="OreBlock", info="Ore block(s) - total weight must not be more than 100%")
    public final BlockDescriptor oreBlock = new BlockDescriptor();
    @DistributionSettingMap.DistributionSetting(name="ReplaceableBlock", info="List of replaceable blocks")
    public final BlockDescriptor replaceableBlocks = new BlockDescriptor(Blocks.field_150348_b);
    @DistributionSettingMap.DistributionSetting(name="TargetBiome", info="List of valid target biomes")
    public final BiomeDescriptor biomes = new BiomeDescriptor(".*");
    @DistributionSettingMap.DistributionSetting(name="DistributionFrequency", info="Number of distribution structures per 16x16 chunk")
    public final HeightScaledPDist frequency = new HeightScaledPDist(0.025f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="Parent", info="The parent distribution, or null if no parent")
    public MapGenOreDistribution parent = null;
    @DistributionSettingMap.DistributionSetting(name="ParentRangeLimit", info="Max horizontal distance to a parent distribution, in meters")
    public final PDist parentRangeLimit = new PDist(32.0f, 32.0f, PDist.Type.normal);
    @DistributionSettingMap.DistributionSetting(name="MinHeight", info="Minimum absolute height allowed")
    public int minHeight;
    @DistributionSettingMap.DistributionSetting(name="MaxHeight", info="Maximum absolute height allowed")
    public int maxHeight;
    @DistributionSettingMap.DistributionSetting(name="HeightOffset", info="Number, in blocks, to add to the scaled height")
    public PDist heightOffset;
    @DistributionSettingMap.DistributionSetting(name="drawBoundBox", info="Whether bounding boxes are drawn for components")
    public boolean wfHasBB = false;
    @DistributionSettingMap.DistributionSetting(name="boundBoxColor", info="Color of bounding boxes for components")
    public long wfBBColor = Integer.MIN_VALUE;
    @DistributionSettingMap.DistributionSetting(name="drawWireframe", info="Whether wireframes are drawn for components")
    public boolean wfHasWireframe = false;
    @DistributionSettingMap.DistributionSetting(name="wireframeColor", info="Color of wireframes for components")
    public long wfWireframeColor = -15294967L;
    @DistributionSettingMap.DistributionSetting(name="completedStructures", info="Structures completed during current game session.")
    public int completedStructures = 0;
    @DistributionSettingMap.DistributionSetting(name="completedStructureBlocks", info="Blocks placed in structures completed during current game session.")
    public long completedStructureBlocks = 0L;
    @DistributionSettingMap.DistributionSetting(name="populatedChunks", info="Chunks populated during current game session.")
    public int populatedChunks = 0;
    @DistributionSettingMap.DistributionSetting(name="placedBlocks", info="Blocks placed during current game session.")
    public long placedBlocks = 0L;
    protected Map<Long, GeometryStream> debuggingGeometryMap = new HashMap<Long, GeometryStream>();
    protected boolean _valid = false;
    protected final boolean _canGenerate;
    private StructureGroup newestGroup = null;
    private StructureGroup oldestGroup = null;
    protected final DistributionSettingMap _settingMap;

    public MapGenOreDistribution(DistributionSettingMap settingMap, int distributionID, boolean canGenerate) {
        this.name = "Distribution_" + distributionID;
        this.seed = new Random(distributionID).nextLong();
        this._canGenerate = canGenerate;
        this._settingMap = settingMap;
        this.minHeight = 0;
        this.maxHeight = 256;
        this.heightOffset = new PDist();
    }

    @Override
    public void inheritFrom(IOreDistribution inherits) throws IllegalArgumentException {
        if (inherits == null || !this.getClass().isInstance(inherits)) {
            throw new IllegalArgumentException("Invalid source distribution '" + inherits + "'");
        }
        this._settingMap.inheritAll(inherits, this);
        this._valid = false;
    }

    public Map getDistributionSettings() {
        return this._settingMap.getDescriptions();
    }

    @Override
    public Object getDistributionSetting(String settingName) {
        return this._settingMap.get(this, settingName);
    }

    @Override
    public void setDistributionSetting(String settingName, Object value) throws IllegalArgumentException, IllegalAccessException {
        this._settingMap.set(this, settingName, value);
    }

    @Override
    public void generate(World world, int chunkX, int chunkZ) {
        if (this._canGenerate && this._valid) {
            if (world != this.field_75039_c) {
                this.clear();
            }
            this.func_151539_a(world.func_72863_F(), world, chunkX, chunkZ, null);
        }
    }

    @Override
    public void populate(World world, int chunkX, int chunkZ) {
        if (this._canGenerate && this._valid) {
            Random random = new Random(world.func_72905_C());
            long xSeed = random.nextLong() >> 3;
            long zSeed = random.nextLong() >> 3;
            random.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ world.func_72905_C() ^ this.seed);
            this.func_75051_a(world, random, chunkX, chunkZ);
        }
    }

    @Override
    public void cull() {
        if (this._canGenerate) {
            int groupsToSave;
            if (this.field_75053_d.size() > groupsToSave * 3) {
                StructureGroup group = this.newestGroup;
                for (groupsToSave = (int)(6.0f * Math.min(1.0f, this.frequency.pdist.getMax()) * (float)(2 * this.field_75040_a + 1) * (float)(2 * this.field_75040_a + 1)); group != null && groupsToSave > 0; --groupsToSave) {
                    group = group.olderGroup;
                }
                if (group != null) {
                    if (group.newerGroup == null) {
                        this.newestGroup = null;
                    } else {
                        group.newerGroup.olderGroup = null;
                    }
                    this.oldestGroup = group.newerGroup;
                    group.newerGroup = null;
                    while (group != null) {
                        Long key = ChunkCoordIntPair.func_77272_a((int)group.chunkX, (int)group.chunkZ);
                        this.field_75053_d.remove(key);
                        group = group.olderGroup;
                    }
                }
            }
        }
    }

    @Override
    public void clear() {
        if (this._canGenerate) {
            this.field_75053_d.clear();
            this.oldestGroup = null;
            this.newestGroup = null;
            this.debuggingGeometryMap.clear();
            this.populatedChunks = 0;
            this.completedStructures = 0;
            this.placedBlocks = 0L;
            this.completedStructureBlocks = 0L;
        }
    }

    public abstract double getAverageOreCount();

    @Override
    public double getOresPerChunk() {
        return (double)this.frequency.pdist.mean * this.getAverageOreCount();
    }

    @Override
    public GeometryStream getDebuggingGeometry(World world, int chunkX, int chunkZ) {
        if (this._canGenerate && this._valid) {
            if (world != this.field_75039_c) {
                return null;
            }
            long key = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
            return this.debuggingGeometryMap.get(key);
        }
        return null;
    }

    @Override
    public boolean validate() throws IllegalStateException {
        float biomeMatchWeight;
        float replBlockMatchWeight;
        this.clear();
        this._valid = true;
        float oreBlockMatchWeight = this.oreBlock.getTotalMatchWeight();
        if (oreBlockMatchWeight <= 0.0f) {
            if (this._canGenerate) {
                this._valid = false;
                throw new IllegalStateException("Ore block descriptor for " + this + " is empty or does not match any registered blocks.");
            }
        } else if (oreBlockMatchWeight > 1.0002f) {
            this._valid = false;
            throw new IllegalStateException("Ore block descriptor for " + this + " is overspecified with a total match weight of " + oreBlockMatchWeight * 100.0f + "%.");
        }
        if ((replBlockMatchWeight = this.replaceableBlocks.getTotalMatchWeight()) <= 0.0f) {
            // empty if block
        }
        if ((biomeMatchWeight = this.biomes.getTotalMatchWeight()) <= 0.0f) {
            // empty if block
        }
        if (this.minHeight > this.maxHeight) {
            this._valid = false;
            throw new IllegalStateException("Invalid height range [" + this.minHeight + "," + this.maxHeight + "] for " + this);
        }
        return this._valid && this._canGenerate;
    }

    protected StructureGroup getCachedStructureGroup(int chunkX, int chunkZ) {
        Long key = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
        StructureGroup group = (StructureGroup)((Object)this.field_75053_d.get(key));
        if (group != null) {
            StructureGroup older = group.olderGroup;
            StructureGroup newer = group.newerGroup;
            if (older == null) {
                this.oldestGroup = newer;
            } else {
                older.newerGroup = newer;
            }
            if (newer == null) {
                this.newestGroup = older;
            } else {
                newer.olderGroup = older;
            }
            group.newerGroup = null;
            group.olderGroup = this.newestGroup;
            if (this.newestGroup == null) {
                this.oldestGroup = group;
            } else {
                this.newestGroup.newerGroup = group;
            }
            this.newestGroup = group;
        }
        return group;
    }

    public void func_151539_a(IChunkProvider par1IChunkProvider, World par2World, int par3, int par4, Block[] chunkBlocks) {
        int k = this.field_75040_a;
        this.field_75039_c = par2World;
        this.field_75038_b.setSeed(par2World.func_72905_C());
        long l = this.field_75038_b.nextLong();
        long i1 = this.field_75038_b.nextLong();
        for (int j1 = par3 - k; j1 <= par3 + k; ++j1) {
            for (int k1 = par4 - k; k1 <= par4 + k; ++k1) {
                long l1 = (long)j1 * l;
                long i2 = (long)k1 * i1;
                this.field_75038_b.setSeed(l1 ^ i2 ^ par2World.func_72905_C());
                this.recursiveGenerate2(par2World, j1, k1, par3, par4, chunkBlocks);
            }
        }
    }

    protected void recursiveGenerate2(World world, int chunkX, int chunkZ, int rootX, int rootZ, Block[] chunkBlocks) {
        if (this.parent != null) {
            int group = this.parent.field_75040_a;
            this.parent.field_75040_a = ((int)this.parentRangeLimit.getMax() + 15) / 16;
            this.parent.generate(world, chunkX, chunkZ);
            this.parent.field_75040_a = group;
        }
        this.field_75038_b.setSeed((long)this.field_75038_b.nextInt() ^ this.seed);
        this.field_75038_b.nextInt();
        StructureGroup group1 = this.getCachedStructureGroup(chunkX, chunkZ);
        if (group1 == null) {
            this.field_75038_b.nextInt();
            if (this.func_75047_a(chunkX, chunkZ)) {
                group1 = (StructureGroup)this.func_75049_b(chunkX, chunkZ);
                long key = ChunkCoordIntPair.func_77272_a((int)chunkX, (int)chunkZ);
                this.field_75053_d.put(key, group1);
            }
        }
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        boolean canSpawn = false;
        if (this._canGenerate && this._valid) {
            canSpawn = this.frequency.getMax(this.field_75039_c, blockX, blockZ) >= 1.0f ? true : this.frequency.getIntValue(this.field_75038_b, this.field_75039_c, blockX, blockZ) == 1;
        }
        return canSpawn;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        int count = this.frequency.getMax(this.field_75039_c, blockX, blockZ) >= 1.0f ? this.frequency.getIntValue(this.field_75038_b, this.field_75039_c, blockX, blockZ) : 1;
        StructureGroup group = new StructureGroup(chunkX, chunkZ, count);
        group.newerGroup = null;
        group.olderGroup = this.newestGroup;
        if (this.newestGroup == null) {
            this.oldestGroup = group;
        } else {
            this.newestGroup.newerGroup = group;
        }
        this.newestGroup = group;
        return group;
    }

    public abstract Component generateStructure(StructureGroup var1, Random var2);

    public boolean func_75051_a(World world, Random random, int chunkX, int chunkZ) {
        if (this._canGenerate && this._valid) {
            int minX = chunkX << 4;
            int minZ = chunkZ << 4;
            StructureBoundingBox bb = new StructureBoundingBox(minX, 0, minZ, minX + 15, world.func_72800_K(), minZ + 15);
            boolean structureFound = false;
            for (int cX = chunkX - this.field_75040_a; cX <= chunkX + this.field_75040_a; ++cX) {
                for (int cZ = chunkZ - this.field_75040_a; cZ <= chunkZ + this.field_75040_a; ++cZ) {
                    StructureGroup group = this.getCachedStructureGroup(cX, cZ);
                    if (group == null || !group.func_75069_d() || !group.func_75071_a().func_78884_a(bb)) continue;
                    group.func_75068_a(world, random, bb);
                    structureFound = true;
                }
            }
            ++this.populatedChunks;
            return structureFound;
        }
        return false;
    }

    public ChunkPosition getNearestStructure(World world, int x, int y, int z) {
        if (this._canGenerate && this._valid) {
            ChunkPosition minPos = null;
            int minDist2 = Integer.MAX_VALUE;
            StructureBoundingBox searchBounds = new StructureBoundingBox(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            for (StructureGroup vs : this.field_75053_d.values()) {
                if (!vs.func_75071_a().func_78884_a(searchBounds)) continue;
                for (Component vc : vs.func_75073_b()) {
                    if (vc.func_74877_c() != 0) continue;
                    ChunkPosition center = vc.func_151553_a();
                    int dist2 = (center.field_151329_a - x) * (center.field_151329_a - x) + (center.field_151328_c - z) * (center.field_151328_c - z);
                    if (dist2 >= minDist2) continue;
                    minPos = center;
                    minDist2 = dist2;
                    int dist = (int)Math.sqrt(dist2) + 1;
                    searchBounds.field_78897_a = x - dist;
                    searchBounds.field_78896_c = z - dist;
                    searchBounds.field_78893_d = x + dist;
                    searchBounds.field_78892_f = z + dist;
                }
            }
            return minPos;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public class Component
    extends StructureComponent {
        public final StructureGroup structureGroup;
        public long populatedBlocks;
        public long placedBlocks;

        public Component(StructureGroup structureGroup) {
            super(0);
            this.populatedBlocks = 0L;
            this.placedBlocks = 0L;
            this.structureGroup = structureGroup;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
            int sizeX = Math.min(bounds.field_78893_d, this.field_74887_e.field_78893_d) - Math.max(bounds.field_78897_a, this.field_74887_e.field_78897_a) + 1;
            int sizeY = Math.min(bounds.field_78894_e, this.field_74887_e.field_78894_e) - Math.max(bounds.field_78895_b, this.field_74887_e.field_78895_b) + 1;
            int sizeZ = Math.min(bounds.field_78892_f, this.field_74887_e.field_78892_f) - Math.max(bounds.field_78896_c, this.field_74887_e.field_78896_c) + 1;
            if (sizeX > 0 && sizeY > 0 && sizeZ > 0) {
                this.populatedBlocks += (long)(sizeX * sizeY * sizeZ);
                sizeX = this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a + 1;
                sizeY = Math.min(world.func_72800_K() - 1, this.field_74887_e.field_78894_e) - Math.max(0, this.field_74887_e.field_78895_b) + 1;
                long totalVolume = sizeX * sizeY * (sizeZ = this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c + 1);
                if (this.populatedBlocks == totalVolume && this.structureGroup != null) {
                    ++this.structureGroup.completeComponents;
                    this.structureGroup.completeComponentBlocks += this.placedBlocks;
                }
                return true;
            }
            return true;
        }

        public boolean attemptPlaceBlock(World world, Random random, int x, int y, int z, StructureBoundingBox bounds) {
            int metadata;
            int cz;
            int cx;
            if (!bounds.func_78890_b(x, y, z)) {
                return false;
            }
            Chunk chunk = world.func_72938_d(x, z);
            Block block = chunk.func_150810_a(cx = x & 0xF, y, cz = z & 0xF);
            int fastCheck = MapGenOreDistribution.this.replaceableBlocks.matchesBlock_fast(block);
            if (fastCheck == 0) {
                return false;
            }
            if (fastCheck == -1 && !MapGenOreDistribution.this.replaceableBlocks.matchesBlock(block, chunk.func_76628_c(cx, y, cz), random)) {
                return false;
            }
            BlockDescriptor.BlockInfo match = MapGenOreDistribution.this.oreBlock.getMatchingBlock(random);
            if (match == null) {
                return false;
            }
            Block oreBlock = match.getBlock();
            boolean placed = world.func_147465_d(x, y, z, oreBlock, metadata = match.getMetadata(), 2);
            if (placed) {
                TileEntityHelper.readFromPartialNBT(world, x, y, z, match.getNBT());
                ++this.placedBlocks;
                ++MapGenOreDistribution.this.placedBlocks;
                world.func_147471_g(x, y, z);
            }
            return placed;
        }

        public void setParent(Component parent) {
            this.field_74886_g = parent != null ? parent.field_74886_g + 1 : 0;
        }

        public void setChild(Component child) {
            if (child != null) {
                child.field_74886_g = this.field_74886_g + 1;
            }
        }

        public void buildWireframe(IGeometryBuilder gb) {
            float[] color = new float[4];
            if (MapGenOreDistribution.this.wfHasBB) {
                color[3] = (float)(MapGenOreDistribution.this.wfBBColor >>> 24 & 0xFFL) / 255.0f;
                color[0] = (float)(MapGenOreDistribution.this.wfBBColor >>> 16 & 0xFFL) / 255.0f;
                color[1] = (float)(MapGenOreDistribution.this.wfBBColor >>> 8 & 0xFFL) / 255.0f;
                color[2] = (float)(MapGenOreDistribution.this.wfBBColor & 0xFFL) / 255.0f;
                gb.setColor(color);
                StructureBoundingBox bounds = this.func_74874_b();
                Transform trans = new Transform();
                trans.scale(0.5f, 0.5f, 0.5f);
                trans.translate(bounds.field_78893_d + bounds.field_78897_a, bounds.field_78894_e + bounds.field_78895_b, bounds.field_78892_f + bounds.field_78896_c);
                trans.scale(bounds.field_78893_d - bounds.field_78897_a, bounds.field_78894_e - bounds.field_78895_b, bounds.field_78892_f - bounds.field_78896_c);
                gb.setPositionTransform(trans);
                WireframeShapes.addUnitWireCube(gb);
            }
            if (MapGenOreDistribution.this.wfHasWireframe) {
                color[3] = (float)(MapGenOreDistribution.this.wfWireframeColor >>> 24 & 0xFFL) / 255.0f;
                color[0] = (float)(MapGenOreDistribution.this.wfWireframeColor >>> 16 & 0xFFL) / 255.0f;
                color[1] = (float)(MapGenOreDistribution.this.wfWireframeColor >>> 8 & 0xFFL) / 255.0f;
                color[2] = (float)(MapGenOreDistribution.this.wfWireframeColor & 0xFFL) / 255.0f;
                gb.setColor(color);
            }
        }

        protected void func_143012_a(NBTTagCompound nbttagcompound) {
        }

        protected void func_143011_b(NBTTagCompound nbttagcompound) {
        }
    }

    public class StructureGroup
    extends StructureStart {
        public final int structureCount;
        public int completeComponents = 0;
        public long completeComponentBlocks = 0L;
        public final int chunkX;
        public final int chunkZ;
        private StructureGroup newerGroup;
        private StructureGroup olderGroup;

        public StructureGroup(int chunkX, int chunkZ, int structureCount) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            int trueStructureCount = 0;
            for (int i = 0; i < structureCount; ++i) {
                Random random = new Random(MapGenOreDistribution.this.field_75038_b.nextLong());
                if (MapGenOreDistribution.this.generateStructure(this, random) == null) continue;
                ++trueStructureCount;
            }
            this.structureCount = trueStructureCount;
            this.func_75072_c();
            if (ServerState.getWorldConfig((World)((MapGenOreDistribution)MapGenOreDistribution.this).field_75039_c).debuggingMode && (MapGenOreDistribution.this.wfHasBB || MapGenOreDistribution.this.wfHasWireframe)) {
                this.buildWireframes();
            }
        }

        public boolean func_75069_d() {
            return true;
        }

        public void addComponent(Component component, Component parent) {
            this.field_75075_a.add(component);
            component.setParent(parent);
            if (parent != null) {
                parent.setChild(component);
            }
        }

        public boolean canPlaceComponentAt(int componentType, float x, float y, float z, Random random) {
            BiomeGenBase dist;
            int iX = MathHelper.func_76141_d((float)x);
            int iY = MathHelper.func_76141_d((float)y);
            int iZ = MathHelper.func_76141_d((float)z);
            if (componentType == 0 && (dist = MapGenOreDistribution.this.field_75039_c.func_72807_a(iX, iZ)) != null && !MapGenOreDistribution.this.biomes.matchesBiome(dist, random)) {
                return false;
            }
            if (componentType == 0 && (iY < MapGenOreDistribution.this.minHeight || iY > MapGenOreDistribution.this.maxHeight)) {
                return false;
            }
            if (componentType == 0) {
                float dist1 = MapGenOreDistribution.this.parentRangeLimit.getValue(random);
                if (MapGenOreDistribution.this.parent != null) {
                    if (dist1 < 0.0f) {
                        return false;
                    }
                    ChunkPosition parentPos = MapGenOreDistribution.this.parent.getNearestStructure(MapGenOreDistribution.this.field_75039_c, iX, 0, iZ);
                    if (parentPos == null) {
                        return false;
                    }
                    float dx = parentPos.field_151329_a - iX;
                    float dz = parentPos.field_151328_c - iZ;
                    if (dx * dx + dz * dz > dist1 * dist1) {
                        return false;
                    }
                }
            }
            return true;
        }

        public void func_75068_a(World world, Random random, StructureBoundingBox bounds) {
            int oldCompleteComponents = this.completeComponents;
            super.func_75068_a(world, random, bounds);
            if (oldCompleteComponents != this.completeComponents && this.completeComponents == this.field_75075_a.size()) {
                MapGenOreDistribution.this.completedStructures += this.structureCount;
                MapGenOreDistribution.this.completedStructureBlocks += this.completeComponentBlocks;
            }
        }

        public void buildWireframes() {
            for (Component comp : this.func_75073_b()) {
                int cZ;
                StructureBoundingBox bb = comp.func_74874_b();
                int cX = bb.func_78881_e() / 16;
                long key = (long)cX << 32 | (long)(cZ = bb.func_78891_g() / 16) & 0xFFFFFFFFL;
                GeometryStream builder = MapGenOreDistribution.this.debuggingGeometryMap.get(key);
                if (builder == null) {
                    builder = new GeometryStream();
                    MapGenOreDistribution.this.debuggingGeometryMap.put(key, builder);
                }
                comp.buildWireframe(builder);
            }
        }
    }
}

