/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.CustomOreGenBase;
import CustomOreGen.CustomPacketPayload;
import CustomOreGen.Server.ConfigOption;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Server.ServerState;
import CustomOreGen.Server.WorldConfig;
import CustomOreGen.Util.BiomeDescriptor;
import CustomOreGen.Util.BlockDescriptor;
import CustomOreGen.Util.ConsoleCommand;
import CustomOreGen.Util.PDist;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ConsoleCommands {
    private static void resetClientGeometryCache() {
        new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryReset, null).sendToAllClients();
    }

    private static void buildFieldValue(StringBuilder msg, String indent, String name, String desc, Object value) {
        msg.append('\n');
        msg.append(indent);
        msg.append(name);
        msg.append(" = ");
        if (value != null) {
            msg.append('[');
            msg.append(value.getClass().getSimpleName());
            msg.append("] ");
            msg.append(value);
            if (desc != null) {
                if (value instanceof BlockDescriptor) {
                    for (String line : ((BlockDescriptor)value).toDetailedString()) {
                        msg.append('\n');
                        msg.append(indent);
                        msg.append("  ");
                        msg.append(line);
                    }
                } else if (value instanceof BiomeDescriptor) {
                    for (String line : ((BiomeDescriptor)value).toDetailedString()) {
                        msg.append('\n');
                        msg.append(indent);
                        msg.append("  ");
                        msg.append(line);
                    }
                }
            }
        } else {
            msg.append("[null]");
        }
        if (desc != null) {
            msg.append('\n');
            msg.append(indent);
            msg.append("  ");
            msg.append("\u00a77");
            msg.append(desc);
            msg.append("\u00a7r");
        }
    }

    @ConsoleCommand.CommandDelegate(desc="Dumps a summary of a distribution or a specific distribution setting to the console.")
    public String cogInfo(@ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") @ConsoleCommand.ArgOptional String distribution, @ConsoleCommand.ArgName(name="setting") @ConsoleCommand.ArgOptional String setting, @ConsoleCommand.ArgName(name="detail") @ConsoleCommand.ArgOptional(defValue="false") boolean detail) {
        StringBuilder msg = new StringBuilder();
        WorldConfig config = ServerState.getWorldConfig((World)world);
        Collection<IOreDistribution> allDists = config.getOreDistributions();
        Collection<IOreDistribution> dists = distribution != null && !distribution.isEmpty() ? config.getOreDistributions(distribution) : null;
        msg.append(CustomOreGenBase.getDisplayString() + " (");
        if (config.world != null) {
            msg.append("Dim " + config.world.field_73011_w.field_76574_g + ", ");
        }
        if (dists != null) {
            msg.append(dists.size() + "/");
        }
        msg.append(allDists.size() + " distributions");
        msg.append(')');
        if (dists != null && dists.size() > 0) {
            msg.append(':');
            Pattern pattern = setting != null && !setting.isEmpty() ? Pattern.compile(setting, 2) : null;
            for (IOreDistribution dist : dists) {
                msg.append("\n " + dist);
                if (pattern == null) continue;
                Map<String, Object> descriptions = dist.getDistributionSettings();
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, Object> entry : descriptions.entrySet()) {
                    if (!pattern.matcher(entry.getKey()).matches()) continue;
                    Object value = dist.getDistributionSetting(entry.getKey());
                    values.put(entry.getKey(), value);
                }
                values.put("Expected ores per chunk", Float.valueOf((float)dist.getOresPerChunk()));
                msg.append(" (" + values.size() + "/" + descriptions.size() + " settings)");
                if (values.size() > 0) {
                    msg.append(':');
                }
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    ConsoleCommands.buildFieldValue(msg, "  ", entry.getKey(), detail ? (String)descriptions.get(entry.getKey()) : null, entry.getValue());
                }
            }
        }
        CustomOreGenBase.log.info(msg.toString());
        return msg.toString();
    }

    @ConsoleCommand.CommandDelegate(desc="Sets the global wireframe rendering mode.  Omit mode to cycle through modes.")
    public void cogWireframeMode(ICommandSender sender, @ConsoleCommand.ArgName(name="None|Polygon|Wireframe|WireframeOverlay") @ConsoleCommand.ArgOptional String renderMode) {
        if (!(sender instanceof EntityPlayerMP)) {
            throw new IllegalArgumentException("/cogWireframeMode is a client-side command and may only be used by a player.");
        }
        new CustomPacketPayload(CustomPacketPayload.PayloadType.DebuggingGeometryRenderMode, (Serializable)((Object)renderMode)).sendToClient((EntityPlayerMP)sender);
    }

    @ConsoleCommand.CommandDelegate(desc="Clears cached structure information.  Omit distribution name to clear all distributions.")
    public String cogClear(@ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") @ConsoleCommand.ArgOptional(defValue=".*") String distribution) {
        int count = 0;
        for (IOreDistribution dist : ServerState.getWorldConfig((World)world).getOreDistributions(distribution)) {
            ++count;
            dist.clear();
            dist.validate();
        }
        ConsoleCommands.resetClientGeometryCache();
        return "Cleared " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Repopulates chunks in the specified range around the player.  Omit distribution name to repopulate all distributions.")
    public String cogPopulate(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="chunkRange") int chunkRange, @ConsoleCommand.ArgName(name="distribution") @ConsoleCommand.ArgOptional(defValue=".*") String distribution, @ConsoleCommand.ArgName(name="centerX") @ConsoleCommand.ArgOptional Integer centerX, @ConsoleCommand.ArgName(name="centerZ") @ConsoleCommand.ArgOptional Integer centerZ) {
        WorldConfig cfg = ServerState.getWorldConfig((World)world);
        Collection<IOreDistribution> list = cfg.getOreDistributions(distribution);
        ChunkCoordinates senderPos = sender.func_82114_b();
        int cX = centerX == null ? senderPos.field_71574_a : centerX;
        int cZ = centerZ == null ? senderPos.field_71573_c : centerZ;
        for (int chunkX = (cX >> 4) - chunkRange; chunkX <= (cX >> 4) + chunkRange; ++chunkX) {
            for (int chunkZ = (cZ >> 4) - chunkRange; chunkZ <= (cZ >> 4) + chunkRange; ++chunkZ) {
                cfg.world.func_72964_e(chunkX, chunkZ);
                ServerState.populateDistributions(list, cfg.world, chunkX, chunkZ);
            }
        }
        return "Populated " + list.size() + " distributions in " + (2 * chunkRange + 1) * (2 * chunkRange + 1) + " chunk(s) around (" + cX + ",0," + cZ + ")";
    }

    @ConsoleCommand.CommandDelegate(desc="Sets the parent distribution.  Omit parent name to clear parent distribution.")
    public String cogParent(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="parent") @ConsoleCommand.ArgOptional String parent) {
        WorldConfig cfg = ServerState.getWorldConfig((World)world);
        IOreDistribution parentDist = null;
        if (parent != null) {
            Collection<IOreDistribution> count = cfg.getOreDistributions(parent);
            if (count.isEmpty()) {
                throw new IllegalArgumentException("Parent name '" + parent + "' does not match any distributions.");
            }
            if (count.size() > 1) {
                throw new IllegalArgumentException("Parent name '" + parent + "' is ambiguous (matches " + count.size() + " distributions).");
            }
            parentDist = count.iterator().next();
        }
        int var12 = 0;
        for (IOreDistribution dist : cfg.getOreDistributions(distribution)) {
            try {
                dist.setDistributionSetting(IOreDistribution.StandardSettings.Parent.name(), parentDist);
                ++var12;
                dist.clear();
                dist.validate();
            }
            catch (Exception var11) {
                ConsoleCommand.sendText(sender, "\u00a7c" + var11.getMessage());
            }
        }
        ConsoleCommands.resetClientGeometryCache();
        return "Changed parent for " + var12 + " distributions";
    }

    private static int changeBiomeDescriptor(String settingName, ICommandSender sender, WorldServer world, String distribution, String descriptor, float weight, boolean clear) {
        int count = 0;
        for (IOreDistribution dist : ServerState.getWorldConfig((World)world).getOreDistributions(distribution)) {
            try {
                Object ex = dist.getDistributionSetting(settingName);
                if (ex == null) {
                    throw new IllegalArgumentException("Distribution '" + dist + "' does not support descriptor " + settingName + ".");
                }
                if (!(ex instanceof BiomeDescriptor)) {
                    throw new IllegalArgumentException("Setting " + settingName + " on Distribution '" + dist + "' is not a biome descriptor.");
                }
                BiomeDescriptor desc = (BiomeDescriptor)ex;
                if (clear) {
                    desc.clear();
                }
                desc.add(descriptor, weight);
                ++count;
                dist.clear();
                dist.validate();
            }
            catch (Exception var12) {
                ConsoleCommand.sendText(sender, "\u00a7c" + var12.getMessage());
            }
        }
        ConsoleCommands.resetClientGeometryCache();
        return count;
    }

    private static int changeBlockDescriptor(String settingName, ICommandSender sender, WorldServer world, String distribution, String descriptor, float weight, boolean clear, boolean describesOre, boolean matchFirst, boolean isRegexp, String nbt) {
        int count = 0;
        for (IOreDistribution dist : ServerState.getWorldConfig((World)world).getOreDistributions(distribution)) {
            try {
                Object ex = dist.getDistributionSetting(settingName);
                if (ex == null) {
                    throw new IllegalArgumentException("Distribution '" + dist + "' does not support descriptor " + settingName + ".");
                }
                if (!(ex instanceof BlockDescriptor)) {
                    throw new IllegalArgumentException("Setting " + settingName + " on Distribution '" + dist + "' is not a block descriptor.");
                }
                if (ex instanceof BlockDescriptor) {
                    NBTBase nbtBase;
                    BlockDescriptor desc = (BlockDescriptor)ex;
                    if (clear) {
                        desc.clear();
                    }
                    if (!((nbtBase = JsonToNBT.func_150315_a((String)nbt)) instanceof NBTTagCompound)) {
                        throw new IllegalArgumentException("NBT is not a compound tag");
                    }
                    desc.add(descriptor, weight, describesOre, isRegexp, matchFirst, nbt == null ? null : (NBTTagCompound)nbtBase);
                    ++count;
                }
                dist.clear();
                dist.validate();
            }
            catch (Exception var12) {
                ConsoleCommand.sendText(sender, "\u00a7c" + var12.getMessage());
            }
        }
        ConsoleCommands.resetClientGeometryCache();
        return count;
    }

    @ConsoleCommand.CommandDelegate(desc="Adds an ore block.")
    public String cogAddOreBlock(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="block") String block, @ConsoleCommand.ArgName(name="weight") @ConsoleCommand.ArgOptional(defValue="1") float weight, @ConsoleCommand.ArgName(name="matchFirstOre") @ConsoleCommand.ArgOptional(defValue="false") boolean matchFirstOre, @ConsoleCommand.ArgName(name="nbt") @ConsoleCommand.ArgOptional String nbt) {
        String setting = IOreDistribution.StandardSettings.OreBlock.name();
        int count = ConsoleCommands.changeBlockDescriptor(setting, sender, world, distribution, block, weight, false, matchFirstOre, matchFirstOre, false, nbt);
        return "Added ore block for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Sets the ore block (clearing any previous ore blocks).")
    public String cogSetOreBlock(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="block") String block, @ConsoleCommand.ArgName(name="weight") @ConsoleCommand.ArgOptional(defValue="1") float weight, @ConsoleCommand.ArgName(name="matchFirstOre") @ConsoleCommand.ArgOptional(defValue="false") boolean matchFirstOre, @ConsoleCommand.ArgName(name="nbt") @ConsoleCommand.ArgOptional String nbt) {
        String setting = IOreDistribution.StandardSettings.OreBlock.name();
        int count = ConsoleCommands.changeBlockDescriptor(setting, sender, world, distribution, block, weight, true, matchFirstOre, matchFirstOre, false, nbt);
        return "Set ore block for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Adds a replaceable block.")
    public String cogAddReplaceable(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="block") String block, @ConsoleCommand.ArgName(name="weight") @ConsoleCommand.ArgOptional(defValue="1") float weight, @ConsoleCommand.ArgName(name="replacesOre") @ConsoleCommand.ArgOptional boolean replacesOre, @ConsoleCommand.ArgName(name="isRegexp") @ConsoleCommand.ArgOptional boolean isRegexp) {
        String setting = IOreDistribution.StandardSettings.ReplaceableBlock.name();
        int count = ConsoleCommands.changeBlockDescriptor(setting, sender, world, distribution, block, weight, false, replacesOre, false, isRegexp, null);
        return "Added replaceable block for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Sets the replaceable block (clearing any previous replaceable blocks).")
    public String cogSetReplaceable(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="block") String block, @ConsoleCommand.ArgName(name="weight") @ConsoleCommand.ArgOptional(defValue="1") float weight, @ConsoleCommand.ArgName(name="replacesOre") @ConsoleCommand.ArgOptional boolean replacesOre, @ConsoleCommand.ArgName(name="isRegexp") @ConsoleCommand.ArgOptional boolean isRegexp) {
        String setting = IOreDistribution.StandardSettings.ReplaceableBlock.name();
        int count = ConsoleCommands.changeBlockDescriptor(setting, sender, world, distribution, block, weight, true, replacesOre, false, isRegexp, null);
        return "Set replaceable block for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Adds a target biome.")
    public String cogAddBiome(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="biome") String biome, @ConsoleCommand.ArgName(name="weight") @ConsoleCommand.ArgOptional(defValue="1") float weight) {
        String setting = IOreDistribution.StandardSettings.TargetBiome.name();
        int count = ConsoleCommands.changeBiomeDescriptor(setting, sender, world, distribution, biome, weight, false);
        return "Added biome for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Sets the target biome (clearing any previous biomes).")
    public String cogSetBiome(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="biome") String biome, @ConsoleCommand.ArgName(name="weight") @ConsoleCommand.ArgOptional(defValue="1") float weight) {
        String setting = IOreDistribution.StandardSettings.TargetBiome.name();
        int count = ConsoleCommands.changeBiomeDescriptor(setting, sender, world, distribution, biome, weight, true);
        return "Set biome for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Sets a distribution setting.  Setting names are the same as the <Setting> names in the config file.  Range and Type are optional (default to 0 and 'uniform', respectively).")
    public String cogSetting(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="setting") String setting, @ConsoleCommand.ArgName(name="average") float average, @ConsoleCommand.ArgName(name="range") @ConsoleCommand.ArgOptional(defValue="0") float range, @ConsoleCommand.ArgName(name="type") @ConsoleCommand.ArgOptional(defValue="uniform") PDist.Type type) {
        int count = 0;
        for (IOreDistribution dist : ServerState.getWorldConfig((World)world).getOreDistributions(distribution)) {
            try {
                dist.setDistributionSetting(setting, new PDist(average, range, type));
                ++count;
                dist.clear();
                dist.validate();
            }
            catch (Exception var12) {
                ConsoleCommand.sendText(sender, "\u00a7c" + var12.getMessage());
            }
        }
        ConsoleCommands.resetClientGeometryCache();
        return "Changed '" + setting + "' for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Sets a simple numeric/boolean/string/enum setting.  Setting names are the same as the corresponding attributes in the config file.")
    public String cogSettingEx(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="distribution") String distribution, @ConsoleCommand.ArgName(name="setting") String setting, @ConsoleCommand.ArgName(name="value") String value) {
        int count = 0;
        for (IOreDistribution dist : ServerState.getWorldConfig((World)world).getOreDistributions(distribution)) {
            try {
                dist.setDistributionSetting(setting, value);
                ++count;
                dist.clear();
                dist.validate();
            }
            catch (Exception var10) {
                ConsoleCommand.sendText(sender, "\u00a7c" + var10.getMessage());
            }
        }
        ConsoleCommands.resetClientGeometryCache();
        return "Changed '" + setting + "' for " + count + " distributions";
    }

    @ConsoleCommand.CommandDelegate(desc="Dumps a summary of an Option to the console.")
    public String cogOptionInfo(@ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="option") @ConsoleCommand.ArgOptional String option, @ConsoleCommand.ArgName(name="detail") @ConsoleCommand.ArgOptional(defValue="false") boolean detail) {
        StringBuilder msg = new StringBuilder();
        WorldConfig config = ServerState.getWorldConfig((World)world);
        Collection<ConfigOption> allOptions = config.getConfigOptions();
        Collection<ConfigOption> options = option != null && !option.isEmpty() ? config.getConfigOptions(option) : null;
        msg.append(CustomOreGenBase.getDisplayString() + " (");
        if (config.world != null) {
            msg.append("Dim " + config.world.field_73011_w.field_76574_g + ", ");
        }
        if (options != null) {
            msg.append(options.size() + "/");
        }
        msg.append(allOptions.size() + " options");
        msg.append(')');
        if (options != null && options.size() > 0) {
            msg.append(':');
            for (ConfigOption opt : options) {
                ConsoleCommands.buildFieldValue(msg, "  ", opt.getName(), detail ? opt.getDescription() : null, opt.getValue());
            }
        }
        CustomOreGenBase.log.info(msg.toString());
        return msg.toString();
    }

    @ConsoleCommand.CommandDelegate(desc="Set an option value for the current dimension.  The change lasts until the world configuration is reloaded.")
    public String cogOption(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="option") String option, @ConsoleCommand.ArgName(name="value") String value) {
        WorldConfig cfg = ServerState.getWorldConfig((World)world);
        Collection<ConfigOption> options = cfg.getConfigOptions(option);
        int count = 0;
        for (ConfigOption opt : options) {
            if (opt.setValue(value)) {
                ++count;
                continue;
            }
            ConsoleCommand.sendText(sender, "\u00a7cInvalid value '" + value + "' for Option '" + opt.getName() + "'");
        }
        WorldConfig.loadedOptionOverrides[2] = options;
        ServerState.clearWorldConfig((World)world);
        cfg = ServerState.getWorldConfig((World)world);
        String var10 = cfg.dimensionDir.toString();
        WorldConfig.loadedOptionOverrides[2] = null;
        ConsoleCommands.resetClientGeometryCache();
        return "Changed " + count + " options for " + var10;
    }

    @ConsoleCommand.CommandDelegate(isDebugging=false, desc="Enabled or disable debugging mode for the current dimension.")
    public String cogEnableDebugging(ICommandSender sender, @ConsoleCommand.ArgName(name="dimension") WorldServer world, @ConsoleCommand.ArgName(name="enable") @ConsoleCommand.ArgOptional(defValue="true") boolean enabled) {
        return this.cogOption(sender, world, "debugMode", Boolean.toString(enabled));
    }

    @ConsoleCommand.CommandDelegate(desc="Reloads the world configuration from disk.  This will reset any changes made via console commands.")
    public String cogLoadConfig(@ConsoleCommand.ArgName(name="dimension") WorldServer world) {
        ServerState.clearWorldConfig((World)world);
        String path = ServerState.getWorldConfig((World)world).dimensionDir.toString();
        ConsoleCommands.resetClientGeometryCache();
        return "Reloaded config data for " + path;
    }
}

