/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.ConfigParser;
import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorSimpleNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorNode {
    private ConfigParser _parser = null;
    private Node _node = null;
    private Hashtable<List, IValidatorFactory> _validatorMap = null;
    private boolean _validatorMapShared = false;

    public ValidatorNode(ConfigParser parser, Node node) {
        this._parser = parser;
        this._node = node;
        node.setUserData("validator", this, null);
    }

    protected ValidatorNode(ValidatorNode parent, Node node) {
        if (parent._validatorMap != null) {
            this._validatorMap = parent._validatorMap;
            parent._validatorMapShared = true;
            this._validatorMapShared = true;
        }
        this._parser = parent._parser;
        this._node = node;
        node.setUserData("validator", this, null);
    }

    public final Node getNode() {
        return this._node;
    }

    public final ConfigParser getParser() {
        return this._parser;
    }

    public final void addGlobalValidator(short nodeType, String nodeName, IValidatorFactory factory) {
        List<Object> key = Arrays.asList(nodeType, nodeName.toLowerCase());
        if (this._validatorMap == null) {
            this._validatorMap = new Hashtable();
            this._validatorMapShared = false;
        } else if (this._validatorMapShared) {
            this._validatorMap = new Hashtable<List, IValidatorFactory>(this._validatorMap);
            this._validatorMapShared = false;
        }
        this._validatorMap.put(key, factory);
    }

    public final void validate() throws ParserException {
        if (this.validateChildren()) {
            this.checkChildrenValid();
        }
    }

    protected boolean validateChildren() throws ParserException {
        if (this._validatorMap != null) {
            LinkedList<Node> childList = new LinkedList<Node>();
            NamedNodeMap attributes = this._node.getAttributes();
            for (int children = 0; attributes != null && children < attributes.getLength(); ++children) {
                childList.addLast(attributes.item(children));
            }
            NodeList elements = this._node.getChildNodes();
            for (int children = 0; elements != null && children < elements.getLength(); ++children) {
                childList.addLast(elements.item(children));
            }
            for (Node child : childList) {
                Object validator;
                List<Object> key = Arrays.asList(child.getNodeType(), child.getNodeName().toLowerCase());
                IValidatorFactory factory = this._validatorMap.get(key);
                if (factory == null || (validator = factory.createValidator(this, child)) == null) continue;
                ((ValidatorNode)validator).validate();
            }
        }
        return true;
    }

    protected void checkChildrenValid() throws ParserException {
        NamedNodeMap attributes = this._node.getAttributes();
        for (int children = 0; attributes != null && children < attributes.getLength(); ++children) {
            Node c = attributes.item(children);
            if (c.getUserData("validated") != null) continue;
            throw new ParserException("Unexpected at this location.", c);
        }
        NodeList var5 = this._node.getChildNodes();
        block5: for (int var6 = 0; var5 != null && var6 < var5.getLength(); ++var6) {
            Node child = var5.item(var6);
            switch (child.getNodeType()) {
                case 3: {
                    if (child.getNodeValue() == null || child.getNodeValue().trim().isEmpty()) continue block5;
                }
                case 8: 
                case 9: {
                    continue block5;
                }
                default: {
                    if (child.getUserData("validated") != null) continue block5;
                    throw new ParserException("Unexpected at this location.", child);
                }
            }
        }
    }

    protected final <T extends ValidatorNode> LinkedList<T> validateNamedChildren(int nodeTypeMask, String nodeName, IValidatorFactory<T> factory) throws ParserException {
        LinkedList<T> childList = new LinkedList<T>();
        NamedNodeMap attributes = this._node.getAttributes();
        NodeList children = this._node.getChildNodes();
        int attrCount = attributes == null ? 0 : attributes.getLength();
        int childCount = children == null ? 0 : children.getLength();
        for (int i = -attrCount; i < childCount; ++i) {
            Node validator;
            Node node = validator = i < 0 ? attributes.item(-i - 1) : children.item(i);
            if ((nodeTypeMask >>> validator.getNodeType()) % 2 == 0 || nodeName != null && !validator.getNodeName().equalsIgnoreCase(nodeName)) continue;
            validator.setUserData("validated", true, null);
            if (factory == null) continue;
            childList.addLast(factory.createValidator(this, validator));
        }
        for (ValidatorNode child : childList) {
            child.validate();
        }
        return childList;
    }

    protected final <T> T validateNamedAttribute(Class<T> attrType, String attrName, T defaultValue, boolean allowElements) throws ParserException {
        LinkedList<ValidatorSimpleNode> children;
        ConfigParser.ConfigExpressionEvaluator configExpressionEvaluator;
        if (defaultValue == null) {
            configExpressionEvaluator = null;
        } else {
            ConfigParser configParser = this.getParser();
            configParser.getClass();
            configExpressionEvaluator = configParser.new ConfigParser.ConfigExpressionEvaluator(defaultValue);
        }
        ConfigParser.ConfigExpressionEvaluator evaluator = configExpressionEvaluator;
        Object value = null;
        int mask = 4;
        if (allowElements) {
            mask |= 2;
        }
        if (!(children = this.validateNamedChildren(mask, attrName, new ValidatorSimpleNode.Factory(attrType, evaluator))).isEmpty()) {
            value = children.getLast().content;
        }
        return (T)(value == null ? defaultValue : value);
    }

    protected final <T> T validateRequiredAttribute(Class<T> attrType, String attrName, boolean allowElements) throws ParserException {
        T value = this.validateNamedAttribute(attrType, attrName, null, allowElements);
        if (value != null) {
            return value;
        }
        throw new ParserException("Required attribute '" + attrName + "' not found.", this.getNode());
    }

    protected final void replaceWithNode(Node ... newNodes) throws ParserException {
        Node parent = this.getNode().getParentNode();
        if (parent != null) {
            if (newNodes != null && newNodes.length > 0) {
                for (Node newNode : newNodes) {
                    if (newNode == null) continue;
                    Node n = newNode;
                    while (true) {
                        Node attr;
                        if ((attr = (Node)n.getUserData("hidden-parent")) == null) {
                            n.setUserData("hidden-parent", this.getNode(), null);
                            break;
                        }
                        if (attr == this.getNode()) break;
                        n = attr;
                    }
                    if (newNode.getNodeType() == 2) {
                        if (parent.getNodeType() != 1) {
                            throw new ParserException("Attempting to merge attribute to non-element node.", newNode);
                        }
                        Attr var9 = (Attr)newNode;
                        var9.getOwnerElement().removeAttributeNode(var9);
                        ((Element)parent).setAttributeNode(var9);
                        continue;
                    }
                    parent.insertBefore(newNode, this.getNode());
                }
            }
            parent.removeChild(this.getNode());
        }
    }

    protected final void replaceWithNodeContents(Node ... containerNodes) throws ParserException {
        Node parent = this.getNode().getParentNode();
        if (parent != null) {
            if (containerNodes != null && containerNodes.length > 0) {
                ArrayList<Node> content = new ArrayList<Node>();
                for (Node containerNode : containerNodes) {
                    Node hiddenParent;
                    Node n;
                    Node child;
                    if (containerNode == null) continue;
                    if (containerNode != this.getNode()) {
                        child = containerNode;
                        while (true) {
                            if ((n = (Node)child.getUserData("hidden-parent")) == null) {
                                child.setUserData("hidden-parent", this.getNode(), null);
                                break;
                            }
                            if (n == this.getNode()) break;
                            child = n;
                        }
                    }
                    if (parent.getNodeType() == 1) {
                        NamedNodeMap var13 = containerNode.getAttributes();
                        for (int var14 = 0; var14 < var13.getLength(); ++var14) {
                            Node n1 = hiddenParent = var13.item(var14);
                            while (true) {
                                Node hiddenParent1;
                                if ((hiddenParent1 = (Node)n1.getUserData("hidden-parent")) == null) {
                                    n1.setUserData("hidden-parent", containerNode, null);
                                    break;
                                }
                                if (hiddenParent1 == containerNode) break;
                                n1 = hiddenParent1;
                            }
                            content.add(var13.item(var14));
                        }
                    }
                    for (child = containerNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                        n = child;
                        while (true) {
                            if ((hiddenParent = (Node)n.getUserData("hidden-parent")) == null) {
                                n.setUserData("hidden-parent", containerNode, null);
                                break;
                            }
                            if (hiddenParent == containerNode) break;
                            n = hiddenParent;
                        }
                        content.add(child);
                    }
                }
                this.replaceWithNode(content.toArray(new Node[content.size()]));
            } else {
                parent.removeChild(this.getNode());
            }
        }
    }

    public static class Factory
    implements IValidatorFactory {
        public ValidatorNode createValidator(ValidatorNode parent, Node node) {
            return new ValidatorNode(parent, node);
        }
    }

    public static interface IValidatorFactory<T extends ValidatorNode> {
        public T createValidator(ValidatorNode var1, Node var2);
    }
}

