/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp.pathfinding;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rivvest.Revamp.pathfinding.PathEntity;
import rivvest.Revamp.pathfinding.PathFinder;
import rivvest.Revamp.pathfinding.PathPoint;

public class PathNavigate
extends net.minecraft.pathfinding.PathNavigate {
    private EntityLiving theEntity;
    private World worldObj;
    private PathEntity currentPath;
    private double speed;
    private IAttributeInstance pathSearchRange;
    private boolean noSunPathfind;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    private boolean canPassOpenWoodenDoors = true;
    private boolean canPassClosedWoodenDoors;
    private boolean avoidsWater;
    private boolean canSwim;

    public PathNavigate(EntityLiving par1EntityLiving, World par2World) {
        super(par1EntityLiving, par2World);
        this.theEntity = par1EntityLiving;
        this.worldObj = par2World;
        this.pathSearchRange = par1EntityLiving.func_110148_a(SharedMonsterAttributes.field_111265_b);
    }

    public void func_75491_a(boolean par1) {
        this.avoidsWater = par1;
    }

    public boolean func_75486_a() {
        return this.avoidsWater;
    }

    public void func_75498_b(boolean par1) {
        if (this.theEntity instanceof EntityVillager) {
            // empty if block
        }
        this.canPassClosedWoodenDoors = par1;
    }

    public void func_75490_c(boolean par1) {
        this.canPassOpenWoodenDoors = par1;
    }

    public boolean func_75507_c() {
        return this.canPassClosedWoodenDoors;
    }

    public void func_75504_d(boolean par1) {
        this.noSunPathfind = par1;
    }

    public void func_75489_a(double par1) {
        this.speed = par1;
    }

    public void func_75495_e(boolean par1) {
        this.canSwim = par1;
    }

    public float func_111269_d() {
        return (float)this.pathSearchRange.func_111126_e();
    }

    public PathEntity getPathToXYZ(double par1, double par3, double par5) {
        return !this.canNavigate() ? null : this.getEntityPathToXYZ((Entity)this.theEntity, MathHelper.func_76128_c((double)par1), (int)par3, MathHelper.func_76128_c((double)par5), this.func_111269_d(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
    }

    public boolean func_75492_a(double par1, double par3, double par5, double par7) {
        PathEntity pathentity = this.getPathToXYZ(MathHelper.func_76128_c((double)par1), (int)par3, MathHelper.func_76128_c((double)par5));
        return this.setPath(pathentity, par7);
    }

    public PathEntity getPathToEntityLiving(Entity par1Entity) {
        if (!this.canNavigate()) {
            return null;
        }
        PathEntity pe = this.getPathEntityToEntity((Entity)this.theEntity, par1Entity, this.func_111269_d(), this.canPassOpenWoodenDoors, this.canPassClosedWoodenDoors, this.avoidsWater, this.canSwim);
        return pe;
    }

    public boolean func_75497_a(Entity par1Entity, double par2) {
        PathEntity pathentity = this.getPathToEntityLiving(par1Entity);
        return pathentity != null ? this.setPath(pathentity, par2) : false;
    }

    public boolean setPath(PathEntity par1PathEntity, double par2) {
        if (par1PathEntity == null) {
            this.currentPath = null;
            return false;
        }
        if (!par1PathEntity.isSamePath(this.currentPath)) {
            this.currentPath = par1PathEntity;
        }
        if (this.noSunPathfind) {
            this.removeSunnyPath();
        }
        if (this.currentPath.func_75874_d() == 0) {
            return false;
        }
        this.speed = par2;
        Vec3 vec3 = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck.field_72450_a = vec3.field_72450_a;
        this.lastPosCheck.field_72448_b = vec3.field_72448_b;
        this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        return true;
    }

    public PathEntity getPath() {
        return this.currentPath;
    }

    public void func_75501_e() {
        ++this.totalTicks;
        if (!this.func_75500_f()) {
            Vec3 vec3;
            if (this.canNavigate()) {
                this.pathFollow();
            }
            if (!this.func_75500_f() && (vec3 = this.currentPath.func_75878_a((Entity)this.theEntity)) != null) {
                this.theEntity.func_70605_aq().func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, this.speed);
            }
        }
    }

    private void pathFollow() {
        int k;
        Vec3 vec3 = this.getEntityPosition();
        int i = this.currentPath.func_75874_d();
        for (int j = this.currentPath.func_75873_e(); j < this.currentPath.func_75874_d(); ++j) {
            if (this.currentPath.getPathPointFromIndex((int)j).field_75837_b == (int)vec3.field_72448_b) continue;
            i = j;
            break;
        }
        float f = this.theEntity.field_70130_N * this.theEntity.field_70130_N;
        for (k = this.currentPath.func_75873_e(); k < i; ++k) {
            if (!(vec3.func_72436_e(this.currentPath.func_75881_a((Entity)this.theEntity, k)) < (double)f)) continue;
            this.currentPath.func_75872_c(k + 1);
        }
        k = MathHelper.func_76123_f((float)this.theEntity.field_70130_N);
        int l = (int)this.theEntity.field_70131_O + 1;
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.currentPath.func_75873_e(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3, this.currentPath.func_75881_a((Entity)this.theEntity, j1), k, l, i1)) continue;
            this.currentPath.func_75872_c(j1);
            break;
        }
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (vec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.func_75499_g();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck.field_72450_a = vec3.field_72450_a;
            this.lastPosCheck.field_72448_b = vec3.field_72448_b;
            this.lastPosCheck.field_72449_c = vec3.field_72449_c;
        }
    }

    public boolean func_75500_f() {
        return this.currentPath == null || this.currentPath.func_75879_b();
    }

    public void func_75499_g() {
        this.currentPath = null;
    }

    private Vec3 getEntityPosition() {
        return Vec3.func_72443_a((double)this.theEntity.field_70165_t, (double)this.getPathableYPos(), (double)this.theEntity.field_70161_v);
    }

    private int getPathableYPos() {
        if (this.theEntity.func_70090_H() && this.canSwim) {
            int i = (int)this.theEntity.field_70121_D.field_72338_b;
            Block j = this.worldObj.func_147439_a(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), i, MathHelper.func_76128_c((double)this.theEntity.field_70161_v));
            int k = 0;
            do {
                if (j != Blocks.field_150358_i && j != Blocks.field_150355_j) {
                    return i;
                }
                j = this.worldObj.func_147439_a(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), ++i, MathHelper.func_76128_c((double)this.theEntity.field_70161_v));
            } while (++k <= 16);
            return (int)this.theEntity.field_70121_D.field_72338_b;
        }
        return (int)(this.theEntity.field_70121_D.field_72338_b + 0.5);
    }

    private boolean canNavigate() {
        return this.theEntity.field_70122_E || this.canSwim && this.isInFluid();
    }

    private boolean isInFluid() {
        return this.theEntity.func_70090_H() || this.theEntity.func_70058_J();
    }

    private void removeSunnyPath() {
        if (!this.worldObj.func_72937_j(MathHelper.func_76128_c((double)this.theEntity.field_70165_t), (int)(this.theEntity.field_70121_D.field_72338_b + 0.5), MathHelper.func_76128_c((double)this.theEntity.field_70161_v))) {
            for (int i = 0; i < this.currentPath.func_75874_d(); ++i) {
                PathPoint pathpoint = this.currentPath.getPathPointFromIndex(i);
                if (!this.worldObj.func_72937_j(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c)) continue;
                this.currentPath.func_75871_b(i - 1);
                return;
            }
        }
    }

    private boolean isDirectPathBetweenPoints(Vec3 par1Vec3, Vec3 par2Vec3, int par3, int par4, int par5) {
        int l = MathHelper.func_76128_c((double)par1Vec3.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)par1Vec3.field_72449_c);
        double d0 = par2Vec3.field_72450_a - par1Vec3.field_72450_a;
        double d1 = par2Vec3.field_72449_c - par1Vec3.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(l, (int)par1Vec3.field_72448_b, i1, par3 += 2, par4, par5 += 2, par1Vec3, d0 *= d3, d1 *= d3)) {
            return false;
        }
        par3 -= 2;
        par5 -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(l * 1) - par1Vec3.field_72450_a;
        double d7 = (double)(i1 * 1) - par1Vec3.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int j1 = d0 < 0.0 ? -1 : 1;
        int k1 = d1 < 0.0 ? -1 : 1;
        int l1 = MathHelper.func_76128_c((double)par2Vec3.field_72450_a);
        int i2 = MathHelper.func_76128_c((double)par2Vec3.field_72449_c);
        int j2 = l1 - l;
        int k2 = i2 - i1;
        do {
            if (j2 * j1 <= 0 && k2 * k1 <= 0) {
                return true;
            }
            if (d6 < d7) {
                d6 += d4;
                j2 = l1 - (l += j1);
                continue;
            }
            d7 += d5;
            k2 = i2 - (i1 += k1);
        } while (this.isSafeToStandAt(l, (int)par1Vec3.field_72448_b, i1, par3, par4, par5, par1Vec3, d0, d1));
        return false;
    }

    private boolean isSafeToStandAt(int par1, int par2, int par3, int par4, int par5, int par6, Vec3 par7Vec3, double par8, double par10) {
        int k1 = par1 - par4 / 2;
        int l1 = par3 - par6 / 2;
        if (!this.isPositionClear(k1, par2, l1, par4, par5, par6, par7Vec3, par8, par10)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + par4; ++i2) {
            for (int j2 = l1; j2 < l1 + par6; ++j2) {
                double d2 = (double)i2 + 0.5 - par7Vec3.field_72450_a;
                double d3 = (double)j2 + 0.5 - par7Vec3.field_72449_c;
                if (!(d2 * par8 + d3 * par10 >= 0.0)) continue;
                Block k2 = this.worldObj.func_147439_a(i2, par2 - 1, j2);
                Material material = k2.func_149688_o();
                if (material == Material.field_151579_a) {
                    return false;
                }
                if (material == Material.field_151586_h && !this.theEntity.func_70090_H()) {
                    return false;
                }
                if (material != Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int par1, int par2, int par3, int par4, int par5, int par6, Vec3 par7Vec3, double par8, double par10) {
        for (int k1 = par1; k1 < par1 + par4; ++k1) {
            for (int l1 = par2; l1 < par2 + par5; ++l1) {
                for (int i2 = par3; i2 < par3 + par6; ++i2) {
                    Block j2;
                    double d2 = (double)k1 + 0.5 - par7Vec3.field_72450_a;
                    double d3 = (double)i2 + 0.5 - par7Vec3.field_72449_c;
                    if (!(d2 * par8 + d3 * par10 >= 0.0) || (j2 = this.worldObj.func_147439_a(k1, l1, i2)).func_149655_b((IBlockAccess)this.worldObj, k1, l1, i2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public PathEntity getPathEntityToEntity(Entity par1Entity, Entity par2Entity, float par3, boolean par4, boolean par5, boolean par6, boolean par7) {
        par1Entity.field_70170_p.field_72984_F.func_76320_a("pathfind");
        int i = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)(par1Entity.field_70163_u + 1.0));
        int k = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        int l = (int)(par3 + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(par1Entity.field_70170_p, i1, j1, k1, l1, i2, j2, 0);
        PathEntity pathentity = new PathFinder((IBlockAccess)chunkcache, par4, par5, par6, par7).createEntityPathTo(par1Entity, par2Entity, par3);
        par1Entity.field_70170_p.field_72984_F.func_76319_b();
        return pathentity;
    }

    public PathEntity getEntityPathToXYZ(Entity par1Entity, int par2, int par3, int par4, float par5, boolean par6, boolean par7, boolean par8, boolean par9) {
        par1Entity.field_70170_p.field_72984_F.func_76320_a("pathfind");
        int l = MathHelper.func_76128_c((double)par1Entity.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)par1Entity.field_70163_u);
        int j1 = MathHelper.func_76128_c((double)par1Entity.field_70161_v);
        int k1 = (int)(par5 + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(par1Entity.field_70170_p, l1, i2, j2, k2, l2, i3, 0);
        PathEntity pathentity = new PathFinder((IBlockAccess)chunkcache, par6, par7, par8, par9).createEntityPathTo(par1Entity, par2, par3, par4, par5);
        par1Entity.field_70170_p.field_72984_F.func_76319_b();
        return pathentity;
    }
}

