/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp.pathfinding;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import rivvest.Revamp.pathfinding.Path;
import rivvest.Revamp.pathfinding.PathEntity;
import rivvest.Revamp.pathfinding.PathPoint;

public class PathFinder {
    private IBlockAccess worldMap;
    private Path path = new Path();
    private IntHashMap pointMap = new IntHashMap();
    private PathPoint[] pathOptions = new PathPoint[32];
    private boolean isWoodenDoorAllowed;
    private boolean hasLadder;
    private boolean isMovementBlockAllowed;
    private boolean avoidsWater;
    private boolean canSwim;
    private boolean canUseLadders = true;

    public PathFinder(IBlockAccess par1IBlockAccess, boolean par2, boolean par3, boolean par4, boolean par5) {
        this.worldMap = par1IBlockAccess;
        this.isWoodenDoorAllowed = par2;
        this.isMovementBlockAllowed = par3;
        this.avoidsWater = par4;
        this.canSwim = par5;
        this.hasLadder = false;
    }

    public PathEntity createEntityPathTo(Entity par1Entity, Entity par2Entity, float par3) {
        return this.createEntityPathTo(par1Entity, par2Entity.field_70165_t, par2Entity.field_70121_D.field_72338_b, par2Entity.field_70161_v, par3);
    }

    public PathEntity createEntityPathTo(Entity par1Entity, int par2, int par3, int par4, float par5) {
        return this.createEntityPathTo(par1Entity, (float)par2 + 0.5f, (float)par3 + 0.5f, (float)par4 + 0.5f, par5);
    }

    private PathEntity createEntityPathTo(Entity par1Entity, double par2, double par4, double par6, float par8) {
        this.path.clearPath();
        this.pointMap.func_76046_c();
        boolean flag = this.avoidsWater;
        int i = MathHelper.func_76128_c((double)(par1Entity.field_70121_D.field_72338_b + 0.5));
        if (this.canSwim && par1Entity.func_70090_H()) {
            i = (int)par1Entity.field_70121_D.field_72338_b;
            Block j = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)par1Entity.field_70165_t), i, MathHelper.func_76128_c((double)par1Entity.field_70161_v));
            while (j == Blocks.field_150358_i || j == Blocks.field_150355_j) {
                j = this.worldMap.func_147439_a(MathHelper.func_76128_c((double)par1Entity.field_70165_t), ++i, MathHelper.func_76128_c((double)par1Entity.field_70161_v));
            }
            flag = this.avoidsWater;
            this.avoidsWater = false;
        } else {
            i = MathHelper.func_76128_c((double)(par1Entity.field_70121_D.field_72338_b + 0.5));
        }
        PathPoint pathpoint = this.openPoint(MathHelper.func_76128_c((double)par1Entity.field_70121_D.field_72340_a), i, MathHelper.func_76128_c((double)par1Entity.field_70121_D.field_72339_c));
        PathPoint pathpoint1 = this.openPoint(MathHelper.func_76128_c((double)(par2 - (double)(par1Entity.field_70130_N / 2.0f))), MathHelper.func_76128_c((double)par4), MathHelper.func_76128_c((double)(par6 - (double)(par1Entity.field_70130_N / 2.0f))));
        PathPoint pathpoint2 = new PathPoint(MathHelper.func_76141_d((float)(par1Entity.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(par1Entity.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(par1Entity.field_70130_N + 1.0f)));
        PathEntity pathentity = this.addToPath(par1Entity, pathpoint, pathpoint1, pathpoint2, par8);
        this.avoidsWater = flag;
        return pathentity;
    }

    private PathEntity addToPath(Entity par1Entity, PathPoint start_point, PathPoint end_point, PathPoint entity_box_pt, float par5) {
        start_point.field_75836_e = 0.0f;
        start_point.field_75834_g = start_point.field_75833_f = start_point.sqdist(end_point);
        this.path.clearPath();
        this.path.addPoint(start_point);
        PathPoint mover = start_point;
        while (!this.path.isPathEmpty()) {
            PathPoint next_point = this.path.dequeue();
            if (next_point.equals((Object)end_point)) {
                return this.createEntityPath(start_point, end_point);
            }
            if (next_point.sqdist(end_point) < mover.sqdist(end_point)) {
                mover = next_point;
            }
            next_point.field_75842_i = true;
            int i = this.findPathOptions(par1Entity, next_point, entity_box_pt, end_point, par5);
            for (int j = 0; j < i; ++j) {
                PathPoint new_point = this.pathOptions[j];
                float f1 = next_point.field_75836_e + next_point.sqdist(new_point);
                if (new_point.func_75831_a() && !(f1 < new_point.field_75836_e)) continue;
                new_point.field_75841_h = next_point;
                new_point.field_75836_e = f1;
                new_point.field_75833_f = new_point.sqdist(end_point);
                if (new_point.func_75831_a()) {
                    this.path.changeDistance(new_point, new_point.field_75836_e + new_point.field_75833_f);
                    continue;
                }
                new_point.field_75834_g = new_point.field_75836_e + new_point.field_75833_f;
                this.path.addPoint(new_point);
            }
        }
        if (mover == start_point) {
            return null;
        }
        return this.createEntityPath(start_point, mover);
    }

    private int findPathOptions(Entity par1Entity, PathPoint par2PathPoint, PathPoint par3PathPoint, PathPoint par4PathPoint, float par5) {
        PathPoint pathpoint_m3;
        int i = 0;
        int b0 = 0;
        int ladderHeightUp = 0;
        int ladderHeightDown = 0;
        if (this.getVerticalOffset(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b + 1, par2PathPoint.field_75838_c, par3PathPoint) == 1) {
            b0 = 1;
        }
        if (this.getVerticalOffset(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b - 1, par2PathPoint.field_75838_c, par3PathPoint) == 3 && (pathpoint_m3 = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b + (ladderHeightDown = this.getLadderHeight(par1Entity.field_70170_p, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b - 1, par2PathPoint.field_75838_c, -1)), par2PathPoint.field_75838_c, par3PathPoint, b0 = 1)) != null && !pathpoint_m3.field_75842_i && pathpoint_m3.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint_m3;
        }
        if (this.getVerticalOffset(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c, par3PathPoint) == 3) {
            ladderHeightUp = this.getLadderHeight(par1Entity.field_70170_p, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c, 1);
            b0 = 1;
            if (ladderHeightUp > 0) {
                int topX = 0;
                int topZ = 0;
                int face = par1Entity.field_70170_p.func_72805_g(par2PathPoint.field_75839_a, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c);
                if (face == 2) {
                    topZ = 1;
                } else if (face == 3) {
                    topZ = -1;
                } else if (face == 4) {
                    topX = 1;
                } else if (face == 5) {
                    topX = -1;
                }
                PathPoint pathpoint_m5 = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a + topX, par2PathPoint.field_75837_b + ladderHeightUp, par2PathPoint.field_75838_c + topZ, par3PathPoint, b0);
                if (pathpoint_m5 != null && !pathpoint_m5.field_75842_i && pathpoint_m5.distanceTo(par4PathPoint) < par5) {
                    this.pathOptions[i++] = pathpoint_m5;
                }
            }
        }
        PathPoint pathpoint3 = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c + 1, par3PathPoint, b0);
        PathPoint pathpoint4 = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a - 1, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c, par3PathPoint, b0);
        PathPoint pathpoint5 = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a + 1, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c, par3PathPoint, b0);
        PathPoint pathpoint6 = this.getSafePoint(par1Entity, par2PathPoint.field_75839_a, par2PathPoint.field_75837_b, par2PathPoint.field_75838_c - 1, par3PathPoint, b0);
        if (pathpoint3 != null && !pathpoint3.field_75842_i && pathpoint3.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.field_75842_i && pathpoint4.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.field_75842_i && pathpoint5.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.field_75842_i && pathpoint6.distanceTo(par4PathPoint) < par5) {
            this.pathOptions[i++] = pathpoint6;
        }
        return i;
    }

    private PathPoint getSafePoint(Entity par1Entity, int par2, int par3, int par4, PathPoint par5PathPoint, int par6) {
        PathPoint pathpoint1 = null;
        int i1 = this.getVerticalOffset(par1Entity, par2, par3, par4, par5PathPoint);
        if (i1 == 2) {
            return this.openPoint(par2, par3, par4);
        }
        if (i1 == 1 || i1 == 3) {
            pathpoint1 = this.openPoint(par2, par3, par4);
        }
        if (pathpoint1 == null && par6 > 0 && i1 != -3 && i1 != -4 && this.getVerticalOffset(par1Entity, par2, par3 + par6, par4, par5PathPoint) == 1) {
            pathpoint1 = this.openPoint(par2, par3 + par6, par4);
            par3 += par6;
        }
        if (pathpoint1 != null) {
            int j1 = 0;
            int k1 = 0;
            while (par3 > 0) {
                k1 = this.getVerticalOffset(par1Entity, par2, par3 - 1, par4, par5PathPoint);
                if (this.avoidsWater && k1 == -1) {
                    return null;
                }
                if (k1 != 1) break;
                if (j1++ >= par1Entity.func_82143_as()) {
                    return null;
                }
                if (--par3 <= 0) continue;
                pathpoint1 = this.openPoint(par2, par3, par4);
            }
            if (k1 == -2) {
                return null;
            }
        }
        return pathpoint1;
    }

    private final PathPoint openPoint(int par1, int par2, int par3) {
        int l = PathPoint.makeHash(par1, par2, par3);
        PathPoint pathpoint = (PathPoint)((Object)this.pointMap.func_76041_a(l));
        if (pathpoint == null) {
            pathpoint = new PathPoint(par1, par2, par3);
            this.pointMap.func_76038_a(l, (Object)pathpoint);
        }
        return pathpoint;
    }

    public int getVerticalOffset(Entity par1Entity, int par2, int par3, int par4, PathPoint par5PathPoint) {
        return PathFinder.staticVerticalOffset(par1Entity, par2, par3, par4, par5PathPoint, this.avoidsWater, this.isMovementBlockAllowed, this.isWoodenDoorAllowed);
    }

    public static int staticVerticalOffset(Entity par0Entity, int par1, int par2, int par3, PathPoint par4PathPoint, boolean eAvoidWater, boolean par6, boolean par7) {
        boolean water_or_trapdoor = false;
        for (int l = par1; l < par1 + par4PathPoint.field_75839_a; ++l) {
            for (int i1 = par2; i1 < par2 + par4PathPoint.field_75837_b; ++i1) {
                for (int j1 = par3; j1 < par3 + par4PathPoint.field_75838_c; ++j1) {
                    Block block = par0Entity.field_70170_p.func_147439_a(l, i1, j1);
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    if (block == Blocks.field_150415_aT) {
                        water_or_trapdoor = true;
                    } else {
                        if (block == Blocks.field_150468_ap) {
                            return 3;
                        }
                        if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
                            if (!par7 && block == Blocks.field_150466_ao) {
                                return 0;
                            }
                        } else {
                            if (eAvoidWater) {
                                return -1;
                            }
                            water_or_trapdoor = true;
                        }
                    }
                    int l1 = block.func_149645_b();
                    if (par0Entity.field_70170_p.func_147439_a(l, i1, j1).func_149645_b() == 9) {
                        int k2;
                        int j2;
                        int i2 = MathHelper.func_76128_c((double)par0Entity.field_70165_t);
                        if (par0Entity.field_70170_p.func_147439_a(i2, j2 = MathHelper.func_76128_c((double)par0Entity.field_70163_u), k2 = MathHelper.func_76128_c((double)par0Entity.field_70161_v)).func_149645_b() == 9 || par0Entity.field_70170_p.func_147439_a(i2, j2 - 1, k2).func_149645_b() == 9) continue;
                        return -3;
                    }
                    if (block.func_149655_b((IBlockAccess)par0Entity.field_70170_p, l, i1, j1) || par6 && block == Blocks.field_150466_ao) continue;
                    if (l1 == 11 || block == Blocks.field_150396_be || l1 == 32) {
                        return -3;
                    }
                    if (block == Blocks.field_150415_aT) {
                        return -4;
                    }
                    Material material = block.func_149688_o();
                    if (material != Material.field_151587_i) {
                        return 0;
                    }
                    if (par0Entity.func_70058_J()) continue;
                    return -2;
                }
            }
        }
        return water_or_trapdoor ? 2 : 1;
    }

    private int getLadderHeight(World worldObj, int l, int i1, int j1, int direction) {
        Block k1 = worldObj.func_147439_a(l, i1, j1);
        int ladderHeight = 0;
        while (k1 == Blocks.field_150468_ap) {
            k1 = worldObj.func_147439_a(l, i1 + (ladderHeight += direction), j1);
        }
        return ladderHeight;
    }

    private PathEntity createEntityPath(PathPoint par1PathPoint, PathPoint par2PathPoint) {
        int i = 1;
        PathPoint pathpoint2 = par2PathPoint;
        while (pathpoint2.field_75841_h != null) {
            ++i;
            pathpoint2 = pathpoint2.field_75841_h;
        }
        PathPoint[] apathpoint = new PathPoint[i];
        pathpoint2 = par2PathPoint;
        apathpoint[--i] = par2PathPoint;
        while (pathpoint2.field_75841_h != null) {
            pathpoint2 = pathpoint2.field_75841_h;
            apathpoint[--i] = pathpoint2;
        }
        return new PathEntity(apathpoint);
    }
}

