/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.village.Village;
import net.minecraft.world.WorldServer;
import rivvest.Revamp.EntityAIAvoidEntityRevamp;
import rivvest.Revamp.EntityAICheckReachableDoors;
import rivvest.Revamp.EntityAIMoveToPinnedDoor;
import rivvest.Revamp.EntityAIMoveTowardsVillage;
import rivvest.Revamp.EntityAIOpenTrapDoor;
import rivvest.Revamp.EntityAIPanicChicken;
import rivvest.Revamp.EntityAIRestrictOpenDoorRevamp;
import rivvest.Revamp.EntityAIRideChicken;
import rivvest.Revamp.EntityAIVillagerMateRevamp;
import rivvest.Revamp.EntityAIWanderRevamp;
import rivvest.Revamp.EntityAIWatchClosestRevamp;
import rivvest.Revamp.EntityEventHandler;
import rivvest.Revamp.Revamp;
import rivvest.Revamp.RevampConfiguration;
import rivvest.Revamp.pathfinding.PathNavigate;

public class ServerTickerRevamp {
    EntityEventHandler evh;
    int numGolems;
    int numVillagers;
    int endNumGolems;
    int modNumGolems;
    int finalNumGolems = 0;
    boolean forcingSpawn = false;
    float villagersPerGolem = RevampConfiguration.VILLAGERSPERGOLEM;
    String numIronGolemsField = "field_75587_j";
    String numVillagersField = "field_75588_h";
    String speedField = "field_75454_e";
    String entityTrackerField = "field_72793_b";
    String navigatorField = "field_70699_by";
    String canSwimField = "field_75517_m";

    public ServerTickerRevamp(EntityEventHandler evh) {
        this.evh = evh;
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ServerTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            this.onStartTickInGame();
        } else if (ev.phase == TickEvent.Phase.END) {
            this.onEndTickInGame();
        }
    }

    private void onStartTickInGame() {
        this.runConversions(this.evh.entitiesToConvert);
        if (RevampConfiguration.VILLAGERSPERGOLEM != 10) {
            this.updateVillageGolemSpawn(Revamp.worldObj.field_72982_D.func_75540_b());
            this.updateVillageGolemSpawn(Revamp.CaveVillageCollectionObj.getVillageList());
        }
        Revamp.pinnedDoors.update(false);
    }

    private void onEndTickInGame() {
        Revamp.CaveVillageCollectionObj.tick();
        this.resetVillageGolemSpawn(Revamp.CaveVillageCollectionObj.getVillageList());
        this.resetVillageGolemSpawn(Revamp.worldObj.field_72982_D.func_75540_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConversions(List<EntityCreature> entitiesToConvert) {
        block8: for (EntityCreature e : entitiesToConvert) {
            block31: {
                EntityVillager villager;
                block32: {
                    block30: {
                        if (RevampConfiguration.ENTITYRENDERFACTOR != 1.0) {
                            Set et = (Set)ReflectionHelper.getPrivateValue(EntityTracker.class, (Object)((WorldServer)Revamp.worldObj).func_73039_n(), (String[])new String[]{this.entityTrackerField});
                            for (EntityTrackerEntry ete : et) {
                                if (!ete.field_73132_a.equals((Object)e)) continue;
                                ete.field_73130_b = (int)(RevampConfiguration.ENTITYRENDERFACTOR * (double)ete.field_73130_b);
                            }
                        }
                        if (!(e instanceof EntityIronGolem)) break block30;
                        EntityIronGolem golem = (EntityIronGolem)e;
                        if (golem != null) {
                            golem.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)RevampConfiguration.PATHFINDINGRANGE / 2.0);
                        }
                        break block31;
                    }
                    if (!(e instanceof EntityChicken)) break block32;
                    EntityChicken chicken = (EntityChicken)e;
                    if (chicken == null) break block31;
                    if (!RevampConfiguration.CHILDRENRIDECHICKENS) break block31;
                    chicken.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanicChicken((EntityCreature)chicken, 0.5f));
                    break block31;
                }
                if (e instanceof EntityVillager && (villager = (EntityVillager)e) != null) {
                    float villagerMinSpeed = 0.56f;
                    float villagerMaxSpeed = 0.64f;
                    villager.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)RevampConfiguration.PATHFINDINGRANGE);
                    if (RevampConfiguration.VILLAGERSUSELADDERS) {
                        boolean canBreakDoors = villager.func_70661_as().func_75507_c();
                        boolean avoidsWater = villager.func_70661_as().func_75486_a();
                        boolean canSwim = (Boolean)ReflectionHelper.getPrivateValue(net.minecraft.pathfinding.PathNavigate.class, (Object)villager.func_70661_as(), (String[])new String[]{this.canSwimField});
                        ReflectionHelper.setPrivateValue(EntityLiving.class, (Object)villager, (Object)((Object)new PathNavigate((EntityLiving)e, e.field_70170_p)), (String[])new String[]{this.navigatorField});
                        villager.func_70661_as().func_75498_b(canBreakDoors);
                        villager.func_70661_as().func_75491_a(avoidsWater);
                        villager.func_70661_as().func_75495_e(canSwim);
                    } else {
                        System.err.println("villagersUseLadders is disabled in Revamp.cfg, force disabling avoidZombies as well.");
                        RevampConfiguration.AVOIDZOMBIES = false;
                    }
                    villager.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)villager, (double)0.6f, Items.field_151166_bC, false));
                    villager.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAICheckReachableDoors(villager));
                    villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenTrapDoor((EntityLiving)villager, true));
                    if (RevampConfiguration.CHILDRENRIDECHICKENS) {
                        villager.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIRideChicken(villager, 0.62f));
                    }
                    Iterator i = villager.field_70714_bg.field_75782_a.iterator();
                    while (i.hasNext()) {
                        EntityAITasks.EntityAITaskEntry AITask;
                        try {
                            AITask = (EntityAITasks.EntityAITaskEntry)i.next();
                        }
                        catch (ConcurrentModificationException e1) {
                            System.out.println("Could not iterate over AITasks list, aborting for this entity");
                            break;
                        }
                        if (AITask.field_75733_a instanceof EntityAIMoveTowardsRestriction) {
                            if (RevampConfiguration.LOADENTITYAIWANDER) {
                                AITask.field_75733_a = new EntityAIMoveTowardsVillage((EntityCreature)villager, villagerMaxSpeed);
                                continue;
                            }
                        }
                        if (AITask.field_75733_a instanceof EntityAIMoveIndoors) {
                            if (RevampConfiguration.PINNEDDOORSELECTION) {
                                AITask.field_75733_a = new EntityAIMoveToPinnedDoor((EntityCreature)villager, villagerMaxSpeed);
                                continue;
                            }
                        }
                        if (AITask.field_75733_a instanceof EntityAIRestrictOpenDoor) {
                            if (RevampConfiguration.PINNEDDOORSELECTION) {
                                AITask.field_75733_a = new EntityAIRestrictOpenDoorRevamp((EntityCreature)villager);
                                continue;
                            }
                        }
                        if (AITask.field_75733_a instanceof EntityAIVillagerMate) {
                            if (RevampConfiguration.USECUSTOMBREEDING) {
                                AITask.field_75733_a = new EntityAIVillagerMateRevamp(villager);
                                continue;
                            }
                        }
                        if (!(AITask.field_75733_a instanceof EntityAIAvoidEntity)) continue;
                        if (!RevampConfiguration.AVOIDZOMBIES) continue;
                        AITask.field_75733_a = new EntityAIAvoidEntityRevamp((EntityCreature)villager, EntityZombie.class, 24.0f, 0.6, 0.6);
                    }
                }
            }
            Iterator i = e.field_70714_bg.field_75782_a.iterator();
            while (i.hasNext()) {
                EntityAITasks.EntityAITaskEntry AITask;
                try {
                    AITask = (EntityAITasks.EntityAITaskEntry)i.next();
                }
                catch (ConcurrentModificationException e1) {
                    System.out.println("Could not iterate over AITasks list, aborting for this entity");
                    continue block8;
                }
                if (AITask.field_75733_a instanceof EntityAIWander) {
                    if (RevampConfiguration.LOADENTITYAIWANDER) {
                        double mobSpeed = (Double)ReflectionHelper.getPrivateValue(EntityAIWander.class, (Object)((EntityAIWander)AITask.field_75733_a), (String[])new String[]{this.speedField});
                        AITask.field_75733_a = new EntityAIWanderRevamp(e, mobSpeed, mobSpeed);
                    }
                }
                if (!(AITask.field_75733_a instanceof EntityAIWatchClosest)) continue;
                AITask.field_75733_a = new EntityAIWatchClosestRevamp((EntityLiving)e, EntityLiving.class, 8.0f);
            }
        }
        this.evh.entitiesToConvert.clear();
    }

    private void updateVillageGolemSpawn(List<Village> villageList) {
        for (int i = 0; i < villageList.size(); ++i) {
            this.numGolems = (Integer)ReflectionHelper.getPrivateValue(Village.class, (Object)villageList.get(i), (String[])new String[]{this.numIronGolemsField});
            this.numVillagers = (Integer)ReflectionHelper.getPrivateValue(Village.class, (Object)villageList.get(i), (String[])new String[]{this.numVillagersField});
            this.modNumGolems = (int)((float)this.numVillagers / this.villagersPerGolem);
            if (this.numGolems > -1) {
                // empty if block
            }
            if (this.modNumGolems <= this.numGolems) continue;
            this.forcingSpawn = true;
            ReflectionHelper.setPrivateValue(Village.class, (Object)villageList.get(i), (Object)new Integer(-1), (String[])new String[]{this.numIronGolemsField});
        }
    }

    private void resetVillageGolemSpawn(List<Village> villageList) {
        for (int i = 0; i < villageList.size(); ++i) {
            this.endNumGolems = (Integer)ReflectionHelper.getPrivateValue(Village.class, (Object)villageList.get(i), (String[])new String[]{this.numIronGolemsField});
            if (this.modNumGolems > this.numGolems) {
                this.forcingSpawn = true;
                ReflectionHelper.setPrivateValue(Village.class, (Object)villageList.get(i), (Object)new Integer(-1), (String[])new String[]{this.numIronGolemsField});
            }
            if (this.endNumGolems > -1 && this.forcingSpawn) {
                if (this.endNumGolems == this.numGolems) {
                    this.finalNumGolems = this.endNumGolems;
                } else if (this.endNumGolems >= this.modNumGolems) {
                    this.finalNumGolems = this.endNumGolems;
                } else {
                    System.out.println("real reset: endNumGolems: " + this.endNumGolems + " numGolems: " + this.numGolems);
                    this.finalNumGolems = this.numGolems + 1;
                }
            } else {
                this.finalNumGolems = this.forcingSpawn ? this.numGolems : this.endNumGolems;
            }
            ReflectionHelper.setPrivateValue(Village.class, (Object)villageList.get(i), (Object)this.finalNumGolems, (String[])new String[]{this.numIronGolemsField});
        }
        this.forcingSpawn = false;
    }
}

