/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.common.config.Configuration;

public class RevampConfiguration {
    public static boolean LOADENTITYAIWANDER = true;
    public static boolean ENTITIESALWAYSWANDER = true;
    public static boolean CHILDRENRIDECHICKENS = false;
    public static boolean PINNEDDOORSELECTION = false;
    public static boolean USECUSTOMBREEDING = true;
    public static boolean AVOIDZOMBIES = true;
    public static boolean VILLAGERSUSELADDERS = true;
    public static double ENTITYRENDERFACTOR = 2.0;
    public static double DOORSPERVILLAGER = 1.0;
    public static int WANDERFREQUENCYINDOOR = 120;
    public static int WANDERFREQUENCYOUTDOOR = 90;
    public static int VILLAGERSPERGOLEM = 10;
    public static int VILLAGERTWINSPERCENT = 5;
    public static int MINIMUMHOUSELIGHT = 8;
    public static int PATHFINDINGRANGE = 64;
    private Configuration conf;

    public RevampConfiguration(FMLPreInitializationEvent event) {
        this.conf = new Configuration(event.getSuggestedConfigurationFile());
        this.process();
    }

    private void process() {
        this.conf.load();
        LOADENTITYAIWANDER = this.conf.get("general", "loadEntityAIWander", true).getBoolean(true);
        this.conf.get((String)"general", (String)"loadEntityAIWander", (boolean)true).comment = "Set to false if you want the Minecraft default wander behavior for Villagers and mobs. Mod default=true.";
        ENTITIESALWAYSWANDER = this.conf.get("general", "entitiesAlwaysWander", true).getBoolean(true);
        this.conf.get((String)"general", (String)"entitiesAlwaysWander", (boolean)true).comment = "WARNING! Can be very CPU intensive! Should entities always wander, even if you are far away? Requires loadEntityAIWander to be true. Mod default=true.";
        CHILDRENRIDECHICKENS = this.conf.get("general", "childrenRideChickens", false).getBoolean(false);
        this.conf.get((String)"general", (String)"childrenRideChickens", (boolean)false).comment = "Set to true if you want baby villagers to ride chickens. It's buggy. Mod default=false.";
        USECUSTOMBREEDING = this.conf.get("general", "useCustomBreeding", true).getBoolean(true);
        this.conf.get((String)"general", (String)"useCustomBreeding", (boolean)true).comment = "Use custom breeding (villagerTwinsPercent, doorsPerVillager). Disable if you are using other mods that affect villager breeding. Mod default=true";
        PINNEDDOORSELECTION = this.conf.get("general", "pinnedDoorSelection", true).getBoolean(true);
        this.conf.get((String)"general", (String)"pinnedDoorSelection", (boolean)true).comment = "Use \"pinned\" doors (resets on world load). Mod default=true.";
        AVOIDZOMBIES = this.conf.get("general", "avoidZombies", true).getBoolean(true);
        this.conf.get((String)"general", (String)"avoidZombies", (boolean)true).comment = "Villagers don't open doors for zombies and can 'hear' them farther away. Mod default=true.";
        VILLAGERSUSELADDERS = this.conf.get("general", "villagersUseLadders", true).getBoolean(true);
        this.conf.get((String)"general", (String)"villagersUseLadders", (boolean)true).comment = "Villagers will use ladders and trapdoors. Mod default=true.";
        ENTITYRENDERFACTOR = this.conf.get("general", "entityRenderFactor", 2.0).getDouble(2.0);
        this.conf.get((String)"general", (String)"entityRenderFactor", (double)2.0).comment = "WARNING! Can be very CPU intensive! Multiplier for how far away entities are rendered. Minecraft default=1.0, Mod default=2.0";
        DOORSPERVILLAGER = this.conf.get("general", "doorsPerVillager", 1.0).getDouble(1.0);
        this.conf.get((String)"general", (String)"doorsPerVillager", (double)1.0).comment = "Number of doors per villager. Minecraft default=0.35. Mod default=1.0";
        WANDERFREQUENCYINDOOR = this.conf.get("general", "wanderFrequencyIndoor", 90).getInt(90);
        this.conf.get((String)"general", (String)"wanderFrequencyIndoor", (int)120).comment = "Frequency Villagers will wander around when indoors at night. (1/x chance when performed.) Set to 1 to have them always move. Minecraft default=120, Mod default=90";
        WANDERFREQUENCYOUTDOOR = this.conf.get("general", "wanderFrequencyOutdoor", 60).getInt(60);
        this.conf.get((String)"general", (String)"wanderFrequencyOutdoor", (int)90).comment = "Frequency mobs will wander around. (1/x chance when performed.) Set to 1 to have them always move. Minecraft default=120, Mod default=60";
        VILLAGERSPERGOLEM = this.conf.get("general", "villagersPerGolem", 10).getInt(10);
        this.conf.get((String)"general", (String)"villagersPerGolem", (int)10).comment = "Number of villagers per iron golem.  Still requires 20 doors to get started. Minecraft default=10, Mod default=10.";
        VILLAGERTWINSPERCENT = this.conf.get("general", "villagerTwinsPercent", 5).getInt(5);
        this.conf.get((String)"general", (String)"villagerTwinsPercent", (int)5).comment = "Percent likelyhood that villagers will have twins. Set to 0 to disable. Mod default=5.";
        MINIMUMHOUSELIGHT = this.conf.get("general", "minimumHouseLight", 8).getInt(8);
        this.conf.get((String)"general", (String)"minimumHouseLight", (int)5).comment = "Minimum light needed to consider a house \"safe\". Lower this if you find your villagers running around at night. Set to 0 to disable. Mod default=8.";
        PATHFINDINGRANGE = this.conf.get("general", "pathFindingRange", 64).getInt(81);
        this.conf.get((String)"general", (String)"pathFindingRange", (int)64).comment = "Maximum distance villagers will pathfind. Used to counter the zombie's improved tracking. Note! Can be memory-intensive if set too high! Minecraft default=16. Mod default=64.";
        this.conf.save();
    }
}

