/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import rivvest.Revamp.RevampConfiguration;

public class PinnedDoors {
    private static HashMap<EntityVillager, VillageDoorInfo> villagerHomes;
    private static HashMap<VillageDoorInfo, Integer> homeCounts;
    private World worldObj;

    public PinnedDoors(World theWorld) {
        this.worldObj = theWorld;
        villagerHomes = new HashMap();
        homeCounts = new HashMap();
    }

    public void addVillagerToDoor(EntityVillager theVillager, VillageDoorInfo door) {
        villagerHomes.put(theVillager, door);
        this.incrementDoorCounter(door);
    }

    private void removeVillagerFromDoor(EntityVillager theVillager) {
        this.decrementDoorCounter(this.getVillagerDoor(theVillager));
    }

    public VillageDoorInfo getVillagerDoor(EntityVillager theVillager) {
        return villagerHomes.get(theVillager);
    }

    private void removeAllVillagersFromDoor(VillageDoorInfo door) {
        Iterator<EntityVillager> i = villagerHomes.keySet().iterator();
        while (i.hasNext()) {
            EntityVillager v = i.next();
            if (villagerHomes.get(v) != door) continue;
            this.removeVillagerFromDoor(v);
            i.remove();
        }
    }

    private void removeOldVillagers() {
        Iterator<EntityVillager> i = villagerHomes.keySet().iterator();
        while (i.hasNext()) {
            EntityVillager v = i.next();
            if (!v.field_70128_L) continue;
            this.removeVillagerFromDoor(v);
            i.remove();
        }
    }

    private void removeDoorFromCount(VillageDoorInfo door) {
        this.removeAllVillagersFromDoor(door);
    }

    private void removeOldDoors() {
        Iterator<VillageDoorInfo> i = homeCounts.keySet().iterator();
        while (i.hasNext()) {
            VillageDoorInfo d = i.next();
            if (d == null) continue;
            if (d.field_75476_g || !this.isWoodenDoorAt(d.field_75481_a, d.field_75479_b, d.field_75480_c)) {
                this.removeDoorFromCount(d);
                i.remove();
                continue;
            }
            if (this.worldObj.field_72995_K) continue;
            if (this.worldObj.func_72957_l(d.func_75471_a(), d.func_75473_b(), d.func_75472_c()) >= RevampConfiguration.MINIMUMHOUSELIGHT) continue;
            this.removeDoorFromCount(d);
            i.remove();
        }
    }

    public VillageDoorInfo findNearestDoor(EntityVillager theVillager, Village theVillage) {
        VillageDoorInfo nearestDoor = null;
        int closest = Integer.MAX_VALUE;
        int leastUsed = Integer.MAX_VALUE;
        boolean addDoor = false;
        if (theVillage == null) {
            return null;
        }
        List villageDoorInfoList = theVillage.func_75558_f();
        TreeMap<Integer, ArrayList> usableDoors = new TreeMap<Integer, ArrayList>();
        for (VillageDoorInfo door : villageDoorInfoList) {
            List list;
            Integer uses = this.getDoorCounter(door);
            if (uses == 0) {
                this.checkPathToDoor(door);
            }
            if (!this.isReachable(door)) continue;
            addDoor = true;
            if (!this.worldObj.field_72995_K) {
                if (this.worldObj.func_72957_l(door.func_75471_a(), door.func_75473_b(), door.func_75472_c()) < RevampConfiguration.MINIMUMHOUSELIGHT) {
                    addDoor = false;
                }
            }
            if (addDoor && !(list = this.worldObj.func_72872_a(EntityZombie.class, AxisAlignedBB.func_72330_a((double)(door.field_75481_a - 6), (double)(door.field_75479_b - 2), (double)(door.field_75480_c - 6), (double)(door.field_75481_a + 6), (double)(door.field_75479_b + 2), (double)(door.field_75480_c + 6)))).isEmpty()) {
                addDoor = false;
            }
            if (!addDoor) continue;
            ArrayList l = new ArrayList();
            if (usableDoors.containsKey(uses)) {
                l = (ArrayList)usableDoors.get(uses);
            }
            l.add(door);
            usableDoors.put(uses, l);
        }
        if (usableDoors.isEmpty()) {
            return null;
        }
        ArrayList l = (ArrayList)usableDoors.get(usableDoors.firstKey());
        for (VillageDoorInfo door : l) {
            int squaredDistToDoor = door.func_75474_b((int)(theVillager.field_70165_t + 0.5), (int)theVillager.field_70163_u, (int)(theVillager.field_70161_v + 0.5));
            if (squaredDistToDoor >= closest) continue;
            nearestDoor = door;
            closest = squaredDistToDoor;
        }
        return nearestDoor;
    }

    private void incrementDoorCounter(VillageDoorInfo door) {
        homeCounts.put(door, this.getDoorCounter(door) + 1);
    }

    private void decrementDoorCounter(VillageDoorInfo door) {
        if (this.getDoorCounter(door) > 0) {
            homeCounts.put(door, this.getDoorCounter(door) - 1);
        }
    }

    private Integer getDoorCounter(VillageDoorInfo door) {
        Integer useCount = homeCounts.get(door);
        if (useCount == null) {
            useCount = 0;
            homeCounts.put(door, useCount);
        }
        return useCount;
    }

    private void markDoorUnreachable(VillageDoorInfo door) {
        if (this.getDoorCounter(door) >= 0) {
            homeCounts.put(door, Integer.MIN_VALUE);
        }
    }

    private void markDoorReachable(VillageDoorInfo door) {
        if (this.getDoorCounter(door) < 0) {
            homeCounts.put(door, 0);
        }
    }

    public boolean isReachable(VillageDoorInfo door) {
        return this.getDoorCounter(door) >= 0;
    }

    private void checkPathToDoor(VillageDoorInfo door) {
        if (door == null) {
            return;
        }
        EntityVillager doorChecker = new EntityVillager(this.worldObj);
        doorChecker.field_70122_E = true;
        doorChecker.func_70107_b((double)door.func_75471_a() + -2.0 * (double)door.field_75477_d, (double)door.func_75473_b(), (double)door.func_75472_c() + -2.0 * (double)door.field_75478_e);
        boolean testpath = doorChecker.func_70661_as().func_75492_a((double)door.func_75471_a() + 0.5 * (double)door.field_75477_d, (double)door.func_75473_b(), (double)door.func_75472_c() + 0.5 * (double)door.field_75478_e, 0.0);
        if (!testpath) {
            this.removeAllVillagersFromDoor(door);
            this.markDoorUnreachable(door);
        } else {
            this.markDoorReachable(door);
        }
        this.worldObj.func_72900_e((Entity)doorChecker);
    }

    public VillageDoorInfo reassignVillager(EntityVillager theVillager, Village theVillage) {
        VillageDoorInfo homeDoor;
        block3: {
            block2: {
                homeDoor = this.getVillagerDoor(theVillager);
                Integer myHomeCount = this.getDoorCounter(homeDoor);
                int minHomeCount = this.minHomeCount();
                int maxHomeCount = this.maxHomeCount();
                if (myHomeCount >= maxHomeCount && maxHomeCount > minHomeCount) break block2;
                if (this.worldObj.func_72957_l(homeDoor.func_75471_a(), homeDoor.func_75473_b(), homeDoor.func_75472_c()) > RevampConfiguration.MINIMUMHOUSELIGHT || this.worldObj.field_72995_K) break block3;
            }
            VillageDoorInfo nearestDoor = this.findNearestDoor(theVillager, theVillage);
            this.removeVillagerFromDoor(theVillager);
            this.addVillagerToDoor(theVillager, nearestDoor);
        }
        return homeDoor;
    }

    private int maxHomeCount() {
        ArrayList<Integer> l = new ArrayList<Integer>(homeCounts.values());
        Collections.sort(l);
        if (l.isEmpty()) {
            return 0;
        }
        return l.get(l.size() - 1);
    }

    private int minHomeCount() {
        int min = 0;
        ArrayList<Integer> l = new ArrayList<Integer>(homeCounts.values());
        Collections.sort(l);
        if (l.isEmpty()) {
            min = 0;
        }
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) < 0) continue;
            min = 0;
            break;
        }
        return min;
    }

    public void update(boolean force) {
        if (villagerHomes.isEmpty()) {
            return;
        }
        if (!force && new Random().nextInt(500) != 0) {
            return;
        }
        this.removeOldVillagers();
        this.removeOldDoors();
        Iterator<VillageDoorInfo> i = homeCounts.keySet().iterator();
        while (i.hasNext()) {
            this.checkPathToDoor(i.next());
        }
    }

    private boolean isWoodenDoorAt(int par1, int par2, int par3) {
        return this.worldObj.func_147439_a(par1, par2, par3) == Blocks.field_150466_ao;
    }

    public String toString() {
        String pinnedDoors = "Doors: " + (homeCounts.size() - 1) + " Villagers: " + (villagerHomes.size() - 1) + "" + " Min/Max: " + this.minHomeCount() + "/" + this.maxHomeCount();
        return pinnedDoors;
    }
}

