/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.biome.BiomeGenBase;
import rivvest.Revamp.RandomPositionGeneratorRevamp;
import rivvest.Revamp.Utils;

public class EntityAIMoveIndoorsRevamp
extends EntityAIBase {
    private EntityCreature entityObj;
    private VillageDoorInfo doorInfo;
    private int insidePosX = -1;
    private int insidePosZ = -1;
    private float speed = 0.3f;
    private double indoorDistanceLimit = 4.0;
    private int freqMoveIndoors = 10;
    private int extraVillageDistance = 14;
    private String rainEnabledField = "field_76765_S";

    public EntityAIMoveIndoorsRevamp(EntityCreature par1EntityCreature, float speed) {
        this.entityObj = par1EntityCreature;
        this.func_75248_a(1);
        this.speed = speed;
    }

    public boolean func_75250_a() {
        if (!(this.entityObj.field_70170_p.func_72935_r() && !this.entityObj.field_70170_p.func_72896_J() || this.entityObj.field_70170_p.field_73011_w.field_76576_e)) {
            boolean biomeHasRain = (Boolean)ReflectionHelper.getPrivateValue(BiomeGenBase.class, (Object)this.entityObj.field_70170_p.func_72807_a((int)this.entityObj.field_70165_t, (int)this.entityObj.field_70161_v), (String[])new String[]{this.rainEnabledField});
            if (!biomeHasRain && this.entityObj.field_70170_p.func_72935_r() && this.entityObj.field_70170_p.func_72896_J()) {
                System.out.println("Biome does not rain, no need to go indoors.");
                return false;
            }
            if (!Utils.isSafeHouse((Entity)this.entityObj)) {
                System.out.println(this.entityObj.func_145782_y() + ": ok to use doors");
                this.entityObj.func_70661_as().func_75498_b(true);
                this.entityObj.func_70661_as().func_75490_c(true);
            }
            if (!this.entityObj.func_70661_as().func_75507_c() && Utils.isSafeHouse((Entity)this.entityObj) && !Utils.inCave((Entity)this.entityObj)) {
                System.out.println("I'm inside, don't need to move to a door");
                return false;
            }
            if (this.insidePosX != -1 && this.entityObj.func_70092_e((double)this.insidePosX, this.entityObj.field_70163_u, (double)this.insidePosZ) < this.indoorDistanceLimit && Utils.isSafeHouse((Entity)this.entityObj) && !Utils.inCave((Entity)this.entityObj)) {
                System.out.println(this.entityObj.func_145782_y() + " is close enough to a door, no need to move inside.");
                return false;
            }
            if (this.entityObj.func_70681_au().nextInt(this.freqMoveIndoors) != 0) {
                return false;
            }
            Village var1 = this.entityObj.field_70170_p.field_72982_D.func_75550_a(MathHelper.func_76128_c((double)this.entityObj.field_70165_t), MathHelper.func_76128_c((double)this.entityObj.field_70163_u), MathHelper.func_76128_c((double)this.entityObj.field_70161_v), this.extraVillageDistance);
            if (var1 == null) {
                System.out.println(this.entityObj.func_145782_y() + " can't find a village, no need to move inside.");
                return false;
            }
            this.doorInfo = this.findNearestDoorUnrestricted(MathHelper.func_76128_c((double)this.entityObj.field_70165_t), MathHelper.func_76128_c((double)this.entityObj.field_70163_u), MathHelper.func_76128_c((double)this.entityObj.field_70161_v), var1);
            return this.doorInfo != null;
        }
        if (!this.entityObj.func_70661_as().func_75507_c()) {
            System.out.println(this.entityObj.func_145782_y() + ": It's not night or raining, ok to use doors");
            this.entityObj.func_70661_as().func_75498_b(true);
            this.entityObj.func_70661_as().func_75490_c(true);
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.entityObj.func_70661_as().func_75500_f()) {
            // empty if block
        }
        return !this.entityObj.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.insidePosX = -1;
        if (this.entityObj.func_70092_e((double)this.doorInfo.func_75471_a(), (double)this.doorInfo.field_75479_b, (double)this.doorInfo.func_75472_c()) > 256.0) {
            Vec3 var1 = RandomPositionGeneratorRevamp.findRandomTargetBlockTowards(this.entityObj, 14, 3, Vec3.func_72443_a((double)((double)this.doorInfo.func_75471_a() + 0.5), (double)this.doorInfo.func_75473_b(), (double)((double)this.doorInfo.func_75472_c() + 0.5)));
            if (var1 != null) {
                this.entityObj.func_70661_as().func_75492_a(var1.field_72450_a, var1.field_72448_b, var1.field_72449_c, (double)this.speed);
            }
        } else {
            this.entityObj.func_70661_as().func_75492_a((double)this.doorInfo.func_75471_a() + 0.5, (double)this.doorInfo.func_75473_b(), (double)this.doorInfo.func_75472_c() + 0.5, (double)this.speed);
        }
    }

    public void func_75251_c() {
        this.insidePosX = this.doorInfo.func_75471_a();
        this.insidePosZ = this.doorInfo.func_75472_c();
        this.doorInfo = null;
    }

    public VillageDoorInfo findNearestDoorUnrestricted(int par1, int par2, int par3, Village theVillage) {
        VillageDoorInfo nearestDoor = null;
        int closest = Integer.MAX_VALUE;
        List villageDoorInfoList = theVillage.func_75558_f();
        Collections.shuffle(villageDoorInfoList);
        for (VillageDoorInfo door : villageDoorInfoList) {
            int weight = 1000;
            int distOverride = 256;
            int squaredDistToDoor = door.func_75474_b(par1, par2, par3) + door.func_75468_f();
            if (squaredDistToDoor >= closest) continue;
            nearestDoor = door;
            closest = squaredDistToDoor;
        }
        System.out.println(this.entityObj.func_145782_y() + " best door: " + nearestDoor.field_75481_a + "," + nearestDoor.field_75479_b + "," + nearestDoor.field_75480_c + ": " + nearestDoor.func_75474_b(par1, par2, par3) + " restriction: " + nearestDoor.func_75468_f());
        return nearestDoor;
    }
}

