/*
 * Decompiled with CFR 0.152.
 */
package rivvest.Revamp;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CaveVillageCollection {
    private World worldObj;
    private List villagerPositionsList = new ArrayList();
    private List newDoors = new ArrayList();
    private List villageList = new ArrayList();
    private int tickCounter = 0;
    String newDoorsField = "field_75555_c";
    String villagerPositionsListField = "field_75554_b";
    String tickCounterField = "field_75553_e";
    String villageListField = "field_75552_d";

    public CaveVillageCollection(World par1World) {
        this.worldObj = par1World;
    }

    public void tick() {
        this.villageList = this.worldObj.field_72982_D.func_75540_b();
        this.newDoors = (List)ReflectionHelper.getPrivateValue(VillageCollection.class, (Object)this.worldObj.field_72982_D, (String[])new String[]{this.newDoorsField});
        this.villagerPositionsList = (List)ReflectionHelper.getPrivateValue(VillageCollection.class, (Object)this.worldObj.field_72982_D, (String[])new String[]{this.villagerPositionsListField});
        this.tickCounter = (Integer)ReflectionHelper.getPrivateValue(VillageCollection.class, (Object)this.worldObj.field_72982_D, (String[])new String[]{this.tickCounterField});
        this.dropOldestVillagerPosition();
        this.addNewDoorsToVillageOrCreateVillage();
    }

    public List getVillageList() {
        return this.villageList;
    }

    private void dropOldestVillagerPosition() {
        if (!this.villagerPositionsList.isEmpty()) {
            this.addUnassignedWoodenDoorsAroundToNewDoorsList((ChunkCoordinates)this.villagerPositionsList.get(0));
        }
    }

    private void addNewDoorsToVillageOrCreateVillage() {
        for (int var1 = 0; var1 < this.newDoors.size(); ++var1) {
            VillageDoorInfo var2 = (VillageDoorInfo)this.newDoors.get(var1);
            boolean var3 = false;
            for (Village var5 : this.villageList) {
                int var7;
                int var6 = (int)var5.func_75577_a().func_71569_e(var2.field_75481_a, var2.field_75479_b, var2.field_75480_c);
                if (var6 > (var7 = 32 + var5.func_75568_b()) * var7) continue;
                var5.func_75576_a(var2);
                ReflectionHelper.setPrivateValue(VillageCollection.class, (Object)this.worldObj.field_72982_D, (Object)this.villageList, (String[])new String[]{this.villageListField});
                var3 = true;
                break;
            }
            if (var3) continue;
            Village var8 = new Village(this.worldObj);
            var8.func_75576_a(var2);
            this.villageList.add(var8);
            ReflectionHelper.setPrivateValue(VillageCollection.class, (Object)this.worldObj.field_72982_D, (Object)this.villageList, (String[])new String[]{this.villageListField});
        }
        this.newDoors.clear();
    }

    private void addUnassignedWoodenDoorsAroundToNewDoorsList(ChunkCoordinates par1ChunkCoordinates) {
        int var2 = 32;
        int var3 = 8;
        int var4 = 32;
        for (int var5 = par1ChunkCoordinates.field_71574_a - var2; var5 < par1ChunkCoordinates.field_71574_a + var2; ++var5) {
            for (int var6 = par1ChunkCoordinates.field_71572_b - var3; var6 < par1ChunkCoordinates.field_71572_b + var3; ++var6) {
                for (int var7 = par1ChunkCoordinates.field_71573_c - var4; var7 < par1ChunkCoordinates.field_71573_c + var4; ++var7) {
                    if (!this.isWoodenDoorAt(var5, var6, var7)) continue;
                    VillageDoorInfo var8 = this.getVillageDoorAt(var5, var6, var7);
                    if (var8 == null) {
                        this.addDoorToNewListIfAppropriate(var5, var6, var7);
                        continue;
                    }
                    var8.field_75475_f = this.tickCounter;
                }
            }
        }
    }

    private VillageDoorInfo getVillageDoorAt(int par1, int par2, int par3) {
        VillageDoorInfo var5;
        Iterator var4 = this.newDoors.iterator();
        do {
            if (!var4.hasNext()) {
                Village var7;
                VillageDoorInfo var6;
                var4 = this.villageList.iterator();
                do {
                    if (var4.hasNext()) continue;
                    return null;
                } while ((var6 = (var7 = (Village)var4.next()).func_75578_e(par1, par2, par3)) == null);
                return var6;
            }
            var5 = (VillageDoorInfo)var4.next();
        } while (var5.field_75481_a != par1 || var5.field_75480_c != par3 || Math.abs(var5.field_75479_b - par2) > 1);
        return var5;
    }

    private void addDoorToNewListIfAppropriate(int doorX, int doorY, int doorZ) {
        int doorOrientation = ((BlockDoor)Blocks.field_150466_ao).func_150013_e((IBlockAccess)this.worldObj, doorX, doorY, doorZ);
        int skyLimit = 5;
        if (doorOrientation != 0 && doorOrientation != 2) {
            int i;
            int skyBlocks = 0;
            int brightnessNeg = 0;
            int brightnessPos = 0;
            for (i = -skyLimit; i < 0; ++i) {
                brightnessNeg += this.worldObj.func_72957_l(doorX, doorY, doorZ + i);
                if (!this.worldObj.func_72937_j(doorX, doorY, doorZ + i)) continue;
                ++skyBlocks;
            }
            for (i = 1; i <= skyLimit; ++i) {
                brightnessPos += this.worldObj.func_72957_l(doorX, doorY, doorZ + i);
                if (!this.worldObj.func_72937_j(doorX, doorY, doorZ + i)) continue;
                ++skyBlocks;
            }
            if (skyBlocks == 0) {
                int doorInside = brightnessPos < brightnessNeg ? 2 : -2;
                this.newDoors.add(new VillageDoorInfo(doorX, doorY, doorZ, 0, doorInside, this.tickCounter));
            }
        } else {
            int i;
            int skyBlocks = 0;
            int brightnessNeg = 0;
            int brightnessPos = 0;
            for (i = -skyLimit; i < 0; ++i) {
                brightnessNeg += this.worldObj.func_72957_l(doorX + i, doorY, doorZ);
                if (!this.worldObj.func_72937_j(doorX + i, doorY, doorZ)) continue;
                ++skyBlocks;
            }
            for (i = 1; i <= skyLimit; ++i) {
                brightnessPos += this.worldObj.func_72957_l(doorX + i, doorY, doorZ);
                if (!this.worldObj.func_72937_j(doorX + i, doorY, doorZ)) continue;
                ++skyBlocks;
            }
            if (skyBlocks == 0) {
                int doorInside = brightnessPos < brightnessNeg ? 2 : -2;
                this.newDoors.add(new VillageDoorInfo(doorX, doorY, doorZ, doorInside, 0, this.tickCounter));
            }
        }
    }

    private boolean isWoodenDoorAt(int par1, int par2, int par3) {
        Block var4 = this.worldObj.func_147439_a(par1, par2, par3);
        return var4 == Blocks.field_150466_ao;
    }
}

