/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.client;

import com.draco18s.hazards.HazardsEventHandler;
import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.entities.PlayerStats;
import com.draco18s.hazards.network.CtoSMessage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class HazardsClientEventHandler {
    private FloatBuffer fogColorBuffer = GLAllocation.func_74529_h((int)16);

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.entity instanceof EntityPlayer && event.entity.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.entity;
            PlayerStats stats = PlayerStats.get(event.entity);
            if (stats != null) {
                float farPlaneDistance;
                float f1 = farPlaneDistance = (float)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16);
                if (stats.airRemaining < 1000) {
                    GL11.glFog((int)2918, (FloatBuffer)this.setFogColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    f1 = 5.0f + (farPlaneDistance - 5.0f) * ((float)Math.max(stats.airRemaining, 0) / 1000.0f);
                    GL11.glFogi((int)2917, (int)9729);
                    GL11.glFogf((int)2915, (float)(f1 * 0.25f));
                    GL11.glFogf((int)2916, (float)f1);
                    if (GLContext.getCapabilities().GL_NV_fog_distance) {
                        GL11.glFogi((int)34138, (int)34139);
                    }
                    event.setCanceled(true);
                    event.density = 0.1f;
                }
            }
        }
    }

    private FloatBuffer setFogColorBuffer(float red, float green, float blue, float alpha) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(red).put(green).put(blue).put(alpha);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            int jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i();
            boolean sendPacket = false;
            boolean state = false;
            if (jumpKey >= 0) {
                sendPacket = HazardsEventHandler.instance.setPlayerSwimming((EntityPlayer)player, Keyboard.isKeyDown((int)jumpKey));
                state = Keyboard.isKeyDown((int)jumpKey);
            } else {
                jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i() + 100;
                if (jumpKey >= 0) {
                    sendPacket = HazardsEventHandler.instance.setPlayerSwimming((EntityPlayer)player, Mouse.isButtonDown((int)jumpKey));
                    state = Keyboard.isKeyDown((int)jumpKey);
                }
            }
            if (sendPacket) {
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeBoolean(state);
                CtoSMessage packet = new CtoSMessage(player.func_145782_y(), (ByteBuf)out);
                UndergroundBase.networkWrapper.sendToServer((IMessage)packet);
            }
        }
    }
}

