/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.block;

import com.draco18s.hardlib.Twister;
import com.draco18s.hazards.HazardsEventHandler;
import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.block.helper.UnstableStoneHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockUnstableStone
extends Block {
    private IIcon[] icons;
    private IIcon baseTexture;
    private boolean iconsSet = false;
    private int renderPass;
    public static int renderID = 0;
    private boolean dropsSelf = false;
    public int color = 0;

    public BlockUnstableStone(String origName, String texName, int multi) {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149663_c(origName.substring(5));
        this.func_149658_d(texName);
        this.color = multi;
    }

    public BlockUnstableStone(String origName, IIcon texture) {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149663_c(origName);
        this.baseTexture = texture;
        this.func_149658_d("null");
    }

    public void setDropsSelf() {
        this.dropsSelf = true;
    }

    public int func_149645_b() {
        return renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        if (this.renderPass == 0) {
            return 0xFFFFFF;
        }
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (this.renderPass == 0 || (meta & 3) == 3) {
            return 0xFFFFFF;
        }
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (this.renderPass == 0 || (world.func_72805_g(x, y, z) & 3) == 3) {
            return 0xFFFFFF;
        }
        return this.color;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[13];
        if (!this.field_149768_d.equals("null")) {
            this.baseTexture = iconRegister.func_94245_a(this.field_149768_d);
        }
        for (int o = 1; o < 13; ++o) {
            this.icons[o] = iconRegister.func_94245_a("hazards:stone_overlay_" + o);
        }
    }

    public boolean canRenderInPass(int pass) {
        this.renderPass = pass;
        return pass <= 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public int func_149738_a(World p_149738_1_) {
        return 50;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item unknown, CreativeTabs tab, List subItems) {
        for (int ix = 0; ix < 4; ++ix) {
            subItems.add(new ItemStack((Block)this, 1, ix));
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        if (!world.func_72873_a(x, y, z, 32) || world.field_73011_w.field_76574_g == Integer.MIN_VALUE) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                UnstableStoneHelper.updateUnstable(world, x, y, z, par5Random, this, meta);
                break;
            }
            case 1: {
                UnstableStoneHelper.updateFractured(world, x, y, z, par5Random, this, meta);
                break;
            }
            case 2: {
                UnstableStoneHelper.updateBroken(world, x, y, z, par5Random, this, meta);
                break;
            }
            case 3: 
            case 7: {
                UnstableStoneHelper.updateCobble(world, x, y, z, par5Random, this, meta & 3);
                break;
            }
            default: {
                world.func_72921_c(x, y, z, meta & 3, 6);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z) & 3;
        if (this.renderPass == 0) {
            return this.baseTexture;
        }
        if (this.renderPass == 1 && meta == 0) {
            return this.icons[12];
        }
        if (meta == 1) {
            if (side > 1) {
                Twister.initialize_generator((int)(2378 + y));
                int ch = 0;
                for (int i = Math.abs(x + z) % 64; i >= 0; --i) {
                    ch = Twister.extract_number();
                }
                ch = (ch + side) % 18;
                switch (Math.abs(ch)) {
                    case 0: 
                    case 12: {
                        return this.icons[2];
                    }
                    case 1: 
                    case 8: {
                        return this.icons[3];
                    }
                    case 2: 
                    case 14: {
                        return this.icons[4];
                    }
                    case 3: 
                    case 7: {
                        return this.icons[5];
                    }
                    case 9: 
                    case 11: {
                        return this.icons[6];
                    }
                    case 10: 
                    case 16: {
                        return this.icons[7];
                    }
                    case 5: 
                    case 15: {
                        return this.icons[8];
                    }
                    case 13: 
                    case 17: {
                        return this.icons[9];
                    }
                    case 4: 
                    case 6: {
                        return this.icons[1];
                    }
                }
            } else {
                return this.icons[12];
            }
        }
        return this.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (this.renderPass == 0) {
            return this.baseTexture;
        }
        if (this.renderPass == 1 && metadata == 0) {
            return this.icons[12];
        }
        if (metadata != 1) {
            metadata += 8;
        }
        if (side == 1 && metadata == 1) {
            return this.icons[12];
        }
        return this.icons[Math.min(metadata, 11)];
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        if (this.dropsSelf) {
            return Item.func_150898_a((Block)this);
        }
        return Item.func_150898_a((Block)Blocks.field_150347_e);
    }

    public int func_149692_a(int p_149692_1_) {
        if (this.dropsSelf) {
            return 3;
        }
        return 0;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (HazardsEventHandler.enableRockDust && world.func_72805_g(x, y, z) == 3) {
            this.func_149674_a(world, x, y, z, world.field_73012_v);
            Random rand = new Random();
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    if (!world.func_147437_c(x + i, y, z + k) || rand.nextInt(3) != 0) continue;
                    world.func_147465_d(x + i, y, z + k, UndergroundBase.rockDust, 4, 3);
                    return;
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        world.func_147464_a(x, y, z, (Block)this, 6 + new Random().nextInt(6));
    }

    public void func_149723_a(World world, int i, int j, int k, Explosion expl) {
        int meta = world.func_72805_g(i, j, k);
        if (meta <= 1 && world.field_73012_v.nextBoolean()) {
            int x = (int)Math.round(expl.field_77284_b - 0.5);
            int y = (int)Math.round(expl.field_77285_c - 0.5);
            int z = (int)Math.round(expl.field_77282_d - 0.5);
            int a = world.field_73012_v.nextInt(13) - 6;
            int b = world.field_73012_v.nextInt(9) - 1;
            int c = world.field_73012_v.nextInt(13) - 6;
            Vec3 up = Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0);
            Vec3 v1 = Vec3.func_72443_a((double)a, (double)b, (double)c);
            Vec3 v2 = Vec3.func_72443_a((double)(i - x), (double)(j - y), (double)(k - z));
            double theta = this.AngleBetween(up, v2);
            Vec3 q = up.func_72431_c(v2).func_72432_b();
            Vec3 f = this.RotateAboutArbitraryAxis(v1, q, theta);
            UnstableStoneHelper.drawLine3D(world, this, meta + 1, i, j, k, (int)Math.round(f.field_72450_a + (double)i), (int)Math.round(f.field_72448_b + (double)j), (int)Math.round(f.field_72449_c + (double)k), true, true);
        }
    }

    private double AngleBetween(Vec3 v1, Vec3 v2) {
        double d = v1.func_72430_b(v2);
        double m1 = v1.func_72433_c();
        double m2 = v2.func_72433_c();
        return Math.acos(d / (m1 * m2));
    }

    private Vec3 RotateAboutArbitraryAxis(Vec3 v1, Vec3 axis, double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        double vx = cos * v1.field_72450_a + -sin * v1.func_72431_c((Vec3)axis).field_72450_a + (1.0 - cos) * v1.func_72430_b(axis) * axis.field_72450_a;
        double vy = cos * v1.field_72448_b + -sin * v1.func_72431_c((Vec3)axis).field_72448_b + (1.0 - cos) * v1.func_72430_b(axis) * axis.field_72448_b;
        double vz = cos * v1.field_72449_c + -sin * v1.func_72431_c((Vec3)axis).field_72449_c + (1.0 - cos) * v1.func_72430_b(axis) * axis.field_72449_c;
        return Vec3.func_72443_a((double)vx, (double)vy, (double)vz);
    }

    private double[] convertSphericalToCartesian(double lat, double lon, double dist) {
        double x = dist * Math.cos(lat) * Math.cos(lon);
        double y = dist * Math.cos(lat) * Math.sin(lon);
        double z = dist * Math.sin(lat);
        double[] point = new double[]{x, y, z};
        return point;
    }

    private double[] convertCartesianToSpherical(int x, int y, int z) {
        double r = Math.sqrt(x * x + y * y + z * z);
        double lat = Math.asin((double)z / r);
        double lon = Math.atan2(y, x);
        double[] vec = new double[]{lat, lon, r};
        return vec;
    }

    private int[] rotateByAngle(int px, int py, int ox, int oy, double theta) {
        int[] p = new int[]{(int)(Math.cos(theta) * (double)(px - ox) - Math.sin(theta) * (double)(py - oy) + (double)ox), (int)(Math.sin(theta) * (double)(px - ox) + Math.cos(theta) * (double)(py - oy) + (double)oy)};
        return p;
    }
}

