/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.block;

import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.block.IBreathable;
import com.draco18s.hazards.block.helper.GasFlowHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;

public class BlockGas
extends BlockFluidFinite
implements IBreathable {
    public static int renderID;
    protected int airQuality;
    protected IIcon stillIcon;
    protected IIcon flowingIcon;

    public BlockGas(Fluid fluid, int quality) {
        super(fluid, UndergroundBase.gas);
        this.airQuality = quality;
    }

    @Override
    public int getAirQuality(int meta) {
        return this.airQuality * (meta + 1);
    }

    @Override
    public boolean causesNausea(int meta) {
        return true;
    }

    public int func_149645_b() {
        return renderID;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        return 13290706;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? this.stillIcon : this.flowingIcon;
    }

    public boolean func_149678_a(int meta, boolean liquids) {
        return false;
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150353_l) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150355_j) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150356_k) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150358_i) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150480_ab) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150478_aa) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150353_l) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150355_j) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150356_k) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150358_i) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150480_ab) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150478_aa) {
            return false;
        }
        if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151594_q) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        world.func_147464_a(x, y, z, (Block)this, 10);
    }

    public void func_149640_a(World world, int x, int y, int z, Entity entity, Vec3 vec) {
    }

    public int func_149660_a(World par1World, int x, int y, int z, int par5, float par6, float par7, float par8, int par9) {
        return 8;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return true;
        }
        return super.func_149646_a(world, x, y, z, side);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.func_72873_a(x, y, z, 16) || world.field_73011_w.field_76574_g == Integer.MIN_VALUE) {
            return;
        }
        super.func_149674_a(world, x, y, z, rand);
        int quantaRemaining = world.func_72805_g(x, y, z) + 1;
        int north = this.getQuantaValue((IBlockAccess)world, x, y, z - 1);
        int south = this.getQuantaValue((IBlockAccess)world, x, y, z + 1);
        int west = this.getQuantaValue((IBlockAccess)world, x - 1, y, z);
        int east = this.getQuantaValue((IBlockAccess)world, x + 1, y, z);
        int newnorth = north;
        int newsouth = south;
        int neweast = east;
        int newwest = west;
        boolean changed = false;
        if (north >= 0 && south >= 0 && Math.abs(north - south) >= 1) {
            changed = true;
            if (north > south && north > 1) {
                if (south == 0 && (this.canDisplace((IBlockAccess)world, x, y, z + 1) || world.func_147439_a(x, y, z + 1) == this)) {
                    --newnorth;
                    ++newsouth;
                }
            } else if (south > 1) {
                if (north == 0 && (this.canDisplace((IBlockAccess)world, x, y, z - 1) || world.func_147439_a(x, y, z - 1) == this)) {
                    ++newnorth;
                    --newsouth;
                }
            } else {
                changed = false;
            }
        }
        if (west >= 0 && east >= 0 && Math.abs(west - east) >= 1) {
            changed = true;
            if (west > east && west > 1) {
                if (east == 0 && (this.canDisplace((IBlockAccess)world, x + 1, y, z) || world.func_147439_a(x + 1, y, z) == this)) {
                    --newwest;
                    ++neweast;
                }
            } else if (east > 1) {
                if (west == 0 && (this.canDisplace((IBlockAccess)world, x - 1, y, z) || world.func_147439_a(x - 1, y, z) == this)) {
                    ++newwest;
                    --neweast;
                }
            } else {
                changed = false;
            }
        }
        if (changed) {
            if (newnorth > 0) {
                world.func_147465_d(x, y, z - 1, (Block)this, newnorth - 1, 3);
            }
            if (newsouth > 0) {
                world.func_147465_d(x, y, z + 1, (Block)this, newsouth - 1, 3);
            }
            if (newwest > 0) {
                world.func_147465_d(x - 1, y, z, (Block)this, newwest - 1, 3);
            }
            if (neweast > 0) {
                world.func_147465_d(x + 1, y, z, (Block)this, neweast - 1, 3);
            }
        }
        if (UndergroundBase.doGasSeeping && quantaRemaining > 1 && world.func_72873_a(x, y, z, 32)) {
            Block[] wID = new Block[]{world.func_147439_a(x + 1, y, z), world.func_147439_a(x, y, z + 1), world.func_147439_a(x - 1, y, z), world.func_147439_a(x, y, z - 1), world.func_147439_a(x, y + this.densityDir, z)};
            for (int i = 0; i < wID.length; ++i) {
                if (!GasFlowHelper.isPartialBlock(wID[i])) continue;
                this.flowPastDoors(world, x, y, z, quantaRemaining - 1, rand, i);
            }
            world.func_147464_a(x, y, z, (Block)this, 100);
        }
    }

    protected void flowPastDoors(World world, int x, int y, int z, int meta, Random rand, int dir) {
        int ox = 0;
        int oy = 0;
        int oz = 0;
        do {
            switch (dir) {
                case 0: {
                    ++ox;
                    break;
                }
                case 1: {
                    ++oz;
                    break;
                }
                case 2: {
                    --ox;
                    break;
                }
                case 3: {
                    --oz;
                    break;
                }
                case 4: {
                    oy += this.densityDir;
                }
            }
            Block s = world.func_147439_a(x + ox, y + oy, z + oz);
            if (GasFlowHelper.isPartialBlock(s)) {
                int bm = world.func_72805_g(x + ox, y + oy, z + oz);
                if (dir < 4 && GasFlowHelper.isDoor(s)) {
                    if ((bm & 8) > 0) {
                        bm = world.func_72805_g(x + ox, y + oy - 1, z + oz);
                    }
                    if ((dir & 1) == (bm & 1) && (bm & 4) == 0) {
                        return;
                    }
                    if ((dir & 1) == (bm & 1) || (bm & 4) == 0) continue;
                    return;
                }
                if (dir > 3 && s == Blocks.field_150415_aT && (bm & 4) == 0) {
                    return;
                }
                if (Math.abs(ox) + Math.abs(oy / 4) + Math.abs(oz) < meta) continue;
                return;
            }
            if (this.canDisplace((IBlockAccess)world, x + ox, y + oy, z + oz)) {
                world.func_147465_d(x + ox, y + oy, z + oz, (Block)this, meta / 2, 3);
                world.func_147465_d(x, y, z, (Block)this, meta - meta / 2, 3);
                return;
            }
            if (s == this) {
                int mm = world.func_72805_g(x + ox, y + oy, z + oz) + meta;
                if (mm - mm / 2 == meta || mm / 2 == meta) continue;
                world.func_147465_d(x + ox, y + oy, z + oz, (Block)this, mm / 2, 3);
                world.func_147465_d(x, y, z, (Block)this, mm - mm / 2, 3);
                return;
            }
            if (!s.func_149662_c()) continue;
            return;
        } while (Math.abs(ox) + Math.abs(oy / 4) + Math.abs(oz) < 8);
    }
}

