/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards;

import com.draco18s.hardlib.CogConfig;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hazards.CommonProxy;
import com.draco18s.hazards.HazardsEventHandler;
import com.draco18s.hazards.StoneRegistry;
import com.draco18s.hazards.block.BlockRockDust;
import com.draco18s.hazards.block.BlockThinVolatileGas;
import com.draco18s.hazards.block.BlockVolatileGas;
import com.draco18s.hazards.block.BlockVolcanicGas;
import com.draco18s.hazards.block.helper.GasFlowHelper;
import com.draco18s.hazards.block.helper.UnstableStoneHelper;
import com.draco18s.hazards.integration.IntegrationForestry;
import com.draco18s.hazards.integration.ModStoneRegistration;
import com.draco18s.hazards.network.CtoSMessage;
import com.draco18s.hazards.network.PacketHandlerServer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="HarderUnderground", name="HarderUnderground", version="1.7.0a", dependencies="required-after:HardLib@[1.7,]")
public class UndergroundBase {
    public static Block blockVolatileGas;
    public static Block blockThinVolatileGas;
    public static Block blockVolcanicGas;
    public static Block rockDust;
    public static Material gas;
    @Mod.Instance(value="HarderUnderground")
    public static UndergroundBase instance;
    public static Configuration config;
    public static boolean doVolcanicGas;
    public static boolean doSmoke;
    public static boolean doStoneReplace;
    public static boolean doGasSeeping;
    public static SimpleNetworkWrapper networkWrapper;
    @SidedProxy(clientSide="com.draco18s.hazards.client.ClientProxy", serverSide="com.draco18s.hazards.CommonProxy")
    public static CommonProxy proxy;
    public static Random rand;
    public static int catchFireRange;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        Fluid fluidVolatile = new Fluid("VolatileGas");
        fluidVolatile.setViscosity(200).setDensity(100).setTemperature(295).setGaseous(true);
        FluidRegistry.registerFluid((Fluid)fluidVolatile);
        blockVolatileGas = new BlockVolatileGas(fluidVolatile);
        GameRegistry.registerBlock((Block)blockVolatileGas, (String)"volatile_gas");
        fluidVolatile = new Fluid("ThinVolatileGas");
        fluidVolatile.setViscosity(200).setDensity(-100).setTemperature(285).setGaseous(true);
        FluidRegistry.registerFluid((Fluid)fluidVolatile);
        blockThinVolatileGas = new BlockThinVolatileGas(fluidVolatile);
        GameRegistry.registerBlock((Block)blockThinVolatileGas, (String)"thin_volatile_gas");
        fluidVolatile = new Fluid("VolcanicGas");
        fluidVolatile.setViscosity(1600).setDensity(-10).setTemperature(675).setGaseous(true);
        FluidRegistry.registerFluid((Fluid)fluidVolatile);
        blockVolcanicGas = new BlockVolcanicGas(fluidVolatile);
        GameRegistry.registerBlock((Block)blockVolcanicGas, (String)"volcanic_gas");
        rockDust = new BlockRockDust();
        GameRegistry.registerBlock((Block)rockDust, (String)"rock_dust");
        CogConfig.addCogModule((String)"UndergroundHazards.xml");
        doVolcanicGas = config.getBoolean("spawnVolcanicGas", "HAZARDS", true, "This spawns smoke above lava when the player is nearby and dissipates quickly.\n");
        doSmoke = config.getBoolean("spawnSmoke", "HAZARDS", true, "This spawns smoke above fires when the player is nearby and dissipates quickly.\n");
        doStoneReplace = config.getBoolean("replaceStone", "HAZARDS", true, "Replaces vanilla stone with a stone that does not float and requires support.\nDrops unstable cobble which smelts into unstable stone.\nThere is a crafting recipe to convert to vanilla.\n");
        doGasSeeping = config.getBoolean("gasSeeps", "HAZARDS", true, "If true, thin volatile gas will try to move past standard \"water tight\" blocks\nlike doors and signs.\n");
        catchFireRange = config.getInt("gasCatchFireRange", "HAZARDS", 96, -1, 512, "Lag preventative, this limits the range that a player needs to be within\nin order for volatile gas to ignite when coming in contact with\nfire sources other than Fire. -1 effectively disables the effect (infinite range).\nIf you are seeing root.tick.gameMode.checkLight (shift-F3) taking most of the\nframe time (>10% of total), lower this value.\n");
        HazardsEventHandler.sidwaysFallPhysics = config.getBoolean("fallingBlocksShiftSideways", "HAZARDS", true, "If enabled, falling block type blocks will attempt to move\nsideways one block if there is open space there, forming pyramids.\n");
        HazardsEventHandler.enableRockDust = config.getBoolean("enableRockDust", "HAZARDS", true, "If enabled, collapsing stone will spawn a cloud of choking dust.");
        if (catchFireRange == 0) {
            catchFireRange = 1;
        }
        HardLibAPI.stoneManager = new StoneRegistry();
        Block unst = HardLibAPI.stoneManager.addStoneType(Blocks.field_150348_b, 0, Blocks.field_150348_b.func_149739_a(), "stone");
        if (doStoneReplace) {
            ItemStack in = new ItemStack(unst, 0, 3);
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150463_bK), (Object[])new Object[]{"sss", "sss", Character.valueOf('s'), in});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150446_ar), (Object[])new Object[]{"  s", " ss", "sss", Character.valueOf('s'), in});
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150347_e), (Object[])new Object[]{"scs", Character.valueOf('s'), new ItemStack(Items.field_151055_y), Character.valueOf('c'), in});
            try {
                Class<?> clz = Class.forName("com.draco18s.hardlibcore.asm.HardLibPatcher");
                clz.getDeclaredField("unstableStoneBlock").set(null, unst);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        UnstableStoneHelper.addSupportBlock(Blocks.field_150348_b);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150365_q);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150366_p);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150352_o);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150482_ag);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150450_ax);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150439_ay);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150369_x);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150412_bA);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150424_aL);
        UnstableStoneHelper.addSupportBlock(Blocks.field_150449_bY);
        int serverMessageID = 1;
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("HarderUnderground");
        networkWrapper.registerMessage(PacketHandlerServer.class, CtoSMessage.class, serverMessageID, Side.SERVER);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"ganyssurface")) {
            ModStoneRegistration.registerGany();
        }
        Blocks.field_150480_ab.setFireInfo(blockVolatileGas, 60, 1);
        Blocks.field_150480_ab.setFireInfo(blockThinVolatileGas, 1000, 25);
        GasFlowHelper.addWoodenDoor(Blocks.field_150466_ao);
        GasFlowHelper.addWoodenDoor(Blocks.field_150454_av);
        GasFlowHelper.addPartialBlock(Blocks.field_150415_aT);
        GasFlowHelper.addPartialBlock(Blocks.field_150468_ap);
        GasFlowHelper.addPartialBlock(Blocks.field_150444_as);
        GasFlowHelper.addPartialBlock(Blocks.field_150457_bL);
        GasFlowHelper.addPartialBlock(Blocks.field_150448_aq);
        GasFlowHelper.addPartialBlock(Blocks.field_150408_cc);
        GasFlowHelper.addPartialBlock(Blocks.field_150319_E);
        GasFlowHelper.addPartialBlock(Blocks.field_150318_D);
        GasFlowHelper.addPartialBlock(Blocks.field_150429_aA);
        GasFlowHelper.addPartialBlock(Blocks.field_150437_az);
        GasFlowHelper.addPartialBlock((Block)Blocks.field_150488_af);
        GasFlowHelper.addPartialBlock(Blocks.field_150414_aQ);
        GasFlowHelper.addPartialBlock(Blocks.field_150422_aJ);
        GasFlowHelper.addPartialBlock(Blocks.field_150396_be);
        GasFlowHelper.addPartialBlock(Blocks.field_150411_aY);
        GasFlowHelper.addPartialBlock(Blocks.field_150443_bT);
        GasFlowHelper.addPartialBlock(Blocks.field_150445_bS);
        GasFlowHelper.addPartialBlock(Blocks.field_150430_aB);
        GasFlowHelper.addPartialBlock(Blocks.field_150456_au);
        GasFlowHelper.addPartialBlock(Blocks.field_150442_at);
        GasFlowHelper.addPartialBlock(Blocks.field_150386_bk);
        GasFlowHelper.addPartialBlock(Blocks.field_150436_aH);
        GasFlowHelper.addPartialBlock(Blocks.field_150471_bO);
        GasFlowHelper.addPartialBlock(Blocks.field_150452_aw);
        GasFlowHelper.addPartialBlock(Blocks.field_150473_bD);
        GasFlowHelper.addPartialBlock((Block)Blocks.field_150479_bC);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.draco18s.hazards.integration.WailaIntegration.callbackRegister");
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("BlockName", "volatile_gas");
        nbt.func_74776_a("Accessibility", 0.05f);
        nbt.func_74776_a("Flat", -0.25f);
        FMLInterModComms.sendMessage((String)"Mystcraft", (String)"blockinstability", (NBTTagCompound)nbt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.registerEvents();
        proxy.registerRenderers();
        CogConfig.unpackConfigs();
        boolean hardShovel = config.getBoolean("modifyBlockHardness", "GENERAL", true, "This setting increases the block hardness of all (vanilla) shovel-harvest blocks,\nincreasing the value of a shovel, as dig speed is reduced by ~60% for most blocks.\nAlso increases the hardness of logs (33%) and huge mushrooms (62%).\n");
        float shovelMulti = config.getFloat("multiplyBlockHardness", "GENERAL", 1.0f, 1.0f, 3.0f, "Not hard enough?  Change this.\nThis value is divided by 0.6 for most blocks and 0.75 for the remainder,\nand multiplied by the blocks' original hardness.\nA value of 1.5 will make grass as hard as stone (using a tool), 1.8 will make dirt and sand that hard.\n");
        if (hardShovel) {
            float f = shovelMulti / 0.6f;
            float f2 = shovelMulti / 0.75f;
            Blocks.field_150346_d.func_149711_c(Blocks.field_150346_d.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150349_c.func_149711_c(Blocks.field_150349_c.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150458_ak.func_149711_c(Blocks.field_150458_ak.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150354_m.func_149711_c(Blocks.field_150354_m.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150351_n.func_149711_c(Blocks.field_150351_n.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150435_aG.func_149711_c(Blocks.field_150435_aG.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150391_bh.func_149711_c(Blocks.field_150391_bh.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150425_aM.func_149711_c(Blocks.field_150425_aM.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150433_aE.func_149711_c(Blocks.field_150433_aE.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150431_aC.func_149711_c(Blocks.field_150431_aC.func_149712_f(null, 0, 0, 0) * f2);
            Blocks.field_150364_r.func_149711_c(Blocks.field_150364_r.func_149712_f(null, 0, 0, 0) * f2);
            Blocks.field_150363_s.func_149711_c(Blocks.field_150363_s.func_149712_f(null, 0, 0, 0) * f2);
            Blocks.field_150420_aW.func_149711_c(Blocks.field_150420_aW.func_149712_f(null, 0, 0, 0) * f);
            Blocks.field_150419_aX.func_149711_c(Blocks.field_150419_aX.func_149712_f(null, 0, 0, 0) * f);
            if (Loader.isModLoaded((String)"Forestry")) {
                IntegrationForestry.modifyForestryTrees();
            }
        }
        config.save();
    }

    public static boolean needsToBreath(EntityLivingBase ent) {
        return !(ent instanceof EntityIronGolem) && ent.func_70668_bt() != EnumCreatureAttribute.UNDEAD;
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (imcMessage.key.equalsIgnoreCase("RR-underground-support")) {
                if (!imcMessage.isItemStackMessage()) continue;
                UnstableStoneHelper.addSupportBlock(Block.func_149634_a((Item)imcMessage.getItemStackValue().func_77973_b()));
                continue;
            }
            if (imcMessage.key.equalsIgnoreCase("RR-underground-isDoor")) {
                if (!imcMessage.isItemStackMessage()) continue;
                GasFlowHelper.addWoodenDoor(Block.func_149634_a((Item)imcMessage.getItemStackValue().func_77973_b()));
                continue;
            }
            if (!imcMessage.key.equalsIgnoreCase("RR-underground-isPartialBlock") || !imcMessage.isItemStackMessage()) continue;
            GasFlowHelper.addWoodenDoor(Block.func_149634_a((Item)imcMessage.getItemStackValue().func_77973_b()));
        }
    }

    static {
        gas = new MaterialLiquid(MapColor.field_151660_b);
        rand = new Random();
    }
}

