/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards;

import com.draco18s.hardlib.api.interfaces.IHardStones;
import com.draco18s.hazards.BlockStoneType;
import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.block.BlockUnstableStone;
import com.draco18s.hazards.block.helper.UnstableStoneHelper;
import com.draco18s.hazards.item.ItemBlockUnstable;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class StoneRegistry
implements IHardStones {
    private static HashMap<BlockStoneType, BlockStoneType> mapping = new HashMap();
    private static ArrayList<int[][]> fracIconOverlays = new ArrayList();

    public Block addStoneType(Block orig, int origMeta, String name, String texName) {
        return this.addStoneType(orig, origMeta, name, texName, 0x737373);
    }

    public Block addStoneType(Block orig, int origMeta, String name, String texName, int colorMult) {
        if (orig == null) {
            RuntimeException e = new RuntimeException("Attempted to register a null block (" + name + ") as stone");
            e.printStackTrace();
            return null;
        }
        UndergroundBase.logger.log(Level.INFO, "Registering unstable_" + name + " with texture " + texName);
        BlockUnstableStone b = new BlockUnstableStone(name, texName, colorMult);
        float hard = 1.5f;
        float resist = 10.0f;
        try {
            hard = orig.func_149712_f(null, 0, 0, 0);
            resist = orig.func_149638_a(null);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        b.func_149711_c(hard);
        b.func_149752_b(resist);
        b.func_149672_a(orig.field_149762_H);
        b.setHarvestLevel(orig.getHarvestTool(origMeta), orig.getHarvestLevel(origMeta));
        if (name.indexOf("tile") >= 0) {
            name = name.substring(5);
        }
        GameRegistry.registerBlock((Block)b, ItemBlockUnstable.class, (String)("unstable_" + name));
        UnstableStoneHelper.addSupportBlock(b);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)b, 1, 3), (ItemStack)new ItemStack((Block)b, 1, 0), (float)0.1f);
        BlockStoneType bst = new BlockStoneType(orig, origMeta);
        BlockStoneType rst = new BlockStoneType(b, 0);
        b.setDropsSelf();
        mapping.put(bst, rst);
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack((Block)b, 1, 3));
        OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack((Block)b, 1, 0));
        return b;
    }

    public static Block getReplacement(Block b, int m) {
        BlockStoneType r = mapping.get(new BlockStoneType(b, m));
        if (r == null) {
            return null;
        }
        return r.stone;
    }

    public boolean isUnstableBlock(Block b) {
        for (BlockStoneType bst : mapping.values()) {
            if (bst.stone != b) continue;
            return true;
        }
        return false;
    }

    public static int[][] getIconOverlay(int index) {
        if (index >= fracIconOverlays.size()) {
            return null;
        }
        return fracIconOverlays.get(index);
    }

    public static void setIconOverlay(int[][] data) {
        fracIconOverlays.add(data);
    }
}

