/*
 * @author t@tabalt.net
 */

$(function() {
	function getSortStr(t)
	{
		switch (t) {
			case 'degree': return 'RAREDEGREE_DESC';
			case 'amount': return 'AMOUNT_ASC';
			case 'time': return 'CREATETIME_ASC';
			default: return 'RAREDEGREE_DESC';
		}
	}
	function refresh() {
		var page_no = parseInt($('#pageno').val()) || 1;
		var sort = $("input[name='sortby']:checked").val();
		var hiprice = parseInt($('#hiprice').val());
		var hidegree = parseInt($('#hidegree').val());
		// pageNo, querySortType, minDegree, minPrice
		Buyer.ShowPetsOnSale(page_no, getSortStr(sort), hiprice, function(list) {
			var min_price = null;
			var min_item = null;
			for (var i = 0; i < list.length; i++) {
				var pet = list[i];
                var price = parseFloat(pet.amount);
                if (pet.rareDegree < (hidegree || 0)) {
                    continue;
                }
                if (min_price == null || price < min_price) {
                    min_price = price;
                    min_item = pet;
                }
			}

			var degree = Buyer.DegreeConf[min_item.rareDegree] || {desc:'未知',buyAmount:'5.00'};
			$('#lowest').html('最低价为：第' + min_item.birthType + '代，' + degree.desc + ', ' + min_price);
		}, hidegree);
	}
	
	$('#zd-buy-btn').click(function() {
		var petId = $.trim($('#zd-pet-id').val());
		if (petId.length < 15) {
			Alert.success('填写的宠物标识不正确', 2);
			return;
		}
		
		Buyer.BuyPet(petId);
	});

	$('#search-btn').click(refresh);

	$('#prev-page').click(function() {
		var page_no = parseInt($('#pageno').val()) || 1;
		page_no--;
		if (page_no < 1) {
			return;
		}
		$('#pageno').val(page_no);
		refresh();
	});
	$('#next-page').click(function() {
		var page_no = parseInt($('#pageno').val()) || 1;
		page_no++;
		if (page_no > 70) {
			return;
		}
		$('#pageno').val(page_no);
		refresh();
	});
	Buyer.InitBuyModal();
    setInterval(function(){
        Buyer.TryBuyPets();
    }, 100);
    Buyer.UserInfo();
});