/*
 * @author t@tabalt.net
 */

var Buyer = {
    lastTradeTime: null,
    TryToBuyChain: {},
    TryedBuyMap: {},
    Buying: false,
    Pause: false,
    Once: false,
    CurrentImg: null,
    Samples: [],

    ApiUrl: {
        QueryPetsOnSale: 'https://pet-chain.baidu.com/data/market/queryPetsOnSale',
        TxnCreate: 'https://pet-chain.baidu.com/data/txn/create',
        CaptchaGen: 'https://pet-chain.baidu.com/data/captcha/gen',
        MyList: 'https://pet-chain.baidu.com/data/user/pet/list',
        SellPet: 'https://pet-chain.baidu.com/data/market/salePet',
        UserInfo: 'https://pet-chain.baidu.com/data/user/get',
        Unsale: 'https://pet-chain.baidu.com/data/market/unsalePet',
		QueryInfo: 'https://pet-chain.baidu.com/data/pet/queryPetById'
    },
    reportSample: function(code, data) {
        if (window.need_report_captcha === 1) {
            $.ajax({
                type: 'POST',
                url: 'http://www.laici123.com/captcha.php',
                //contentType : 'application/json',
                data: {code: code, data: data},
                success:function(res){
                    
                }
            });
        }
    }, 
    DegreeConf: Configurator.getDegreeConf(),
    Unsale:function(petId) {
        
        $.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.Unsale,
            contentType : 'application/json',
            data: JSON.stringify({
                "petId": petId,
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":"",
                "timeStamp":null,
                "nounce":null,
                "token":null
            }),
            success:function(res){
                if (res.errorNo == "00") {
                    Alert.Success('撤销成功！', 3);
                } else {
                    Alert.Error('错误：' + res.errorMsg, 3);
                }
            }
        });
    },
    UserInfo: function() {
        $.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.UserInfo,
            contentType : 'application/json',
            data: JSON.stringify({
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":""
            }),
            success:function(res){
                if (res.errorNo == "00") {
                    var balance = res.data.amount;
                    $('#balance').html(balance);
                } else {
                    Alert.Error('错误：' + res.errorMsg, 3);
                }
            }
        });

    },
    SellPet: function(petID) {
        var price = prompt('Input Price?');
        price = $.trim(price);
        if (price == '') {
            Alert.Error('Your Price is empty');
            return;
        }
        Alert.Success('Your Price is ' + price);

        $.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.SellPet,
            contentType : 'application/json',
            data: JSON.stringify({
                "petId": petID,
                "amount": price,
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":""
            }),
            success:function(res){
                if (res.errorNo == "00") {
                    Alert.Success('卖出成功！', 3);
                } else {
                    Alert.Error('错误：' + res.errorMsg, 3);
                }
            }
        });
    },

    InitBuyModal: function() {
        $('#buyModalCenter form').submit(function(){
            Buyer.submitBuy();
            return false;
        });

        $('#buyVerifyRefresh').click(function() {
            Buyer.displayVerifyImage();
        });
        
        $('#buyVerifyCode').keyup(function(){
            var verifyCode = $(this).val();
            if (verifyCode.length == 4) {
                Buyer.submitBuy();
            }
        });
        $('#buyModalSubmit').click(function(){
            Buyer.submitBuy();
        });
    },
    MyList: function(curpage) {
        $('#mydogs').html('加载中...');
        $.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.MyList,
            contentType : 'application/json',
            data: JSON.stringify({
                "pageNo":curpage || 1,
                "pageSize":20,
                "pageTotal":-1,
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":""
            }),
            success:function(res){
                var list = res.data.dataList;
                var $dogs = $('#mydogs');
                $dogs.html('');
                for (var i in list) {
                    var item = list[i];
                    var id = item['id'];
                    var gen = item['generation'];
                    //var degree = item['rareDegree'];
                    var amount = item['amount'];
                    var shelfStatus = item['shelfStatus'];
                    var chainStatus = item['chainStatus'];
                    var degree = Buyer.DegreeConf[item.rareDegree] || {desc:'未知',buyAmount:'5.00'};
                    var $li = $('<tr><td>' + id + '</td><td>' + degree.desc + '</td><td>第' + gen + '代</td><td>'+ (amount > 0 ? amount : '-') + '</td><td><a href="https://pet-chain.baidu.com/chain/detail?channel=market&petId='+item['petId']+'" target=_blank>' + item['petId'] + '</a><td></tr>');
                    $li.data('item', item);
                    $li.dblclick(function() {
                        var $li = $(this);
                        var item = $li.data('item');
                        if (item.amount > 0) {
                            Buyer.Unsale(item['petId'])
                        } else {
                            Buyer.SellPet(item['petId'])
                        }
                    });
                    $li.hover(function() {
                        var item = $(this).data('item');
                        var petURL = item['petUrl'];
                        $('#petimg').attr('src', petURL);
                    })
                    $dogs.append($li);

                }
            }
        });
    },

    ShowPetsOnSale: function(pageNo, querySortType, highPrice, cb, minDegree, minPrice) {
        $("#petsOnSale tbody").html("加载中");
        $.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.QueryPetsOnSale,
            contentType : 'application/json',
            data: JSON.stringify({
                "pageNo":pageNo || 1,
                "pageSize":20,
                "querySortType": querySortType || "AMOUNT_ASC", //RAREDEGREE_DESC
                "petIds":[],
                "lastAmount":null,
                "lastRareDegree":null,
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":""
            }),
            success:function(res) {
                $("#petsOnSale tbody").html("");
                var petsOnSale = res.data.petsOnSale || [];

                var min_price = minPrice || 0;
                
                for (var i = petsOnSale.length - 1; i >= 0; i--) {
                    var pet = petsOnSale[i];
                    var degree = Buyer.DegreeConf[pet.rareDegree] || {desc:'未知',buyAmount:'5.00'};
                    if (pet.rareDegree < (minDegree || 0)) {
                        continue;
                    }
                    var needToBuyColor = '';
                    var price = parseFloat(pet.amount);
                    if (price < min_price) {
                        continue;
                    }
                    
                    if (price <= parseFloat(degree.buyAmount)) {
                        
                        if (Buyer.lastTradeTime === null || new Date().getTime() - Buyer.lastTradeTime > 120000)  {
                            if (pet.birthType == 0) {
                                Buyer.TryToBuyChain[pet.id] = {
                                    degree:degree,
                                    pet:pet
                                }
                            }
                            needToBuyColor = 'red';
                        }/**/
                    }

                    if (price <= highPrice) {
                        needToBuyColor = 'green';
                    }


                    $tr = $('<tr>\
                        <td>' + i + '</td>\
                        <td>' + pet.id + '</td>\
                        <td><a href="https://pet-chain.baidu.com/chain/detail?channel=market&petId=' + pet.petId + '" target=_blank>' + pet.petId + '</a></td>\
                        <td>第' + pet.birthType + '代</td>\
                        <td>' + degree.desc + '</td>\
                        <td><font color="' + needToBuyColor + '">' + pet.amount + '</font></td>\
                    </tr>');

                    $tr.data('item', {
                            degree:degree,
                            pet:pet
                        });
                    $tr.dblclick(function() {
                        var $tr = $(this);
                        
                        var item = $tr.data('item');
                        
                        Buyer.Once = true;

                        Buyer.TryToBuyChain[pet.id] = item;
                    });

                    $tr.hover(function() {
                        var item = $(this).data('item');
                        var petURL = item.pet['petUrl'];
                        $('#petimg').attr('src', petURL);
                    })
                    $("#petsOnSale tbody").append($tr);
                }

                if (cb) {
                    cb(petsOnSale);
                }
            }
        });
    },
	
	BuyPet: function(petId) {
		// retrive first
		
		$.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.QueryInfo,
            contentType : 'application/json',
            data: JSON.stringify({
                "petId": petId,
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":"",
                "timeStamp":null,
                "nounce":null,
                "token":null
            }),
            success:function(res){
                if (res.errorNo == "00") {
                    var pet = res.data;
					var degree = Buyer.DegreeConf[pet.rareDegree] || {desc:'未知',buyAmount:'5.00'};
					var item = {
						degree:degree,
						pet:pet
					};
					Buyer.Once = true;
					Buyer.TryToBuyChain[petId] = item;
                } else {
                    Alert.Error('错误：' + res.errorMsg, 3);
                }
            }
        });
		
		
	},

    TryBuyPets:function() {
        if (!Buyer.Once) {
            if (Buyer.Buying || Buyer.Pause) {
                return;
            }
        }
        

        if (!(Buyer.lastTradeTime === null || new Date().getTime() - Buyer.lastTradeTime > 120000))  {
            return;
        }

        var toBuy = null;
        for(var key in Buyer.TryToBuyChain){
            toBuy = Buyer.TryToBuyChain[key]
            delete Buyer.TryToBuyChain[key];
            break;
        }
        //var toBuy = Buyer.TryToBuyChain.pop() || undefined;
        if (toBuy == undefined || toBuy == null) {
            return
        }

        var tryed = Buyer.TryedBuyMap[toBuy.pet.id] || false;
        if (tryed) {
            //return
        }

        if (Buyer.TryedBuyMap.length >= 100) {
            Buyer.TryedBuyMap = [];
        }
        Buyer.Once = false;
        Buyer.startBuyProcess();
        Buyer.displayBuyModal(toBuy.degree, toBuy.pet);
        Buyer.TryedBuyMap[toBuy.pet.id] = true;
    },

    displayBuyModal: function(degree, pet) {
        var detail = '\
        <p>尝试购买：ID[<span>'+pet.id+'</span>],\
        级别[<span>'+pet.rareDegree+'</span>],\
        价格[<font color="red">'+pet.amount+'</font>]</p>\
        <p>命中策略：等级[<span>'+degree.desc+'</span>],\
        最高价格[<font color="green">'+degree.buyAmount+'</font>]</p>\
        ';
        $("#buyModalPetDetail").html(detail);
        $("#buyPetId").val(pet.petId);
        $("#buyValidCode").val(pet.validCode);
        $("#buyPetAmount").val(pet.amount);

        Buyer.displayVerifyImage();

        $('#buyModalCenter').on('shown.bs.modal', function () {
            $('#buyVerifyCode').val('').focus();
        }).on('hidden.bs.modal', function () {
            Buyer.stopBuyProcess();
        });
        $('#stopBuyBtn').click(function() {
            Buyer.Pause = true;
        });

        $('#buyModalCenter').modal('show');
    },

    displayVerifyImage: function() {
        $.ajax({
            type: 'GET',
            url: Buyer.ApiUrl.CaptchaGen,
            contentType : 'application/json',
            data: {
                "requestId": new Date().getTime(),
                "appId":1,
                "tpl":""
            },
            success:function(res){
                $("#buyVerifySeed").val(res.data.seed);
                Buyer.CurrentImg = res.data.img;
                $('#buyVerifyImage').attr('src', 'data:image/jpeg;base64,'+res.data.img);
            }
        });
    },

    startBuyProcess: function() {
        Buyer.Buying = true;
    },

    stopBuyProcess: function() {
        Buyer.Buying = false;
    },

    submitBuy: function () {
        var verifySeed = $('#buyVerifySeed').val();
        var verifyCode = $('#buyVerifyCode').val();
        if (verifyCode == '' || verifyCode.length != 4) {
            Alert.Error("请填写4位验证码！", 3);
            return
        }

        var petId = $('#buyPetId').val();
        var petAmount = $('#buyPetAmount').val();
        var validCode = $("#buyValidCode").val();

        $.ajax({
            type: 'POST',
            url: Buyer.ApiUrl.TxnCreate,
            contentType : 'application/json',
            data: JSON.stringify({
                "amount": petAmount,
                "appId": 1,
                "seed": verifySeed,
                "captcha": verifyCode,
                "petId": petId,
                "requestId": new Date().getTime(),
                "validCode": validCode,
                "tpl":"",
            }),
            success:function(res2){
                if (res2.errorNo == 0) {
                    Buyer.lastTradeTime = new Date().getTime();
                    Alert.Success("抢到啦！！！！！", 3);
                    sample = { 'code': verifyCode, 'data': Buyer.CurrentImg };
                    Buyer.Samples.push(sample);
                    Buyer.reportSample(verifyCode, Buyer.CurrentImg);
                } else {
                    if (res2.errorMsg.indexOf('上笔交易正在进行中') > 0) {
                        Buyer.lastTradeTime = new Date().getTime(); 
                    }

                    // if verifyCode is right
                    if (res2.errorMsg != '验证码错误') {
                        sample = { 'code': verifyCode, 'data': Buyer.CurrentImg };
                        Buyer.Samples.push(sample);
                        Buyer.reportSample(verifyCode, Buyer.CurrentImg);
                    }
                    var msg = '没抢到：错误码[' + res2.errorNo + '],错误信息[' + res2.errorMsg + ']'
                    Alert.Error(msg, 3);
                    
                    
                }

                $('#buyModalCenter').modal('hide');
            },
            error:function(){
                Alert.Error("出错啦！", 3);
                $('#buyModalCenter').modal('hide');
            }
        });
    }
};