/**
 * jQuery.popover plugin v1.1.2
 * By Davey IJzermans
 * See http://wp.me/p12l3P-gT for details
 * http://daveyyzermans.nl/
 * 
 * Released under MIT License.
 */

;(function($) {
	//define some default plugin options
	var defaults = {
		verticalOffset: 10, //offset the popover by y px vertically (movement depends on position of popover. If position == 'bottom', positive numbers are down)
		horizontalOffset: 10, //offset the popover by x px horizontally (movement depends on position of popover. If position == 'right', positive numbers are right)
		//title: false, //heading, false for none
		content: false, //content of the popover
		//url: false, //set to an url to load content via ajax
		classes: '', //classes to give the popover, i.e. normal, wider or large
		position: 'auto', //where should the popover be placed? Auto, top, right, bottom, left or absolute (i.e. { top: 4 }, { left: 4 })
		fadeSpeed: 160, //how fast to fade out popovers when destroying or hiding
		trigger: 'click', //how to trigger the popover: click, hover or manual
		preventDefault: true, //preventDefault actions on the element on which the popover is called
		stopChildrenPropagation: true, //prevent propagation on popover children
		hideOnHTMLClick: true, //hides the popover when clicked outside of it
		//autoReposition: true, //automatically reposition popover on popover change and window resize
		anchor: false, //anchor the popover to a different element
        //(Add by feiqian)
        //userDefinePopover:false ,// use the attribute of the content which is defined by you to replace the default content and title of the popover,that's to say, rather than be used as content of the popover
        wrapper:'body', //  the wrapper container of the popover
        popoverId:'defaultPopoverId',//the id of the popover,keep in mind that if you want your jquery object to own more than one popover,be sure to set the id that is different from others
        zIndexOwner:0 ,//to control the z-index of the owner of the popover when show ,when hide set the z-index to 0
        extraStyle:{}, //the extra style of the popover
        beforeShow: null
	}
	var popovers = {};
    var uuid=0;

    //私有方法
	var _ = {
		calc_position: function(popover, position,popoverId ,index) {

            if(!popoverId) return;
			var data = popover.popover("getData",popoverId);
            if(data) {
                data=data[popoverId];
                var options = data.options;
                var $anchor = options.anchor ? $(options.anchor) : popover;
                var el = data.popover;
                var x1,y1;

                var wrapper= $(options.wrapper);
                var coordinates = $anchor.offset();
                var isChild= wrapper.closest($anchor).length ;

                if(isChild)   //wrapper是$anchor的子元素或本身
                {
                    if (position == 'top') {
                        y1 = -el.outerHeight()-20;
                        x1 = -(el.outerWidth()-$anchor.outerWidth()) / 2;

                    } else if (position == 'right') {
                        y1 = 0;
                        x1 = $anchor.outerWidth();
                    } else if (position == 'left') {
                        y1 = 0;
                        x1 = -$anchor.outerWidth();
                    } else {
                        //bottom
                        y1 = $anchor.outerHeight();
                        x1 = -(el.outerWidth()-$anchor.outerWidth()) / 2;
                    }
                }
                else     //'body'
                {
                    if (position == 'top') {
                        y1 = coordinates.top - el.outerHeight();
                        x1 = coordinates.left - el.outerWidth() / 2 + $anchor.outerWidth() / 2;
                    } else if (position == 'right') {
                        y1 = coordinates.top + $anchor.outerHeight() / 2 - el.outerHeight() / 2;
                        x1 = coordinates.left	+ $anchor.outerWidth();
                    } else if (position == 'left') {
                        y1 = coordinates.top + $anchor.outerHeight() / 2 - el.outerHeight() / 2;
                        x1 = coordinates.left	- el.outerWidth();
                    } else {
                        //bottom
                        y1 = coordinates.top + $anchor.outerHeight();
                        x1 = coordinates.left - el.outerWidth() / 2 + $anchor.outerWidth() / 2;
                    }

                    x1=x1<0?0:x1;
                    if(x1+el.outerWidth()>wrapper.outerWidth()) x1=wrapper.outerWidth()- el.outerWidth();

                    if (!index) {
                        if(position=='top'){
                            if (y1 < 0 ) {
                                position = 'bottom';
                                return  _.calc_position(popover, position, popoverId, true);
                            }
                        }
                        else if(position=='bottom'){
                            if (y1 + el.outerHeight() > wrapper.outerHeight()) {
                                position = 'top';
                                return  _.calc_position(popover, position, popoverId, true);
                            }
                        }
                    }
                    else {
                        y1=y1<0?0:y1;
                        if(y1+el.outerHeight()>wrapper.outerHeight()) y1=wrapper.outerHeight()- el.outerHeight();
                    }
                }

                return {
                    x1: x1,
                    y1: y1,
                    position:position
                };
            }
		},
        hideEventFun:function(){
            var flag=true;
            for(var key in popovers)
            {
                if(flag&&popovers.hasOwnProperty(key))
                {
                    var data=popovers[key].popover('getData');
                    if(data)
                    {
                        $.each(data,function(popoverId,data){
                            var display=data.popover.css('display');
                            if(display&&display!=='none'&&data.bound&&data.bound.isContainsPoint(event.clientX,event.clientY)) flag=false;
                        })
                    }
                }
            }
            flag&& $.fadeOutAllPopovers();
        },
        setBound:(
            function(){
                function Bound(left, top, width, height) {
                    this.left = left || 0;
                    this.top = top || 0;
                    this.height = height || 0;
                    this.width = width || 0;

                    this.right = left + this.width;
                    this.bottom = top + this.height;
                }

                Bound.prototype.isContainsPoint = function (x,y) {
                    return x >= this.left && x <= this.right && y >= this.top && y <= this.bottom;
                };

                return function(obj)
                {
                    if(!obj) return null;
                    var offset=$(obj.children()[0]).offset();
                    return new Bound(offset.left,offset.top,obj.width(),obj.height());
                }
            })()
	};

    //公有方法
	var methods = {
		/**
		 * Initialization method
		 * Merges parameters with defaults, makes the popover and saves data
		 *
		 * @param object
		 * @return jQuery
		 */
		init : function(params) {
			return this.each(function() {
				var options = $.extend({}, defaults, params);
				var $this = $(this);
				var data = $this.popover('getData');
				if ( ! data||!data[options.popoverId]) {
                    options.oldZIndexOwner= $this.css('z-index');
                    if(options.oldZIndexOwner=='auto'||!options.oldZIndexOwner) options.oldZIndexOwner=0;
                    if(!options.zIndexOwner) options.zIndexOwner=options.oldZIndexOwner;
                    var popover;

                    if(!options.content) return;
                    popover=$('<div class="user-popover" />').addClass(options.classes).css(options.extraStyle).html(options.content instanceof jQuery ? options.content[0] : options.content);
                    popover.appendTo(options.wrapper) .hide();

					if (options.stopChildrenPropagation) {
						popover.children().unbind('click.popover').bind('click.popover', function(event) {
							event.stopPropagation();
						});
					}
					
					if (options.anchor) {
						if ( ! options.anchor instanceof jQuery) {
							options.anchor = $(options.anchor);
						}
					}

                    if(!data)
                    {
                        // 增加id，方便在popovers数组中找到此元素
                        options._popoverUUID=uuid++;
                        popovers[options._popoverUUID]=$this;

                        //自动销毁对象
                        $this.on('remove.popover',function(){
                           $this.popover('destroy');
                           event.stopPropagation();
                        });

                        var hideEvent = ["mousedown"];
                        for(var i= 0,len=hideEvent.length;i<len;++i)
                        {
                            document.removeEventListener(hideEvent[i],_.hideEventFun,true);
                            document.addEventListener(hideEvent[i],_.hideEventFun,true);
                        }
                    }

					var data = {
						target: $this,
						popover: popover,
						options: options,
                        bound:null
					};

                    $this.popover('setData',data,options.popoverId);
                    $this.popover('setTrigger', options.trigger,options.popoverId);
				}
			});
		},
		/**
		 * Reposition the popover
		 * 
		 * @return jQuery
		 */
		reposition: function(popoverId) {
			return this.each(function() {
				var $this = $(this);
				var data = $this.popover('getData',popoverId);
				
				if (data) {
                    $.each(data,function(popoverId,data){
                        var popover = data.popover;
                        var options = data.options;
                        var position = options.position;
                        if ( ! (position == 'top' || position == 'right' || position == 'left' || position == 'auto')) {
                            position = 'bottom';
                        }
                        var calc;

                        calc = _.calc_position($this, position,popoverId);
                        position=calc.position;

                        var marginTop = 0;
                        var marginLeft = 0;
                        if (position == 'bottom') {
                            marginTop = options.verticalOffset;
                        }
                        if (position == 'top') {
                            marginTop = -options.verticalOffset;
                        }
                        if (position == 'right') {
                            marginLeft = options.horizontalOffset;
                        }
                        if (position == 'left') {
                            marginLeft = -options.horizontalOffset;
                        }

                        var css = {
                            left: calc.x1,
                            top: calc.y1,
                            position:'absolute',
                            marginTop: marginTop+"px",
                            marginLeft: marginLeft+"px"
                        };

                        popover.css(css);
                        $this.popover('setData',data,popoverId);
                    });
				}
			});
		},
		/**
		 * Remove a popover from the DOM and clean up data associated with it.
		 * 
		 * @return jQuery
		 */
		destroy: function() {
			return this.each(function() {
				var $this = $(this);
				var data = $this.popover('getData');
				if(data)
                {
                    var popoverUUID=null;
                    $this.unbind(".popover");
                    $.each(data,function(i,data){
                        data.popover.remove();
                        if(data.options._popoverUUID!==undefined) popoverUUID= data.options._popoverUUID;
                    });
                    delete popovers [popoverUUID];
                    $this.removeData('popover');
                    if($.isEmptyObject(popovers)) {
                        document.removeEventListener('mousedown', _.hideEventFun,true);
                        uuid=0;
                    }
                }
			});
		},
        /**
         * Show the popover
         * @param popoverId
         * @param options
         * @returns {*}
         */
		show: function(popoverId,options) {
			return this.each(function() {
				var $this = $(this);
                var selfFun=arguments.callee;
                if($.isPlainObject(popoverId)) {options=popoverId;popoverId=undefined;}
				var data = $this.popover('getData',popoverId);
				if (data) {
                    $.each(data,function(popoverId,data){
                        var popover = data.popover;
                        var srcOptions =data.options;
                        if($.isPlainObject(options)) $.extend(srcOptions,options);

                        if(data.options.beforeShow){
                            data.options.beforeShow.apply(this,[popover]);
                            selfFun.apply(this);
                        }
                        $this.popover('reposition',popoverId);
                        $this.css({'z-index':srcOptions.zIndexOwner});
                        popover.clearQueue().show();
                        data.bound= _.setBound(popover);
                    });
				}
			});
		},
        isShow:function(popoverId){
            var $this = $(this);
            var data = $this.popover('getData',popoverId);
            if (data) {
                if(!popoverId) popoverId=defaults.popoverId;
                data=data[popoverId];
                var popover = data.popover;
                var isDisplay=popover.css("display");
                return isDisplay&&isDisplay!=='none';
            }
            return false;
        },
		/**
		 * Hide the popover
		 *
		 * @return jQuery
		 */
		hide: function(popoverId) {
			return this.each(function() {
				var $this = $(this);
				var data = $this.popover('getData',popoverId);

				if (data) {
                    $.each(data,function(popoverId,data){
                        var srcOptions =data.options;
                        $this.css({'z-index':srcOptions.oldZIndexOwner});
                        data.popover.hide();
                    });
				}
			});
		},
		/**
		 * Fade out the popover
		 * 
		 * @return jQuery
		 */
		fadeOut: function(ms,popoverId) {
			return this.each(function() {
				var $this = $(this);
				var data = $this.popover('getData',popoverId);
				
				if (data) {
                    $.each(data,function(popoverId,data){
                        var popover = data.popover;
                        var options = data.options;
                        if(popover.css('display')!=='none')
                        {
                            $this.css({'z-index':options.oldZIndexOwner});
                            popover.delay(100).fadeOut(ms ? ms : options.fadeSpeed);
                        }
                    });
				}
			});
		},
        /**
         *  Fade out all popovers
         * @param ms
         * @param hideAll 是否隐藏所有popover，如果为false，ooptions.hideOnHTMLClick为true的不隐藏,默认为false
         * @returns {*}
         */
		fadeOutAll: function(ms,hideAll) {

            if(!popovers) return;
            if(typeof (ms)!=='number') {hideAll=ms;ms=undefined;}
			return $.each (popovers, function(prop) {
                if(popovers.hasOwnProperty(prop))
                {
                    var $this = popovers[prop];
                    var data = $this.popover('getData');
                    if (data) {
                        $.each(data,function(popoverId,data){
                            var popover = data.popover;
                            var options = data.options;
                            var display= popover.css('display');
                            if(display&&display!=='none')
                            {
                                $this.css({'z-index':options.oldZIndexOwner});
                                if(hideAll||options.hideOnHTMLClick)
                                    popover.fadeOut(ms ? ms : options.fadeSpeed);
                            }
                        });
                    }
                }
			});
		},
		/**
		 * Set the event trigger for the popover. Also cleans the previous binding. 
		 * 
		 * @param string
		 * @return jQuery
		 */
		setTrigger: function(trigger,popoverId) {
            if(!popoverId) return null;
			return this.each(function() {
				var $this = $(this);
				var data = $this.popover('getData',popoverId);

				if (data) {
                    data=data[popoverId];
					var popover = data.popover;
					var options = data.options;
					var $anchor = options.anchor ? $(options.anchor) : $this;

                    var clickEvent='click.popover.'+popoverId;
					if (trigger === 'click') {
						$anchor.unbind(clickEvent).bind(clickEvent, function(event) {
							if (options.preventDefault) {
								event.preventDefault();
							}
							event.stopPropagation();
							$this.popover('show',popoverId);
						});
						popover.unbind(clickEvent).bind(clickEvent, function(event) {
							event.stopPropagation();
						});
					} else {
						$anchor.unbind(clickEvent);
						popover.unbind(clickEvent);
					}

                    var mousemoveEvent='mousemove.popover.'+popoverId,mouseleaveEvent= 'mouseleave.popover.'+popoverId;
					if (trigger === 'hover') {
						$anchor.add(popover).bind(mousemoveEvent, function(event) {
							$this.popover('show');
						});
						$anchor.add(popover).bind(mouseleaveEvent, function(event) {
							$this.popover('fadeOut');
						});
					} else {
						$anchor.add(popover).unbind(mousemoveEvent).unbind(mouseleaveEvent);
					}

                    var focusEvent='focus.popover.'+popoverId,blurEvent='blur.popover.'+popoverId;
					if (trigger === 'focus') {
						$anchor.add(popover).bind(focusEvent, function(event) {
							$this.popover('show');
						});
						$anchor.add(popover).bind(blurEvent, function(event) {
							$this.popover('fadeOut');
						});
						$anchor.bind(clickEvent, function(event) {
							event.stopPropagation();
						});
					} else {
						$anchor.add(popover).unbind(focusEvent).unbind(blurEvent).unbind(clickEvent);
					}
				}
			});
		},
		/**
		 * Set the popover's content
		 * 
		 * @param html
		 * @return jQuery
		 */
		content: function(html,popoverId) {
            if(!html) return null;
			return this.each(function() {
				var $this = $(this);
				var data = $this.popover('getData');
				if (data) {
                    if(popoverId==undefined) popoverId=defaults.popoverId;
                    data=data[popoverId];
                    var options=data.options;
                    data.popover.html(html instanceof jQuery ? html[0] : html);
                    if (options.stopChildrenPropagation) {
                        data.popover.children().unbind('click.popover').bind('click.popover', function(event) {
                            event.stopPropagation();
                        });
                    }
				}
			});
		},
        /**
         *
         * @param {string=} popoverId
         * @param {object} options
         * @returns {*}
         */
		setOption: function(popoverId,options) {
			return this.each(function() {
				var $this = $(this);
                if($.isPlainObject(popoverId)) {
                    options=popoverId;
                    popoverId=defaults.popoverId;
                }
                var data = $this.popover('getData',popoverId);
                if (data) {
                    $.each(data,function(popoverId,data){
                        if(data){
                            var srcOptions =data.options;
                            if($.isPlainObject(options))  $.extend(srcOptions,options);
                        }
                    });
                }
			});
		},
		getData: function(popoverId) {
			var ret = [];
			this.each(function() {
				var $this = $(this);
				var data = $this.data('popover');
				if (data)
                {
                    if(popoverId!=undefined) {
                        data=data[popoverId];
                        var obj={};obj[popoverId]=data;data=obj;
                    }
                    ret.push(data);
                }
			});
			
			if (ret.length == 0) {
				return;
			}
			if (ret.length == 1) {
				ret = ret[0];
			}
			return ret;
		} ,
        setData:function(data,popoverId){

           if(!data) return;
           this.each(function(){
              var $this=$(this);
              if(popoverId!=undefined)
              {
                  var existData=$this.data('popover');
                  if(!existData) existData={};
                  existData[popoverId]=data;
                  $this.data('popover',existData);

              }
              else $this.data('popover',data);
           })

        }
	};

	$.fn.popover = function(method) {
		if (methods[method]) {
			return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
		} else if ( typeof method === 'object' || !method) {
			return methods.init.apply(this, arguments);
		} else {
			$.error('Method ' + method + ' does not exist on jQuery.popover');
		}
	}
    $.extend($,{'fadeOutAllPopovers':methods.fadeOutAll});
})(jQuery);
