﻿/**
 * SpeechUI 模板处理模块
 * @module speechui/common/resource
 * @date 2013/06/09
 */
define(function (require, exports) {

    var define = require('../define');
    var shellcmd=require('../../../common/shellcmd');
    var $ = require('jquery');

    /**
    * 初始化SpeechUI
    * @param {speechui.define.CardName} cardName 卡片名称
    * @return {string} 卡片模板
    */
    exports.getTemplate = function (cardName) {

        // TODO：处理本地运行时卡片模板的获取

        var tmpUrl;
        switch (cardName) {
//            case define.CardName.EnWordEval:
//                tmpUrl = require.resolve('../../view/templates/enwordeval.html#');
//                break;
//            case define.CardName.CnWordEval:
//                tmpUrl = require.resolve('../../view/templates/cnwordeval.html#');
//                break;
//            case define.CardName.Poetry:
//                tmpUrl = require.resolve('../../view/templates/poetry.html#');
//                break;
            case define.CardName.Gallery:
                tmpUrl = require.resolve('../../view/templates/gallerycard.html#');
                break;
            case define.CardName.Choice:
                tmpUrl = require.resolve('../../view/templates/choicecard.html#');
                break;
            default:
                throw new Error('Unknown cardName:' + cardName);
        }

        var tpl = '';
        // 本地路径
        if(tmpUrl.indexOf('file:///') > -1 || tmpUrl.match(/\b[A-z]:[\\|\/]/)){
            tpl=shellcmd.readFile(tmpUrl);
        } else{
            $.ajax(tmpUrl, {
                async: false,
                success: function (result) {
                    tpl = result;
                },
                error: function () {
                    throw new Error("get " + cardName + " template error");
                }
            });
        }

        return tpl;
    };
});