/**
 * 遮盖罩
 * @module speechui/common/resource
 * @date 2013/06/21
 */

define(function(require, exports, module) {
    var $ = require('jquery');

    /**
     * 显示或隐藏遮罩
     * @function
     * @param {{
     *     self    : CnWordEvalCard
     *     type    : string
     *     msg     : string
     *     lagTime : Number
     *     flag    : Boolean
     * }} options 遮盖罩加载参数
     */

    function showMask(options){

        var self     =  options.self,
            type     =  options.type,
            msg      =  options.msg,
            flag     =  options.flag,
            lagTime  =  options.lagTime ? options.lagTime : 0,
            maskName = ( type === 'fullScreen' ? 'word_mask' :
                         type === self.maskType.top ? 'top_mask' : 'word_mask' );

        if( flag === true ){
            var bh;
            var bw;
            var strHtml = "<div class='" + maskName + "'></div>";
            var zIndex  = ( type === 'fullScreen' ? 20 :
                            type === self.maskType.top ? 20 : 5 );

            $('.' + maskName + '_load').remove();
            $('.' + maskName).remove();

            if(type === 'fullScreen'){
                bh = $('body').height();
                bw = $('body').width();
                $('body').append(strHtml);
            } else {
                bh = self.dom.height();
                bw = self.dom.width();
                self.dom.append(strHtml);
            }

            $('.' + maskName).css("background-color" , "dimgray")
                .css("filter"			, "alpha(opacity=50)"	)
                .css("opacity"			, "0.5"					)
                .css("position"			, "fixed"				)
                .css("top"				, "0"					)
                .css("-moz-opacity"		, "0.5"					)
                .css("-khtml-opacity"	, "0.5"					)
                .css("display"			, "none"				)
                .css("height"           ,  bh	                )
                .css("width"            ,  bw	                )
                .css("z-index"          ,  zIndex               )
                .show(lagTime);

            if(msg){
                var htmlLoad = "";
                var info = {};
                if( type === self.maskType.common || type === self.maskType.top ) {
                    var imgSrc = "./js-debug/speechui/view/images/loading_icon.gif";
                    htmlLoad += "<div class='" + maskName + "_load'>";
                    htmlLoad += 	"<div style='position:absolute;margin-left:-32px;z-index:-1;'>";
                    htmlLoad +=			"<img border='0' src='./js-debug/speechui/view/images/loading_bgleft.gif' width='10px' height='50px' >";
                    htmlLoad +=			"<img class='" + maskName + "_bgcent' border='0' src='./js-debug/speechui/view/images/loading_bgcent.gif' height='50px'>";
                    htmlLoad +=			"<img border='0' src='./js-debug/speechui/view/images/loading_bgright.gif' width='10px' height='50px'>";
                    htmlLoad +=		"</div>"
                    htmlLoad += 	"<b class='" + maskName + "_msg' style='font-size:14px;color:#fff;margin-left:-12px;height:50px;line-height:50px;vertical-align:middle;display:inline-block;'>" + msg + "</b>";
                    htmlLoad += 	"<img src='" + imgSrc + "' width='24' height='24'style='position:absolute;padding-top:13px;' />";
                    htmlLoad += "</div>";
                }
                if( type === self.maskType.card ){
                    htmlLoad += "<div class='" + maskName + "_load'>";
                    htmlLoad +=     msg;
                    htmlLoad += "</div>";
                }

                self.dom.append(htmlLoad);

                if( type === self.maskType.card){
                    info = {
                        "marginLeft"     : 0.07 * bw,
                        "filter"         : "alpha(opacity = 100)",
                        "opacity"        : "1",
                        "mozOpacity"     : "1",
                        "khtmlOpacity"   : "1",
                        "position"       : "fixed",
                        "zIndex"         : "10",
                        "top"            : 0.25 * bh,
                        "textAlign"      : "left",
                        "padding"        : "0 50px 0 32px"
                    }
                }else{
                    info = {
                        "marginLeft"     : 0.4 * bw,
                        "filter"         : "alpha(opacity = 70)",
                        "opacity"        : "0.7",
                        "mozOpacity"     : "0.7",
                        "khtmlOpacity"   : "0.7",
                        "position"       : "fixed",
                        "zIndex"         : "10",
                        "top"            : 0.4 * bh,
                        "textAlign"      : "center",
                        "padding"        : "0 50px 0 32px"
                    }
                    info.zIndex = (type === self.maskType.top ? 25 : 10);
                }

                $('.' + maskName + '_load').css("margin-left"     , info.marginLeft     )
                    .css("filter"		  , info.filter	        )
                    .css("opacity"		  , info.opacity		)
                    .css("-moz-opacity"	  , info.mozOpacity		)
                    .css("-khtml-opacity" , info.khtmlOpacity   )
                    .css("position"		  , info.position		)
                    .css("z-index"		  , info.zIndex			)
                    .css("top"            , info.top            )
                    .css("text-align"     , info.textAlign      )
                    .css("padding"        , info.padding        );

                if( type === self.maskType.common ){
                    $('.word_mask_bgcent').css("width" , parseInt($(".word_mask_load").width() + 56));
                } else {
                    $('.top_mask_bgcent').css("width" , parseInt($(".top_mask_load").width() + 56));
                }
            }
        } else {
            $('.' + maskName + '_load').remove();
            $('.' + maskName).fadeOut(lagTime, function(){
                $(this).remove();
            });
        }
    }

    /**
     * @export {speechui.common.mask.showMask}
     */
    exports.showMask = showMask;
});