var Lang = (function () {
    var Lang = function (langPack, css) {
        var self = this;

        self.pack = langPack || {};
        self.styleCSS = css || {     fontFamily: "Verdana, Arial",
            direction: "ltr",
            textAlign: "left"
        }
        self._start();
    };

    /**
     * 需要翻译的属性
     */
    Lang.prototype.attrList = [
        'title',
        'alt',
        'placeholder',
        'src'
    ];

    /**
     * 扫描带有“lang”属性标签的Dom元素
     * 存储参数值
     * @private
     */
    Lang.prototype._start = function (selector) {
        var arr = selector !== undefined ? (selector instanceof jQuery ? selector : $(selector)).filter('[lang]') : $(':not(html)[lang]'),
            arrCount = arr.length,
            elem;
        while (arrCount--) {
            elem = $(arr[arrCount]);
            this._processElement(elem);
        }

        arr = selector !== undefined ? (selector instanceof jQuery ? selector : $(selector)).find('[lang]') : $(':not(html)[lang]');
        arrCount = arr.length;
        while (arrCount--) {
            elem = $(arr[arrCount]);
            this._processElement(elem);
        }

    };

    Lang.prototype._processElement = function (elem) {
        this._storeAttribs(elem);
        this._storeContent(elem);
    };

    /**
     * 存储需要翻译的属性
     * @param {object} elem The jQuery selected element.
     * @private
     */
    Lang.prototype._storeAttribs = function (elem) {
        var attrIndex,
            attr,
            attrObj;

        for (attrIndex = 0; attrIndex < this.attrList.length; attrIndex++) {
            attr = this.attrList[attrIndex];
            if (elem.attr(attr)) {
                attrObj = elem.data('lang-attr') || {};
                attrObj[attr] = elem.attr(attr);
                elem.data('lang-attr', attrObj);
            }
        }
    };

    /**
     * 存储Dom内容
     * @param elem
     * @private
     */
    Lang.prototype._storeContent = function (elem) {
        if (elem.is('input')) {
            switch (elem.attr('type')) {
                case 'button':
                case 'submit':
                case 'reset':
                case 'text':
                    elem.data('lang-val', elem.val());
                    break;
            }
        } else {
            var nodes = this._getTextNodes(elem);
            if (nodes) {
                elem.data('lang-text', nodes);
            }
        }
    };

    /**
     * Retrieves the text nodes from an element and returns them.
     * @param elem
     * @returns {Array|*}
     * @private
     */
    Lang.prototype._getTextNodes = function (elem) {
        var nodes = elem.contents(),
            nodeArr;

        nodeArr = nodes.filter(function () {
            this.langDefaultText = this.data;
            return this.nodeType === 3;
        });

        return nodeArr;
    };

    /**
     * 翻译
     * @param lang
     * @param selector
     */
    Lang.prototype.change = function (selector) {
        var self = this;
        var flag = selector !== undefined;
        var arr, arrCount, elem, elemlang;
        if (!flag) {
            arr = flag ? $(selector).find('[lang]') : $(':not(html)[lang]');
            arrCount = arr.length;
            while (arrCount--) {
                elem = $(arr[arrCount]);
                self._translateElement(elem);
            }
        }
        else if (flag) {
            arr = flag ? (selector instanceof jQuery ? selector : $(selector)).filter('[lang]') : $(':not(html)[lang]');
            arrCount = arr.length;

            while (arrCount--) {
                elem = $(arr[arrCount]);
                elemlang = elem.attr('lang');
                if (elemlang !== this.currentLang) {
                    this._translateElement(elem, this.currentLang);
                }
            }

            arr = flag ? (selector instanceof jQuery ? selector : $(selector)).find('[lang]') : null;
            arrCount = arr.length;

            while (arrCount--) {
                elem = $(arr[arrCount]);
                elemlang = elem.attr('lang');
                if (elemlang !== this.currentLang) {
                    this._translateElement(elem, this.currentLang);
                }
            }

        }
    };

    Lang.prototype._translateElement = function (elem) {
        this._translateAttribs(elem);
        if (elem.attr('data-lang-content') != 'false') {
            this._translateContent(elem);
        }
        //修改样式
        this.styleCSS.fontFamily && elem.css("font-family", this.styleCSS.fontFamily);
        this.styleCSS.fontSize && elem.css("font-size", this.styleCSS.fontSize);
        this.styleCSS.direction && elem.css("direction", this.styleCSS.direction);
        this.styleCSS.textAlign && elem.css("text-align", this.styleCSS.textAlign);
        this.styleCSS.fontWeight && elem.css("text-weight", this.styleCSS.fontWeight);

    };

    /**
     * Translates and sets the attributes of an element to the passed language.
     * @param elem
     * @param lang
     * @private
     */
    Lang.prototype._translateAttribs = function (elem) {
        var attr,
            attrObj = elem.data('lang-attr') || {},
            translation;
        if (elem.is('img')) {
            if (elem.data('lang-attr').src) {
                // Get the translated value
                translation = this._translate(elem.data('lang-attr').src);
                // Check we actually HAVE a translation
                if (translation != null) {
                    // Change the attribute to the translated value
                    elem.attr("src", translation);
                }
            }
            return;
        }

        for (attr in attrObj) {
            if (attrObj.hasOwnProperty(attr)) {
                if (elem.attr(attr)) {
                    translation = this._translate(attrObj[attr]);
                    if (translation != null) {
                        elem.attr(attr, translation);
                    } else {
                        elem.attr(attr, attrObj[attr]);
                    }
                }

            }
        }
    }
    ;

    /**
     * Translates and sets the contents of an element to the passed language.
     * @param elem
     * @param lang
     * @private
     */
    Lang.prototype._translateContent = function (elem) {
        var translation,
            nodes;

        if (elem.is('input')) {
            switch (elem.attr('type')) {
                case 'button':
                case 'submit':
                case 'reset':
                case 'text':
                    translation = this._translate(elem.data('lang-val'));
                    if (translation != null) {
                        elem.val(translation);
                    }
            }
        } else {
            nodes = elem.data('lang-text');
            if (nodes) {
                this._setTextNodes(elem, nodes);
            }
        }
    };

    /**
     * Sets text nodes of an element translated based on the passed language.
     * @param elem
     * @param nodes
     * @param lang
     * @private
     */
    Lang.prototype._setTextNodes = function (elem, nodes, lang) {
        var index,
            textNode,
            defaultText,
            translation;

        for (index = 0; index < nodes.length; index++) {
            textNode = nodes[index];

            defaultText = $.trim(textNode.langDefaultText);

            if (defaultText) {
                translation = this._translate(defaultText, lang);

                if (translation != null) {
                    try {
                        textNode.data = textNode.data.split($.trim(textNode.data)).join(translation);
                    } catch (e) {

                    }
                } else {
                    console.log('Translation for "' + defaultText + '" not found!');
                }
            }
        }
    };

    /**
     * 翻译单词
     * @param {String} text The text to translate.
     * @param {String} lang The two-letter language code to translate to.
     * @returns {*}
     */
    Lang.prototype._translate = function (text) {
        var translation = '';
        if(text.match(/\{%.+?%\}/)){
            text = text.substr(2, text.length - 4);
            translation = this.pack[text];
        }
        if(translation != null){
            return translation;
        }
        else{
            return text;
        }

    };

    Lang.prototype.refreshUI = function () {
        this.change();
    }

    /**
     * 替换语言包
     * @param newLangPack
     */
    Lang.prototype.changeLangPack = function (newLangPack,css) {
        this.pack = newLangPack;
        if(css){
            this.styleCSS = css;
        }
    }

    /**
     *
     * @param newLangPack
     */
    Lang.prototype.translateObj = function (strOrObj) {
        strOrObj = strOrObj instanceof jQuery ? strOrObj : $(strOrObj);
        this._start(strOrObj);
        this.change(strOrObj);
        return strOrObj;
    }

    return Lang;
})();