﻿/**
 * SmartBook入口模块
 */
define(function (require, exports) {
    require('lab');
    require('jquery');
    require('xml2json');
    require('jquery_ui');
    require('pagination');
    require('browserContext');
    require('./app/book/pageitem');
    var path = require('./common/path');
    var confirmExit = require('./common/confirmExit');
    var _define = require('./app/define');
    var ebookContext = require('./app/ebookcontext').Instance;
    var trace = require('./app/trace').Instance;
    var actionType = require('./app/trace').ActionType;
    var shellcmd = require('./common/shellcmd');
    var bookAccessor = require('./app/bookshelf/bookaccessor').Instance;
    var userLog = require('./app/logmgr').Instance;
    var userData = require('./common/userdata').Instance;
    var indexhelper = require("./indexhelper");
    var snapShot = require('./app/book/toolbar/snapShot').Instance;
    var monitorInfo = require('./common/MonitorInfo').Instance;
    var guidCreate = require('./common/guid').Instance;
    var recordLesson = require('./app/book/toolbar/recordlesson').Instance;

    /** @type {BookContainer} */
    var _bookContainer;

    /** @type {CanvasManager}*/
    var canvasManager, BlackBoard, mainToolbar, sideToolbar, CardWrapper, smartBar;

    //是否正在编辑模式
    var isEditing = false;
    var isWB = false;
    //20150116 此字段用于区分是否显示change
    var isWB2 = "";

    $(function () {
        var browserWidth = Config["Width"];
        var browserHeight = Config["Height"];
        // 是留给下面工具条的高度
        var viewHeight = browserHeight - $('#mainToolBar').height() - $('#header').height() - 10;
        //这里我们假设所有屏幕都是高小于宽
        var scale = correctToBaseResolution();
        var viewWidth = browserWidth - $("#leftToolbar").width() * scale[0] - $('#rightToolbar').width() * scale[0];
        var $book = $("#book");
        var bookContainerEle = $('#bookContainer');
        var $bookwarp = $("#bookwarp");
        $bookwarp.css("minHeight", viewHeight - 4 + "px");
        if (browserWidth < 1000) {
            $book.css("width", (viewWidth + 10) + "px").css("height", viewHeight + 'px');
            bookContainerEle.css({
                width: viewWidth + 'px',
                height: viewHeight + 'px',
                marginLeft: '5px'
            });

            $bookwarp.css("marginLeft", "45px").css("marginRight", "45px").css("minHeight", viewHeight - 24 + "px");
            $("#rbarWarp").css("width", "45px");
            $("#lbarWarp").css("width", "45px");
            $("#btnMoveMenuBar").css("bottom", "-20px");
        }
        else {
            bookContainerEle.css({
                width: (viewWidth - 10 ) + 'px',
                height: viewHeight + 'px',
                marginLeft: '5px'
            });
            $book.css("width", viewWidth + "px").css("height", viewHeight + 'px');
        }

        showLoading({tips: AppBlackBoardTipsList.Loading});
        var playerMgr = require('./app/book/hotspot/playerMgr').Instance;
        var pageProvider = require('./app/book/pageprovider').Instance;
        var bookCode = indexhelper.QueryString("bookCode");
        var curUser = decodeURIComponent(indexhelper.QueryString("user"));
        var pwd = indexhelper.QueryString("pwd");
        var ticket = indexhelper.QueryString("ticket");
        var points = indexhelper.QueryString("points");
        var books = indexhelper.QueryString("books");
        var phone = indexhelper.QueryString("phone");
        var province = indexhelper.QueryString("p");
        var uid = indexhelper.QueryString("uid");
        var userName = decodeURIComponent(indexhelper.QueryString("userName"));
        var userLoginName = decodeURIComponent(indexhelper.QueryString("userloginname"));
        var isOnline = !!(indexhelper.QueryString("isonline") == 'true');
        var isActive = !!(indexhelper.QueryString("isactive") == 'true');
        var pageIndex = parseInt(indexhelper.QueryString('pageIndex'));
        var loginFrom = indexhelper.QueryString("LoginFrom");
        var isU = indexhelper.QueryString("isU");
        var isWB = indexhelper.QueryString("isWB");
        var SSOTicket = indexhelper.QueryString("SSOTicket");

        isWB2 = isWB;

        indexhelper.setTime();
        setInterval(indexhelper.setTime, 5000);

        LAN = null;
        var langPath = Config.binPath + "webapp/assert/js/lang/" + AppCfg.lang + "/index.json";
        var lanpack = null;
        shellcmd.readFileAsync(langPath).done(function (ret) {
            lanpack = JSON.parse(ret);
            if (AppCfg.lang == "uyghur") {
                var Uycss = {
                    fontFamily: "ALKATIP Basma"
                }
                LAN = new Lang(lanpack, Uycss);
            }
            else {
                LAN = new Lang(lanpack, {});
            }

            userData.init();
            curUser = curUser ? curUser : AppCfg.testUser;
            bookCode = bookCode ? bookCode : AppCfg.testBook;

            trace.log('ebook', actionType.SetBook, {bookCode: bookCode});

            ebookContext.setBinPath(Config.binPath);
            ebookContext.setWBEB("EB");
            ebookContext.setIsU(isU);
            ebookContext.setUser(curUser, pwd);
            ebookContext.setBookCode(bookCode);
            ebookContext.setUserBaseInfo(uid, "", phone, userName, province);
            ebookContext.setUserExtInfo(ticket, isOnline, isActive, userLoginName, loginFrom, points, SSOTicket, books);

            var sndPlayer = playerMgr.createPlayer(_define.PlayerType.AudioPlayer);
            sndPlayer.init($('#player'));
            setGloabalContextPlayer(playerMgr);
            pageProvider.setPlayer(playerMgr.createPlayer(_define.PlayerType.HotspotPlayer), sndPlayer);

            // 初始化课本容器
            _bookContainer = initBookContainer(bookContainerEle);
            // 初始化画布
            var canvasMgr = initPaintCanvas(_bookContainer);

            // 初始化工具栏
            // 初始化主工具栏结束之后初始化幕布,工具箱，模板
            // 等课本初始化之后再去初始化目录，页面预览（否则拿不到目录信息）资源库，搜索面板（优化体验）
            initToolbar(_bookContainer, canvasMgr, pageIndex, bookCode);

            var iFlyMouse = require('./iFlyMouse');
            iFlyMouse.init(_bookContainer);
            iFlyMouse.registerEvent();

            var cardWrapper = require('./app/card/cardwrapper');
            CardWrapper = cardWrapper.Instance;
            CardWrapper.init("cardWrapper", "siderbar_left", "siderbar_right", "pic_zoomin", "pic_zoomout");
            //聚焦初始化
            var surfaceTool = require('./app/paint/surfacetool');
            var SurfaceTool = surfaceTool.Instance;
            SurfaceTool.init(_bookContainer);

            indexhelper.setIatPanelPos();
            loadBook(bookCode, pageIndex, isWB).done(function () {
                console.log("index.js:index->loadBook callback begin");
                //记录书本使用时间，取消‘新’字段
                bookAccessor.updateBookUseDate(bookCode, ebookContext.getUser());
                //写日志，记录书号
                userLog.init();
                userLog.addUsedBook(bookCode);
                //初始化目录导航
                sideToolbar.initnavigator(_bookContainer);
                //初始化退出按钮
                confirmExit.init(_bookContainer, canvasManager);
                isWB && changeWBEB();

                if (curUser == AppCfg.defaultuser) {
                    var userLogin = require("./app/login/loginmgr").Instance;
                    userLogin.initDOM(), userLogin.bingEventsToDOM(), setGlobalLoginMgr(userLogin);
                }

            });
            LAN.refreshUI();
        });

        if (Config.Width < 950) {
            $("#main td").css("padding-left", "50px");
        }

        //禁用拖放打开本地文件操作
        var commonfunc = require("./common/commonfunc");
        commonfunc.disabledDropLocalFiles();

        $("body").keydown(function (e) {
            //如果type存在，则是text节点
            //反之是body，如果发现问题，再处理
            if (e.which == 8 && (!e.target.type)) {
                return false;
            }
            //屏蔽Alt+X热键（这里屏蔽了Alt键）
            if (e.which == 18 && (!e.target.type)) {
                return false;
            }
        });

        //监管平台
        var session_id = guidCreate.guid(32);
        var session_id_trigger = guidCreate.guid(32);
        var monitorMessage = '';
        var monitorMessage_trigger = '';
        var uid = ebookContext.getUser().getUid();
        uid = uid == "0" ? "" : uid;
        if (isWB != true) {
            monitorMessage = 'entry|||' + session_id + '|{"module":02 , "user_id":' + uid + '}';
            monitorInfo.addMonitorInfo('02', session_id);
            shellcmd.MonitorSend(monitorMessage);
            monitorMessage_trigger = 'trigger|||' + session_id_trigger + '|{"module":02,"param":"entryEbook","user_id":' + uid + '}';
            shellcmd.MonitorSend(monitorMessage_trigger);
            console.log('entry电子书:' + session_id);
            console.log('entry电子书_trigger:' + session_id_trigger);
        }
    });

    function initBookContainer(bookContainerEle) {
        var bookContainerModule = require('./app/book/container');

        //在书本上操作的时候，先隐藏目录导航
        bookContainerEle.mousedown(function () {
            $("#directory_box_right").hide();
            $("#directory_box_left").hide();
            $("#localResId").hide();
            $("#localResNoneId").hide();
        });

        var bookContainer = new bookContainerModule.BookContainer(bookContainerEle, confirmExit);

        var saveStroke = function () {
            //笔迹有改变，才保存
            if (canvasManager.getStrokeCanvas()) {
                if (canvasManager.getIsStrokeChanged()) {
                    canvasManager.drawStrokeCanvasToBookContainer();
                }
                $("#pen_canvas").hide();
            }
        }

        var rePaintStroke = function () {
            //不在鼠标状态时，翻页时才需要把笔迹重绘到全局canvas并显示全局canvas
            //否则只需要显示pageItem的canvas即可(这一步已经在pageItemload的时候做了)
            if (!canvasManager.isMouseMode()) {
                if (canvasManager.getStrokeCanvas()) {
                    canvasManager.restoreStrokeFromBookContainer();
                }
            }
            //翻页后需设定canvasManager的isStrokeChanged属性为false，这样防止连续翻页时笔迹没变也保存到本地
            canvasManager.setIsStrokeChanged(false);
            //编辑状态下，隐藏笔迹
            if (isEditing) {
                _bookContainer.hidePageItemCanvas();
            }
        }

        $(bookContainer).bind('beforePageChange', function (e, indexInfo) {
            saveStroke();
            isEditing = false;
            smartBar.closeSmartBar();
            localResMgr.hideLocalResPanel();
        })

        $(bookContainer).bind('pageChanged', function (e, indexInfo) {
            rePaintStroke();

            //加载手势
            this.getPageViewType() === _define.PageViewType.WhiteBoardView && ($("#btnPen").click());
            //这句写在上一句的后面是为了纠正鼠标指针的显示错误   ---  by  yczhu
            smartBar.openClose();
        });

        $(bookContainer).bind('beforeBookViewChange', function (e, bookViewInfo) {
            //笔迹有改变，才保存
            saveStroke();
            isEditing = false;
            smartBar.closeSmartBar();
            localResMgr.hideLocalResPanel();
            //书本加载完毕，修正背景颜色
            bookContainerEle.css({backgroundColor: "#fff"});
        })

        $(bookContainer).bind('bookViewChanged', function (e, bookViewInfo) {
            rePaintStroke();

            //加载手势
            this.getPageViewType() === _define.PageViewType.WhiteBoardView && ($("#btnPen").click(),
                bookContainerEle.css({backgroundColor: AppCfg.wbcolor}),isWB2 = 0);

            if (!isWB2 && AppCfg.showLastChange && this.getPageViewType() != _define.PageViewType.WhiteBoardView ) {

                var h0 = $("#header")[0].offsetHeight;
                var h1 = $("#mainToolBar")[0].offsetHeight;
                var $leftToolbar = $("#leftToolbar");
                var h00 = parseInt($leftToolbar.css("padding-top"));
                var h001 = parseInt($leftToolbar.css("margin-top"));
                var h2 = $(".mt10")[0].offsetHeight;
                var h3 = $(".bt_line")[0].offsetHeight;
                var h4 = $("#btnLocalResMgr")[0].offsetHeight;
                var h = h0 + h1 + h2 + h3 + h00 + h001 - h4 - 30.8 + "px";
                var $guide02 = $(".guide02");
                var $guid_box = $(".guid_box");

                $(".guide01").css("top", h);
                $guid_box.show();
                $guide02.show();
                $guide02.click(function () {
                    return false;
                })
                $guid_box.click(function () {
                    //获取存放showLastChange值的文件路径fliepath，并读取到ff
                    var fliepath = path.join(Config.binPath, "webapp/assert/js/appcfg.js");
                    var ff = shellcmd.readFile(fliepath);
                    //更改showLastChange值，并保存
                    var ff2 = ff.replace("showLastChange : true,", "showLastChange : false,");
                    shellcmd.saveFile(ff2, fliepath);
                    $guid_box.hide();
                    $guide02.hide();
					AppCfg.showLastChange = false;
                });
            }


            //这句写在上一句的后面是为了纠正鼠标指针的显示错误   -----  by  yczhu
            smartBar.openClose();
        });

        // 调试状态下暴露移动BookView的方法
        if (AppCfg.isDebug) {
            window.move = function (x, y) {
                _bookContainer.moveView({x: x, y: y});
            }
            window.bookContainer = _bookContainer;
        }
        setGlobalBookContainer(bookContainer);
        return bookContainer;
    }

    /**
     * 初始化工具栏
     * @param {BookContainer} bookContainer
     * @param {PaintCanvas} canvasMgr
     */
    function initToolbar(bookContainer, canvasMgr, pageIndex, bookCode) {
        // 初始化主工具栏
        mainToolbar = require('./app/book/toolbar/maintoolbar');
        mainToolbar.init({
            btnToggleHotspot: $('#btnToggleHotspot'),
            btnTogglePlay: $('#btnTogglePlay'),
            btnClearRes: $('#btnClearRes'),
            mainToolBar: $('#mainToolBar'),
            btnMoveMenuBar: $("#btnMoveMenuBar"),
            btnWBBlack: $("#WBBlack"),
            btnWBWhite: $("#WBWhite"),
            btnWBGreen: $("#WBGreen")
        }, bookContainer, pageIndex, bookCode);

        // 初始化侧边工具栏
        sideToolbar = require('./app/book/toolbar/sidetoolbar');
        var buttons = {
            btnLeftSwitchPageView: $('#btnLeftPageView'),       // 左侧切换书本视图按钮
            btnRightSwitchPageView: $('#btnRightPageView'),     // 右侧切换书本视图按钮
            btnLeftPrePage: $("#btnLeftPrePage"),               // 左侧上一页按钮
            btnLeftNextPage: $("#btnLeftNextPage"),             // 左侧下一页按钮
            btnRightPrePage: $("#btnRightPrePage"),             // 右侧上一页按钮
            btnRightNextPage: $("#btnRightNextPage"),           // 右侧下一页按钮
            btnZoomIn: $('#btnZoomIn'),                         // 页面放大按钮
            btnZoomOut: $('#btnZoomOut'),                       // 页面缩小按钮
            btnBookShelf: $("#btnBookShelf"),                     //书架按钮
            btnLBlackBoard: $('#btnBlackBoardLeft'),
            btnRBlackBoard: $("#btnBlackBoardRight"),
            WBL: $("#WBL"),                                    //左右黑板
            WBR: $("#WBR"),
            EBL: $("#EBL"),                                    //左右课本
            EBR: $("#EBR"),
            btnMuluR: $("#contentRight"),                      //左右目录
            btnMuluL: $("#contentLeft"),
            btnResShow: $("#btnLocalResMgr")

        };
        sideToolbar.init(buttons, bookContainer, canvasMgr, confirmExit, BlackBoard);

        var CloudresourceBase = require('./app/book/smartbar/cloudresourcebase');
        smartBar = require('./app/book/smartbar/smartbar').Instance;
        localResMgr = require('./app/book/toolbar/localres').Instance;
        var smartBarEle = $("#smartbar");
        smartBar.init(bookContainer, smartBarEle);

        setGlobalContextCloudresourceBase(new CloudresourceBase(bookContainer));
    }

    function initPaintCanvas(bookContainer) {
        //全局画笔板擦声明与初始化
        var CanvasManager = require('./app/paint/canvasmgr');
        canvasManager = CanvasManager.Instance;
        canvasManager.init();
        //如果全局笔迹改变，则会保存到pageItem的canvas上后显示pageItem的canvas，否则直接显示pageItem的canvas
        $(canvasManager).bind('strokeChanged', function (e, StrokeCanvas, IsStrokeChanged, Strokes) {
            bookContainer.paintStroke(StrokeCanvas, IsStrokeChanged, Strokes);
        })

        $(canvasManager).bind('doEraser', function (e, l, t, w, h) {
            //第一个参数e表示事件本身
            bookContainer.doEraser(l, t, w, h);
        });

        $(canvasManager).bind('recognition', function (e, lan) {
            //第一个参数e表示事件本身
            bookContainer.recognition(lan);
        });

        $(canvasManager).bind('restoreStroke', function () {
            var viewDom = bookContainer.getViewDOM();
            var strokeCanvas = this.getStrokeCanvas();
            var tempCanvas = this.getTempCanvas();
            var w = viewDom.width();
            var h = viewDom.height();
            if (tempCanvas) {
                tempCanvas.attr({width: w, height: h});
            }
            if (strokeCanvas) {
                strokeCanvas.attr({width: w, height: h});
                // 恢复笔迹
                this.clearCanvas();
                bookContainer.restoreStroke(strokeCanvas[0], this);
            }

            viewDom.append(this.getCanvasContainer());
        });

        return canvasManager;
    }

    function changeWBEB(value) {
        if (value) {
            if (value == isWB) return;
            else isWB = value;
        }
        else isWB = !isWB;
        var uid = ebookContext.getUser().getUid();
        uid = uid == "0" ? "" : uid;
        if (isWB) {
            setBlackboardFlag(true);
            //监管平台
            var session_id = guidCreate.guid(32);
            var session_id_trigger = guidCreate.guid(32);
            var monitorMessage;
            var monitorMessage_trigger;
            monitorMessage = 'entry|||' + session_id + '|{"module":03 , "user_id":' + uid + '}';
            monitorInfo.addMonitorInfo('03', session_id);
            monitorMessage_trigger = 'trigger|||' + session_id_trigger + '|{"module":03,"param":"entryBlackboard","user_id":' + uid + '}';
            shellcmd.MonitorSend(monitorMessage);
            shellcmd.MonitorSend(monitorMessage_trigger);
            console.log('entry黑板:' + session_id);
            console.log('entry黑板trigger:' + session_id_trigger);

            session_id = monitorInfo.getSession_id('02');
            if (session_id != undefined) {
                monitorMessage = 'quit|||' + session_id + '|{"module":02 , "user_id":' + uid + '}';
                monitorInfo.deleteMonitorInfo('02');
                shellcmd.MonitorSend(monitorMessage);
                console.log('quit电子书:' + session_id);
            }
        }
        else {
            setBlackboardFlag(false);
            var session_id = guidCreate.guid(32);
            var monitorMessage;
            var session_id_trigger = guidCreate.guid(32);
            var monitorMessage_trigger;
            monitorMessage = 'entry|||' + session_id + '|{"module":02 , "user_id":' + uid + '}';
            monitorMessage_trigger = 'trigger|||' + session_id_trigger + '|{"module":02,"param":"entryEbook","user_id":' + uid + '}';
            monitorInfo.addMonitorInfo('02', session_id);
            shellcmd.MonitorSend(monitorMessage);
            shellcmd.MonitorSend(monitorMessage_trigger);
            console.log('entry电子书:' + session_id);
            console.log('entry电子书_trigger:' + session_id_trigger);

            session_id = monitorInfo.getSession_id('03');
            monitorMessage = 'quit|||' + session_id + '|{"module":03 , "user_id":' + uid + '}';
            monitorInfo.deleteMonitorInfo('03');
            shellcmd.MonitorSend(monitorMessage);
            console.log('quit黑板:' + session_id);
        }

        smartBar.closeSmartBar();
        localResMgr.hideLocalResPanel();
        mainToolbar.changeWBEB(isWB);
        sideToolbar.changeWBEB(isWB);
    }

    function bindCommands() {

        $('#WBL, #WBR, #EBL, #EBR')
            .click(function () {
                changeWBEB();
                $("#directory_box_right, #directory_box_left").css("display", "none");
                $("#localResId").hide();
                $("#localResNoneId").hide();
            })
            .mousedown(function () {
                if (!smartBar.editStatus) this.className = 'sidertool_current';
            });

        $("#snapShot").click(function () {
            snapShot.snap();
        });
        $("#recordLesson").click(function () {
            recordLesson.recordlesson();
        });

        //还没完成的"白板"模块直接删掉了 ------ by yczhu
        $("#btnExitApp").click(function () {
            confirmExit.ExitAlert();
        });

        $("#btnMinApp").click(function () {
            //sessionStorage['isBookMin']=true;
            app_global_screenSaversMgr && app_global_screenSaversMgr.setScreenSavers(false);
            app_global_playerMgr && app_global_playerMgr.pause();   //暂停音频资源播放
            shellcmd.ebookMin();
        });

        $("#btnGloQQService").click(function () {
            var QQService = require('./common/QQService').QQService;
            QQService();
        });
    }

    /**
     *
     * @param {string} bookCode
     * @param {int} pageIndex
     * @returns {*}
     */
    function loadBook(bookCode, pageIndex, WB) {
        var def = $.Deferred();

        if (pageIndex === 'undefined' || pageIndex === undefined || !pageIndex) pageIndex = 1;
        try {
            _bookContainer.loadPage(bookCode, pageIndex).done(function () {
                console.log("index.js:container->loadPage callback begin");

                _bookContainer.switchPageView(_define.PageViewType.SimpleDoublePage).done(function () {
                    $(_bookContainer).trigger('bookViewChanged');
                    $(_bookContainer).trigger('pageChanged');

                    (!WB) && hideLoading();
                    bindCommands();
                    def.resolve();
                });
            });
        } catch (e) {
            console.error("---index load book error ---");
            hideLoading();
            bindCommands();

            $.Zebra_Dialog(AppBookShelfTipsList.OpenBookError, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.OkTips],
                'onClose': function (capition) {
                    //这个时候需要清除内存中的该书本的LIC，并返回书架
                    ebookContext.getUser().getUserToken().done(function (token) {
                        var path = require('./common/path');
                        var msg = {
                            licfile: path.trimPosix(ebookContext.getUser().getBookLicenseFullPath(bookCode)),
                            token: token
                        }
                        shellcmd.removeResLicFromMem(JSON.stringify(msg));
                        var _pageNavigatorHelper = require('./common/pagenavigatorhelper');
                        _pageNavigatorHelper.goToBookShelf(ebookContext.getUser());
                    })
                }
            });
            def.reject();
        }
        return def.promise();
    }

    function initScreenSavers() {
        app_global_screenSaversMgr = {};

        var _eventListener = function () {
            app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;
        };

        app_global_playerMgr.bind('play', function () {
            app_global_screenSaversMgr && app_global_screenSaversMgr.setScreenSavers(false);
        }).bind('pause', function () {
            app_global_screenSaversMgr.setScreenSavers(true);
        }).bind('ended', function () {
            app_global_screenSaversMgr.setScreenSavers(true);
        });

        var _timerId = null, _triggerEvent = ['mousedown', 'mousemove', 'keydown'], _hasScreenSavers = false;
        /**
         * @param {boolean=} index 是否设置屏保
         */
        app_global_screenSaversMgr.setScreenSavers = function (index) {
            index = (index === undefined ? true : index);
            if (index) {
                if (AppCfg.screenSaversTime <= 0 || _hasScreenSavers) return;
                _hasScreenSavers = true;
                app_global_screenSaversMgr._isPause = false;
                app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;

                _timerId = setTimeout(function () {
                    if (!app_global_screenSaversMgr._isPause) {
                        var self = arguments.callee;
                        if (app_global_screenSaversMgr._leftTime > 0) {
                            --app_global_screenSaversMgr._leftTime;
                            if (app_global_screenSaversMgr._leftTime <= 0) {
                                app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;
                                //没有任何可见的iframe的情况下才允许进入屏保.
                                if (!$("iframe:visible").length) {
                                    CardWrapper.minimize();
                                    //进入黑板
                                    BlackBoard.enter();
                                }
                            }
                        }
                        _timerId = setTimeout(function () {
                            self();
                        }, 1000);
                    }
                }, 1000);

                for (var i = 0; i < _triggerEvent.length; ++i) {
                    document.addEventListener(_triggerEvent[i], _eventListener, true);
                }
            }
            else {
                app_global_screenSaversMgr._leftTime = AppCfg.screenSaversTime;
                app_global_screenSaversMgr._isPause = true;
                _hasScreenSavers = false;

                clearTimeout(_timerId);
                _timerId = null;
                for (var i = 0; i < _triggerEvent.length; ++i) {
                    document.removeEventListener(_triggerEvent[i], _eventListener, true);
                }
            }
        }
        shellcmd.isAppMin().done(function (ret) {
            !ret && app_global_screenSaversMgr.setScreenSavers(true);
        })

    }

    function initCfgDom() {
        loadConfig().done(function (configs) {
            console.log('mvvm init invoked');
            ko.applyBindings(configs);
        })
    }

    function loadConfig() {
        var def = $.Deferred();
        //这句是为了获取window对象
        var win = (function () {
            return this;
        })();

        if (AppVersionCfg.AppVersion !== AppVerCfg.BaseLine) {
            $LAB.script("assert/js/configs/" + AppVersionCfg.AppVersion + ".js").wait(function () {
                var prjConfig = win['AppVersionCfg' + AppVersionCfg.AppVersion];
                $.extend(true, AppVersionCfg, prjConfig);
                console.log(AppVersionCfg);
                def.resolve(AppVersionCfg);
            });
        }
        else {
            def.resolve(AppVersionCfg);
        }

        return def.promise();
    }

    exports.initCfgDom = initCfgDom;
    exports.loadBook = loadBook;
})
