/**
 *
 * User: chengyang@iflytek.com
 * Date: 14-12-23 下午4:42
 * Version: 1.0
 */

define(function(require, exports){
    require('jquery');

    var _bookContainer;
    var _roomInRate = 1.2;
    var _roomOutRate = 0.1;

    function init(bookContainer){
        _bookContainer = bookContainer;
    }

    function registerEvent(){
        $(window).keydown(function(event){
            console.log("iFlyMouse, keydown code:" + event.which);
            if (event.target && event.target.tagName.toLowerCase() != 'input' && event.target.tagName.toLowerCase() != 'textarea') {
                iFlyMouseHandler(event.which);
            }
        })
    }

    function pageViewEvent(){       //单双页切换
        $("#btnLeftPageView").trigger("click");
    }

    function hotspotPlayEvent(){    //热区播放、暂停
        $("#btnTogglePlay").trigger("click");
    }

    function changeEBWBEvent(){      //电子书、黑板切换
        $("#EBL").trigger("click");
    }

    function zoomEvent(){            //缩放
        if(_bookContainer.isZoomInEnable()){
            _bookContainer.zoom(_roomInRate);
        }else{
            _bookContainer.zoom(_roomOutRate);
        }
    }

    //上下移动单页
    function pageViewDown(){
        _bookContainer.moveView({x:0,y:-50});
    }

    function pageViewUp(){
        _bookContainer.moveView({x:0,y:50});
    }


    function iFlyMouseHandler(eventCode){
        switch(eventCode){
            case 112:       //F1键
                pageViewEvent();
                break;
            case 120:       //播放键
                hotspotPlayEvent();
                break;
            case 36:        //切换键
                changeEBWBEvent();
                break;
            case 123:      //缩放
                zoomEvent();
                break;
            case 40:
                pageViewDown();
                break;
            case 38:
                pageViewUp();
                break;
        }
    }
    exports.init = init;
    exports.registerEvent = registerEvent;
});
