/**
 * 外壳命令调用模块
 * User: yuwang@iflytek.com
 * Date: 13-6-20 上午9:36
 * Version: 1.0
 */
define(function (require, exports) {
    require('browserContext');
    var path = require('./path');
    var md5helper = require('./md5helper');
    var base64 = require('./base64').Instance;

    function UcopyFile(src, dst) {
        src = src.replace(/\//g, '\\\\');
        src = src.replace(/\bfile:(\\+)/g, "");
        dst = dst.replace(/\//g, '\\\\');

        var defer = $.Deferred();
        callClient('syscmd', 'cmd', 'copy /y "{0}" "{1}"'.format(src, dst), 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }



        /**
     * 拷贝文件
     * @param {string} src 原始文件路径
     * @param {string} dst 目标路径
     */
    function copyFile(src, dst) {
        src = src.replace(/\//g, '\\\\');
        src = src.replace(/\bfile:(\\+)/g, "");
        dst = dst.replace(/\//g, '\\\\');

//        var defer = $.Deferred();
//        callClient('syscmd', 'cmd', 'copy /y "{0}" "{1}"'.format(src, dst), 0, function (ret) {
//            defer.resolve(ret);
//        });
//        return defer.promise();



//================copyfile function is not steady , so we use the Like-MultiCopyFile function to replace===================================================
        var args = {"files": []};
         args.files[0] = {
            "oriname": src,
            "newname": dst
        };
        args = JSON.stringify(args);
        var defered = $.Deferred();
        showLoading({tips: AppTips.OpenResLoadingTips});
        //为解决维语问题，在此做base64编码，然后传到delphi端，在delphi端解码，避免维语信息丢失
        //var str = base64.encode(args);
        var str= '';
        for (var i = 0 ;i < args.length-1 ;i++){
            str += args.charCodeAt(i)+'|';
        }
        str += args.charCodeAt(i);
        callClient('syscmd', 'batfilecopy', str , 0, function (ret) {
            hideLoading();
            defered.resolve(ret == 'true');
        });
        return defered.promise();
    }

    /**
     * 批量复制
     * @param args
     */
    function multiCopyFile(args) {
        var defered = $.Deferred();
        showLoading({tips: AppTips.OpenResLoadingTips});
        //为解决维语问题，在此做base64编码，然后传到delphi端，在delphi端解码，避免维语信息丢失
        //var str = base64.encode(args);
        var str= '';
        for (var i = 0 ;i < args.length-1 ;i++){
            str += args.charCodeAt(i)+'|';
        }
        str += args.charCodeAt(i);
        callClient('syscmd', 'batfilecopy', str , 0, function (ret) {
            hideLoading();
            defered.resolve(ret == 'true');
        });
        return defered.promise();
    }

    /***
     * 异步copy目录
     * @param {string} src
     * @param {string} dst
     */
    function copyDir(src, dst) {
        var args = src + "|" + dst;

        var defer = $.Deferred();
        callClient('syscmd', 'dircpy', args, 0, function () {
            defer.resolve();
        });
        return defer.promise();
    }

    /***
     * 从TCH里抽取MP3(目前弃用)
     * @param tch
     * @param bookid
     * @param spotId
     * @param lan
     * @returns {*}
     */
    function extractMp3(tch, bookid, spotId, lan) {
        var str = [tch, bookid, spotId, lan].join('|');
        return callClient('syscmd', 'extractmp3', str, 0);
    }

    /**
     * 语音合成
     * @param {string} text
     * @param {string} speecher
     * @param {string} audioPath
     * @param {boolean} useCSSML
     * @returns {json}
     */
    function text2speech(text, speecher, audioPath, useCSSML) {

        var max = 30;
        var saveJSONtoFile = false;
        var isCnSpeecher = (speecher === "xiaoyan" || speecher === "xiaoyu" || speecher === "wangru");
        if (text.length > max && useCSSML != true && isCnSpeecher)
            saveJSONtoFile = true;

        var param = {"SynthText": text, "VoiceSpeecher": speecher, "WordSpeed": "5", "UseCSSML": "0", "AudioPath": audioPath};
        if (useCSSML) {
            param.UseCSSML = "1";
        }
        //因为CEF传输大数据有BUG,当合成出的JSON太大的时候,把JSON保存到硬盘,再同步读出.
        if (saveJSONtoFile) {
            param.SavePath = Config.tmpPath + "/ttsresult.txt";
        }

        var dtd = $.Deferred();
        var callback = function (args) {
            var data = args || '';
            if (data.length > 2) {
                if (saveJSONtoFile) {
                    var json = readFile(param.SavePath);
                    dtd.resolve(json, param);
                } else {
                    //合成结果是个很长的json串
                    dtd.resolve(data, param);
                }
            }
            else {
                console.error(' first text2speech failed' + data);
                dtd.resolve(data, param);
            }
        };
        callClient('syscmd', 'text2speech', JSON.stringify(param), 0, callback);

        return dtd.promise();
    }

    /**
     * 语音合成 失败则再试一次
     * @param {string} text
     * @param {string} speecher
     * @param {string} audioPath
     * @param {boolean} useCSSML
     * @returns {json}
     */
    function text2speech2(text, speecher, audioPath, useCSSML) {
        var max = 30;
        var saveJSONtoFile = false;
        var isCnSpeecher = (speecher === "xiaoyan" || speecher === "xiaoyu" || speecher === "wangru");
        if (text.length > max && useCSSML != true && isCnSpeecher)
            saveJSONtoFile = true;

        var param = {"SynthText": text, "VoiceSpeecher": speecher, "WordSpeed": "5", "UseCSSML": "0", "AudioPath": audioPath};
        if (useCSSML) {
            param.UseCSSML = "1";
        }
        //因为CEF传输大数据有BUG,当合成出的JSON太大的时候,把JSON保存到硬盘,再同步读出.
        if (saveJSONtoFile) {
            param.SavePath = Config.tmpPath + "/ttsresult.txt";
        }

        var dtd = $.Deferred();

        /*很挫的写法，不得已为之
         *如果第一次合成失败，则尝试第二次
         */
        callClient('syscmd', 'text2speech', JSON.stringify(param), 0, function (args1) {
            var data1 = args1 || '';
            //长文本返回true
            if(data1 == 'true'){
                if (saveJSONtoFile) {
                    var json = readFile(param.SavePath);
                    dtd.resolve(json, param);
                }
            }else if(data1.length > 4){//合成成功的返回字符串长度必大于4 [{}]
                dtd.resolve(data1, param);
            }else{
                console.error('first text2speech failed:'+data1);
                callClient('syscmd', 'text2speech', JSON.stringify(param), 0, function (args2){
                    var data2 = args2 || '';
                    //合成成功的返回字符串长度必大于4 [{}]
                    if(data2 == 'true'){
                        if (saveJSONtoFile) {
                            var json = readFile(param.SavePath);
                            dtd.resolve(json, param);
                        }
                    }else if(data2.length > 4){
                        dtd.resolve(data2, param);
                    }else {
                        console.error('second text2speech failed' + data2);
//                        dtd.resolve(data2,param);
                    }
                });
            }

        });
        return dtd.promise();
    }

    /**
     * 手写识别
     * @param {json} jsonStr
     * @returns {string}
     */
    function hcr(jsonStr) {
        var def = $.Deferred();
        callClient('syscmd', 'hcr', jsonStr, 0, function (wordStr) {
            def.resolve(wordStr);
        });
        return def.promise();
    }

    /**
     * 初始化合成引擎
     * @returns {boolean}
     */
    function initTTS() {
        var def = $.Deferred();
        callClient('syscmd', 'inittts', '', 0, function (initResult) {
            def.resolve(initResult == "true");
        });
        return def.promise();
    }

    /**
     * 逆初始化引擎
     * @returns {boolean}
     */
    function UninitTTS() {
        var def = $.Deferred();
        callClient('syscmd', 'finitts', '', 0, function () {
            def.resolve();
        });
        return def.promise();
    }

    function playVideo(src, playerState) {
        callClient('syscmd', 'simpleshellexecute', src, 0);
//        src = path.toWindows(path.trimPosix(src));
//        var player = path.trimPosix(Config.binPath + "splayer/splayer.exe");
//        src = '"' + src + '"';
//        var cmdArgs = player + '|' + src + '|' + playerState;
//        var defer = $.Deferred();
//        callClient('syscmd', 'shellexecute', cmdArgs, 0, function () {
//            defer.resolve();
//        });
//        return defer.promise();
    }

    /**
     * 播放音频
     * @param audioPath {string} 音频地址
     */
    function sndPlay(audioPath) {
        callClient('syscmd', 'sndplay', audioPath, 2);
    }

    /**
     * 暂停播放
     */
    function sndPause() {
        callClient('syscmd', 'sndpause', '', 0);
    }

    /**
     * 停止播放
     */
    function sndStop() {
        callClient("syscmd", "sndstop", "", 0);
    }

    /**
     * 继续播放
     */
    function sndResume() {
        callClient("syscmd", "sndresume", "", 2);
    }

    /**
     *
     * 保存文件异步
     * @param {string} content 文件文本类容
     * @param {string} filePath 文件路径
     */
    function saveFilAsync(content, filePath) {
        var def = $.Deferred();
        callClient('syscmd', 'savefile', '{0}|{1}'.format(filePath, content), 0, function (ret) {
            if (!ret) {
                console.error('shellcmd::saveFile return fail');
            }
            def.resolve(ret);
        });
        return def.promise();
    }


    function XinJiang_saveFilAsync(content, filePath) {
        var def = $.Deferred();
        //解决维语问题
        var str= '';
        for (var i = 0 ;i < content.length-1 ;i++){
            str += content.charCodeAt(i)+'|';
        }
        str += content.charCodeAt(i);
        callClient('syscmd', 'savefilexinjiang', '{0}&{1}'.format(filePath, str), 0, function (ret) {
            if (!ret) {
                console.error('shellcmd::saveFilexinjiang return fail');
            }
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 将html 5 拍照的base64 保存成图片，插入到书本中
     * @param content
     * @returns {*}
     */
    function saveBase64AsImage(content) {
        var def = $.Deferred();
        callClient('syscmd', 'savebaseimage', content, 0, function (ret) {
            if (!ret) {
                console.error('shellcmd::saveFile return fail');
            }
            def.resolve(ret);
        });
        return def.promise();
    }


    /***
     * DRM 资源是否包含该文件
     * @param zip
     * @param file
     * @returns {*}
     */
    function isEncryptFileExist(zip, file) {
        var param = { "zip": "", "file": ""};
        param.zip = zip;
        param.file = file;

        var defer = $.Deferred();
        callClient('syscmd', 'drmIsContainsFile', JSON.stringify(param), 0, function (ret) {
            defer.resolve(ret == 'true');
        });
        return defer.promise();
    }


    /**
     * 读取文件类容异步
     * @param {string} filePath  文件路径
     * @return {string}
     */
    function readFileAsync(filePath) {
        var def = $.Deferred();
        if (AppCfg.useAjax) {
            //这里是同步的
            var fileObj = $.ajax({url: filePath, async: false});
            def.resolve(fileObj.responseText);
        }
        else {
            callClient('syscmd', 'readfile', filePath, 0, function (ret) {
                def.resolve(ret);
            });
        }
        return def.promise();
    }

    /**
     * 判断文件是否存在
     * @param {string} filePath 文件路径
     * @returns {boolean}
     */
    function isFileExist(filePath) {
        //console.log('%c isFileExists start %s', 'color:green', filePath);
        var defer = $.Deferred();
        if (!filePath) return defer.resolve(false);
        filePath = path.trimPosix(filePath);
        callClient('syscmd', 'fileexists', filePath, 0, function (ret) {
            // console.log('%c isFileExists end %s %s','color:brown',filePath,ret);

            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }


    /**
     * 判断文件是否存在 (同步方法)
     * @param {string} filePath 文件路径
     * @returns {boolean}
     *
     * Caution : 这个函数有些莫名其妙的错误。
     * 在我的本地查找 “file:/E:/....../...../...”失败，文件是存在的
     * 一点点猜想 ，应该找 “file:///E:/” 或者 “E:/......”
     *
     *              --------- by  yczhu
     *
     */
    function isFileExistSync(filePath) {
        return cef.fs.fileExists(filePath);
    }


    /***
     * 判断目录是否存在
     * @param dir
     * @returns promise对象
     */
    function isDirExist(dir) {
        if (!isShellRunning()) {
            console.warn("application is not running shell!");
            return true;
        }
        dir = path.trimPosix(dir);
        var defer = $.Deferred();
        callClient('syscmd', 'isdirexist', dir, 0, function (ret) {
            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }

    /***
     * 判断目录是否存在
     * @param dir
     * @returns true/false
     */
    function isDirExistSync(dir) {
        return cef.fs.dirExists(dir);
    }

    /***
     * 创建目录(同步方法)
     * @param dir
     * @returns {promise对象|*}
     */
    function createDirSync(dir) {
        return  cef.fs.createDir(dir);
    }

    /***
     * 删除目录(同步方法)
     * @param dir
     * @returns {promise对象|*}
     */
    function deleteDirSync(dir) {
        return  cef.fs.deleteDir(dir);
    }

    /***
     * 创建目录
     * @param dir
     * @returns promise对象
     */
    function createDir(dir, tryTimes) {
        var defer = $.Deferred();
        if (typeof tryTimes == "number") {
            console.log(tryTimes);
            if (tryTimes > 10) {
                defer.resolve(false);
                return defer.promise();
            }
        }
        dir = path.trimPosix(dir);
        callClient('syscmd', 'createdir', dir, 0, function (ret) {
            if (ret === "false" && typeof tryTimes == "number") createDir(dir, tryTimes + 1);
            else defer.resolve(ret === 'true');
        });
        return defer.promise();
    }

    /***
     * 删除目录
     * @param dir
     * @returns promise对象
     */
    function deleteDir(dir) {
        dir = path.trimPosix(dir);
        var defer = $.Deferred();
        callClient('syscmd', 'deletedir', dir, 0, function (ret) {
            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }


    function createDirIfNotExist(dir, tryTimes) {
        if (!isDirExistSync(dir, tryTimes))
            createDir(dir, tryTimes);
    }

    /**
     * 读取文件类容(同步方法!!)
     * @param {string} filePath  文件路径
     * @return {string}
     */
    function readFile(filePath) {
        if (!isShellRunning()) {
            console.warn("application is not running shell!");
            return "";
        }
        filePath = path.trimPosix(filePath);
        var retval;
        var file = cef.fs;
        try {
            //     console.log(filePath);
            retval = file.readAll(filePath);
        } catch (e) {
            //  console.error(e);
            retval = null;
        }
        return retval;
    }

    /**
     * 保存文件 (同步方法!!!)
     * @param {string} content 文件文本类容
     * @param {string} filePath 文件路径
     */
    function saveFile(content, filePath) {
        if (!isShellRunning()) {
            console.warn("application is not running shell!");
            return;
        }
        filePath = path.trimPosix(filePath);
        var retval;
        var file = cef.fs;
        try {
            file.writeAll(filePath, content);
        } catch (e) {
            // console.error(e);
        }
    }

    /**
     * 删除文件
     * @param filePath
     */
    function deleteFile(filePath) {
        if (!isShellRunning()) {
            console.warn("application is not running shell!");
            return false;
        }
        filePath = path.trimPosix(filePath);
        //console.log("delete file:" + filePath);
        var defer = $.Deferred();
        //filePath = base64.encode(filePath);
        var str= '';
        for (var i = 0 ;i < filePath.length-1 ;i++){
            str += filePath.charCodeAt(i)+'|';
        }
        str += filePath.charCodeAt(i);
        callClient('syscmd', 'deletefile', str, 0, function (ret) {
            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }

    /***
     * 读取DRM加密资源
     * @param token
     * @param zip
     * @param lic
     * @param file
     * @param savepath
     * @returns {*}
     */
    function readEncryptFile(token, zip, lic, file, savepath) {
        var param = {"token": "", "zip": "", "lic": "", "file": "", "savepath": ""};
        param.token = token;
        param.zip = zip;
        param.lic = lic;
        param.file = file;
        param.savepath = savepath;

        console.time('readdrmres:' + file);
        console.log("readEncryptFile->start");
        var defer = $.Deferred();
        callClient('syscmd', 'drmunpacker', JSON.stringify(param), 0, function (ret) {
            console.timeEnd('readdrmres:' + file);
            defer.resolve(ret);
        });
        return defer.promise();
    }


    /**
     * 获取硬件号
     * @returns {string}
     */
    function getHardwareInfo(userAccount) {
        var defer = $.Deferred();
        callClient('syscmd', 'getsn', '', 0, function (ret) {
            var md5encode = md5helper.hex_md5(ret + userAccount);
            defer.resolve(md5encode);
        });
        return defer.promise();
    }

    /**
     * 获取硬件类型
     * @returns {string}  0:计算机，1：平板
     */
    function getHardwareType() {
        var defer = $.Deferred();
        callClient('syscmd', 'checkhardware', '', 0, function (ret) {
            if (ret === "0" || ret === "1") {
                defer.resolve(ret);
            }
            else {
                //偶发会出现取得的值是未加密的硬件信息
                callClient('syscmd', 'checkhardware', '', 0, function (ret2) {
                    console.log("second get HardType");
                    defer.resolve(ret2);
                });
            }
        });
        return defer.promise();
    }

    /**
     * 获取硬件名称
     * @returns {string}
     */
    function getHardwareName() {
        var defer = $.Deferred();
        callClient('syscmd', 'getcomptname', '', 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 环境检查
     * @returns {boolean}
     */
    function checkEnvironment() {
        var defer = $.Deferred();
        callClient('syscmd', 'getsn', '', 0, function (ret) {
            defer.resolve(ret != null);
        });
        return defer.promise();
    }

    /**
     * 联网检查
     * 一般联网检测检查的都是这个页面，书库例外
     * @returns {boolean}
     */
    function checkOnline() {
        var defer = $.Deferred();
        checkUrlAccess(AppRemoteSvcCfg.OnlineCheckUrl).done(function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 书库页面检查
     * @returns {*}
     */
    function checkUrlAccess(url) {
        var defer = $.Deferred();
        if (AppCfg.useAjax) {
            var param = {
                type: "GET",
                url: url,
                data : {
                    version : AppCfg.version ,
                    product : AppCfg.product
                }
            };
            if (AppCfg.ajaxTimeOut > 0) {
                param.timeout = AppCfg.ajaxTimeOut;
            }
            $.ajax(param)
                .done(function (data) {
                    defer.resolve(true);
                })
                .error(function (XMLHttpRequest, textStatus, errorThrown) {
                    console.log(XMLHttpRequest.status);
                    defer.resolve(false);
                });
        } else {
            callClient('syscmd', 'checkurlaccess', url, 0, function (ret) {
                defer.resolve(ret === 'true');
            });
        }
        return defer.promise();
    }

    function getHttpRequest(url,param) {
        var defer = $.Deferred();
        param = param || {};
        param["client_version"] = AppCfg.version;
        param["product"] = AppCfg.product;

        var _obj = {
            type: "GET",
            url: url,
            data : param
        }
        if(param.timeout){
            _obj.timeout = param.timeout
        }
        if(param.dataType){
            _obj.dataType = param.dataType
        }

        $.ajax(_obj)
            .done(function (data) {
                defer.resolve(data);
            })
            .fail(function (failret) {
                console.log(failret);
                console.log("http get ajax failed");
                defer.resolve("");
            });

        return defer.promise();
    }

    function getTextHttpRequest(url,param){
        var defer = $.Deferred();
        param = param || {};
        param.client_version = AppCfg.version;
        param.product = AppCfg.product;
        $.ajax({type: "GET", url: url,dataType:"text",data:param})
            .done(function (data) {
                defer.resolve(data);
            })
            .fail(function (failret) {
                console.log(failret);
                console.log("http get ajax failed");
                defer.resolve("");
            });

        return defer.promise();
    }

    function getHttpRequestJSON(url,param) {
        var defer = $.Deferred();
        param = param || {};
        param["client_version"] = AppCfg.version;
        param["product"] = AppCfg.product;
        $.ajax({type: "GET", url: url, dataType: "json",data:param})
            .done(function (data) {
                defer.resolve(data);
            })
            .fail(function (failret) {
                console.log(failret);
                console.log("http get ajax failed");
                defer.resolve("");
            });

        return defer.promise();
    }

    function getHttpRequest_mobile(url,param) {
        var defer = $.Deferred();
        param = param || {};
        param["client_version"] = AppCfg.version;
        param["product"] = AppCfg.product;
        $.ajax({type: "GET", url: url, dataType: "json",data:param})
            .done(function (data) {
                defer.resolve(data);
            })
            .fail(function (failret) {
                console.log(failret);
                console.log("http get ajax failed");
                defer.resolve(failret);
            });

        return defer.promise();
    }

    function postHttpRequest(msg) {
        var defer = $.Deferred();
        msg["client_version"] = AppCfg.version;
        msg["product"] = AppCfg.product;
        var msgStr = JSON.stringify(msg);
        if (AppCfg.useAjax) {

            var param = (AppCfg.ajaxTimeOut > 0) ? {type: "POST", url: msg.url, data: msg, timeout: AppCfg.ajaxTimeOut} :
            {type: "POST", url: msg.url, data: msg};
            if(msg.timeout){
                param.timeout = msg.timeout;
            }
            if(msg.dataType){
                param.dataType = msg.dataType;
            }
            $.ajax(param)
                .done(function (data) {
                    defer.resolve(data);
                })
                .fail(function () {
                    console.log("http post ajax failed");
                    defer.resolve("");  //不能返回"failed",，因为调用这个方法的程序是基于""做异常处理的
                });
        } else {
            callClient('syscmd', 'httppost', msgStr, 0, function (ret) {
                defer.resolve(ret);
            });
        }
        return defer.promise();
    }

    /**
     * 异步联网检查
     * @returns {boolean}
     */
    function checkOnlineAsyn() {
        var ret = callClient('syscmd', 'sychisnetworking', "http://www.baidu.com/", 2);
    }


    /**
     * 调用外部浏览器打开页面
     * @param url
     * @private
     */
    function openPageOutside(url) {
       // callClient('syscmd', 'shellexecute', url, 0);
        shellExecute(url);
    }

    /**
     * 文件下载
     * @param fileMetadata
     */
    function fileDownload(fileMetadata) {
        // if (AppCfg.useDownloader) {
        //维语转码
        //解决维语问题

        callClient("syscmd", "download", fileMetadata, 2);
//        }
//        else {
//            callClient("syscmd", "filedownload", fileMetadata, 2);
//        }
    }

    function getMetaMap(url) {
        if (url == null || url == "") {
            return;
        }
        var def = $.Deferred();
        callClient('syscmd', 'getbookmap', url, 0, function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 获取书本lic
     * @param url
     * @param bookId
     * @param userAccount
     * @param hdInfo
     * @param hdType
     * @returns {*}
     */
    function getBookLic(url, bookId, userAccount, hdInfo, hdType, savePath) {
        var defer = $.Deferred();
        var httpurl = AppRemoteSvcCfg.BookLicenseGetUrl;
        var msgJson = {
            url: httpurl,
            account: userAccount,
            resid: bookId,
            hardware: hdInfo,
            hdtype: hdType,
            savepath: savePath,
            version: AppCfg.version,
            product: AppCfg.product
        };
        var msg = JSON.stringify(msgJson);
        callClient('syscmd', 'getbooklic', msg, 0, function (ret) {
            defer.resolve(ret);
        });
//        postHttpRequest(msg).done(function(ret){
//            defer.resolve(ret);
//        });
        return defer.promise();
    }

    /**
     * 连接数据库
     * @param dbPath
     * @returns {boolean}
     */
//    function connectDb(dbPath) {
//        var defer = $.Deferred();
//        callClient("syscmd", "connectdb", dbPath, 0, function (ret) {
//            defer.resolve(ret == 1);
//        });
//        return defer.promise();
//    }

    /**
     * 读数据库
     * @param sql
     * @returns {*}
     */
    function retriveDbAsyn(dbPath, sql) {
        var defer = $.Deferred();
        var param = {
            dbfile: dbPath,
            sqlstr: sql
        }
        callClient("syscmd", "opensqlwithcon", JSON.stringify(param), 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();

//        var defer = $.Deferred();
//        callClient("syscmd", "connectdb", dbPath, 0, function (ret) {
//            console.log("connectdb - "+dbPath+"--"+ret);
//            if (ret == 1) {
//                callClient("syscmd", "opensql", sql, 0, function (ret2) {
//                    console.log(ret2);
//                    defer.resolve(ret2);
//                });
//            } else {
//                console.log("resoleve null");
//                defer.resolve(null);
//            }
//        });
//        return defer.promise();
    }

    /**
     * 写数据库
     * @param sql
     * @returns {boolean}
     */
    function executeDbAsyn(dbPath, sql) {
        var defer = $.Deferred();
        var param = {
            dbfile: dbPath,
            sqlstr: sql
        }
        callClient("syscmd", "execsqlwithcon", JSON.stringify(param), 0, function (ret2) {
            defer.resolve(ret2 === 'true');
        });
        return defer.promise();

//        var defer = $.Deferred();
//        callClient("syscmd", "connectdb", dbPath, 0, function (ret) {
//            if (ret == 1) {
//                callClient("syscmd", "execsql", sql, 0, function (ret2) {
//                    defer.resolve(ret2 === 'true');
//                });
//            } else {
//                defer.resolve(false);
//            }
//        });
//        return defer.promise();
    }

    function getFirstItemAsyn(dbPath, sql) {
        var defer = $.Deferred();
        var param = {
            dbfile: dbPath,
            sqlstr: sql
        }
        callClient("syscmd", "getfirstwithcon", JSON.stringify(param), 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();

//        var defer = $.Deferred();
//        callClient("syscmd", "connectdb", dbPath, 0, function (ret) {
//            if (ret == 1) {
//                callClient("syscmd", "opensqlandgetfirst", sql, 0, function (ret) {
//                    defer.resolve(ret);
//                });
//            } else {
//                defer.resolve();
//            }
//        });
//        return defer.promise();
    }

    /**
     * 导出资源
     * @param value
     * @returns {*}
     */
    function resExport(value) {
        var defer = $.Deferred();
        callClient('syscmd', 'resexport', value, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 导入资源的对话框
     */
    function resImport() {
        var defer = $.Deferred();
//        callClient('syscmd', 'resimport', '', 0, function (ret) {
//            defer.resolve(ret);
//        });
        var options = {"multi": false, "ext": ['.mtbk']};
        openFileDialog(options).done(function (ret) {
            if (ret.length > 0) {
                var file = ret[0];
                var fileExt = path.extname(file);
                if (fileExt == '.mtbk')
                    defer.resolve(ret[0]);
                else {
                    $.Zebra_Dialog(AppImportAndExportTips.ImportWrongFile, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips],
                        'onClose': function (capition) {
                            if (capition == AppTips.OkTips) {
                            }
                        }
                    });
                    defer.resolve('');
                }
            } else {
                defer.resolve('');
            }
        });
        return defer.promise();
    }

    /**
     * 获得导入资源的内容
     * @param importPath
     * @returns {*}
     */
    function getZipInnercode(importPath) {
        var defer = $.Deferred();
        callClient('syscmd', 'getzipinnercode', importPath, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 删除目录下的所有文件但不删除目录和子目录
     * @param dir
     * @returns {*}
     */
    function clearDir(dir) {
        var defer = $.Deferred();
        callClient("syscmd", "cleardir", dir, 0, function (ret) {
            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }

    /**
     * 解压
     * @param args  格式为：'{"zippath":"' + importPath + '","despath":"' + pathDir + '"}'
     * @returns {*}
     */
    function unzip(args) {
        var defer = $.Deferred();
        callClient('syscmd', 'unzip', args, 0, function (ret) {
            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }

    function isDirEmpty(dir) {
        var defer = $.Deferred();
        callClient('syscmd', 'isdirempty', dir, 0, function (ret) {
            defer.resolve(ret === 'true');
        });
        return defer.promise();
    }

    /**
     * 选择目录
     * @returns {*}
     */
    function dirSelect() {
        var defer = $.Deferred();
        callClient('syscmd', 'dirselect', '', 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 程序最小化
     */
    function ebookMin() {
        callClient('syscmd', 'ebookmin', '', 0);
    }

    /**
     * 关闭程序
     */
    function closeApp() {
        var defer = $.Deferred();
        callClient('syscmd', 'ebookclose', '', 0, function (ret) {
            defer.resolve();
        });
        return defer.promise();
    };

    function checkLocalAuthorization(msg) {
        var defer = $.Deferred();
        callClient('syscmd', 'checkauthor', msg, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    };

    function desEncrpty(content, key) {
        var defer = $.Deferred();
        var argsJson = '{"content":"' + content + '","key":"' + key + '"}';
        callClient('syscmd', 'desencode', argsJson, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }


    function desEncrptyWithBase64(content, key) {
        var defer = $.Deferred();
        var argsJson = '{"content":"' + content + '","key":"' + key + '"}';
        callClient('syscmd', 'desencodewithbase64', argsJson, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 解密
     * @param content
     * @param key
     * @returns {*|string}
     */
    function desDecrpty(content, key) {
        var des = $.Deferred();
        var argsJson = '{"content":"' + content + '","key":"' + key + '"}';
        callClient('syscmd', 'desdecode', argsJson, 0, function (ret) {
            des.resolve(ret);
        });
        return des.promise();
    }

    /**
     * 读取书本许可证
     * @param msg
     */
    function getBookLicNode(msg) {
        var des = $.Deferred();
        callClient('syscmd', 'getresliccontent', msg, 0, function (ret) {
            console.log('getresliccontent: ' + ret);
            des.resolve(ret);
        });
        return des.promise();
    }

    /**
     * 移除内存中的书本LIC数据
     * @param msg
     * @returns {*}
     */
    function removeResLicFromMem(msg) {
        var des = $.Deferred();
        callClient("syscmd", "removereslicfrommem", msg, 0, function () {
            console.log('removereslicfrommem');
            des.resolve();
        });
        return des.promise();
    }

    /**
     * 从指定的URL中下载图片
     * @param imgUrl
     * @param savePath
     * @returns {*}
     */
    function getImageFromUrl(imgUrl, savePath) {
        var des = $.Deferred();
        callClient('syscmd', 'saveimagefromurl', imgUrl + '|' + savePath, 0, function (ret) {
            des.resolve(ret);
        });
        return des.promise();
    }

    /**
     * 打开文件对话框
     * @param options
     * @returns {*}
     */
    function openDialog(options) {
        var defer = $.Deferred();
        callClient('syscmd', 'opendialog', options, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /***
     * 显示保存对话框
     * @param ext
     * @returns {*}
     */
    function saveFileDialog(saveName, ext) {
        var defer = $.Deferred();
        sendCefMsg('dialog.filesave', [saveName, ext], function (ret) {
            defer.resolve(ret);
        });
        return defer;
    }

    /***
     * CEF 自已的文件打开功能,见clienttest.html 示例
     * @param options
     * @returns {*}
     */
    function openFileDialog(options) {
        var defer = $.Deferred();
        options.ext.unshift('');
        if (options.multi) {
            sendCefMsg('dialog.multifileopen', options.ext, function (ret) {
                defer.resolve(ret);
            });
        } else {
            sendCefMsg('dialog.fileopen', options.ext, function (ret) {
                defer.resolve(ret);
            });
        }
        return defer.promise();
    }

    function openDirSelect(){
        var def = $.Deferred();
        callClient('syscmd' , 'opendirselect' , '' , 0 ,function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 获取系统System32目录
     * @returns {*}
     */
    function getSystemDir() {
        var defer = $.Deferred();
        callClient('syscmd', 'getsystem32', '', 0, function (ret) {
            //console.log(ret);
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 取消下載
     * @param id 下載資源的ID
     */
    function cancleDownload(id) {
        var defer = $.Deferred();
        callClient('syscmd', 'canceldownload', id, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }


    function shellExecute(src) {
	
        var defer = $.Deferred();
        var strs = src.split('|');
        var param ='';
        if (strs.length == 2) {
            for (var i = 0 ;i < strs[0].length-1 ;i++){
                param += strs[0].charCodeAt(i)+'&';
            }
            param += strs[0].charCodeAt(i);
            callClient('syscmd', 'shellexecute', path.trimPosix(param) + '| ', 0, function (ret) {
                defer.resolve(ret);
            });
        }
        else {
            for (var i = 0 ;i < src.length-1 ;i++){
                param += src.charCodeAt(i)+'&';
            }
            param += src.charCodeAt(i);
            callClient('syscmd', 'shellexecute', path.trimPosix(param), 0, function (ret) {
                defer.resolve(ret);
            });
        }
        return defer.promise();
    }

    function simpleShellexecute(src) {
        var defer = $.Deferred();
        callClient('syscmd', 'simpleshellexecute', path.trimPosix(src), 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    function shellexecutewithargs(srcpath, args1, args2) {
        var defer = $.Deferred();
        args2 = args2 == undefined ? "" : args2;
        console.log("args2:" + args2);
        if (args2 == "") {
            callClient('syscmd', 'shellexecutewithargs', path.trimPosix(srcpath) + "|" + args1, 0, function (ret) {
                defer.resolve(ret);
            });
        }
        else {
            callClient('syscmd', 'shellexecutewithargs', path.trimPosix(srcpath) + "|" + args1 + "|" + args2, 0, function (ret) {
                defer.resolve(ret);
            });
        }

        return defer.promise();
    }
    //包括创建时间和上次修改时间，中间以‘|’ 分割
    function getFileTimeInfo(filePath) {
        var defer = $.Deferred();
        callClient('syscmd', 'filetimeget', path.trimPosix(filePath), 0, function (ret) {
            console.log('fileInfo: ' + ret);
            defer.resolve(ret);
        });
        return defer.promise();
    }


    /**
     * 隐藏客户端外壳
     * @returns {*}
     */
    function shellHide() {
        var def = $.Deferred();
        callClient('syscmd', 'ebookhide', "", 0, function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 文件上传
     * @returns {*}
     */
    function uploadFile(msg) {
        var def = $.Deferred();
        callClient('syscmd', 'upload', msg, 0, function () {
            def.resolve(eval('(' + msg + ')'));
        });
        return def.promise();
    }

    function saveAsDlg(title) {
        var def = $.Deferred();
        callClient('syscmd', 'saveasdlg', title, 0, function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    function chaptersExport(args) {
        var def = $.Deferred();
        callClient('syscmd', 'chaptersexport', args, 0, function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 重命名文件
     * @param src
     * @param newname
     */
    function rename(src, newname) {
        //  callClient('syscmd', 'cmd', 'rename "{0}" "{1}"'.format(src, newname), 0);
        //console.log(src, newname)
        callClient('syscmd', 'filerename', src + "|" + newname, 0);
    }

    /**
     * 调用输入法
     * @param type
     * @param focusElem
     */
    function callIme(type, focusElem) {
        var def = $.Deferred();
        var exePath = "";
        if (type == "write") {
            exePath = path.trimPosix(Config.binPath) + "iFlyIme/iFlyInk.exe";
        }
        else if (type == "voice") {
            exePath = path.trimPosix(Config.binPath) + "iFlyIme/iFlyVoice.exe";
        }
        else if (type == "keyboard") {
            openOsk(exePath);
            def.resolve();
            return def.promise();
        }
        simpleShellexecute(exePath).done(function (ret) {
            //返回>32,成功
            focusElem.focus();
            def.resolve();
        });
        return def.promise();
    }

    /**
     * 调用软键盘(屏幕输入法)
     * @param exePath
     * @returns {*}
     */
    function openOsk(exePath) {
        var def = $.Deferred();
        callClient('syscmd', 'openosk', exePath, 0, function () {
            def.resolve();
        });
        return def.promise();
    }

    /**
     * 关闭进程
     * @param exeName
     * @returns {*}
     */
    function killProcess(exeName) {
        var def = $.Deferred();
        callClient('syscmd', 'killprocess', exeName, 0, function () {
            def.resolve();
        });
        return def.promise();
    }

    function asynLogin(msg) {
        callClient('syscmd', 'asynlogin', msg, 0);
    }

    /**
     * 查找进程是否存在
     * @param exeName
     * @returns {*}
     */
    function findProcess(exeName) {
        var def = $.Deferred();
        callClient('syscmd', 'findprocess', exeName, 0, function (num) {
            //console.log("! " + num);
            def.resolve(num);
        });
        return def.promise();
    }

    /**
     * 单例调用输入法程序
     * @param exeName
     * @param type
     * @param focusElem
     */
    function callSingleton(exeName, type, focusElem) {
        var def = $.Deferred();
        killProcess(exeName).done(function () {
            callIme(type, focusElem).done(function (ret) {
                //执行reiv程序 将输入法程序窗口置顶
                //  callClient('syscmd', 'runreiv', '', 0, function (ret) {
                def.resolve(ret == 'true');
                // });
            });
        });
        return def.promise();
    }

    function checkRunningDiskSpace() {
        var def = $.Deferred();
        callClient('syscmd', 'getdiskfreespace', '', 0, function (freeSpace) {
            var temp = parseInt(freeSpace);
            def.resolve(temp);
        });
        return def.promise();
    }

    function checkUnzip() {
        var def = $.Deferred();
        callClient('syscmd', 'checkunzip', '', 0, function (num) {
            var temp = parseInt(num);
            def.resolve(num > 0);
        });
        return def.promise();
    }

    /**
     * 写文件（追加）
     */
    function savefileappent(content, filePath) {
        var def = $.Deferred();
        callClient('syscmd', 'savefileappent', '{0}|{1}'.format(filePath, content), 0, function (ret) {
            if (!ret) {
                console.error('shellcmd::saveFile return fail');
            }
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 获取ipv4地址
     * @returns {*}
     */
    function getipv4address() {
        var def = $.Deferred();
        callClient('syscmd', 'getipv4address', '', 0, function (ret) {
            if (!ret) {
                console.error('get ipv4 fail');
            }
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 获取exe信息
     * @param src
     * @returns {*}
     */
    function getExeInfo(exePath, icoSavePath) {
        var defer = $.Deferred();
        var param = exePath + "|" + icoSavePath
        console.log(param);
        callClient('syscmd', 'getexeinfo', param, 0, function (ret) {
            //   console.log(ret);
            defer.resolve(ret);
        });
        return defer.promise();
    }

    /**
     * 读取注册表
     * @param path
     * @returns {*}
     */
    function readRegistry(path) {
        var defer = $.Deferred();
        callClient('syscmd', 'readregistry', path, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    function mount(path) {
        var defer = $.Deferred();
        callClient('syscmd', 'mount', path, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    function isAppMin() {
        var defer = $.Deferred();

        callClient('syscmd', 'getappstatus', '', 0, function (ret) {
            console.log("isAppMin" + ret);
            if (ret == 'min')
                defer.resolve(true);
            else
                defer.resolve(false);
        });
        return defer.promise();
    }

    function uplaodByDll(localPath, webPath) {
        var defer = $.Deferred();

        callClient('syscmd', 'uploadbydll', localPath + "|" + webPath, 0, function (ret) {
            defer.resolve(ret);
        });
        return defer.promise();
    }

    function getUserFromFile() {
        var def = $.Deferred();
        callClient('syscmd', 'ccsslogin', '', 0, function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    //获取文件大小
    function getFileSize(filePath) {
        var def = $.Deferred();
        callClient('syscmd', 'filesizeget', filePath, 0, function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    function snapshot(cmdCorrespond) {
        callClient("syscmd", "snapshot", cmdCorrespond, 0, function () {
        });
    }

    function writeAESUserInfo(userAccountInfo) {
        callClient('syscmd', 'filewrite', userAccountInfo, 0);
    }

    function beforeExitApp() {
        callClient('syscmd', 'ccsslogout', '', 0);
    }


    function FileUnzip(sourceFile ,destPath){
        var def = $.Deferred();
        callClient('syscmd','fileunzip',sourceFile + '|'+ destPath , 0, function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }

    function AfterRender(){
        callClient('syscmd', 'afterrender', '' , 0);
    }


    function GetUpanInfo(){
        var def = $.Deferred();
        callClient('syscmd' , 'getupaninfo' , '' , 0 , function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }

    function GetUpanList(){
        var def = $.Deferred();
        GetUpanInfo().done(function(ret){
            var ans = ret.split("|");
            var len = ans.length,i=0;
            for(i=0;i<len;i++){
                ans[i] = ans[i].split(":");
            }
            def.resolve(ans);
        });
        return def.promise();
    }

    function checkU(isU,name){
        var def = $.Deferred();
        GetUpanList().done(function(list){
            var i = 0,len = list.length;
            for(i=0;i<len;i++){
                if(isU == md5helper.hex_md5(list[i][2] + name) ){
                    def.resolve(list[i][0]);
                }
            }
            def.resolve("");
        });
        return def.promise();
    }

    function createShortCut(path){
        callClient('syscmd' , 'createshortcut', path ,0);
    }

    function MonitorStart(configPath){
        callClient('syscmd', 'monitorstart', configPath,0);
    }

    function MonitorSend(jsonStr){
        callClient('syscmd', 'monitorsend', jsonStr ,0);
    }

    function MonitorStop(){
        callClient('syscmd', 'monitorstop', '',0);
    }

    function getAllFolder(pathdir){
        var def = $.Deferred();
        callClient('syscmd', 'searchfolder', pathdir, 0 ,function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }
    //传入参数为路径，以“/”结尾
    function getAllFolderList(pathdir){
        var def = $.Deferred();
        var list = [];
        getAllFolder(pathdir).done(function(ret){
            list = ret.split("|");
            def.resolve(list);
        });
        return def.promise();
    }

    function getAllFile(path , ext){  //attention: ext的格式为 *.txt 、 *.doc .....
        var def = $.Deferred();
        callClient('syscmd', 'searchfile', path + '|' + ext , 0 ,function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }

    function getAllFileList(path , ext){
        var def = $.Deferred();
        var list = [];
        getAllFile(path,ext).done(function(ret){
            list = ret.split("|");
            def.resolve(list);
        })
        return def.promise();
    }

    function rewriteAppCfg(path){
        callClient('syscmd' , 'rewriteappcfg' , path , 0);
    }

    function rewriteReaderXml(Xmlpath , content){
        var def = $.Deferred();
        Xmlpath = path.trimPosix(Xmlpath);
        callClient('syscmd' , 'rewritereaderxml' , Xmlpath + '|' + content, 0 , function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }

    //回调函数返回的size结构：width|height
    function getPicSize(path){
        var def = $.Deferred();
        callClient('syscmd' , 'getpicsize' , path, 0 , function(size){
            def.resolve(size);
        });
        return def.promise();
    }

   function getCpuId(command,workPath){
       var def = $.Deferred();
       command = path.trimPosix(command);
       workPath = path.trimPosix(workPath);
       callClient('syscmd' , 'getcpuid' , command +'|'+ workPath, 0 , function(ret){
           def.resolve(ret);
       });
       return def.promise();

   }

    function openLocalFolder(path){
        callClient('syscmd' , 'openlocalfolder',path, 0, 0 );
    }





    exports.getUserFromFile = getUserFromFile;
    exports.getipv4address = getipv4address;
    exports.savefileappent = savefileappent;
    exports.findProcess = findProcess;
    exports.copyFile = copyFile;
    exports.UcopyFile = UcopyFile;
    exports.extractMp3 = extractMp3;
    exports.text2speech = text2speech;
    exports.text2speech2 = text2speech2;
    exports.hcr = hcr;
    exports.initTTS = initTTS;
    exports.playVideo = playVideo;
    exports.sndPlay = sndPlay;
    exports.sndPause = sndPause;
    exports.sndStop = sndStop;
    exports.sndResume = sndResume;
    exports.copyDir = copyDir;
    exports.multiCopyFile = multiCopyFile;
    exports.isFileExist = isFileExist;
    exports.isFileExistSync = isFileExistSync;
    exports.isDirExist = isDirExist;
    exports.isDirExistSync = isDirExistSync;
    exports.createDir = createDir;
    exports.deleteDir = deleteDir;
    exports.createDirIfNotExist = createDirIfNotExist;

    exports.saveFile = saveFile;
    exports.saveFilAsync = saveFilAsync;
    exports.XinJiang_saveFilAsync = XinJiang_saveFilAsync;
    exports.readFile = readFile;
    exports.readFileAsync = readFileAsync;
    exports.deleteFile = deleteFile;
    exports.readEncryptFile = readEncryptFile;
    exports.rename = rename;

    exports.isEncryptFileExist = isEncryptFileExist;

    exports.getHardwareInfo = getHardwareInfo;
    exports.getHardwareType = getHardwareType;
    exports.getHardwareName = getHardwareName;
    exports.checkEnvironment = checkEnvironment;

    exports.checkOnline = checkOnline;
    exports.checkOnlineAsyn = checkOnlineAsyn;
    exports.getBookLic = getBookLic;
    exports.postHttpRequest = postHttpRequest;

    exports.openPageOutside = openPageOutside;

    exports.fileDownload = fileDownload;

    //exports.connectDb = connectDb;

    exports.retriveDbAsyn = retriveDbAsyn;
    exports.executeDbAsyn = executeDbAsyn;
    exports.getFirstItemAsyn = getFirstItemAsyn;

    exports.resExport = resExport;
    exports.resImport = resImport;
    exports.getZipInnercode = getZipInnercode;
    exports.isDirEmpty = isDirEmpty;
    exports.clearDir = clearDir;
    exports.createDirSync = createDirSync;
    exports.dirSelect = dirSelect;
    exports.unzip = unzip;
    exports.saveAsDlg = saveAsDlg;
    exports.saveFileDialog = saveFileDialog;
    exports.chaptersExport = chaptersExport;

    exports.ebookMin = ebookMin;
    exports.closeApp = closeApp;
    exports.checkLocalAuthorization = checkLocalAuthorization;
    exports.desEncrpty = desEncrpty;
    exports.desDecrpty = desDecrpty;
    exports.desEncrptyWithBase64 = desEncrptyWithBase64;
    exports.getBookLicNode = getBookLicNode;
    exports.removeResLicFromMem = removeResLicFromMem;
    exports.getImageFromUrl = getImageFromUrl;

    exports.getMetaMap = getMetaMap;
    exports.openDialog = openDialog;
    exports.openFileDialog = openFileDialog;
    exports.getSystemDir = getSystemDir;
    exports.cancleDownload = cancleDownload;
    exports.shellExecute = shellExecute;
    exports.simpleShellExecute = simpleShellexecute;
    exports.shellexecutewithargs = shellexecutewithargs;

    exports.shellHide = shellHide;
    exports.uploadFile = uploadFile;

    exports.callIme = callIme;
    exports.killProcess = killProcess;
    exports.checkUrlAccess = checkUrlAccess;
    exports.asynLogin = asynLogin;
    exports.callSingleton = callSingleton;
    exports.checkRunningDiskSpace = checkRunningDiskSpace;
    exports.saveBase64AsImage = saveBase64AsImage;
    exports.checkUnzip = checkUnzip;
    exports.getExeInfo = getExeInfo;
    exports.getHttpRequest = getHttpRequest;
    exports.getTextHttpRequest = getTextHttpRequest;
    exports.getHttpRequestJSON = getHttpRequestJSON;

    exports.readRegistry = readRegistry;
    exports.mount = mount;
    exports.isAppMin = isAppMin;
    exports.uplaodByDll = uplaodByDll;
    exports.getFileTimeInfo = getFileTimeInfo;
    exports.getFileSize = getFileSize;
    exports.writeAESUserInfo = writeAESUserInfo;
    exports.beforeExitApp = beforeExitApp;
    exports.snapshot = snapshot;
    exports.FileUnzip = FileUnzip;
    exports.AfterRender = AfterRender;
    exports.getHttpRequest_mobile = getHttpRequest_mobile;
    exports.GetUpanInfo = GetUpanInfo;
    exports.createShortCut = createShortCut;
    exports.MonitorStart = MonitorStart;
    exports.MonitorSend = MonitorSend;
    exports.MonitorStop = MonitorStop;
    exports.getAllFolder = getAllFolder;
    exports.getAllFolderList = getAllFolderList;
    exports.getAllFile = getAllFile;
    exports.GetUpanList = GetUpanList;
    exports.getAllFileList = getAllFileList;
    exports.openDirSelect = openDirSelect;
    exports.rewriteAppCfg = rewriteAppCfg;
    exports.checkU = checkU;
    exports.getPicSize = getPicSize;
    exports.rewriteReaderXml = rewriteReaderXml;
    exports.getCpuId = getCpuId;
    exports.openLocalFolder = openLocalFolder;

})
