/**
 * 页面跳转类
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-9-5
 * Time: 下午3:36
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {
    var userLog = require('../app/logmgr').Instance;
    var bookAccessor = require('../app/bookshelf/bookaccessor').Instance;
    var shellcmd = require('./shellcmd');

    /**
     * 跳转到bookshelf页面
     * @param user
     */

    function goToBookShelf(user) {
        window.location.href = "bookshelf.html?user=" + user.getName() +
            "&ticket=" + user.getTicket() + "&uid=" + user.getUid()+
            "&userloginname=" + encodeURIComponent(user.getUserLoginName()) +
            "&userName=" + encodeURIComponent (user.getUserName()) + "&p=" + user.getProvince()+
            "&isonline=" + user.getIsOnline() + "&LoginFrom=" + user.getLoginForm()+
            "&isactive=" + user.getIsActive()+
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints()+
            "&books=" + user.getBooks()+
			"&SSOTicket="  + user.getSSOTicket();
    }

    /**
     * 从登录界面跳转至书架
     * @param user
     * @param password
     */
    function goToShelfFromLogin(user) {
        user.getPassword().done(function (pwd) {
            window.location.href = "bookshelf.html?user=" +  user.getName() +
                "&ticket=" + user.getTicket() + "&uid=" + user.getUid()+
                "&userloginname=" + encodeURIComponent(user.getUserLoginName())+
                "&userName=" + encodeURIComponent (user.getUserName()) + "&firstload=1"+
                "&photo=" + user.getPhoto()+ "&isactive=" + user.getIsActive()+
                "&pwd=" + encodeURIComponent (pwd)+ "&p=" + user.getProvince()+
                "&phone=" + user.getPhoneNum() + "&LoginFrom=" + user.getLoginForm()+
                "&isonline=" + user.getIsOnline()+
                "&SSOTicket="  + user.getSSOTicket();
        });
    }

    /**
     * 跳转到login页面
     * @private
     */
    function goToLogin() {
        var EduSSO = require('./sso');
        var edusso = new EduSSO(AppRemoteSvcCfg.SSOUrl, AppRemoteSvcCfg.CycoreSSOUrl);
        edusso.logout(function (result) {
            if (result && result.result) {
                if (result.result == "success") {

                    console.log("SSO logout success");
                    //登出成功处理代码;
                } else {
                    console.log("SSO logout fail");
                    //登出失败处理代码;
                }
            } else {
                console.log("SSO数据：" + result);
            }
        });

        //将单点登录上次的请求时间设为undefined
        sessionStorage["lastCheckSingleLogin"] = undefined;
        userLog.init();
        userLog.sendLog();
        window.location.href = "bookshelf.html?logout=1";
    }

    /**
     * 跳转到index页面
     * @param bookCode
     * @param user
     */
    function goToIndex(bookCode, user, pageIndex,isU) {
        if (pageIndex == "" || pageIndex == null) {
            pageIndex = 1;
        }
        var url = "index.html?bookCode=" + bookCode +
            "&user=" + user.getName() +  "&ticket=" + user.getTicket() +
            "&userName=" + encodeURIComponent(user.getUserName())  + "&p=" + user.getProvince() +
            "&userloginname=" + encodeURIComponent(user.getUserLoginName())  +
            "&isonline=" + user.getIsOnline() + "&isactive=" + user.getIsActive() +
            "&pageIndex=" + pageIndex + "&uid=" + user.getUid() +
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints() +
            "&books=" + user.getBooks()+
            "&isU=" + isU + "&SSOTicket=" + user.getSSOTicket() +
            "&LoginFrom=" + user.getLoginForm();
        window.location.href = url;
    }

    function goToWhiteBoard(user) {
        var url = "";
        bookAccessor.getLast3BookInfo(user).done(function (booklist) {
            if (booklist.length != 0 ) {
                if(booklist[0].isU){
                    shellcmd.checkU(booklist[0].isU,user.getName()).done(function(ret){
                        if(ret){
                            url = goWBhelper1(user,booklist[0].bookCode,booklist[0].lastPage,booklist[0].isU);
                            window.location.href = url;
                        }
                        else{
                            url = goWBhelper2(user);
                            window.location.href = url;
                        }
                    });
                }
                else{
                    url = goWBhelper1(user,booklist[0].bookCode,booklist[0].lastPage,"");
                    window.location.href = url;
                }
            }
            else {
                url = goWBhelper2(user);
                window.location.href = url;
            }
        });
    }

    function goWBhelper1 (user,bookCode,lastPage,isU){
       var  url = "index.html?bookCode=" + bookCode+
            "&user=" + user.getName() + "&isWB=1"+
            "&userName=" + encodeURIComponent(user.getUserName()) +
            "&ticket=" + user.getTicket() + "&SSOTicket=" + user.getSSOTicket()+
            "&isonline=" + user.getIsOnline() + "&isactive=" + user.getIsActive()+
            "&pageIndex=" + lastPage +
            "&p=" + user.getProvince() + "&uid=" + user.getUid()+
            "&phone=" + user.getPhoneNum() + "&points=" + user.getPoints()+
            "&books=" + user.getBooks()+
            "&userloginname=" + encodeURIComponent( user.getUserLoginName()) +
            "&isU=" + isU +
            "&LoginFrom=" + user.getLoginForm();
        return url ;
    }

    function goWBhelper2(user){
        var url = "singleWB.html?" + "&user="  + user.getName()  +
            "&ticket=" + user.getTicket() + "&isonline=" + user.getIsOnline() +
            "&isactive=" + user.getIsActive() + "&points=" + user.getPoints() +
            "&books=" + user.getBooks()+
            "&phone=" + user.getPhoneNum() + "&userName=" + encodeURIComponent( user.getUserName()) +
            "&p=" + user.getProvince() +
            "&uid=" + user.getUid() + "&userloginname=" +  encodeURIComponent( user.getUserLoginName()) +
            "&SSOTicket="  + user.getSSOTicket() +
            "&isU=&LoginFrom=" + user.getLoginForm();
        return url ;
    }

    exports.goToShelfFromLogin = goToShelfFromLogin;
    exports.goToBookShelf = goToBookShelf;
    exports.goToLogin = goToLogin;
    exports.goToIndex = goToIndex;
    exports.goToWhiteBoard = goToWhiteBoard;
});