/**
 * 封装映射关系
 * yczhu
 * time：13-8-2 13:51
 */
define(function (require, exports, module) {
    require('jquery');
    require('xml2json');
    var path = require('./path');
    var _shellcmd = require('./shellcmd');

    function BookItemMapping() {
        var _self = this;
        _self.subject = [];
        _self.grades = [];
        _self.publishers = [];
        _self.volumn = [];

        _self.init = function () {
            var def = $.Deferred();
            var dataPath = path.trimPosix(Config.binPath) + "share/metamap.data";
            _shellcmd.readFileAsync(dataPath).done(function(ret){
                var obj = {};
                try{
                    obj = JSON.parse(ret);
                }catch(e){
                    console.log(ret);
                }
                if(obj != null){
                    var Meta = obj.data;
                    _self.subject = Meta.subjects;
                    _self.grades = Meta.grades;
                    _self.publishers = Meta.publishers;
                    _self.volumn = Meta.volumns;
                    def.resolve(ret);
                }
                else{
                    def.resolve(ret);
                }
            });
            return def.promise();
        }

        _self.parseSubject = function (subjectCode) {
            if(_self.subject != null){
                for (var i = 0; i < _self.subject.length; i++) {
                    if (_self.subject[i].code == subjectCode) {
                        return  _self.subject[i].name;
                    }
                }
            }
        }

        _self.parseGrades = function (gradesCode) {
            if(_self.grades != null){
                for (var i = 0; i < _self.grades.length; i++) {
                    if (_self.grades[i].code == gradesCode) {
                        return  _self.grades[i].name;
                    }
                }
            }
        }

        _self.parsePublisher = function (publisherCode) {
            if(_self.publishers != null){
                for (var i = 0; i < _self.publishers.length; i++) {
                    if (_self.publishers[i].code == publisherCode) {
                        return  _self.publishers[i].name;
                    }
                }
            }
        }

        _self.parseVolumn = function (volumnCode) {
            if(_self.volumn != null){
                for (var i = 0; i < _self.volumn.length; i++) {
                    if (_self.volumn[i].code == volumnCode) {
                        return  _self.volumn[i].name;
                    }
                }
            }
        }

        /******粤教云定制******/
        _self.gradeParse = function (gradeStr){
            if(_self.grades != null){
                for (var i = 0; i < _self.grades.length; i++) {
                    if (_self.grades[i].name == gradeStr) {
                        return  _self.grades[i].code;
                    }
                }
                return "";
            }
            return "";
        }

        /******粤教云定制******/
        _self.volumnParse = function (volumnStr) {
            if(_self.volumn != null){
                for (var i = 0; i < _self.volumn.length; i++) {
                    if (_self.volumn[i].name == volumnStr) {
                        return  _self.volumn[i].code;
                    }
                }
                return "";
            }
            return "";
        }

    }

    exports.Instance = new BookItemMapping();
});