/**
 * 退出（注销）逻辑和提示
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-7-26
 * Time: 下午5:46
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {
    require('jquery');
    require('jquery_confirm');
    var path = require('./path');
    var ebookContext = require('../app/ebookcontext').Instance;
    var userLog = require('../app/logmgr').Instance;
    var bookAccessor = require('../app/bookshelf/bookaccessor').Instance;
    var userData = require('./userdata').Instance;
    var _shellcmd = require('./shellcmd');
    var _pageNavigatorHelper = require('./pagenavigatorhelper');
    var userinfoAccessor = require("../app/login/userinfoAccessor.js");
    var monitorInfo = require('./MonitorInfo').Instance;
    var bookContainer, canvasManager;

    function confirmAppExit(msg) {

        if (AppCfg.lang == "uyghur") {
            $.confirm({
                'message': msg,
                'buttons': {
                    'جەزىملەشتۈرۈش': {
                        'action': function () {
                            _shellcmd.killProcess("getres.exe");
                            _shellcmd.killProcess("uploadres.exe");
                            realExit();
                        }
                    },
                    'بىكار قىلىش': {
                        'action': function () {
                        }
                    }
                }
            });
        }
        else {
            $.confirm({
                'message': msg,
                'buttons': {
                    '确定': {
                        'action': function () {
                            _shellcmd.killProcess("getres.exe");
                            _shellcmd.killProcess("uploadres.exe");
                            _shellcmd.killProcess("Bkplayer.exe");
                            realExit();
                        }
                    },
                    '取消': {
                        'action': function () {
                        }
                    }
                }
            });
        }

        function realExit() {
            //监管平台
            var monitorMessage;
            var session_id;
            var monitorInfoData = monitorInfo.getInfoData();
            var uid = ebookContext.getUser().getUid();
            uid = uid == "0"? "" : uid;
            for (var key in monitorInfoData){
                session_id = monitorInfo.getSession_id(key);
                monitorMessage ='quit|||' + session_id + '|{"module":' + key + ', "user_id":'+uid+'}';
                monitorInfo.deleteMonitorInfo(key);

                if(key == '02'){
                    console.log('quit电子书:' + session_id);
                }
                else if(key == '03'){
                    console.log('quit黑板:' + session_id);
                }
                _shellcmd.MonitorSend(monitorMessage);
            }

            //SSO密码文件删除
            _shellcmd.beforeExitApp();
            var filePath = Config.binPath+'users/';
            _shellcmd.deleteFile(filePath + 'awdlog.cr');
            setTimeout(function(){_shellcmd.MonitorStop();},2000);
            var EduSSO = require('./sso');
            var edusso = new EduSSO(AppRemoteSvcCfg.SSOUrl, AppRemoteSvcCfg.CycoreSSOUrl);
            edusso.logout(function (result) {
                if (result && result.result) {
                    if (result.result == "success") {
                        console.log("SSO logout success");
                    //this code solve the problem that the iflybook process cannot be killed in some special conditions
                        setTimeout(function(){_shellcmd.closeApp();},2000);
                        //登出成功处理代码;
                    } else {
                        console.log("SSO logout fail");
                        setTimeout(function(){_shellcmd.closeApp();},2000);
                        //登出失败处理代码;
                    }
                } else {
                    console.log("SSO数据：" + result);
                    setTimeout(function(){_shellcmd.closeApp();},2000);
                }
            });
           _shellcmd.shellHide();
            var saveBookDataTask = saveBookData();
            //不管发送是否成功
            userLog.init();
            $.when(saveBookDataTask).done(function () {
                var task1 = userLog.sendLog();
                var task2 = userData.postToWeb();
                var getMataMapTask = getMataMapDir();
                $.when(getMataMapTask, task1, task2).done(function (ret1, ret2) {
                    _shellcmd.closeApp();
                });
            });
        }

        /**
         * 是否需要更新映射表
         * @returns {boolean}
         * @constructor
         */
        function isNeedrefrash() {
            //断网标记就是假
            if (ebookContext.getUser().getIsOnline()) {
                return true;
            }
            return false;
        }

        /**
         * 获取映射目录
         */
        function getMataMapDir() {
            var des = $.Deferred();
            if (isNeedrefrash()) {
                _shellcmd.checkOnline().done(function (canAccess) {
                    //确实联网
                    if (canAccess) {
                        var httpurl = AppRemoteSvcCfg.MataMapGetUrl;
                        _shellcmd.getMetaMap(httpurl).done(function (dataReceived) {
                            if (dataReceived == null || dataReceived == "" || dataReceived == '[]') {
                                des.resolve(null);
                                return;
                            }
                            var obj = {};
                            try {
                                obj = JSON.parse(dataReceived);
                            }
                            catch (e) {
                                des.resolve(null);
                                return;
                            }
                            if (obj.grades == null || obj.grades == "" || obj.grades == '[]') {
                                des.resolve(null);
                                return;
                            }
                            var dataPath = path.trimPosix(Config.binPath) + "share/metamap.data";

                            _shellcmd.saveFilAsync('{"data":' + dataReceived + '}', dataPath).done(function () {
                                des.resolve();
                            });
                        });
                    }
                    else {
                        des.resolve(null);
                    }
                });
            }
            else {
                des.resolve(null);
            }
            return des.promise();
        }
    }

    function init(_bookContainer, _canvasManager) {
        bookContainer = _bookContainer;
        canvasManager = _canvasManager;
    }

    /**
     * 保存书本信息（资源，笔迹，页码等）
     * @returns {*}
     */
    function saveBookData() {
        var def = $.Deferred();
        if (bookContainer && canvasManager) {
            //记录本次页面
            var bookCode = bookContainer.bookCode;
            var pageNum = "";
            var isU = "";
            //当不存在getPageIndex方法的时候，表明是白板模式。
            bookContainer.getPageIndex && (pageNum = bookContainer.getPageIndex());
            var user = ebookContext.getUser();
            if (pageNum) {
                /*在更改分辨率时，也会执行到这里，由于更改分辨率的操作执行概率很低，就放在这了*/
                /*但实际上更改分辨率的时候写数据库记住页码是个无意义的操作*/
                /*在退出电子书时会再写一次数据库，只有那个地方的记住页码有意义*/
                bookAccessor.updateLastPage(bookCode, pageNum, user).done(function () {
                    saveCanvas();
                    //2014-07-14 使用记录
                    //为教师助手留的方法，一时间没想到更好的方法。
                    var usebookCodePath = path.join(path.trimPosix(ebookContext.getUser().getUserBasePath()), 'useBook.dat');
                    bookAccessor.getLast3BookInfo(user).done(function (booklist) {
                        var _strObj = {
                            booklist: booklist
                        };
                        booklist[0] && (isU = booklist[0].isU);
                        _shellcmd.saveFilAsync(JSON.stringify(_strObj), usebookCodePath).done(function () {
                            bookContainer.dispose(true);
                            def.resolve(bookCode, pageNum, user,isU);
                        });
                    });
                });
            }
            else {
                //白板模式下只保留笔迹
                saveCanvas();
                def.resolve();
            }
        }
        else {
            def.resolve();
        }
        return def.promise();
    }

    function saveCanvas() {
        var strokeCanvas = canvasManager.getStrokeCanvas();
        if (strokeCanvas) {
            bookContainer.paintStrokeWithoutDrag(strokeCanvas[0], canvasManager.getIsStrokeChanged(),canvasManager.getStrokes());
            bookContainer.saveStrokesToLocal();
        }
    }

    /**
     *  判断是否存在上传下载进程
     */
    function findUpDownLoad() {
        var def = $.Deferred();
        var task1 = _shellcmd.findProcess("getres.exe");
        var task2 = _shellcmd.findProcess("uploadres.exe");
        /*没有进程返回0，有下载返回1，有上传返回2，都有返回3
         */
        if (getGlobalUploadInfo() == 6){
            def.resolve(3);
        }
        else{
            $.when(task1, task2).done(function (num1, num2) {
                console.log(num1 + "..." + num2);
                if (num1 == 0 && num2 == 0) {
                    def.resolve(0);
                }
                else if (num1 == 0 && num2 != 0) {
                    def.resolve(2);
                }
                else if (num1 != 0 && num2 == 0) {
                    def.resolve(1);
                }
                else if (num1 != 0 && num2 != 0) {
                    def.resolve(3);
                }
            });
        }
        return def.promise();
    }

    /**
     * 判断提示语
     */
    function alertTips() {
        var def = $.Deferred();
        findUpDownLoad().done(function (num) {
            switch (num) {
                case 1:
                    def.resolve(AppTips.ExistDownLoadProcess);
                    break;
                case 2:
                    def.resolve(AppTips.ExistUpLoadProcess);
                    break;
                case 3:
                    def.resolve(AppTips.ExistUpDownLoadProcess);
                    break;
                default:
                    _shellcmd.checkUnzip().done(function (ret) {
                        if (ret) {
                            def.resolve(AppTips.DoingUnZipMsg);
                        } else {
                            def.resolve(AppTips.EnSureLogOut);
                        }
                    });
            }
        });
        return def.promise();
    }

    /**
     * 退出提示
     */
    function ExitAlert() {
        alertTips().done(function (retString) {
            confirmAppExit(retString);
        });
    }

    /**
     *注销提示
     */
    function GoToLoginAlert() {
        alertTips().done(function (retString) {
            if (retString == AppTips.EnSureLogOut) {
                retString = AppBookShelfTipsList.EnSureToCancellation;
            }
            $.Zebra_Dialog(retString, {
                'type': 'question',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.CancelTips, AppTips.OkTips],
                'onClose': function (capition) {
                    if (capition == AppTips.OkTips) {
                        _shellcmd.killProcess("getres.exe");
                        _shellcmd.killProcess("uploadres.exe");
                        //删除awdlog.cr文件
                        var filePath = Config.binPath+'users/';
                        _shellcmd.deleteFile(filePath + 'awdlog.cr');
                        //用记住密码字段区分下次是否自动登录
                        userinfoAccessor.rememberPwd(ebookContext.getUser().getName()).done(function () {
                            window.location.href = "bookshelf.html?logout=1";
                        });
                    }
                }
            });
        });
    };

    /**
     * 重新加载Index页面，分辨率更改时调用
     */
    function refreshIndex() {
        saveBookData().done(function (bookCode, pageNum, user,isU) {
            if (bookCode) _pageNavigatorHelper.goToIndex(bookCode, user, pageNum,isU);
            else history.go(0);
        })
    }

    exports.GoToLoginAlert = GoToLoginAlert;
    exports.ExitAlert = ExitAlert;
    exports.saveBookData = saveBookData;
    exports.init = init;
    exports.refreshIndex = refreshIndex;
})