/**
 * 定义公用函数库
 * Created with JetBrains WebStorm.
 * User: qmjie
 * Date: 13-9-5
 * Time: 下午3:44
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {
    /**
     *  禁用拖放打开本地文件操作
     */
    function disabledDragLocalFiles() {
        $(document).bind({
            dragenter: function (e) {
                e.stopPropagation();
                e.preventDefault();
                var dt = e.originalEvent.dataTransfer;
                dt.effectAllowed = dt.dropEffect = 'none';
            },
            dragover: function (e) {
                e.stopPropagation();
                e.preventDefault();
                var dt = e.originalEvent.dataTransfer;
                dt.effectAllowed = dt.dropEffect = 'none';
            }
        });
    }

    function disabledDropLocalFiles() {
        $(document).bind({
            dragover: function (e) {
                e.stopPropagation();
                e.preventDefault();
                var dt = e.originalEvent.dataTransfer;
        //        console.log("common dragover:" + dt.effectAllowed + " | " + dt.dropEffect);
                dt.effectAllowed = dt.dropEffect = 'move';
            },
            dragStart: function (e) {
                return false;
            },
            drop: function (e) {
                return false;
            }
        });
    }

    function newGuid() {
        var guid = "";
        for (var i = 1; i <= 32; i++) {
            var n = Math.floor(Math.random() * 16.0).toString(16);
            guid += n;
            if ((i == 8) || (i == 12) || (i == 16) || (i == 20))
                guid += "-";
        }
        return guid;
    }

    /**
     * 检测网络连接异常接口
     * @param url
     * @param iframe
     * @param tipsStyle
     * @param panel
     * @param handle
     */
    function online(url, iframe, tipsStyle, panel, handle,user) {
        iframe.hide();
        panel.find(".tips_box").remove();
        //显示网络连接提示语
        var tipsBox = $('<div class="tips_box"> ' +
            '<img src="assert/images/waiting.gif"/>' +
            '</div>  ');
        tipsBox.attr("style", tipsStyle);
        panel.append(tipsBox);
        var param ={
            type: "GET",
            url: AppRemoteSvcCfg.OnlineCheckUrl,
            version : AppCfg.version,
            product : AppCfg.product
        };
        if (AppCfg.ajaxTimeOut && AppCfg.ajaxTimeOut > 0) {
            param.timeout = AppCfg.ajaxTimeOut
        }
        $.ajax(param)
            .done(function (data) {
                user.showIsOnline(true);
                panel.find(".tips_box").remove();
                console.log(url);
                iframe.attr("src", url);
                iframe.show();
            })
            .error(function (XMLHttpRequest, textStatus, errorThrown) {
                user.showIsOnline(false);
                panel.find(".tips_box").remove();
                //显示网络连接提示语
                tipsBox = $('<div class="tips_box"> ' +
                    '<img src="assert/images/loader.gif"/>' +
                    '</div>  ');
                tipsBox.attr("style", tipsStyle);
                panel.append(tipsBox);
                tipsBox.html(AppResTipList.badWeb);
                if (handle != undefined)
                    handle();
            });
    }

    exports.disabledDragLocalFiles = disabledDragLocalFiles;
    exports.disabledDropLocalFiles = disabledDropLocalFiles;
    exports.newGuid = newGuid;
    exports.online = online;

})