/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-12-12
 * Time: 上午11:44
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {

        function BookDirectoryParser(remoteBookJson, localBookJson) {
            _self = this;
            this._remoteBookJson = remoteBookJson;
            this._localBookJson = localBookJson;
          //  console.log(JSON.stringify(localBookJson));
            console.log(JSON.stringify(remoteBookJson));
            this.parseJson = function () {
                var book = {};
                var indexInfo = {}, filePath = '', doubleLanguage = false, pageImageSize = {}, units = {};  //第二层
                //基本信息使用本地XML转JSON后的数据
                try {
                    indexInfo = _self._localBookJson.IndexInfo;
                    filePath = _self._localBookJson.FilePath;
                    doubleLanguage = _self._localBookJson.DoubleLanguage;
                    pageImageSize = _self._localBookJson.PageImageSize;
                    var remoteUnits = _self._remoteBookJson.data;
                    var resUnits = [];
                    var curPageIndex = 1;

                    for (var i in remoteUnits) {
                        var tempUnit = {};
                        var nextUnit = null;
                        /***********************************************************************
                         *这个Code具体是做什么我也不知道，请保持结构，不要轻易更改。
                         *                        ------------  by  yczhu
                         ***********************************************************************/
                        tempUnit.Code = remoteUnits[i].PageCode;
                        tempUnit.UnitCode = remoteUnits[i].Code;
                        tempUnit.Name = remoteUnits[i].Name;
                        if (i < remoteUnits.length - 1)
                            nextUnit = remoteUnits[parseInt(i) + 1];
                        var pageRes = _self.adjustPages(curPageIndex, remoteUnits[i], nextUnit);
                        tempUnit.Pages = pageRes.Pages;
                        //把curPageIndex返回，传递出来，下一轮继续推算
                        curPageIndex = pageRes.curPageIndex;
                        tempUnit.Courses = _self.adjustCourses(remoteUnits[i], tempUnit.Pages.BookPage);
                        //这两个数据在随书XML中没有，可以添加
                        tempUnit.PageCode = remoteUnits[i].PageCode;
                        tempUnit.PageCodeEnd = remoteUnits[i].PageCodeEnd;
                        resUnits.push(tempUnit);

                        /*
                        tempUnit.Code = remoteUnits[i].PageCode;
                        tempUnit.UnitCode = remoteUnits[i].Code;
                        tempUnit.Name = remoteUnits[i].Name;
                        var nextUnit = null;
                        if (i < remoteUnits.length - 1)
                            nextUnit = remoteUnits[parseInt(i) + 1];
                        var pageRes = _self.adjustPages(curPageIndex, remoteUnits[i], nextUnit);
                        tempUnit.Pages = pageRes.Pages;
                        //把curPageIndex返回，传递出来，下一轮继续推算
                        curPageIndex = pageRes.curPageIndex;
                        tempUnit.Courses = _self.adjustCourses(remoteUnits[i], tempUnit.Pages.BookPage);
                        //这两个数据在随书XML中没有，可以添加
                        tempUnit.PageCode = remoteUnits[i].PageCode;
                        tempUnit.PageCodeEnd = remoteUnits[i].PageCodeEnd;
                        resUnits.push(tempUnit);
                        */
                    }

                    book = {
                        IndexInfo: indexInfo,
                        FilePath: filePath,
                        DoubleLanguage: doubleLanguage,
                        PageImageSize: pageImageSize,
                        DownloadDate: new Date().toUTCString(), //记录下载日期，用于更新
                        Units: {
                            Unit: resUnits
                        }
                    }
                    console.log(JSON.stringify(book));
                    return book;
                } catch (ex) {   //转换失败
                    console.log("merge book dir fail");
                    return null;
                }
            }

            /**
             *  将远程json中的Pages信息转换
             * @param preUnit 调整后的上一单元
             * @param curUnit 调整前的当前单元
             */
            this.adjustPages = function (curPageIndex, curUnit, nextUnit) {
                var bookPages = [];
                var singlePage = {};
                if (isNaN(curUnit.PageCode)) {   //如果不是数字，目录部分
                    if (curUnit.PageCode == curUnit.PageCodeEnd) {    //如果只有一页
                        singlePage.Code = curPageIndex.toString();
                        curPageIndex++;
                        singlePage.Name = curUnit.PageCode;
                    } else {      //如果有多页
                        //len不是数组长度，是字符串长度
                        var len = curUnit.PageCode.length;
                        for (var i = 0; i < len && isNaN(curUnit.PageCode.charAt(i), 10); i++);
                        //首端字符
                        var letter = curUnit.PageCode.substring(0, i);
                        var start = parseInt(curUnit.PageCode.substring(i));
                        var end = parseInt(curUnit.PageCodeEnd.substring(i));
                        for (var p = start; p <= end; p++) {
                            var bookPage = {};
                            bookPage.Code = curPageIndex.toString();
                            curPageIndex++;
                            bookPage.Name = letter + p;
                            bookPages.push(bookPage);
                        }
                    }
                } else {
                    var startPageCode = parseInt(curUnit.PageCode);
                    var endPageCode = parseInt(curUnit.PageCodeEnd);
                    var i = startPageCode;
                    /**********************************************************************
                     * 远程获取的pageCode对客户端无实际意义。客户端是没有pageCode的概念的。
                     * 客户端的pageIndex是包括目录所在的页码的。
                     * 只能根据pageIndex一点点推。
                     * 这里，把物理文件的pageIndex存储为Code，
                     * 把远程获取到的PageCode存为Name。
                     * 在我修改这一段的时候，pages是长这样的：
                     *  {
                     *       "Code": "1",
                     *       "Name": ""
                     *   }
                     *   远程获取的Name是个无聊的值。
                     *
                     *              ------------- by yczhu 2014.8.30
                     *****************************************************************************/
                    for (; i <= endPageCode; i++) {
                        var bookPage = {};
                        bookPage.Code = curPageIndex.toString();
                        curPageIndex++;
                        bookPage.Name = i.toString();
                        bookPages.push(bookPage);
                    }

                    //如果和下一单元的起始页码一样，需要去掉
                    if (nextUnit && !(isNaN(nextUnit.PageCode))&& i-1 ==parseInt(nextUnit.PageCode)){
                        bookPages.pop();
                        curPageIndex--;
                    }

                    if(bookPages.length==1){
                    //如果只有一页，需要转换为对象，和随书XML兼容
                        singlePage.Code = bookPages[0].Code;
                        singlePage.Name =  bookPages[0].Name;
                    }else if(bookPages.length==0){
                    //如果没有页，用空字符串，和随书XML兼容
                        singlePage="";
                    }
                }

                //组织数据，兼容随书XML
                var tempBookPages = "";
                if (bookPages.length > 1) {
                    tempBookPages = {
                        BookPage: bookPages
                    }
                } else if (singlePage != "") {
                    tempBookPages = {
                        BookPage: singlePage
                    }
                }
                var res = {
                    Pages: tempBookPages,
                    curPageIndex: curPageIndex
                }
                return res;
            }

            /**
             *  将远程json中的Courses信息转换
             * @param curUnit 调整前的当前所有Page
             */
            this.adjustCourses = function (curUnit, bookPages) {
                if (!curUnit.Courses || curUnit.Courses.length == 0) {
                    return "";
                }
                var unitCourses = [];
                for (var i in curUnit.Courses) {
                    var course = {};
                    course.Code = curUnit.Courses[i].Code;
                    course.Name = curUnit.Courses[i].Name;
                    course.PageCode = curUnit.Courses[i].PageCode;
                    course.PageCodeEnd = curUnit.Courses[i].PageCodeEnd;
                    course.ImageIndex = _self.getPageIndex(curUnit.Courses[i].PageCode, bookPages);
                    unitCourses.push(course);
                }
                var Courses = {
                    Course: unitCourses
                }
                return Courses;
            }

            /**
             *
             * @param pageCode
             * @param bookPage pageCode所在单元的Pages
             * @returns {*}
             */
            this.getPageIndex = function (pageCode, bookPages) {
                //debugger;
                if(bookPages.length){
                    for (var i in bookPages) {
                        if (bookPages[i].Name == pageCode) {
                            return bookPages[i].Code;
                        }
                    }
                    return  bookPages[0].Code;
                }
                else{
                    return  bookPages.Code;
                }
            }
        }

        exports.BookDirectoryParser = BookDirectoryParser;
    }
)
;