﻿/**
 * 全局播放器
 * @type {null}
 */
var app_global_playerMgr = null;

var app_iframe_arr = [];

var app_global_resLibMgr = null;
var app_global_bookLibMgr = null;
var app_global_yjbookLibMgr = null;
var app_global_rescontentMgr = null;
var app_global_searchMgr = null;
var app_global_classPresentationMgr = null;
var app_global_feedbackMgr = null;

var app_global_bookContainer = null;

var app_global_loginMgr = null;
var app_global_screenSaversMgr = null;
var app_global_bookShelfMsg = null;
var app_global_isnocamera = false;

var app_global_resUpdateMgr = null;

var app_global_isMainToolBarUp = true;

var app_global_CloudresourceBase = null;

var app_global_alertNotEdit = null;

var app_global_curWidget = null;

var newWidgetPos = null;

var app_ClientToken = null;

//粤教云token
var app_YueJiaoToken = null;

//smartbar中预览时，设置一个标志位，在预览页面左右箭头键不再翻页
var global_flag = false;

//打开云资源库窗口时，设置一个标志位，鼠标滚轮事件只针对当前云资源库
var global_scoll_flag = false;

var global_scoll_flag2 = false;

var global_scoll_flag3 = false;

var global_uploadInfo = 0;

var global_blackboardFlag = false;
/**
 * 注册全局函数
 */
InjectGlobal();

function getBlackboardFlag(){
    return global_blackboardFlag;
}
function setBlackboardFlag(flag){
    global_blackboardFlag = flag;
}

function setGlobalUploadInfo(uploadState){
    global_uploadInfo = uploadState;
}

function getGlobalUploadInfo(){
    return global_uploadInfo;
}

function InjectGlobal() {
    _injectStringMethod();
}

function setGlobalCurWidget(CurWidget) {
    app_global_curWidget = CurWidget;
}

function setGlobalContextCloudresourceBase(CloudresourceBase) {
    app_global_CloudresourceBase = CloudresourceBase;
}

function setGlobalContextResLibMgr(resLibMgr) {
    app_global_resLibMgr = resLibMgr;
}

function setGlobalContextBookLibMgr(bookLibMgr) {
    app_global_bookLibMgr = bookLibMgr;
}

function setGlobalContextYJBookLibMrg(yjbookLibMgr){
    app_global_yjbookLibMgr = yjbookLibMgr;
}

function setGlobalContextResContMgr(resContMgr){
    app_global_rescontentMgr = resContMgr;
}

function setGlobalfeedbackMgr(feedbackMgr) {
    app_global_feedbackMgr = feedbackMgr;
}

function setGlobalContextSearchMgr(searchMgr) {
    app_global_searchMgr = searchMgr;
}

function setGlobalContextClassPresentaionMgr(classPresentaionMgr) {
    app_global_classPresentationMgr = classPresentaionMgr;
}

function setGloabalContextPlayer(player) {
    app_global_playerMgr = player;
}

function getGlobalContextPlayer() {
    return app_global_playerMgr;
}

function getGlobalBookContainer() {
    return app_global_bookContainer;
}

function setGlobalBookContainer(bookContainer) {
    app_global_bookContainer = bookContainer;
}

function setGlobalBookShelfMsg(bookShelfMsg) {
    app_global_bookShelfMsg = bookShelfMsg;
}

function setGlobalLoginMgr(loginMgr) {
    app_global_loginMgr = loginMgr;
}

function setGlobalResUpdateMgr(resUpdateMgr) {
    app_global_resUpdateMgr = resUpdateMgr;
}
/**
 * 注册客户端消息发送的对象(iframe)
 * @param {string} iframeId
 * @param targetUrl :postmessage的 target 域名
 */
function registerIframe(iframeId, targetUrl) {
    app_iframe_arr.push([iframeId, targetUrl]);
}

/**
 * 反注册客户端消息发送的对象
 * @param iframeId
 */
function unregisterIframe(iframeId) {
    app_iframe_arr.filter(function (ele) {
        return ele[0] != iframeId;
    });
}

function _injectStringMethod() {
    //添加format方法
    if (!String.prototype.format) {
        String.prototype.format = function () {
            var args = arguments;
            return this.replace(/{(\d+)}/g, function (match, number) {
                return typeof args[number] != 'undefined'
                    ? args[number]
                    : match
                    ;
            });
        };
    }
    // 添加startWith 方法
    if (typeof String.prototype.startsWith != 'function') {
        // see below for better implementation!
        String.prototype.startsWith = function (str) {
            return this.indexOf(str) == 0;
        };
    }
    //添加endWith 方法
    if (typeof String.prototype.endsWith != 'function') {
        String.prototype.endsWith = function (str) {
            return this.slice(-str.length) == str;
        };
    }
}

/**
 * 调用客户端命令
 * @param {string} cmdRegion 模块名称
 * @param {string} cmdName 命令名
 * @param {string} cmdArgs 多个参数，参数间使用|分隔
 * @param {string=} cmdType 命令类别    0(执行完了可以立即销毁),1,2(内部有多线程,不能立即销毁)
 * @returns {string}
 */
function callClient(cmdRegion, cmdName, cmdArgs, cmdType, callback) {
    var funcName = cmdRegion + '.' + cmdName;
    if (callback) {
        var wrapper = function (name, args) {
            callback(args[0]);
        };
        cef.message.sendMessage(funcName, [cmdArgs, cmdType.toString()]);
        cef.message.setMessageCallback(funcName, wrapper);
    } else {
        //无回调
        cef.message.sendMessage(funcName, [cmdArgs, cmdType.toString()]);
    }
}

function sendCefMsg(funcName, args, callback) {
    if (callback) {
        var wrapper = function (name, args) {
            callback(args[0]);
        };
        cef.message.sendMessage(funcName, args);
        cef.message.setMessageCallback(funcName, wrapper);
    } else {
        cef.message.sendMessage(funcName, args);
    }
}


/**
 * 客户端调用页面函数名
 * @param msg是个json 结构为 {evt:eventname,data:somedata}
 */
function onClientInvoked(msg) {
    // console.log('onClientInvoked:'+ msg);
    if (!msg) return;
    msg = msg.replace(/\\/g,'\\\\');
    var obj = JSON.parse(msg);
    if (obj) {
        if (obj.evt.startsWith('play_') && app_global_playerMgr) {
            app_global_playerMgr.onMessageReceived(obj);
        }
        if (obj.evt.startsWith('file_download')) {
            if (obj.data.sourcepage == 'reslib' && app_global_resLibMgr) {
                app_global_resLibMgr.onMessageReceived(obj);
            } else if ((obj.data.sourcepage == 'booklib' || obj.data.sourcepage == 'booklibres') && app_global_bookLibMgr) {
                app_global_bookLibMgr.onMessageReceived(obj);
            } else if( (obj.data.sourcepage == 'yjbooklib') && app_global_yjbookLibMgr){
                app_global_yjbookLibMgr.onMessageReceived(obj);
            } else if (obj.data.sourcepage == 'searchresult' && app_global_searchMgr) {
                app_global_searchMgr.onMessageReceived(obj);
            } else if (obj.data.sourcepage == 'classpresentation' && app_global_classPresentationMgr) {
                app_global_classPresentationMgr.onMessageReceived(obj);
            } else if ((obj.data.sourcepage == 'bookupdate' || obj.data.sourcepage == 'resupdate') && app_global_resUpdateMgr) {

                app_global_resUpdateMgr.onMessageReceived(obj);
            } else if (obj.data.sourcepage == 'CloudresourceBase' && app_global_CloudresourceBase) {
                app_global_CloudresourceBase.onMessageReceived(obj);
            } else if(obj.data.sourcepage =='resourcecontent' || obj.data.sourcepage == 'resourcecontentsave'){
                app_global_rescontentMgr.onMessageReceived(obj);

            }

        }
        if (obj.evt.startsWith('mtbkunzip') && app_global_bookContainer) {
            app_global_bookContainer.onMessageReceived(obj);
        }
        if (obj.evt.startsWith('change_pageIndex')) {
            if (typeof obj.data.index == "number") {
                app_global_bookContainer.onMessageReceived(obj);
            }
        }
        if (obj.evt.startsWith('get_pageIndex')) {
            app_global_bookContainer.onMessageReceived(obj);
        }
        if (obj.evt.startsWith('get_openedWidgetId')) {
            app_global_bookContainer.onMessageReceived(obj);
        }
        if (obj.evt == "checknetaccess" || obj.evt == "tryonlinelogin") {
            app_global_loginMgr.onMessageReceived(obj);
        }
        if (obj.evt.startsWith('saveResAndPaint')) {
            app_global_bookContainer.onMessageReceived(obj);
        }

        if (obj.evt.startsWith('videocap')) {
            app_global_bookContainer.onMessageReceived(obj);
        }

        if (obj.evt.startsWith('showvideocap')) {
            app_global_bookContainer.onMessageReceived(obj);
        }

        if (obj.evt.startsWith('ebookreactive')) {
            //console.log(obj.data);
            //sessionStorage['isBookMin']=false;
            app_global_screenSaversMgr && app_global_screenSaversMgr.setScreenSavers(true);
        }

        if (obj.evt.startsWith('nocamera')) {
            if (app_global_isnocamera == false) {
                app_global_isnocamera = true;
                $.Zebra_Dialog(AppCameraTips.NoCamera, {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [ AppTips.OkTips],
                    'onClose': function (capition) {
                        app_global_isnocamera = false;
                    }
                });
            }
        }
        if (obj.evt.startsWith('uploadcallback')) {
            app_global_bookContainer.onMessageReceived(obj);
        }
        if (obj.evt.startsWith('appclosing')) {
            if (app_global_bookContainer) app_global_bookContainer.onMessageReceived(obj);
            if (app_global_bookShelfMsg)  app_global_bookShelfMsg.onMessageReceived(obj);
            if (app_global_loginMgr) app_global_loginMgr.onMessageReceived(obj);
        }

        if (obj.evt.startsWith( 'displaychange')) {//屏幕分辨率改变回调
            console.log('displayChanged');
            app_global_bookContainer ? app_global_bookContainer.onMessageReceived(obj) : (window.location.href = "bookshelf.html");
            console.log(msg);
        }

        if (obj.evt.startsWith('uploaddllcall')) {
            /*the JS callback had been discard , but we can see the upload informations by this method*/
            console.log(obj.evt);
            console.log(obj.type);
            console.log(obj.data);

            if (obj.type == '6'){
                tipsDialog({
                    "id" : "uploading" + new Date().getTime(),
                    "content" : "上传中..."
                    }
                );
            } else  if (obj.type == '3'){
                tipsDialog({
                        "id" : "uploadStart" + new Date().getTime(),
                        "content" : "上传开始"
                    }
                );
            } else if (obj.type == '5'){
                tipsDialog({
                        "id" : "failure" + new Date().getTime(),
                        "content" : "上传失败"
                    }
                );
            } else if (obj.type == '2'){
                tipsDialog({
                        "id" : "noSource" + new Date().getTime(),
                        "content" : "源文件不存在"
                    }
                );
            }else if (obj.type == '1'){
                tipsDialog({
                        "id" : "uploadManagerBroken" + new Date().getTime(),
                        "content" : "上传管理器异常，请重启iflybook"
                    }
                );
            }
            if(obj.data && obj.data.data) app_global_CloudresourceBase.onMessageReceived(obj);
            setGlobalUploadInfo(obj.type);
        }


        if (obj.evt.startsWith('audiorecord')) {
            app_global_bookContainer.onMessageReceived(obj);
        }

        if (obj.evt.startsWith('resstartupload')){
           app_global_bookContainer.onMessageReceived(obj);
        }

        if (obj.evt.startsWith('closeApp')){
           if (app_global_bookShelfMsg) app_global_bookShelfMsg.onMessageReceived(obj);
            app_global_bookContainer.onMessageReceived(obj);
        }

        if (obj.evt.startsWith('screenshot')){
            app_global_bookContainer.onMessageReceived(obj);
        }
    }
    dispatchClientMsg(msg);
}

/**
 *
 */
function dispatchClientMsg(msg) {
    for (var i = 0; i < app_iframe_arr.length; i++) {
        try {
            var iframe = document.getElementById(app_iframe_arr[i][0]);
            iframe.contentWindow.postMessage(msg, app_iframe_arr[i][1]);
        }
        catch (e) {
            app_iframe_arr.splice(i--, 1);    //  删除出错的iframe
        }
    }
}

//是否在壳内运行，而不是在真实的浏览器中运行
function isShellRunning() {
    return typeof cef !== 'undefined';
}

/**
 *
 * @param object
 * @returns {boolean}
 * @constructor
 */
function isString(object) {
    if (!object)
        return false;
    return object.constructor === String;
}
/**
 * 用以显示语音卡片中的Flash对象
 */
function showFlash() {
    dispatchClientMsg({evt: 'showFlash'});
}

/**
 *  默认的基准值分辨率
 */
var base_resolution = {
    width: 1024,
    height: 768,
    max_width: typeof Config != 'undefined' ? Config.Width : 1024,
    max_height: typeof Config != 'undefined' ? Config.Height : 768
}

//页面的基准分辨率
var page_base_resolution = {
    width: 1640,
    height: 922
}

/**
 *  * 参照一个基准分辨率进行放缩，基准值是  1024,768
 * @param {object=} obj
 * @param {obj=}  isScaleFromCenter 是否从中心点缩放 scaleOrder:缩放顺序，为true时分辨率与放缩倍数成正相关 默认为true  keepScale 为true时保持长宽都是同一放缩比例默认为false
 * @returns {Array}  放缩矩阵
 */
function correctToBaseResolution(obj, options) {
    var scale = [1, 0, 0, 1, 0, 0];
    options = options || {};
    var parms = $.extend({}, base_resolution, options);

    //减去window任务栏的高度
    if (parms.max_height - Config.Height) parms.max_height -= 30;
    var scaleX, scaleY;
    if (parms.width == parms.max_width) return scale;

    var scaleFromCenter = parms.scaleFromCenter == undefined ? true : parms.scaleFromCenter;
    var scaleOrder = parms.scaleOrder == undefined ? true : parms.scaleOrder;


    if (scaleOrder) {
        scaleX = parms.max_width / parms.width;
        scaleY = parms.max_height / parms.height;

        scale[0] = scaleX >= 1 ? 1 : scaleX;
        scale[3] = scaleY >= 1 ? 1 : scaleY;
    }
    else {
        scaleX = parms.width / parms.max_width * 1.1;
        scaleY = parms.height / parms.max_height * 1.1;
        scale[0] = scaleX <= 1 ? 1 : (scaleX <= 1.5 ? scaleX : 1.5);
        scale[3] = scaleY <= 1 ? 1 : (scaleY <= 1.5 ? scaleY : 1.5);
    }

    if (parms.keepScale) scale[0] = scale[3] = Math.min(scale[0], scale[3]);

    if (obj) {
        var objArray = $.makeArray(obj);
        $.each(objArray, function (i, obj) {
            obj = $(obj);
            var elementWidth = obj.outerWidth(), elementHeight = obj.outerHeight();

            var scaleXFromCenter = scaleFromCenter, scaleYFromCenter = scaleFromCenter;
            if (elementWidth > parms.max_width || elementHeight > parms.max_height) {
                if (scaleXFromCenter = elementWidth > parms.max_width) {
                    scale[4] += (parms.max_width - elementWidth * scale[0]) / 2;
                    scaleXFromCenter = false;
                }
                else scaleXFromCenter = true;
                if (elementHeight > parms.max_height) {
                    scale[5] += (parms.max_height - elementHeight * scale[3]) / 2;
                    scaleYFromCenter = false;
                }
                else scaleYFromCenter = true;
            }

            if (!scaleXFromCenter) scale[4] += scaleOrder ? (-(1 - scale[0]) * elementWidth / 2) : (scale[0] - 1) * elementWidth / 2;
            if (!scaleYFromCenter) scale[5] += scaleOrder ? (-(1 - scale[3]) * elementHeight / 2) : (scale[3] - 1) * elementHeight / 2;

            if (!(scale[0] == 1 && scale[3] == 1)) obj.css('-webkit-transform', 'matrix(' + scale.join(',') + ')');
        });
    }

    return scale;
}

/**
 * 加载提示对话框
 * @param {object=} options  {tips:提示内容，parent:对话框父元素}
 */
function showLoading(options) {
    hideLoading();
    options = options || {};

    var loadLeft = 0, loadTop = 0, loadWidth = $(window).width() , loadHeight = $(window).height();
    if (!options.tips) options.tips = AppTips.DefaultLoadingTips;
  //  options.tips = "";
    if (options.parent) {
        if (!(options.parent instanceof jQuery)) options.parent = $(options.parent);
        var offset = options.parent.offset();
        loadLeft = offset.left;
        loadTop = offset.top;
        loadWidth = options.parent.outerWidth();
        loadHeight = options.parent.outerHeight();
    }

    var loadingContent = $('<div style="position: absolute;opacity: 0.9;z-index: 10000;" id="loading_tip"> ').
        css({left: loadLeft, top: loadTop, width: loadWidth, height: loadHeight});
    var loadingBox = $('<div class="loading_box" style="position: absolute"> ' +
        '<div class="cancelBtn" style="position:absolute;right: 5px;top: 5px;display: none"><image src="assert/images/pop_close.png"></image></div>' +
        ' <div class="pic"><img src="assert/images/loading.gif" style="width:48px;height:48px;margin-top: 3px;"></div> ' +
        ' <div class="zi">' +
        options.tips +
        '</div>  ' +
        '</div></div>');

//    if (AppCfg.lang == "uyghur") {
//        loadingBox = $('<div class="loading_box" style="position: absolute"> ' +
//            '<div class="cancelBtn" style="position:absolute;right: 5px;top: 5px;display: none"><image src="assert/images/pop_close.png"></image></div>' +
//            ' <div class="pic"><img src="assert/images/loading.gif"></div> ' +
//            ' <div class="zi" style="direction:rtl;">' +
//            options.tips +
//            '</div>  ' +
//            '</div></div>');
//    }


    loadingContent.append(loadingBox);
    $('body').append(loadingContent);
    loadingBox.css({
        position: 'absolute',
        left: (loadWidth - loadingBox.outerWidth()) / 2,
        top: (loadHeight - loadingBox.outerHeight()) / 2 + $(document).scrollTop()
    });

    if (AppCfg.loadTimeOut > 0) {
        setTimeout(function () {
            loadingBox.find('.cancelBtn').show().bind('click', function () {
                hideLoading();
                event.stopPropagation();
            })
        }, AppCfg.loadTimeOut);
    }
}

function hideLoading() {
    $("#loading_tip").remove();
}

function showAlertTips(tips){
    $.Zebra_Dialog(tips, {
        'type': 'information',
        'title': AppTips.WarmTips,
        'zIndex': 1000,
        'buttons': [AppTips.OkTips]
    });
}

/**
 * 东阳登录回调
 */
function onLoginSuccess(info){
    $("#E_Odiv").hide();
    console.log(1+"--------"+info);
    showLoading({tips: '正在登录中请稍候...'});
    app_global_loginMgr.loginFunction(info,"111111");
}

/**
 * flash播放器组件结束回调
 */
function endHostPlay(){
    app_global_playerMgr._currPlayer.trigger('ended');
}

/**
 * Js时间格式化（网上抄的）
 */
Date.prototype.Format = function (fmt) {
    var o = {
        "M+": this.getMonth() + 1,                 //月份
        "d+": this.getDate(),                    //日
        "h+": this.getHours(),                   //小时
        "m+": this.getMinutes(),                 //分
        "s+": this.getSeconds(),                 //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds()             //毫秒
    };
    if (/(y+)/.test(fmt))
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt))
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
}






