define(function (require, exports) {

    var shellcmd = require('./common/shellcmd');
    var path = require('./common/path');
    var userLog = require('./app/logmgr').Instance;
    var confirmExit = require('./common/confirmExit');
    var _pageNavigatorHelper = require('./common/pagenavigatorhelper');
    var ebookContext = require('./app/ebookcontext').Instance;

    //禁用某些快捷键
    function disableKey() {
        $("body").keydown(function (e) {
            //如果type存在，则是text节点
            //反之是body，如果发现问题，再处理
            if (e.which == 8 && (!e.target.type)) {
                return false;
            }
            //屏蔽Alt+X热键（这里屏蔽了Alt键）
            if (e.which == 18 && (!e.target.type)) {
                return false;
            }
        });
    }

    //获得页面参数的方法
    function QueryString(val) {
        var uri = window.location.search;
        var reg = new RegExp("" + val + "=([^&?]*)", "ig");
        return ((uri.match(reg)) ? (uri.match(reg)[0].substr(val.length + 1)) : null);
    }

    //创建快捷方式
    function createShortCut() {
        if (AppCfg.isShortCut == false) {
            //create shortCut , just be showed at the first time after user login;
            var tips = $("<div><p style = 'margin-left: 0px;margin-top: 4px;font-size: 15px;color:black;'>确定创建快捷方式?</p>" +
                "<p style='margin-top: 6px;margin-bottom: 10px;'><a id='a_t' style='margin-left: 0px;font-size: 13px;color:rgb(140,140,140);'>默认创建到桌面</a>" +
                "<a id='tips' style='color:rgb(5,135,245);margin-left: 88px;font-size: 13px;cursor:pointer;'>更改路径</a></p></div></div>");
            var shortCutPath = '';
            tips.find('#tips').click(function () {
                shellcmd.openDirSelect().done(function (ret) {
                    if (ret != "") {
                        tips.find('#a_t').html(ret);
                        shortCutPath = ret;
                    }
                });
            });
            $.Zebra_Dialog(tips, {
                'type': 'ibicon',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.CancelTips, AppTips.CreateTips],
                'onClose': function (capition) {
                    if (capition == AppTips.CreateTips) {
                        shellcmd.createShortCut(shortCutPath);
                    }
                }
            });
            shellcmd.rewriteAppCfg(path.trimPosix(Config.binPath) + 'webapp/assert/js/appcfg.js');
        }
    }

    /**
     * 启动上传
     */
    function StartUpload(ebookuser) {
        //写上传参数文件，启动上传器
        ebookuser.setDynamicToken().done(function (token) {
            var obj = {
                'appkey': 'HWQIjW2K',
                'token': token,
                'uid': ebookuser.getUid(),
                'loginname': ebookuser.getName()
            }
            var str = JSON.stringify(obj);
            var filePath = Config.binPath + 'users/';
            shellcmd.saveFile(str, filePath + 'awdlog.cr');
            var uploadManagerexe = Config.binPath + 'iFlybookUploadMananger.exe';
            shellcmd.shellexecutewithargs(uploadManagerexe, AppRemoteSvcCfgBase.CYAPI);
            console.log('uploadManagerexe start success!');
            var configPath = Config.binPath + 'LogCenterExtract.cfg';
            configPath = path.trimPosix(configPath);
            configPath = path.toWindows(configPath);
            shellcmd.MonitorStart(configPath);
        });
    }

    /**
     * 更新用户授权
     */
    function writeUserLic() {
        //获取用户登录授权文件
        var _loginAssistor = require('./app/login/loginAssistor');
        var getHdTypeTask = shellcmd.getHardwareType();
        var getHdInfoTask = shellcmd.getHardwareInfo(ebookContext.getUser().getName());
        $.when(getHdTypeTask, getHdInfoTask).done(function (hdType, hardwareInfo) {
            _loginAssistor.callGetUserLicense(ebookContext.getUser(), hardwareInfo, hdType)
                .done(function (dataReceived) {
                    hideLoading();
                    var retObj = _loginAssistor.userLicDataConverter(dataReceived);
                    if (retObj.statusCode == 0 && retObj.data) {
                        shellcmd.saveFile(retObj.data, path.trimPosix(ebookContext.getUser().getUserLicenseFullPath()))
                    }
                });
        });
    }

    /**
     * 检测用户数据库
     */
    function checkDBOK(dbpath, tempdbpath) {
        var def = $.Deferred();
        dbpath = path.trimPosix(dbpath);
        shellcmd.getFileSize(dbpath).done(function (ret) {
            console.log("---dbsize : " + ret + "---");
            if (ret < 7000) {
                tempdbpath = path.trimPosix(tempdbpath);
                shellcmd.deleteFile(dbpath).done(function () {
                    shellcmd.copyFile(tempdbpath, dbpath).done(function () {
                        def.resolve("");
                    });
                });
            }
            else {
                def.resolve("");
            }
        });
        return  def.promise();
    }

    /**
     * 写日志文件
     */
    function logged() {
        userLog.init();
        userLog.insertNewLog();
    }

    /**
     * 通用事件DOM
     */
    function EventLogicDom() {
        var buttons = {
            btnAllBooks: $("#allBooks"),
            btnSelectedBooks: $("#selectedBooks")
        };
        var controls = {
            ctrFlipLeftImg: $("#ringLeft"),
            ctrFlipRightImg: $("#ringRight"),
            leftRing: $("#leftRing"),
            rightRing: $("#rightRing"),
            leftArrow: $("#leftArrow"),
            rightArrow: $("#rightArrow"),
            ctrFlipPanelDiv: $("#panel"),
            ctrClassBookCaseDiv: $(".bookoutside"),
            ctrRingLeftImg: $(".ring_left"),
            ctrRingRightImg: $(".ring_right"),
            ctrBookCaseTopShadowImg: $(".bookcase_shadow"),
            ctrBookShowListDiv: $("#bookShowList"),
            ctrSectionPanelDiv: $("#panelsection"),
            ctrGradePanelDiv: $("#panelgrade"),
            ctrBookInfoContentDiv: $("#bookInfoContent"),
            ctrBooksListDiv: $("#bookslist")
        }

        return  {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 工具栏DOM
     */
    function ToolBarDom() {
        var buttons = {
            btnBooksNeedUpdate: $("#booksNeedUpdate"),
            btnEditBooks: $("#editBooks"),
            btnEditCancel: $("#editCancel"),
            btnAllBooks: $("#allBooks"),
            btnSelectedBooks: $("#selectedBooks"),
            btnRecentBooks: $("#recentBooks"),
            btnNewBooks: $("#newBooks"),
            btnCancelBooks: $("#cancelBooks"),
            btnNameModelDisplay: $("#nameModelDisplay"),
            btnIconModelDisplay: $("#iconModelDisplay"),
            btnEditAllSelect: $("#editAllSelect"),
            btnEditNoSelect: $("#editNoSelect"),
            btnEditDelete: $("#editDelete"),
            btnExBook: $("#exportBook"),
            btnInBook: $("#inportU"),
            btnBookLib: $("#btnBookStack"),
            btnYJBookStack:$("#btnYJBookStack")
        };
        var controls = {
            ctrRingLeftImg: $(".ring_left"),
            ctrRingRightImg: $(".ring_right"),
            ctrBookCaseTopShadowImg: $(".bookcase_shadow"),
            ctrFlipPanelDiv: $("#panel"),
            ctrGradePanelDiv: $("#panelgrade"),
            ctrSectionPanelDiv: $("#panelsection"),
            ctrClassBookCaseDiv: $(".bookcase"),
            ctrBooksListDiv: $("#bookslist"),
            ctrBookShowListDiv: $("#bookShowList"),
            ctrBookOutSideDiv: $("#bookoutside"),
            ctrBookInfoContentDiv: $("#bookInfoContent")
        }

        return  {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 加载书DOM
     */
    function BookLoaderDom() {
        var buttons = {
            btnBooksNeedUpdate: $("#booksNeedUpdate"),
            btnAllBooks: $("#allBooks"),
            btnNewBooks: $("#newBooks"),
            btnEditAllSelect: $("#editAllSelect"),
            btnEditNoSelect: $("#editNoSelect")
        };
        var controls = {
            ctrBookCaseDiv: $(".bookoutside"),
            ctrFlipPanelImg: $(".flip"),
            ctrRingLeftImg: $(".ring_left"),
            ctrRingRightImg: $(".ring_right"),
            ctrBookCaseTopShadowImg: $(".bookcase_shadow"),
            ctrBookShowListDiv: $("#bookShowList"),
            ctrBookListAndListTopDiv: $("#bookListAndListTop"),
            ctrBookListOutSide: $("#listOutSide"),
            ctrBooksListDiv: $("#bookslist"),
            ctrFlipPanelDiv: $("#panel"),
            ctrBookInfoContentDiv: $("#bookInfoContent")
        };
        return  {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 书库DOM
     */
    function BookLibDom() {
        var buttons = {
            EditCancelTrigger: $("#editCancel"),
            AllBookTrigger: $("#allBooks"),
            RecentBookTrigger: $("#recentBooks"),
            btnCloseBookLib: $("#btnCloseBookLib"),
            downLoadRenJiaoBook: $("#downLoadRenJiaoBook")

        };
        var controls = {
            bookLibIfrm: $("#bookLibIfrm"),
            bookLibPanel: $("#bookLibPanel")
        };
        return  {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 书本更新DOM
     */
    function UpdateDom(resUpdatePanel) {
        var buttons = {
            booksNeedUpdate: $("#booksNeedUpdate"),
            closePanel: resUpdatePanel.find("#closeBooksUpdatePanel"),
            lastPage: resUpdatePanel.find("#btnLastPage"),
            nextPage: resUpdatePanel.find("#btnNextPage"),
            selectPage: resUpdatePanel.find("#btnSelectPage"),
            selectPageArrow: resUpdatePanel.find("#btnSelectPageArrow")
        };
        var controls = {
            shelfPanel: $("body"),
            resUpdatePanel: resUpdatePanel,
            resUpdateList: resUpdatePanel.find("#resUpdateList"),
            pageTip: resUpdatePanel.find("#pageTip"),
            updateTab: resUpdatePanel.find("#updateTab"),
            personalInfoPanel: $("#personalInfoPanel"),
            purchasedBooksPanel: $("#purchasedBooksPanel")
        };
        return  {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 个人中心DOM
     */
    function PersonalInfoDom(resUpdatePanel) {
        var buttons = {
            btnOpenPersonalInfo: $("#btnOpenPersonalInfo"),
            btnClosePersonalInfoPanel: $("#btnClosePersonalInfoPanel"),
            btnClosePurchasedBooksPanel: $("#btnClosePurchasedBooksPanel"),
            btnPurchasedBooks: $("#btnPurchasedBooks")
        };
        var controls = {
            personalInfoIfrm: $("#personalInfoIfrm"),
            personalInfoPanel: $("#personalInfoPanel"),
            purchasedBooksPanel: $("#purchasedBooksPanel"),
            purchasedBooksIfrm: $("#purchasedBooksIfrm"),
            purchasedBooksPanelMask: $("#purchasedBooksPanelMask"),
            bookpop_tab: $("#bookpop_tab"),
            booklist_tab: $("#booklist_tab"),
            personalInfoPanelMask: $("#personalInfoPanelMask"),
            ctrHeadPortrait: $("#ctrHeadPortrait"),
            resUpdatePanel: resUpdatePanel
        };
        return  {
            buttons: buttons,
            controls: controls
        }
    }

    /**
     * 这个函数改动的可能性很小很小了
     * 主要是一些不变的固定事件
     */
    function someOKThing() {

        /* the methods of $(window).height() and $(window).width() have inner bug in the browser,
         when the screen image resolution changed and the browser is not active or be minimization.
         The above two methods will not update their data immediately. But when we get the data from
         Config file also have problems, it will not adapted when the windows TaskBar changed.------JJ*/

        var _windowHeight = Config.Height;
        var _windowWidth = Config.Width;
        var _h = $("#first").height();
        var _showBookDivHeight = _windowHeight - _h;

        $(".book").css("min-height", _showBookDivHeight);
        $("#bookShowList").css("min-height", _showBookDivHeight);
        $("#bookLibPanel").css("height", _windowHeight).hide();
        $("#bookLibIfrm").css("height", _windowHeight);
        $(".bookoutside").css("height", _showBookDivHeight);
        $("#listOutSide").css("height", _showBookDivHeight - 39);

        //分辨率为800*600时，列表模式标题宽度改变
        if (_windowWidth < 1000) {
            $(".w180").css("width", "120px");
            $(".shelf_list .xk").css("width", "100px");
            $("#editBooks").css("margin-left", "-10px");
            $(".book_head").css("margin-left", "-30px").css("-webkit-transform", "matrix(0.8,0,0,1,0,0)");
            $(".open_board").css("margin-left", "-35px").css("-webkit-transform", "matrix(0.7,0,0,1,0,0)");
        }

        $("#personalInfoPanel").hide();

        $("#btnMinApp").click(function () {
            shellcmd.ebookMin();
        });

        $("#btnExitApp").click(function () {
            confirmExit.ExitAlert(null, null);
        });

        $("#btnGloQQService").click(function(){
            var QQService = require('./common/QQService').QQService;
            QQService();
        });

        $("#btnLogout").click(function () {
            confirmExit.GoToLoginAlert();
        });

        $("#goToWhiteBoard").click(function () {
            _pageNavigatorHelper.goToWhiteBoard(ebookContext.getUser());
        });

        $("#feedbackBtn").click(function () {
            var feedback = require("./app/bookshelf/feedback/feedback.js").Instance;
            feedback.show();
        });

        $("#addPoints").click(function () {
            var recharge = require("./app/bookshelf/recharge/recharge").Instance;
            recharge.show();
        });

        $("#userlogout").click(function () {
            confirmExit.GoToLoginAlert();
        })

        $("#goToPay").click(function () {
            shellcmd.openPageOutside(AppRemoteSvcCfg.BuyPointUrl + (ebookContext.getUser().getSSOTicket() || ""));
        });


        $("#helpLinkUrl").click(function () {
            shellcmd.openPageOutside(AppRemoteSvcCfg.UserHelpDocUrl + (ebookContext.getUser().getSSOTicket() || ""));
        });
    }

    function changeLoginStyle(curUser, isOnline, isActive,userLoginName,userName) {
        $("#loginafter").show();
        $("#loginbefore").hide();
        //第三方账户显示第三方账户名，反之显示账户名，自动生成的账户名显示用户名
        $("#curUser").text( userLoginName || ( /^User/.test(curUser) ?  userName : curUser));
        var $inAccount = $("#inAccount"),
            $okAccount = $("#okAccount");
        isActive ? ($okAccount.show(),$inAccount.hide()) : ($inAccount.show(),$okAccount.hide());
        //    $("#userActive").css("display",isActive ? "none" : "inline");
    }

    function StartMonitor(){
        var configPath = Config.binPath + 'LogCenterExtract.cfg';
        configPath = path.trimPosix(configPath);
        configPath = path.toWindows(configPath);
        shellcmd.MonitorStart(configPath);
    }

    function afterReder(){
        $("#usrInfo").show();
        $("#btnbarleft").show();
        $("#btnBookStack").show();
        $("#cylogo").show();

        setTimeout(function(){
            //隐藏欢迎页
            shellcmd.AfterRender();
        },1000);
    }

    exports.disableKey = disableKey;
    exports.Request = QueryString;
    exports.createShortCut = createShortCut;
    exports.StartUpload = StartUpload;
    exports.writeUserLic = writeUserLic;
    exports.checkDBOK = checkDBOK;
    exports.logged = logged;
    exports.EventLogicDom = EventLogicDom;
    exports.ToolBarDom = ToolBarDom;
    exports.BookLoaderDom = BookLoaderDom;
    exports.BookLibDom = BookLibDom;
    exports.UpdateDom = UpdateDom;
    exports.PersonalInfoDom = PersonalInfoDom;
    exports.someOKThing = someOKThing;
    exports.changeLoginStyle = changeLoginStyle;
    exports.StartMonitor = StartMonitor;
    exports.afterReder = afterReder;
});