﻿/**
 * 书架相关逻辑
 * @author yczhu@iflytek.com
 * @date
 */
define(function (require, exports) {
    require('lab');
    require('jquery');
    require('jqjson');
    require('xml2json');
    require('browserContext');
    require('jquery_ui');
    var _bookLoader = require('./app/bookshelf/bookloader').Instance;
    var eventLogic = require('./app/bookshelf/eventlogic').Instance;
    var bookShelfStatus = require('./app/bookshelf/bookshelfstatus').Instance;
    var _BookItemMapping = require('./common/metadatamapping').Instance;
    var resUpdateMgr = require('./app/bookshelf/resupdatemgr').Instance;
    var bookShelfToolBarMgr = require('./app/bookshelf/bookshelftoolbarmgr').Instance;
    var confirmExit = require('./common/confirmExit');
    var ebookContext = require('./app/ebookcontext').Instance;
    var shellcmd = require('./common/shellcmd');
    var path = require('./common/path');
    var _Des = require('./common/des.js');
    var _pageNavigatorHelper = require('./common/pagenavigatorhelper');
    var register = require('./app/login/register').Instance;
    var result = require("./app/login/loginhelper").Result;
    var _bookShelfMsg = require("./app/bookshelf/bookshelfmsg").Instance;
    require('zebra_dialog');
    var _userData = require('./common/userdata').Instance;
    var commonfunc = require("./common/commonfunc");
    var _PersonalInfoManager = require('./app/bookshelf/personalInfo/personalInfomgr');
    var _bookLibManager = require('./app/bookshelf/bookLib/booklibmgr');
    var userLogin = require("./app/login/loginmgr").Instance;
    /*resUpdatePanel对象放在这里是为了单击书库，个人中心，我的课本时可以获取该对象以隐藏该面板*/
    var resUpdatePanel = $($("#res_update_template").html());
    var userinfoAccessor =  require("./app/login/userinfoAccessor.js");
    var _yjBookLibMgr = require('./app/bookshelf/bookLib/yjbooklibmgr').Instance;
    var bookShelfHelper = require('./bookshelfhelper');
    var lan = null;
    var isInitLogin = false;

    /**
     * 初始化登录
     */
    function initLoginModle() {
        if (!isInitLogin) {
            userLogin.initDOM();
            userLogin.bingEventsToDOM();
            setGlobalLoginMgr(userLogin);
            isInitLogin = true;
        }
    }

    /**
     * 初始化书架界面
     */
    function init(curUser, pwd, ticket,isActive) {
        bookShelfStatus.init();

        if(AppVersionCfg.AppVersion == AppVerCfg.GanSuPlat) {
            var $logo3rd = $("#logo3rd");
            $logo3rd.show().click(function(){
                var url = $logo3rd.attr("url");
                if(url){
                    shellcmd.openPageOutside(url);
                }
            })
        }

        $("#cloudLinkUrl").click(function () {
            //测试数据是"iflybook","uid=jiaoyanyuan&&pwd=111111"
            //  var ret = _Des.desEncodeByJs("iflybook","uid=jiaoyanyuan&&pwd=111111");
            // 下面这块也先别删
//            var ret = _Des.desEncodeByJs("iflybook", "uid=" + curUser + "&&pwd=" + pwd);
//            ret = encodeURIComponent(ret);
//            console.log(ret);
//            shellcmd.openPageOutside(AppRemoteSvcCfg.TeacherCloudUrl + ret);

            var url = $(this).attr("url");
            shellcmd.openPageOutside(url);
        });

        $("#gotoLoginUrl").click(function () {
            initLoginModle();
            userLogin.show();
        });

        $("#registerLinkUrl").click(function () {
            shellcmd.checkOnline().done(function(ret){
                if(ret){
                    initLoginModle();
                    register.show();
                }
                else{
                    $.Zebra_Dialog(AppTips.NetWorkConnectFailed, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips],
                        'zIndex': 1000
                    });
                }
            });
        });

        $("#userActive").click(function(){
            if(!isActive){
                var active = require("./app/login/activeaccount").Instance;
                active.show();
            }
        })

        bookShelfHelper.someOKThing();
    }

    function initPersonalInfo(user) {
        var personalInfoManager = new _PersonalInfoManager.PersonalInfoManager();
        var Dom = bookShelfHelper.PersonalInfoDom(resUpdatePanel);
        personalInfoManager.init(Dom.buttons, Dom.controls, user);
        //注册客户端发送消息的对象(purchasedBooksIfrm)
        registerIframe("purchasedBooksIfrm", "*");
    }

    function initResUpdate(user, lan) {
        var Dom = bookShelfHelper.UpdateDom(resUpdatePanel);
        resUpdateMgr.init(Dom.buttons, Dom.controls, user, lan);
        setGlobalResUpdateMgr(resUpdateMgr);
    }

    function initBookLib() {
        var bookLibManager = new _bookLibManager.BookLibraryManager();
        var Dom = bookShelfHelper.BookLibDom(resUpdatePanel);
        initLoginModle();
        bookLibManager.init(Dom.buttons, Dom.controls, userLogin);
        setGlobalContextBookLibMgr(bookLibManager);
        $("#btnBookStack").click(function () {
            resUpdatePanel.hide();
            $("#personalInfoPanel").hide();
            $("#purchasedBooksPanel").hide();
            //先不显示“下载人教课本按钮”，后来再显示
//            $("#downLoadRenJiaoBook").css('display','none');
            bookLibManager.showBookLibPanel();
        });
        registerIframe("bookLibIfrm", "*");

        _yjBookLibMgr.init(bookLibManager);
        setGlobalContextYJBookLibMrg(_yjBookLibMgr);

        $("#btnYJBookStack").click(function(){
            resUpdatePanel.hide();
            $("#personalInfoPanel").hide();
            $("#purchasedBooksPanel").hide();
            //先不显示“下载人教课本按钮”，后来再显示
//            $("#downLoadRenJiaoBook").css('display','none');
            _yjBookLibMgr.showYueJiaoBookLibPanel();
        })

    }

    function initBookLoader() {
        var Dom = bookShelfHelper.BookLoaderDom();
        _bookLoader.init(Dom.buttons, Dom.controls);
    }

    function initBookShelfToolBar() {
        var Dom = bookShelfHelper.ToolBarDom();
        bookShelfToolBarMgr.init(Dom.buttons, Dom.controls);
    }

    function initEventLogic() {
        var Dom = bookShelfHelper.EventLogicDom();
        eventLogic.init(Dom.buttons, Dom.controls);
    }

    function loginFromShelf(account, pwd,flag) {
        console.log(account + "----" + pwd);
        showLoading({tips: AppBookShelfTipsList.loadingNow});
        if (account && pwd && (account != " ") && (pwd != " ")) {
            userLogin.loginFunction(account, pwd, true ).done(function(ret){
                if( ret != result.CloudResult.alreadyBind && ret != result.CloudResult.bindSuccess &&
                    ret != result.LocalResult.localSuccess){
                    //单点登录失败，显示默认账户
                    //登陆成功处理不在这里，在loginmgr的showCloudResult中处理
                    //只能怪单点登录策略太挫，如果后面单点登录删除文件的时机改动
                    //你可以考虑修改优化
                    autoLoginHelp(ret);
                    loginOKThenDo(AppCfg.defaultuser, "", "", true, null, 1, false,0,0,0,"","","");
                }
            });
        }
        else if(!flag){
            //没有拿到单点登录信息，获取上一次登录信息
            userinfoAccessor.getLastLoginUser().done(function(lastuser){
                if(lastuser.account && (lastuser.IsRememberPasswordOrNOt == 1) ){
                    //如果信息存在，自动登录
                    shellcmd.desDecrpty(lastuser.password,lastuser.account).done(function(pwd2){
                        userLogin.loginFunction(lastuser.account, pwd2, true).done(function(ret){
                            if( ret != result.CloudResult.alreadyBind && ret != result.CloudResult.bindSuccess &&
                                ret != result.LocalResult.localSuccess){
                                //自动登录失败，显示默认账户
                                //登陆成功处理不在这里，在loginmgr的showCloudResult中处理
                                autoLoginHelp(ret);
                                loginOKThenDo(AppCfg.defaultuser, "", "", true, null, 1, false,0,0,0,"","","","");
                            }
                        });
                    })
                }
                else{
                    //反之，显示默认账户
                    loginOKThenDo(AppCfg.defaultuser, "", "", true, null, 1, false,0,0,0,"","","","");
                }
            })
        }
        else{
            //注销进来的
            loginOKThenDo(AppCfg.defaultuser, "", "", true, null, 1, false,0,0,0,"","","","");
        }
    }

    function autoLoginHelp(ret){
        var tips = "" ;
        switch (ret) {
            case result.CloudResult.webError:
                tips = AppTips.NetWorkConnectFailed;
                break;
            case result.CloudResult.accountOrPwdWrong:
                tips = AppTips.autoPwdError;
                break;
            case result.CloudResult.isDeleOrOutDate:
                tips = AppTips.autoForbidden;
                break;
            case result.CloudResult.canNotBind:
                tips = AppTips.autoOverflow;
                break;
            case result.CloudResult.getBindMsgError:
            case result.CloudResult.bindFail:
                console.log("这里不应该被执行到");
                tips = AppTips.bindFailMsg;
                break;
            case result.LocalResult.noLicense:
                tips = AppTips.autoFailMsg;
                break;
            case result.LocalResult.accountForbidden:
                tips = AppTips.autoForbidden;
                break;
            case result.LocalResult.argumentImperfect:
                tips = AppTips.autoFailMsg;
                break;
            case result.LocalResult.accountNotMatchPwd:
                tips = AppTips.autoPwdError;
                break;
            case result.LocalResult.accountNotMatchMachineCode:
                tips = AppTips.autoNotMatch;
                break;
            case result.LocalResult.timeStampOver:
                tips = AppTips.autoTimeOver;
                break;
            default :
        }

        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.OkTips],
            'onClose' : function(){
                if(AppTips.autoOverflow == tips){
                    $("#gotoLoginUrl").click();
                }
            }
        });
    }

    var loginOKThenDo = function (curUser, pwd, ticket, isOnline, photo, firstload, isActive,
                                  uid,points,books,phone,userloginname,loginFrom,userName,SSOTicket,province) {
        //这一步只获取ip地址
        _userData.init();
        init(curUser, pwd, ticket,isActive);
        initBookLoader();
        initEventLogic();
        initBookLib();
        initBookShelfToolBar();

        //如果用户存在了，不用登陆
        if (curUser) {
            ebookContext.setBinPath(Config.binPath);
            ebookContext.setUser(curUser, pwd);//Password没有传过来
            ebookContext.setUserBaseInfo(uid,"",phone,userName);
            ebookContext.setUserExtInfo(ticket,isOnline,isActive,userloginname,loginFrom);
            var ebookuser = ebookContext.getUser();
            ebookuser.showIsOnline(isOnline);
            ebookuser.setSSOTicket(SSOTicket);
            ebookuser.setProvince(province);
            bookShelfHelper.checkDBOK(ebookuser.getUserDbFullPath(),ebookuser.getTempUserDb()).done(function(){
                _BookItemMapping.init().done(function () {
                    //在这里加载书
                    console.log("MetaMapDone");
                    eventLogic.initAllBookList().done(function () {
                        console.log("initAllBookListDone");
                        eventLogic.reNewBookSelf().done(function () {
                            console.log("reNewBookShelfDone");
                            if (firstload == 1 && isOnline && photo) {
                                initPersonalInfo(ebookuser);
                            } else {
                                initPersonalInfo(ebookuser);
                            }
                            initResUpdate(ebookuser, lan);
                            console.log("initResUpdate OK");
                        });
                    });
                });
            });
        } else { //用户登陆
            _pageNavigatorHelper.goToLogin();
        }
        //禁用拖放打开本地文件操作
        var commonfunc = require("./common/commonfunc");
        commonfunc.disabledDragLocalFiles();
        //如果是登录后首次进入书架，则更新用户license
        if (firstload == 1) {
            bookShelfHelper.logged();
            if (isOnline) {
                    if(curUser !== AppCfg.defaultuser){
                        ebookuser.getPointsThenSet();
                        pwd && ebookuser.setPassword(pwd);
                        bookShelfHelper.writeUserLic();
                        bookShelfHelper.StartUpload(ebookuser);
                    }
            }
            else{
                $("#lastBooks").hide();
            }
            hideLoading();
        }
        else{
            ebookuser.setBooks(books);
            books ? ($("#bookNum").text(books )) : ($("#lastBooks").hide());
        }

        isOnline && ebookuser.checkSingleLogin(_pageNavigatorHelper);
        bookShelfHelper.disableKey();
        bookShelfHelper.createShortCut();
    }

    var enloginFromShelf = function (flag) {
        if(flag){
            //注销并显示默认账户
            loginFromShelf("","",flag);
        }
        else{
            //单点登录入口
            shellcmd.getUserFromFile().done(function(ret){
                var userEntryInfo = ret.split("=");
                console.log(userEntryInfo[0]+'-------'+userEntryInfo[1]);
                loginFromShelf(userEntryInfo[0],userEntryInfo[1]);
            });
        }
    }

    //当seajs预执行完毕以后才会执行到这里
    $(function () {
        console.log("-----now start ok----");
        bookShelfHelper.StartMonitor();

        var curUser = bookShelfHelper.Request("user") ;
        var ticket = bookShelfHelper.Request("ticket");
        var isOnline = !!(bookShelfHelper.Request("isonline") == 'true');
        var isActive = !!(bookShelfHelper.Request("isactive") == 'true');
        var uid = bookShelfHelper.Request("uid");
        var logout = bookShelfHelper.Request("logout");
        var photo = bookShelfHelper.Request("photo");
        var firstload = bookShelfHelper.Request("firstload");
        var points = bookShelfHelper.Request("points");
        var books = bookShelfHelper.Request("books");
        var phone = bookShelfHelper.Request("phone");
        var pwd = decodeURIComponent( bookShelfHelper.Request("pwd"));
        var province = bookShelfHelper.Request("p");
        var loginFrom = bookShelfHelper.Request("LoginFrom");
        var userName = decodeURIComponent (bookShelfHelper.Request("userName"));
        var userloginname = decodeURIComponent( bookShelfHelper.Request("userloginname"));
        var SSOTicket = bookShelfHelper.Request("SSOTicket");

        (curUser == AppCfg.defaultuser) && (logout = 1);
        if (!curUser || (curUser == AppCfg.defaultuser)) {
            //没有用户，就从书架直接登录
            initLoginModle();
            enloginFromShelf(logout);
        }
        else {
            //从登陆页或电子书跳转过来
            bookShelfHelper.changeLoginStyle(curUser, isOnline, isActive,userloginname,userName);
            loginOKThenDo(curUser, pwd, ticket, isOnline, "",firstload, isActive,
                uid,points,books,phone,userloginname,loginFrom,userName,SSOTicket,province);
        }
        setGlobalBookShelfMsg(_bookShelfMsg);
        bookShelfHelper.afterReder();
    });

    function initCfgDom(){
        loadConfig().done(function(configs){
            console.log('mvvm init invoked');
            ko.applyBindings(configs);
        })
    }

    function loadConfig(){
        var def = $.Deferred();
        //这句是为了获取window对象
        var win = (function(){return this;})();

        if(AppVersionCfg.AppVersion !== AppVerCfg.BaseLine) {
//            var configBaseDir = require.resolve('./configs/');
//            console.log(configBaseDir);
//            var prjConfigUrl = path.join(configBaseDir,AppVersionCfg.AppVersion + ".js");
//            console.log(prjConfigUrl);
            $LAB.script( "assert/js/configs/" + AppVersionCfg.AppVersion + ".js").wait(function(){
                var prjConfig = win['AppVersionCfg' + AppVersionCfg.AppVersion];
                $.extend(true, AppVersionCfg, prjConfig );
                console.log(AppVersionCfg);
                def.resolve(AppVersionCfg);
            });
        }
        else{
            def.resolve(AppVersionCfg);
        }

        return def.promise();
    }

    exports.initCfgDom = initCfgDom;
});
