/**
 * 聚焦模块
 * Date: 2013/07/26
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module app/paint/surfacetool
 */

/**
 * Idea :
 * 实现聚焦功能的时候，是先显示一块canvas，然后利用这个canvas绘制一块矩形。
 * 当鼠标抬起的那一刻，收集这块矩形的数据，隐藏这个canvas，
 * 然后，在这个矩形的上下左右全部罩上div。
 * 因此，这块矩形下面的按钮都还是可以操作的。
 * 比如热区可以点读。
 * 如果不能，是做了特殊处理禁用按钮以免引起混乱。
 * 比如，聚焦 “聚焦”按钮 这一块。。。恩，聚焦按钮可以再次单击，再罩上一层canvas。。
 * 乱套了。
 *
 *            ----------  by yczhu
 */
define(function (require, exports, module) {

    function SurfaceTool() {

        var _model = require("../model");
        var _EventUtil = require('../../common/eventUtil');
        var _define=require("../define");
        var smartBar =  require('../book/smartbar/smartbar').Instance;
        var _tempCanvas;
        var _tempContext;

        var _isPainting = false;

        var _surfaceToolContainer = null;

        var _focusRect = null;

        var _isLightOff = false;

        var _bookContainer = null;

        var _surfaceToolBar = null;

        var _fullScreenMask = null;

        var _resizableDiv = null;

        var _resizeCorner = null;

        var _resizeRect = null;

        var _resizeManager = null;

        var _restrictFocusRect = null;

        var _hasBindSurfaceToolBarCommands = false;

        this.init = function (bookContainer) {
            _bookContainer = bookContainer;
        }

        /**
         * @description 显示遮罩层canvas
         */
        function _showTempCanvas() {
            //创建tempCanvas
            if (!_tempCanvas) {
                _tempCanvas = $("<canvas>").attr("id", 'temp_canvas')
                    .css({
                        "position": "absolute",
                        "z-index": "550"
                    });
                _tempCanvas.attr("width", $(document).width());
                _tempCanvas.attr("height", $(document).height());
                _surfaceToolContainer.append(_tempCanvas);
                _tempContext = _tempCanvas[0].getContext("2d");
            } else {
                _tempCanvas.show();
            }
            ;
            _tempCanvas.unbind();
            _tempContext.strokeStyle = "white";
            _tempContext.lineWidth = 1;
            //绑定事件
            var startX, startY;
            var endX, endY;
            _tempCanvas.mousedown(function () {
                if (_restrictFocusRect.isContainsPoint(new _model.Point(event.offsetX, event.offsetY))) {
                    startX = event.offsetX;
                    startY = event.offsetY;

                    _tempContext.beginPath();
                    _isPainting = true;
                }
                event.stopPropagation();
            });
            _tempCanvas.mousemove(function (evt) {

                if (_isPainting && _restrictFocusRect.isContainsPoint(new _model.Point(event.offsetX, event.offsetY))) {
                    endX = evt.offsetX;
                    endY = evt.offsetY;

                    _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                    _tempContext.strokeRect(startX, startY, endX - startX, endY - startY);

                    _tempContext.stroke();
                    _tempContext.closePath();
                }
            });
            _tempCanvas.mouseup(function (evt) {
                if (_isPainting) {

                    if (_restrictFocusRect.isContainsPoint(new _model.Point(event.offsetX, event.offsetY))) {
                        endX = evt.offsetX;
                        endY = evt.offsetY;
                    }

                    _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                    _focusRect = new _model.Bound(Math.min(startX, endX), Math.min(startY, endY), Math.abs(startX - endX), Math.abs(startY - endY));

                    if (_focusRect.width > 5 && _focusRect.height > 5) {
                        _drawFocusArea(_focusRect);
                        _showResizableDiv();
                        _tempCanvas.hide();
                        _surfaceToolContainer.find("#btnCloseSurfaceMode").hide();
                    }
                }
                _isPainting = false;
            });
            _tempCanvas.mouseout(function () {
                if (_isPainting) {
                    _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                }
                _isPainting = false;
            });
        }

        function _setMovable(focusDiv) {
            var isDraging = false;

            function setCanMove(focusDiv) {
                if (!focusDiv) return;
                var miniBoardDiv = focusDiv[0];
                var startX, startY;
                var endX, endY;
                var originalLeft, originalTop;

                $(document).bind('mousedown.surfaceTool',function () {
                    if (_focusRect && _focusRect.isContainsPoint) {
                        if (_focusRect.isContainsPoint(new _model.Point(event.clientX, event.clientY))) {
                            isDraging = true;
                            originalLeft = miniBoardDiv.offsetLeft;
                            originalTop = miniBoardDiv.offsetTop;
                            startX = event.clientX;
                            startY = event.clientY;
                            _drawFocusArea();
                        }
                    }
                    event.stopPropagation();
                }).bind('mousemove.surfaceTool',function () {
                        if (isDraging && _focusRect && _focusRect.isContainsPoint) {
                            if (_focusRect.isContainsPoint(new _model.Point(event.clientX, event.clientY))) {
                                endX = originalLeft + event.clientX - startX;
                                endY = originalTop + event.clientY - startY;

                                var index = false;
                                if (endX >= _restrictFocusRect.left && endX < _restrictFocusRect.right - miniBoardDiv.offsetWidth) {
                                    miniBoardDiv.style.left = endX + "px";
                                    index = true;
                                }
                                if (endY >= _restrictFocusRect.top && endY < _restrictFocusRect.bottom - miniBoardDiv.offsetHeight) {
                                    miniBoardDiv.style.top = endY + "px";
                                    index = true;
                                }
                                index && _drawFocusArea();
                            }
                        }
                        event.stopPropagation();

                    }).bind('mouseup.surfaceTool', function () {
                        isDraging = false;
                        event.stopPropagation();
                    });
            }

            setCanMove(focusDiv);
        }

        function _setUnmovable() {
            $(document).unbind('.surfaceTool');
        }

        /**
         * 显示聚焦区域外的遮罩
         * @param {object=} _focusRect
         * @private
         */
        function _drawFocusArea(focusRect) {

            if (!focusRect) {
                var offset = _resizableDiv.offset();
                _focusRect = new _model.Bound(offset.left, offset.top, _resizableDiv.width(), _resizableDiv.height());
            }
            else _focusRect = focusRect;

            _resizeRect[0].css({left: 0, top: 0, width: Config.Width, height: _focusRect.top});
            _resizeRect[1].css({left: 0, top: _focusRect.top, width: _focusRect.left, height: Math.ceil(_focusRect.height)});
            _resizeRect[2].css({left: _focusRect.left + _focusRect.width, top: _focusRect.top, width: Config.Width - _focusRect.width - _focusRect.left, height: Math.ceil(_focusRect.height)});
            _resizeRect[3].css({left: 0, top: _focusRect.top + _focusRect.height, width: Config.Width, height: Config.Height - _focusRect.top - _focusRect.height});
            _repositionResizableDiv();
        }

        /**
         * 设置聚焦区域四周的四个可拖动区域，并更正聚焦工具栏的位置
         * @private
         */
        function _repositionResizableDiv() {
            _resizeCorner[2].css({left: _focusRect.right - 5, top: _focusRect.bottom - 5});
            _resizeCorner[3].css({left: _focusRect.left - 5, top: _focusRect.bottom - 5});
            _resizeCorner[0].css({left: _focusRect.left - 5, top: _focusRect.top - 5});
            _resizeCorner[1].css({left: _focusRect.right - 5, top: _focusRect.top - 5});
            //_resizableDiv.popover('setOption', {position: _focusRect.bottom + 50 < Config.Height ? 'bottom' : 'top'});
            _resizableDiv.popover('reposition');
        }

        /**
         * 设置聚焦区域的样式
         * @param {boolean=} flag  是否关灯
         * @private
         */
        function _setFullScreenMaskStyle(flag) {
            if (flag == undefined) flag = _isLightOff;
            var style = {
                'background-color': flag ? 'black' : 'rgba(63,63,63,1)',
                'opacity': flag ? "1" : '0.7',
                'z-index': 500
            };
            _resizeRect[0].css(style);
            _resizeRect[1].css(style);
            _resizeRect[2].css(style);
            _resizeRect[3].css(style);
        }

        /**
         * 显示聚焦区域
         * @private
         */
        function _showResizableDiv() {

            _resizableDiv.css("left", _focusRect.left);
            _resizableDiv.css("top", _focusRect.top);
            _resizableDiv.css("width", _focusRect.width);
            _resizableDiv.css("height", _focusRect.height);

            _surfaceToolBar.show();
            _bindSurfaceToolBarCommands();

            _resizableDiv.popover({position: 'bottom', content: _surfaceToolBar, userDefinePopover: true, hideOnHTMLClick: false, extraStyle: {'z-index': '500'}})
                .popover('show');

            _setFullScreenMaskStyle();
            _repositionResizableDiv();
            _resizeManager = new Resize(_resizableDiv[0])
                .set(_resizeCorner[0], 'leftUp')
                .set(_resizeCorner[3], 'leftDown')
                .set(_resizeCorner[2], 'rightDown')
                .set(_resizeCorner[1], 'rightUp');

            _bookContainer.getContent().trigger('unSwipable').trigger('unDraggable');
            _surfaceToolContainer.find("#btnCloseSurfaceMode").unbind().hide();
            _setMovable(_resizableDiv);
        }

        function _hideResizableDiv() {
            _setUnmovable();
            _resizeManager && _resizeManager.destroy();
            _surfaceToolBar && _surfaceToolBar.hide();
        }

        function _destroySurfaceTool() {
            _surfaceToolContainer.hide();
            _resizableDiv && _resizableDiv.popover('destroy');
            _fullScreenMask && _fullScreenMask.remove();
            _tempCanvas && _tempCanvas.remove();
            _setUnmovable();
            _resizeManager && _resizeManager.destroy();
            _focusRect = _resizeManager = _resizeRect = _tempCanvas = _fullScreenMask = _surfaceToolBar = _resizableDiv = _resizeCorner = null;

            _bookContainer.getContent().trigger('swipable').trigger('draggable');
            _disableToolBar(false);
        }

        $("#btnFocus").click(function () {
            $("#btnToolBox").attr("isshow")=='1'&& $("#btnToolBox").trigger('click');
            //关闭smartBar
            smartBar.closeSmartBar();
            if($("#smartbar").attr("flag")=="top")
                $('#top_tit').hide();
            else
                $('#bottom_tit').hide();

            //已经点击了一次聚焦
            if (_focusRect) return;

            _focusRect = {top: 0, left: 0, width: 0, height: 0, right: 0, bottom: 0};
            _restrictFocusRect = new _model.Bound(0, 0, Config.Width, Config.Height);
            _surfaceToolContainer = $("#surfaceToolContainer");
            _resizableDiv = $("#resizableDiv");

            var _resizeCornerDiv = _surfaceToolContainer.find(".resizeCorner");
            _resizeCorner = [ _resizeCornerDiv.find("#rLeftUp"), _resizeCornerDiv.find("#rRightUp"), _resizeCornerDiv.find("#rRightDown"), _resizeCornerDiv.find("#rLeftDown")];
            _fullScreenMask = $('<div id="fullScreenMask"></div>');
            _surfaceToolBar = $(document.getElementById("template_surfaceToolBar").innerHTML);

            (app_global_bookContainer.getPageViewType() === _define.PageViewType.WhiteBoardView) && (
                _surfaceToolBar.css("width","112px").find("#surToolHotPlay").hide()
                )

            _hasBindSurfaceToolBarCommands = false;
            _surfaceToolContainer.find("#btnCloseSurfaceMode").css("left", $(document).width() - 45).show().one('click',function () {
                _destroySurfaceTool();
                if($("#smartbar").attr("flag")=="top")
                    $('#top_tit').show();
                else
                    $('#bottom_tit').show();
                event.stopPropagation();
            });

            _isLightOff = false;

            _showTempCanvas();
            _disableToolBar();
            _hidePopControls();

            (function () {
                var topRect = $('<div id="topRect" style="position: fixed;left: 0px;top: 0px;width: 100%;height: 100%;background-color:rgba(63,63,63,1);opacity: 0.8;z-index: 500"></div>');
                var leftRect = $('<div id="leftRect" style="position: fixed;"></div>');
                var rightRect = $('<div id="rightRect" style="position: fixed;"></div>');
                var bottomRect = $('<div id="bottomRect" style="position: fixed;"></div>');
                _surfaceToolContainer.append(_fullScreenMask.append(topRect).append(leftRect).append(rightRect).append(bottomRect));
                _resizeRect = [topRect, leftRect, rightRect, bottomRect];
            })();
            _surfaceToolContainer.show();
            event.stopPropagation();
        })

        /**
         * 禁用工具栏
         * @param ｛boolean=｝ index 是否禁用主工具栏和侧边栏按钮
         * @private
         */
        var _disableToolBar = (function () {
            var fun = function () {
                event.stopPropagation();
            }
            return function (index) {
                if (index === false) {
                    $("#mainToolBar ul")[0].removeEventListener('click', fun, true);
                    $("#leftToolbar")[0].removeEventListener('click', fun, true);
                    $("#rightToolbar")[0].removeEventListener('click', fun, true);
                }
                else {
                    $("#mainToolBar ul")[0].addEventListener('click', fun, true);
                    $("#leftToolbar")[0].addEventListener('click', fun, true);
                    $("#rightToolbar")[0].addEventListener('click', fun, true);
                }
            }

        })();

        /**
         * 初始化页面时隐藏一些控件，例如板擦控件、颜色选择器、其他笔
         */
        function _hidePopControls() {
            //切换到鼠标状态
            $("#btnMouse").triggerHandler('click');
            //隐藏课本目录
            $("#directory_box_left").css({display: "none"});
            $("#directory_box_right").css({display: "none"});
            $("#localResId").hide();
            $("#localResNoneId").hide();
        }

        function _bindSurfaceToolBarCommands() {
            if (_hasBindSurfaceToolBarCommands) return;

            _hasBindSurfaceToolBarCommands = true;

            _surfaceToolBar.find(".btnSurfaceToolClose").click(function () {
                _destroySurfaceTool();
                if($("#smartbar").attr("flag")=="top")
                    $('#top_tit').show();
                else
                    $('#bottom_tit').show();
                event.stopPropagation();
            })

            _surfaceToolBar.find(".btnSurfaceToolLight").click(function () {
                _isLightOff = !_isLightOff;
                if (!_isLightOff) {
                    _surfaceToolBar.find("img.btnSurfaceToolLight").attr("src", "assert/images/tool_turnoff.png");
                } else {
                    _surfaceToolBar.find("img.btnSurfaceToolLight").attr("src", "assert/images/tool_openlamp.png");
                }
                _setFullScreenMaskStyle();
                event.stopPropagation();
            })

            _surfaceToolBar.find(".btnSurfaceFullScreen").click(function () {

                //保存之前的页面放缩数据
                var _transformData = _bookContainer.getTransformData();
                var $bookContainer = $("#bookContainer");

                var width = _resizableDiv.width() / _transformData.a, height = _resizableDiv.height() / _transformData.d,
                    maxWidth = $bookContainer.width(), maxHeight = $bookContainer.height();

                var newScale = Math.min(maxWidth / width, maxHeight / height);


                //计算偏移位置
                var resizableDivOffset = _resizableDiv.offset(), bookContainerOffset = $bookContainer.offset();
                var centerOffsetX = (maxWidth - width * newScale) / 2, centerOffsetY = (maxHeight - height * newScale) / 2;

                //修正单页时定位错误
                if (!_bookContainer.getCurrentBookView().isDoublePage())  maxHeight = $(".viewdom").height();
                var transformOriginX = (bookContainerOffset.left - resizableDivOffset.left - (_transformData.a - 1) / 2 * maxWidth + _transformData.tx) * newScale / _transformData.a + centerOffsetX,
                    transformOriginY = (bookContainerOffset.top - resizableDivOffset.top - (_transformData.d - 1) / 2 * maxHeight + _transformData.ty) * newScale / _transformData.d + centerOffsetY;

                var viewDom = _bookContainer.getCurrentBookView().getViewDOM();
                viewDom.css({
                    '-webkit-transform': 'matrix(' + [newScale, 0, 0, newScale, transformOriginX, transformOriginY] + ')',
                    '-webkit-transform-origin': "0% 0%"
                });

                var oldFocusRect = _focusRect;
                _focusRect = new _model.Bound(bookContainerOffset.left + centerOffsetX, bookContainerOffset.top + centerOffsetY, width * newScale, height * newScale);
                _drawFocusArea(_focusRect);
                _setFullScreenMaskStyle(true);
                _hideResizableDiv();

                var _slideToolBar = new SlideToolBar();
                _slideToolBar.show();
                _slideToolBar.one('minmize', function () {
                    _bookContainer.zoom(_transformData.a / _bookContainer.getZoomRate(), _transformData);
                    _drawFocusArea(oldFocusRect);
                    _showResizableDiv();
                });

                event.stopPropagation();
            });

            _addPlayEventListener(_surfaceToolBar.find('.btnSurfacePlay'));
        }

        /**
         * 监听热区和音频的播放，暂停，停止事件
         * @param btnPlay
         * @private
         */

        function _addPlayEventListener(btnPlay) {
            if (!btnPlay) return;
            var btnTogglePlay = $('#btnTogglePlay');
            if (btnTogglePlay.attr('state') === 'playing')  btnPlay.attr('src', 'assert/images/sidertool_suspended.png');

            btnPlay.on('click', function () {
                btnTogglePlay.triggerHandler('click');
            });

            app_global_playerMgr.bind(btnPlay, 'play',function (event,playerType) {
                if(playerType===_define.PlayerType.HotspotPlayer||playerType===_define.PlayerType.AudioPlayer)
                    btnPlay.attr('src', 'assert/images/sidertool_suspended.png');
            }).bind(btnPlay, 'pause',function (event,playerType) {
                    if(playerType===_define.PlayerType.HotspotPlayer||playerType===_define.PlayerType.AudioPlayer)
                         btnPlay.attr('src', 'assert/images/sidertool_play.png');
            }).bind(btnPlay, 'ended', function (event,playerType) {
                    if(playerType===_define.PlayerType.HotspotPlayer||playerType===_define.PlayerType.AudioPlayer)
                        btnPlay.attr('src', 'assert/images/sidertool_play.png');
             });
        }


        function _bind(object, fun) {
            var args = Array.prototype.slice.call(arguments).slice(2);
            return function () {
                return fun.apply(object, args);
            }
        }
        ;

        function _bindAsEventListener(object, fun) {
            var args = Array.prototype.slice.call(arguments).slice(2);
            return function (event) {
                return fun.apply(object, [event || window.event].concat(args));
            }
        }
        ;

        function _currentStyle(element) {
            return element.currentStyle || document.defaultView.getComputedStyle(element, null);
        }
        ;

        function Class(properties) {
            var _class = function () {
                return (arguments[0] !== null && this.initialize && typeof(this.initialize) == 'function') ? this.initialize.apply(this, arguments) : this;
            };
            _class.prototype = properties;
            return _class;
        }
        ;

        var Resize = new Class({
            initialize: function (obj) {
                this.obj = obj;
                this.fun = null;
                this.original = [];
                this.width = null;
                this.height = null;
                this.fR = _bindAsEventListener(this, this.resize);
                this.fS = _bind(this, this.stop);
                this.resizeElements = [];
            },
            set: function (elm, direction) {
                if (!elm)return;
                elm.bind('mousedown.resize', _bindAsEventListener(this, this.start, this[direction]));
                elm.bind('blur.resize', this.fS);
                this.resizeElements.push(elm);
                elm.show();
                return this;
            },

            start: function (e, fun) {
                this.fun = fun;
                this.original = [parseInt(_currentStyle(this.obj).width), parseInt(_currentStyle(this.obj).height), parseInt(_currentStyle(this.obj).left), parseInt(_currentStyle(this.obj).top)];
                this.width = (this.original[2] || 0) + this.original[0];
                this.height = (this.original[3] || 0) + this.original[1];
                $(document).bind('mousemove.resize', this.fR).bind('mouseup.resize', this.fS);
                _setUnmovable();
            },
            resize: function (e) {
                this.fun(e);
            },
            stop: function () {
                $(document).unbind('.resize');
                window.getSelection ? window.getSelection().removeAllRanges() : document.selection.empty();
                _setMovable(_resizableDiv);
            },
            up: function (e) {
                if (e.clientY <= _restrictFocusRect.bottom && e.clientY >= _restrictFocusRect.top) {
                    this.height > e.clientY ? $(this.obj).css({top: e.clientY + "px", height: this.height - e.clientY + "px"}) : this.turnDown(e);
                    _drawFocusArea();
                }
            },
            down: function (e) {
                if (e.clientY <= _restrictFocusRect.bottom && e.clientY >= _restrictFocusRect.top) {
                    e.clientY > this.original[3] ? $(this.obj).css({top: this.original[3] + 'px', height: e.clientY - this.original[3] + 'px'}) : this.turnUp(e);
                    _drawFocusArea();
                }
            },
            left: function (e) {
                if (e.clientX >= _restrictFocusRect.left && e.clientX <= _restrictFocusRect.right) {
                    e.clientX < this.width ? $(this.obj).css({left: e.clientX + 'px', width: this.width - e.clientX + "px"}) : this.turnRight(e);
                    _drawFocusArea();
                }
            },
            right: function (e) {
                if (e.clientX >= _restrictFocusRect.left && e.clientX <= _restrictFocusRect.right) {
                    e.clientX > this.original[2] ? $(this.obj).css({left: this.original[2] + 'px', width: e.clientX - this.original[2] + "px"}) : this.turnLeft(e);
                    _drawFocusArea();
                }
            },
            leftUp: function (e) {
                this.up(e);
                this.left(e);
                _drawFocusArea();
            },
            leftDown: function (e) {
                this.left(e);
                this.down(e);
                _drawFocusArea();
            },
            rightUp: function (e) {
                this.up(e);
                this.right(e);
                _drawFocusArea();
            },
            rightDown: function (e) {
                this.right(e);
                this.down(e);
                _drawFocusArea();
            },
            turnDown: function (e) {
                $(this.obj).css({top: this.height + 'px', height: e.clientY - this.height + 'px'});
                _drawFocusArea();
            },
            turnUp: function (e) {
                $(this.obj).css({top: e.clientY + 'px', height: this.original[3] - e.clientY + 'px'});
                _drawFocusArea();
            },
            turnRight: function (e) {
                $(this.obj).css({left: this.width + 'px', width: e.clientX - this.width + 'px'});
                _drawFocusArea();
            },
            turnLeft: function (e) {
                $(this.obj).css({left: e.clientX + 'px', width: this.original[2] - e.clientX + 'px'});
                _drawFocusArea();
            },
            destroy: function () {

                var element;
                while (element = this.resizeElements.shift()) {
                    element.unbind('.resize');
                    element.hide();
                }
                $(document).unbind('.resize');
            }
        });

        /**
         * 聚焦全屏后两边的侧边栏
         * @constructor
         */
        function SlideToolBar() {

            this.slideToolBar = $(document.getElementById('template_slideBar').innerHTML).css('display', 'none');
            $('body').append(this.slideToolBar);
            this._hasBindCommands = false;
            this._btns = {
                leftSlideToolBar: this.slideToolBar.find('.siderbar_left'),
                rightSlideToolBar: this.slideToolBar.find('.siderbar_right'),
                btnPackUp: this.slideToolBar.find('.btnSurfacePackUp'),
                btnPackUp2: [this.slideToolBar.find('.sidertool_zkleft'), this.slideToolBar.find('.sidertool_zkright')],
                btnPlay: this.slideToolBar.find('.btnSurfacePlay'),
                btnExit: this.slideToolBar.find('.btnSurfaceExit')
            };
        }

        SlideToolBar.prototype = new _EventUtil();
        SlideToolBar.constructor = SlideToolBar;

        SlideToolBar.prototype.show = function () {

            this._bindCommands();

            (app_global_bookContainer.getPageViewType() === _define.PageViewType.WhiteBoardView) && this._btns.btnPlay.hide();

            this.slideToolBar.css('display', 'block');
            var slideToolBarHeight = this._btns.leftSlideToolBar.height();
            var top = (Config.Height - slideToolBarHeight) / 2;
            this._btns.leftSlideToolBar.css({
                left: 0,
                top: top
            });
            this._btns.rightSlideToolBar.css({
                right: 0,
                top: top
            });

            this._btns.btnPackUp2[0].css({
                'left': 0,
                'top': top + slideToolBarHeight - this._btns.btnPackUp2[0].height()
            });

            this._btns.btnPackUp2[1].css({
                'right': 0,
                'top': top + slideToolBarHeight - this._btns.btnPackUp2[1].height()
            });

        }

        SlideToolBar.prototype._bindCommands = function () {

            if (this._hasBindCommands) return;
            this._hasBindCommands = true;

            var _self = this;

            this._btns.btnExit.on('click', function () {
                _self.triggerHandler('minmize');
                _self.destroy();
                event.stopPropagation();
            });

            var _isPackUp = false;

            this._btns.btnPackUp.on('click', function () {
                if (!_isPackUp) {
                    _self._btns.leftSlideToolBar.stop().animate({left: '-55px'}, 100);
                    _self._btns.rightSlideToolBar.stop().animate({right: '-55px'}, 100);
                    $.each(_self._btns.btnPackUp2, function (i, element) {
                        element.show();
                    });
                }
                _isPackUp = !_isPackUp;
            });

            $.each(this._btns.btnPackUp2, function (i, element) {
                element.on('click', function () {
                    _self._btns.leftSlideToolBar.stop().animate({left: '0px'}, 100);
                    _self._btns.rightSlideToolBar.stop().animate({right: '0px'}, 100);
                    $.each(_self._btns.btnPackUp2, function (i, element) {
                        element.hide();
                    });
                    _isPackUp = !_isPackUp;
                })
            });

            _addPlayEventListener(this._btns.btnPlay);
        }

        SlideToolBar.prototype.destroy = function () {
            if (this.slideToolBar) {
                this.slideToolBar.remove();
                this.slideToolBar = this._btns = null;
            }
        }
    }

    exports.Instance = new SurfaceTool;
});