/**
 * 画笔板擦模块，提供全局的画笔、板擦功能
 * Date: 2013/06/16
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module app/paint/canvasmgr
 */

define(function (require, exports, module) {

    var _model = require('../model');
    var canvasMgrHelper = require("./canvasmgrhelper").CanvasMgrHelper;
    var bbhelper = require("../blackboard/blackboardhelper").instance;
    var StrokeResult = require("./strokeresult").Instance;
    var ebContext = require("../ebookcontext").Instance;

    var TempToolType = {
        TransPenYellow: 'transPenYellow',
        TransPenRed: 'transPenRed',
        TransPenBlue: 'transPenBlue'
    }

    var Dom = {
        _colorBoxImg: $("#colorBoxImg"),
        _colorBox: $(document.getElementById('template_color_box').innerHTML),
        _otherPenControl: $(document.getElementById('template_other_pen_control').innerHTML),
        /** @type {jQuery} */
        _canvasContainer: $('<div/>').attr('class', 'paint_container').css({'width': '100%', 'height': '100%'}),
        _toolQtb: $("#tool_qtb")
    }

    /**
     */
    function PaintCanvas() {
        var strokes = [];
        var clearAreaPoints = [];
        //添加color_box
        Dom._colorBoxImg.popover({content: Dom._colorBox, userDefinePopover: true, popoverId: 'title', verticalOffset: "20"});

        //翻译
        LAN.translateObj(Dom._colorBox);

        //添加otherPenControl
        Dom._toolQtb.popover({content: Dom._otherPenControl, userDefinePopover: true, popoverId: 'title', verticalOffset: "20"});

        Dom = canvasMgrHelper.getCanvasMgrDom(Dom);
        var _self = this;
        /** @type {jQuery} */
        var _strokeCanvas;
        /** @type {CanvasRenderingContext2D} */
        var _strokeContext;
        /** @type {HTMLCanvasElement} */
        var _tempCanvas;
        /** @type {CanvasRenderingContext2D} */
        var _tempContext;
        var _curPenSize = 4;
        var _curPenColor = "Black";
        var _curEraserSize = bbhelper.EraserSize.Normal;
        var _isPainting = false;
        var _curTool = bbhelper.ToolType.Mouse;
        var _curOtherPen = TempToolType.TransPenYellow;
        var _curCursor = bbhelper.cursor.auto;
        var _lastSelected = {
            curToolType: null,
            penColorEle: $(Dom._penColors[0]),
            penColorValue: _curPenColor,
            penSizeEle: $(Dom._penSizes[1]),
            penSizeValue: _curPenSize,
            otherPenEle: null,
            otherPenValue: _curOtherPen,
            eraserType: bbhelper.ToolType.NormalEraser,
            eraserTypeEle: $(Dom._eraserTypes[1]),
            eraserTypeValue: _curEraserSize
        };
        var _isStrokeChanged = false;
        var _zoomRate = 1;
        var _isEditing = false;

        this.getStrokes = function () {
            return strokes;
        }

        this.setStrokes = function (_strokes) {
            strokes = _strokes;
        }

        /**
         * 返回基础画布canvas对象
         * @returns {jQuery}
         */
        this.getStrokeCanvas = function () {
            return   _strokeCanvas;
        }

        /**
         * 返回荧光笔、区域擦除临时画布canvas对象
         * @returns {jQuery}
         */
        this.getTempCanvas = function () {
            return   _tempCanvas;
        }

        /**
         * 返回画布父容器Div
         * @returns {jQuery}
         */
        this.getCanvasContainer = function () {
            return Dom._canvasContainer;
        }

        /**
         * 初始化画布
         */
        this.init = function () {
            _removePenSlectedStyles();
            _hidePopControls();
            _bindClickEventsToMainUI();
        }

        /**
         * 设置缩放后的板擦大小,否则放大的情况下板擦会跟着变大（鼠标很小，很怪）
         */
        this.setZoomedEraserSize = function (zoomRate) {
            _zoomRate = zoomRate;
            _curEraserSize = bbhelper.EraserSize[_lastSelected.eraserType] / zoomRate;
        }

        /**
         * 将_strokeCanvas内容绘制到viewDom
         */
        this.drawStrokeCanvasToBookContainer = function () {
            _drawStrokeCanvasToBookContainer();
        }

        /**
         * 将viewDom的canvas笔迹恢复到全局_strokeCanvas
         */
        this.restoreStrokeFromBookContainer = function () {
            _restoreStrokeFromBookContainer();
        }

        /**
         * 获取当前所处工具状态，是否处于鼠标状态
         */
        this.isMouseMode = function () {
            return (Dom.btnMouse.attr("class") === "tool_current");
        }

        /**
         * 清空canvas
         */
        this.clearCanvas = function () {
            _strokeContext.clearRect(0, 0, _strokeCanvas.width(), _strokeCanvas.height());
        }

        /**
         * 隐藏颜色选择器、荧光笔等弹出层控件
         */
        this.hidePopControls = function () {
            _hidePopControls();
        }

        /**
         * 设置编辑模式状态标记
         * @param {Boolean} value
         */
        this.setIsEditing = function (value) {
            if (value == _isEditing) return;
            _isEditing = value;

            Dom.btnPen.find('img').attr('src', 'assert/images/tool_brush' + (_isEditing ? '_disable' : '') + '.png');
            Dom.btnRightPen.find('img').attr('src', 'assert/images/tool_brush' + (_isEditing ? '_disable' : '') + '.png');
            Dom.btnEraser.find('img').attr('src', 'assert/images/tool_ostrich' + (_isEditing ? '_disable' : '') + '.png');
            Dom.btnRightEraser.find('img').attr('src', 'assert/images/tool_ostrich' + (_isEditing ? '_disable' : '') + '.png');

            (_isEditing) && ( Dom.btnMouse.trigger("click"));
        }

        /**
         * 获取画笔笔迹是否改变标记值
         */
        this.getIsStrokeChanged = function () {
            return _isStrokeChanged;
        }
        /**
         * 设定画笔笔迹是否改变标记值
         */
        this.setIsStrokeChanged = function (isStrokeChanged) {
            _isStrokeChanged = isStrokeChanged;
        }

        /**
         * 设置画笔颜色
         */
        function _setColor(color) {
            (_strokeContext != null) && ( _strokeContext.strokeStyle = color , _strokeContext.fillStyle = color, _curPenColor = color);
        }

        /**
         * 设置画笔、板擦粗细
         */
        function _setSize(tool, size) {
            if (_strokeContext) {
                _strokeContext.lineWidth = size, _strokeContext.lineJoin = "round", _strokeContext.lineCap = "round";
                if (tool === bbhelper.ToolType.Pen) {
                    _curPenSize = size;
                } else if (tool === bbhelper.ToolType.Eraser) {
                    _curEraserSize = size;
                }
            }
        }

        /**
         * 设置鼠标样式
         */
        function _setCursor(cursor) {
            (_strokeCanvas) && ( _strokeCanvas.css("cursor", cursor) , _curCursor = cursor);
        }

        /**
         * 设置工具类型
         */
        function _changeToMode(toolType) {
            _removeToolBarSlectedStyles();
            if (toolType === bbhelper.ToolType.Mouse) {
                _lastSelected.curToolType = _curTool = bbhelper.ToolType.Mouse;
                //设置工具栏鼠标选中状态
                Dom.btnMouse.attr("class", "tool_current");
                Dom.btnRightMouse.attr("class", "sidertool_current");
                _hidePopControls();
                _hideTempCanvas();
            }
            else if (toolType === bbhelper.ToolType.Pen) {
                //这里要先设置curtool，后面的bindCommands会用到
                _lastSelected.curToolType = _curTool = bbhelper.ToolType.Pen;
                //设置工具栏画笔选中状态
                Dom.btnPen.attr("class", "tool_current");
                Dom.btnRightPen.attr("class", "sidertool_current");
                _lastSelected.penColorEle.attr("class", "current");
                _lastSelected.penSizeEle.attr("class", "current");
                //隐藏板擦控件，显示画笔控件
                Dom.penControl.show(), Dom.eraserControl.hide();
                _hideTempCanvas();
                _createCanvas(), _bindCommands();
                _strokeContext.globalCompositeOperation = "source-over";
            //    _setSize(bbhelper.ToolType.Pen, _curPenSize);
            //    _setColor(_curPenColor);
                _setCursor(bbhelper.cursor.penCursor);
            }
            else if (toolType === bbhelper.ToolType.Eraser) {
                _lastSelected.curToolType = _curTool = bbhelper.ToolType.Eraser;
                //设置工具栏板擦选中状态
                Dom.btnEraser.attr("class", "tool_current");
                Dom.btnRightEraser.attr("class", "sidertool_current");
                Dom.btnLeftEraser.attr("class", "sidertool_current");
                _lastSelected.eraserTypeEle.attr("class", "party_current");
                //隐藏画笔控件，显示板擦控件
                Dom.penControl.css("display", "none");
                Dom.eraserControl.css("display", "block");
                _createCanvas(), _bindCommands();
                _strokeContext.globalCompositeOperation = "destination-out";
               // _setSize("eraser", _curEraserSize);
                _setCursor(_curCursor === bbhelper.cursor.auto ? bbhelper.cursor.midEraCursor  : _curCursor);
            }
        }

        /**
         * @description 创建绘图的canvas
         */
        function _createCanvas() {
            _strokeCanvas ? (_strokeCanvas.show()) :
                (_strokeCanvas = canvasMgrHelper.creatStrokeCanvas(_strokeCanvas),
                    Dom._canvasContainer.append(_strokeCanvas), _strokeContext = _strokeCanvas[0].getContext("2d"));
        };

        /**
         * 绑定绘制笔迹的事件
         */
        function _bindCommands() {

            //写的时候，记录手势
            //擦的时候，将修正手势的操作放至wbitem中

            _strokeCanvas.unbind();
            var startPoint = new _model.Point(), endPoint = new _model.Point(), _isPainting = false;

            _strokeCanvas.mousedown(function (evt) {
                var startX = evt.offsetX, startY = evt.offsetY;
                _strokeContext.beginPath();
                if (_curTool === bbhelper.ToolType.Pen) {
                    _hidePopControls();
                    //在仅仅点击鼠标时，需要画出一个点，如果不加上这0.01个像素，则画不出来
                    startPoint.x = startX + 4, startPoint.y = startY + 4;
                    endPoint.x = startX + 4 + 0.01, endPoint.y = startY + 4 + 0.01;
                    strokes.push([startPoint.x, startPoint.y]);
                    //很奇怪的，这两句放在这里才会起作用，并不是多余   ----  by  yczhu
                    _setSize("pen", _curPenSize);
                    _setColor(_curPenColor);
                    _strokeContext.moveTo(startPoint.x, startPoint.y), _strokeContext.lineTo(endPoint.x, endPoint.y);
                    _strokeContext.stroke();
                } else if (_curTool === bbhelper.ToolType.Eraser) {
                    startPoint.x = startX, startPoint.y = startY;
                    _strokeContext.clearRect(startPoint.x, startPoint.y, _curEraserSize, _curEraserSize);
                    //解决bug：翻页时为了将笔迹恢复而改成了source-over，但是板擦状态下需要改回来
                    _strokeContext.globalCompositeOperation = "destination-out";
                    //解决bug:单双页切换时板擦大小问题
                    _setSize(bbhelper.ToolType.Eraser, _curEraserSize);
                    strokes = bbhelper.clearPoints(startPoint, {width: _lastSelected.eraserTypeValue, height: _lastSelected.eraserTypeValue}, strokes);
                    $(_self).trigger('doEraser',[startPoint.x, startPoint.y, _curEraserSize, _curEraserSize])
                }
                _isPainting = _isStrokeChanged = true;
            })
                .mousemove(function (evt) {
                    if (_isPainting) {
                        if (_curTool === bbhelper.ToolType.Pen) {
                            endPoint.x = evt.offsetX + 4, endPoint.y = evt.offsetY + 4;
                            strokes.push([endPoint.x, endPoint.y]), _strokeContext.lineTo(endPoint.x, endPoint.y);
                            _strokeContext.stroke();
                        } else if (_curTool === bbhelper.ToolType.Eraser) {
                            endPoint.x = evt.offsetX;
                            endPoint.y = evt.offsetY;
                            _strokeContext.clearRect(endPoint.x, endPoint.y, _curEraserSize, _curEraserSize);

                            //TODO : here!!!
                            strokes = bbhelper.clearPoints(endPoint, {width: _lastSelected.eraserTypeValue, height: _lastSelected.eraserTypeValue}, strokes);
                            strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                            $(_self).trigger('doEraser',[endPoint.x, endPoint.y,_curEraserSize, _curEraserSize])
                        }
                    }
                })
                .mouseup(function () {
                    _mouseUpEventHelper();
                })
                .mouseout(function () {
                    //以前是 _curTool === bbhelper.ToolType.Pen && (_isPainting = false);
                    //目的使画笔和板擦在移出画布的表现一致。
                    // ----------  by  yczhu  2014年9月28日09:35:29
                    _mouseUpEventHelper();
                });

            /**
             * 辅助函数，只在这里使用。原因是_isPainting为_bindCommands函数内部有效
             */
            function _mouseUpEventHelper() {
                _isPainting = false;
                (_lastSelected.curToolType === bbhelper.ToolType.Pen) && (strokes.push([-1, -1]));
                (_lastSelected.curToolType === bbhelper.ToolType.Eraser) && (clearAreaPoints = []);

                //TODO : here!!!
                strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
            }

        }

        /**
         * 区域擦除、荧光笔时，显示上层的tempCanvas
         */
        function _showTempCanvas(tempTool) {
            _createCanvas();
            //创建tempCanvas
            _tempCanvas ? (_tempCanvas.show()) :
                ( _tempCanvas = canvasMgrHelper.creatTempCanvas(_tempCanvas, _strokeCanvas),
                    Dom._canvasContainer.append(_tempCanvas), _tempContext = _tempCanvas[0].getContext("2d"));

            _tempCanvas.unbind();
            if (tempTool === bbhelper.ToolType.AreaEraser) {
                _tempCanvas.css("cursor", bbhelper.cursor.areaEraCursor);
                _tempContext.strokeStyle = "blue";
                _tempContext.lineWidth = 1;
                //绑定事件
                var startX, startY, endX, endY;
                _tempCanvas.mousedown(function (evt) {
                    startX = evt.offsetX, startY = evt.offsetY;
                    _tempContext.lineJoin = "miter";

                    _tempContext.beginPath();
                    _isPainting = true;
                })
                    .mousemove(function (evt) {
                        endX = evt.offsetX, endY = evt.offsetY;
                        if (_isPainting) {
                            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                            _tempContext.strokeRect(startX, startY, endX - startX, endY - startY);
                        }
                    })
                    .mouseup(function () {
                        if (_isPainting) {
                            var clearAreaWidth = endX - startX, clearAreaHeight = endY - startY;
                            _strokeContext.globalCompositeOperation = "destination-out";
                            _strokeContext.fillRect(startX, startY, clearAreaWidth, clearAreaHeight);
                            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                            _isStrokeChanged = true;

                            //TODO : here!!!
                            strokes = bbhelper.clearPoints({x: startX, y: startY}, {width: clearAreaWidth, height: clearAreaHeight}, strokes);
                            strokes = bbhelper.removeSerialJoints(bbhelper.removeFirstJoint(strokes));
                            $(_self).trigger('doEraser',[startX,startY,clearAreaWidth,clearAreaHeight]);
                        }
                        _isPainting = false;
                    })
                    .mouseout(function () {
                        if (_isPainting) {
                            _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                        }
                        _isPainting = false;
                    });
            }
            if (tempTool === TempToolType.TransPenYellow
                || tempTool === TempToolType.TransPenRed
                || tempTool === TempToolType.TransPenBlue) {
                _curOtherPen = tempTool;
                _tempContext.lineWidth = 20, _tempContext.lineCap = "round", _tempContext.lineJoin = "round";
                if (tempTool === TempToolType.TransPenYellow) {
                    _tempContext.strokeStyle = _tempContext.fillStyle = "rgba(255,255,0,0.5)";
                } else if (tempTool === TempToolType.TransPenRed) {
                    _tempContext.strokeStyle = _tempContext.fillStyle = "rgba(255,0,0,0.5)";
                } else if (tempTool === TempToolType.TransPenBlue) {
                    _tempContext.strokeStyle = _tempContext.fillStyle = "rgba(0,0,255,0.5)";
                }
                var mouse = {x: 0, y: 0}, ppts = [];

                _tempCanvas.mousedown(function (e) {
                    mouse.x = e.offsetX, mouse.y = e.offsetY;
                    _onPaint();
                    _isPainting = _isStrokeChanged = true;
                    strokes.push([mouse.x -1, mouse.y -1]);
                })
                    .mousemove(function (e) {
                        mouse.x = e.offsetX, mouse.y = e.offsetY;
                        if (_isPainting) {
                            _onPaint();
                            strokes.push([mouse.x, mouse.y]);
                        }
                    })
                    .mouseup(function () {
                        _onEnd(this);
                    })
                    .mouseout(function () {
                        _onEnd(this);
                    });

                function _onPaint() {
                    ppts.push({x: mouse.x, y: mouse.y});
                    if (ppts.length < 2) {
                        var b = ppts[0];
                        _tempContext.beginPath();
                        _tempContext.arc(b.x, b.y, _tempContext.lineWidth / 2, 0, Math.PI * 2, !0);
                        _tempContext.fill();
                        _tempContext.closePath();
                        return;
                    }
                    _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                    _tempContext.beginPath();
                    for (var i = 0; i < ppts.length - 1; i++) {
                        var c = (ppts[i].x + ppts[i + 1].x) / 2;
                        var d = (ppts[i].y + ppts[i + 1].y) / 2;
                        _tempContext.quadraticCurveTo(ppts[i].x, ppts[i].y, c, d);
                    }
                    _tempContext.stroke();
                }

                function _onEnd(_this) {
                    //将笔迹拷贝到下层的canvas上
                    _strokeContext.drawImage(_this, 0, 0);
                    _tempContext.clearRect(0, 0, _tempCanvas.width(), _tempCanvas.height());
                    ppts = [];
                    _isPainting && strokes.push([-1, -1]);
                    _isPainting = false;
                }
            }
        }

        /**
         * 初始化页面时隐藏一些控件，例如板擦控件、颜色选择器、其他笔
         */
        function _hidePopControls() {
            //隐藏课本目录
            $("#directory_box_left").css("display", "none");
            $("#directory_box_right").css("display", "none");
            $("#localResId").hide();
            $("#localResNoneId").hide();
        }

        /**
         * 隐藏上层tempCanvas
         */
        function _hideTempCanvas() {
            _tempCanvas && _tempCanvas.hide();
        }

        /**
         * 清空canvas
         * @private
         */
        function _clearCanvas() {
            _strokeContext.clearRect(0, 0, _strokeCanvas.width(), _strokeCanvas.height());
            $(_self).trigger('doEraser',[0, 0, _strokeCanvas.width(), _strokeCanvas.height()]);
        }

        /**
         * 将_strokeCanvas内容绘制到底层
         */
        function _drawStrokeCanvasToBookContainer() {
            (_strokeCanvas) && (_hideTempCanvas(), $(_self).trigger('strokeChanged',[_strokeCanvas[0],_isStrokeChanged,strokes]),strokes = []);
        }

        /**
         * 将底层的canvas笔迹恢复到全局_strokeCanvas
         */
        function _restoreStrokeFromBookContainer() {
            if (_strokeCanvas) {
                _strokeContext.globalCompositeOperation = "source-over";
                $(_self).trigger('restoreStroke');
                _strokeCanvas.show();
                //解决bug：单双页切换后事件消失
                _bindCommands();
                //如果是区域擦除、荧光笔选中，则还显示tempCanvas
                if (Dom.tool_qycc.attr("class") === "party_current") {
                    (Dom.btnPen.attr("class") != "tool_current") && _showTempCanvas(bbhelper.ToolType.AreaEraser);
                }
            }
        }

        /**
         * 删除上方和左右两侧所有按钮的选中状态
         */
        function _removeToolBarSlectedStyles() {
            Dom.mainToolBar.children().children(".tool_current").attr("class", "tool_normal");
            Dom.rightToolbar.children().children(".sidertool_current").attr("class", "sidertool_normal");
            Dom.leftToolbar.children().children(".sidertool_current").attr("class", "sidertool_normal");
        };

        /**
         * 去除所有画笔颜色、粗细的选中状态
         */
        function _removePenSlectedStyles() {
            Dom._penColors.attr("class", "normal"), Dom._penSizes.attr("class", "normal");
            Dom.otherPenControl.children().children(".party_current").attr("class", "party_normal");
        };

        /**
         * 去除所有板擦颜色、粗细的选中状态
         */
        function _removeEraserSlectedStyles() {
            Dom.eraserControl.find("dd").attr("class", "party_normal");
        };

        /**
         * 给页面元素绑定点击事件
         */
        function _bindClickEventsToMainUI() {

            $("#zwsb").unbind().click(function () {
                _drawStrokeCanvasToBookContainer();
                $(_self).trigger('recognition',[bbhelper.LanguageType.Chinese]);
            });

            $("#ywsb").unbind().click(function () {
                _drawStrokeCanvasToBookContainer();
                $(_self).trigger('recognition',[bbhelper.LanguageType.English]);
//                (!StrokeResult.ready ) && StrokeResult.init();
//                _drawStrokeCanvasToBookContainer();
//                StrokeResult.showResult(bbhelper.LanguageType.English, strokes);
            });

            //全局鼠标
            Dom.btnMouse.click(function () {
                _removePenSlectedStyles();
                _removeEraserSlectedStyles();
                _changeToMode(bbhelper.ToolType.Mouse);
                _drawStrokeCanvasToBookContainer();
                //切换到鼠标状态后设为false，则在翻页等操作时就不用再保存笔迹到pageItem上了
                _isStrokeChanged = false;
                (_strokeCanvas) && (_strokeCanvas.hide());
            });

            //右侧工具栏鼠标
            Dom.btnRightMouse.click(function () {
                Dom.btnMouse.click();
            });

            //全局画笔
            Dom.btnPen.click(function (event) {
                //隐藏展开的便签内容
                if (!_isEditing) {
                    $('.notes_box').hide();
                    var isFromMouse = (Dom.btnMouse.attr("class") == "tool_current");
                    _changeToMode(bbhelper.ToolType.Pen);
                    //从鼠标切换过来时才恢复笔迹
                    (isFromMouse) &&  _restoreStrokeFromBookContainer();
                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            //右侧工具栏画笔
            Dom.btnRightPen.click(function () {
                Dom.btnPen.click();
            });

            //全局板擦
            Dom.btnEraser.click(function () {
                if (!_isEditing) {
                    (!_lastSelected.eraserType) ?
                        (_lastSelected.eraserType = bbhelper.ToolType.NormalEraser, _lastSelected.curToolType = bbhelper.ToolType.NormalEraser) :
                        ( _lastSelected.curToolType = _lastSelected.eraserType);

                    //  yczhu  add    2014年10月23日17:22:24
                    _lastSelected.eraserType == bbhelper.ToolType.SmallEraser && _setCursor(bbhelper.cursor.minEraCursor);
                    _lastSelected.eraserType == bbhelper.ToolType.NormalEraser && _setCursor(bbhelper.cursor.midEraCursor);
                    _lastSelected.eraserType == bbhelper.ToolType.BigEraser && _setCursor(bbhelper.cursor.bigEraCursor);

                    var isFromMouse = (Dom.btnMouse.attr("class") == "tool_current");
                    //这一步是为了防止直接从鼠标切换到板擦时，全局画布不存在
                    _changeToMode(bbhelper.ToolType.Eraser);

                    //当鼠标处于选中状态时，直接点击板擦按钮，需要从页面上恢复笔迹给全局Canvas
                    isFromMouse && _restoreStrokeFromBookContainer();
                    //这一步是为了将全局画布转到板擦状态
                    _changeToMode(bbhelper.ToolType.Eraser);
                    //修复荧光笔直接到板擦的bug
                    (_tempCanvas && _tempCanvas.css("display") == "block") && _tempCanvas.hide();
                    //如果是区域擦除选中，则还显示tempCanvas.
                    (_lastSelected.eraserType === bbhelper.ToolType.AreaEraser) && (Dom.btnPen.attr("class") != "tool_current") && _showTempCanvas(bbhelper.ToolType.AreaEraser);

                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            //右侧工具栏板擦
            Dom.btnRightEraser.click(function () {
                Dom.btnEraser.click();
            });

            //绑定画笔颜色点击事件
            Dom._penColors.click(function () {
                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    Dom.btnPen.triggerHandler('click');
                    Dom._penColors.attr("class", "normal");
                    var _herethis = $(this);
                    _herethis.attr("class", "current");
                    _setColor(_herethis.attr('color'));
                    _lastSelected.penColorEle = _herethis;
                    _lastSelected.penColorValue = _herethis.attr('color');
                    _lastSelected.curToolType = bbhelper.ToolType.Pen;
                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            //颜色选择器图标
            Dom._colorBoxImg.click(function (event) {
                if (!_isEditing) {
                    _hidePopControls();
                    var $this = $(this);
                    $this.popover("fadeOutAll");
                    (!$this.popover('isShow', 'title')) ?
                        ( $this.popover('show', 'title', {position: app_global_isMainToolBarUp ? 'bottom' : 'top'})) :
                        ($this.popover('hide', 'title'));
                    Dom._colorBox.parent().css("z-index", 11);
                    event.stopPropagation();
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            //关闭颜色选择器
            Dom._colorBox.find("#close_box").click(function () {
                Dom._colorBoxImg.popover('hide');
                event.stopPropagation();
            });

            //绑定画笔粗细
            Dom._penSizes.click(function () {
                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    Dom.btnPen.click();
                    Dom._penSizes.attr("class", "normal");
                    var herethis = $(this);
                    herethis.attr("class", "current");
                    _setSize(bbhelper.ToolType.Pen, herethis.attr("size"));
                    _lastSelected.penSizeEle = herethis;
                    _lastSelected.penSizeValue = herethis.attr("size");
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });

            //绑定板擦粗细
            Dom.tool_small.click(function () {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.SmallEraser, Dom.tool_small,
                        bbhelper.cursor.minEraCursor, $(this), bbhelper.EraserSize.Small);
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });
            Dom.tool_mid.click(function () {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.NormalEraser, Dom.tool_mid,
                        bbhelper.cursor.midEraCursor, $(this), bbhelper.EraserSize.Normal);
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });
            Dom.tool_big.click(function () {
                if (!_isEditing) {
                    eraserClickHelper(bbhelper.ToolType.BigEraser, Dom.tool_big,
                        bbhelper.cursor.bigEraCursor, $(this), bbhelper.EraserSize.Big);
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });
            //区域擦除
            Dom.tool_qycc.click(function () {
                if(!_isEditing){
                    //模拟点击一次板擦按钮
                    Dom.btnEraser.click();
                    _removeEraserSlectedStyles();
                    Dom.tool_qycc.attr("class", "party_current");
                    _showTempCanvas(bbhelper.ToolType.AreaEraser);
                    _tempCanvas.css("cursor", bbhelper.cursor.areaEraCursor);
                    _lastSelected.eraserTypeEle = $(this);
                    _lastSelected.eraserTypeValue = bbhelper.ToolType.AreaEraser;
                    _lastSelected.curToolType = bbhelper.ToolType.AreaEraser;
                    _lastSelected.eraserType = bbhelper.ToolType.AreaEraser;
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });
            //全部擦除
            Dom.tool_qbcc.click(function () {
                if (!_isEditing) {
                    //模拟点击一次板擦按钮
                    Dom.btnEraser.click();
                    _clearCanvas();
                    _setCursor(_curCursor);
                    _isStrokeChanged = true;
                    //TODO　: here !!!
                    strokes = [];
                }
                else {
                    app_global_alertNotEdit && app_global_alertNotEdit();
                }
            });
            //给其他笔绑定点击事件
            Dom._toolQtb.click(function () {
                if (!_isEditing) {
                    //如果当前为鼠标状态，需要先切换到画笔状态，相当于先点击了画笔按钮
                    Dom.btnPen.click();
                    _hidePopControls();
                    $(this).popover('show', 'title', {position: app_global_isMainToolBarUp ? 'bottom' : 'top'});
                    Dom._otherPenControl.parent().css("z-index", 11);
                    Dom._otherPenControl.find(app_global_isMainToolBarUp ? ".bot_arrow" : ".top_arrow").hide().siblings().show();
                    _showTempCanvas(_curOtherPen);
                    _tempCanvas.css("cursor", bbhelper.cursor.penCursor);
                    if (_curOtherPen === TempToolType.TransPenYellow) {
                        QTBClickHelper(Dom.tool_flupen, TempToolType.TransPenYellow);
                    } else if (_curOtherPen === TempToolType.TransPenRed) {
                        QTBClickHelper(Dom.tool_flugred, TempToolType.TransPenRed);
                    } else if (_curOtherPen === TempToolType.TransPenBlue) {
                        QTBClickHelper(Dom.tool_flugblue, TempToolType.TransPenBlue);
                    }
                    event.stopPropagation();
                }
            });

            Dom.tool_flupen.click(function () {
                if (!_isEditing) {
                    fiuPenClickHelper(Dom.tool_flupen, "transPenYellow", $(this), bbhelper.ToolType.TransPenYellow);
                }
            });
            Dom.tool_flugred.click(function () {
                if (!_isEditing) {
                    fiuPenClickHelper(Dom.tool_flugred, "transPenRed", $(this), bbhelper.ToolType.TransPenRed);
                }
            });
            Dom.tool_flugblue.click(function () {
                if (!_isEditing) {
                    fiuPenClickHelper(Dom.tool_flugblue, "transPenBlue", $(this), bbhelper.ToolType.TransPenBlue);
                }
            });
        }

        function eraserClickHelper(tooltype, domeraser, curstr, herethis, erasersize) {
            _lastSelected.eraserType = tooltype;
            _self.setZoomedEraserSize(_zoomRate);
            //模拟点击一次板擦按钮
            Dom.btnEraser.click();
            _removeEraserSlectedStyles();
            domeraser.attr("class", "party_current");
            _hideTempCanvas();
            _setCursor(curstr);
            _lastSelected.eraserTypeEle = herethis;
            _lastSelected.eraserTypeValue = erasersize;
            _lastSelected.curToolType = tooltype;
        }

        function QTBClickHelper(pen, color) {
            Dom.otherPenControl.children().children(".party_current").attr("class", "party_normal");
            pen.attr("class", "party_current");
            _lastSelected.curToolType = color;
        }

        function fiuPenClickHelper(nowFluPen, colorstr, herethis, toolType) {
            Dom.otherPenControl.children().children(".party_current").attr("class", "party_normal");
            nowFluPen.attr("class", "party_current");
            _showTempCanvas(colorstr);
            _curOtherPen = colorstr;
            _lastSelected.otherPenEle = herethis;
            _lastSelected.otherPenValue = colorstr;
            _lastSelected.curToolType = toolType;
        }

    }

    exports.Instance = new PaintCanvas();
});