﻿/**
 * Created with JetBrains WebStorm.
 * User: Taly
 * Date: 13-6-16
 * Time: 下午1:49
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {
    require('browserContext');
    var define = require('./define');
    var path = require('../common/path');
    require('jqjson');


    /**
     *
     * @param {number=} x
     * @param {number=} y
     * @constructor
     */
    function Point(x, y) {
        this.x = x || 0;
        this.y = y || 0;
    }

    Point.prototype.toString = function () {
        return $.toJSON(this);
    };

    /**
     * 计算到另一点的距离
     * @param {Point} p 点
     * @return {number}
     */
    Point.prototype.distance = function (p) {
        try{
        var distance = Math.sqrt(Math.pow((this.x - p.x), 2) + Math.pow((this.y - p.y), 2));
        }catch (e){
            console.log(this);
            console.log(p);
        }
        return distance;
    };

    /**
     * 偏移量
     * @param {number=} x
     * @param {number=} y
     * @constructor
     */
    function Offset(x, y) {
        this.x = x || 0;
        this.y = y || 0;
    }

    Offset.prototype.toString = function () {
        return $.toJSON(this);
    };

    /**
     *
     * @param {number=} width 宽度
     * @param {number=} height 高度
     * @constructor
     */
    function Size(width, height) {
        this.width = width || 0;
        this.height = height || 0;
    }

    Size.prototype.toString = function () {
        return $.toJSON(this);
    };

    /**
     * 图形边界
     * @param {number=} left
     * @param {number=} top
     * @param {number=} width
     * @param {number=} height
     * @constructor
     */
    function Bound(left, top, width, height) {
        this.left = left || 0;
        this.top = top || 0;
        this.height = height || 0;
        this.width = width || 0;

        this.right = left + this.width;
        this.bottom = top + this.height;
        this.center = new Point(this.left + this.width / 2, this.top + this.height / 2);
    }

    Bound.prototype.toString = function () {
        return $.toJSON(this);
    };

    // 保存时需要的用；隔开的字符串
    Bound.prototype.serialize = function () {
        return [this.left, this.top, this.width, this.height].join(';');
    };

    /**
     * 图形边界内是否包含点
     * @param {Point | model.Point} point
     * @returns {boolean}
     */
    Bound.prototype.isContainsPoint = function (point) {
        return point.x >= this.left && point.x <= this.right && point.y >= this.top && point.y <= this.bottom;
    };

    /**
     * 创建热区元数据
     * @param {define.HotSpotType} type 热区类型
     * @param {JSON} xamlJSON
     * @constructor
     */
    function HotspotMeta(type, xamlJSON) {
        this.type = type;

        if (type === define.HotspotType.Path) {
            this.data = xamlJSON['Data'];
        } else {
            this.width = parseInt(xamlJSON['Width']);
            this.height = parseInt(xamlJSON['Height']);
            this.left = parseInt(xamlJSON['Canvas.Left']);
            this.top = parseInt(xamlJSON['Canvas.Top']);
        }

        this.audio = parseInt(xamlJSON['eb:HotspotControl.Audio']);
        this.zIndex = parseInt(xamlJSON['Panel.ZIndex']);
    }

    HotspotMeta.prototype.toString = function () {
        return $.toJSON(this);
    };

    HotspotMeta.prototype.toXml = function () {
        var xmlResult = '';
        var hotspotType = '';
        if (this.type == define.HotspotType.Rectangle)
            hotspotType = "Rectangle";
        else if (this.type == define.HotspotType.Ellipse)
            hotspotType = "Ellipse";
        else
            hotspotType = "Path";

        xmlResult += "\n<" + hotspotType + " ";

        if (hotspotType == "Path")
            xmlResult += "Data=" + "'" + this.data + "' ";
        else
            xmlResult += "Width=" + "'" + this.width + "' " + "Height=" + "'" + this.height + "' " +
                "Canvas.Left=" + "'" + this.left + "' " + "Canvas.Top=" + "'" + this.top + "' ";

        xmlResult += "eb:HotspotControl.Audio=" + "'" + this.audio + "' " + "Panel.ZIndex=" + "'" +
            this.zIndex + "'>";
        xmlResult += "\n</" + hotspotType + ">";
        return xmlResult;
    };


    /**
     * 目录条目
     * @param {string} title
     * @param {number} pageIndex
     * @constructor
     * 之前程序中将pageCode当成pageIndex使了，这会导致相当一部分书课本目录无法显示——xjzhou：2013年8月14日11:24:33s
     */
    function MenuItem(title, pageCode, pageIndex,pageIndexEnd, unitCode) {
        /**
         * 标题，课本目录显示时需要用到
         * 加载课本时，xml反序列化得到
         * @type {string}
         */
        this.title = title;
        /**
         *  单元起始页pageCode，课本目录显示时需要用到
         *  加载课本时，xml反序列化得到
         * @type {string}
         */
        this.pageCode=pageCode;

        /**
         * 单元起始页pageIndex，通过课本目录跳转到相应页码时需要用到
         * 加载课本时，手动计算获得
         * @type {number}
         */
        this.pageIndex = pageIndex;

        /**
         * 单元结尾页pageIndex，通过课本目录跳转到相应页码时需要用到
         * 加载课本时，手动计算获得
         * @type {number}
         */
        this.pageIndexEnd=pageIndexEnd;

        /**
         * 单元编码，xml文件中没有，但资源库中定位到当前单元时需要用到
         * 加载课本时，手动计算获得
         * @type {*}
         */
        this.unitCode = unitCode;

        this.courses={};
    }

    function Book(bookCode, bookInfo) {
        this.bookCode = bookCode;
        this.title = bookInfo.Title
        this.subject = bookInfo.Subject;
        this.publisher = bookInfo.Publisher;
        this.grade = bookInfo.Grade;
        this.volumn = bookInfo.Volumn;
        this.bookId=bookInfo.ID;
    }

    /////
    function createImgNode() {
        return {
            "img": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.Img),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }

    function createVideoNode() {
        return {
            "video": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "Inside"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.Video),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }

    function createFlashNode() {
        return {
            "flash": {
                "src": "",
                "title": "",
                "thumb": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.Flash),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }

    function createEvalNode() {
        return {
            "file": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.Evaluate),
            "bound": "0;0;0;0",
            "editable": "True",
            "type": ""
        };
    }


    function createOnlineResNode() {
        return {
            "file": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.OnlineRes),
            "bound": "0;0;0;0",
            "editable": "True",
            "type": ""
        };
    }



    function createProc3rdNode() {
        return {
            "file": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "id": _createId(define.WidgetType.Proc3rd),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }

    function createGalleryNode() {
        return {
            "file": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.Gallery),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }

    function createChoiceNode() {
        return {
            "file": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": _createId(define.WidgetType.Choice),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }

    function createAudioNode() {
        return {
            "audio": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "stack",
                "style": "pop"
            },
            "id": _createId(define.WidgetType.Audio),
            "bound": "0;0;0;0",
            "editable": "True"
        };
    }


    function createNoteNode(){

        var id= _createId(define.WidgetType.Note);
        return{
            "note": {
                "src": "",
                "title": ""
            },
            "layout": {
                "src": "absolute",
                "style": "inside"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": id,
            "bound": "0;0;0;0"
        }
    }

    function createFadeCurtainNode(){
        var id= _createId(define.WidgetType.FadeCurtain);
        return{
            "fadeCurtain": {
                "src":""
            },
            "layout": {
                "src": "absolute",
                "style": "inside"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": id,
            "bound": "0;0;0;0",
            "editable": "True",
            "style": ""
        }
    }

    function createICWNode(){
        var id= _createId(define.WidgetType.Icw);
        return{
            "icw": {
                "src":""
            },
            "layout": {
                "src": "absolute",
                "style": "inside"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": id,
            "bound": "0;0;0;0",
            "editable": "True",
            "style": ""
        }
    }

    function createImgPaintNode(){
        var id= _createId(define.WidgetType.ImgPaint);
        return{
            "imgPaint": {
                "src":""
            },
            "layout": {
                "src": "absolute",
                "style": "inside"
            },
            "event": [
                {
                    "action": "opened",
                    "style": "zoomin_anim"
                },
                {
                    "action": "closed",
                    "style": "zoomout_anim"
                }
            ],
            "id": id,
            "bound": "0;0;0;0",
            "editable": "True",
            "style": ""
        }
    }


    var lastHash;
    function _createId(widgetType) {
        var now = new Date();
        var hash;
        if(!lastHash) hash=lastHash=[now.getMonth(), now.getDay(), now.getHours(), now.getMinutes(), now.getSeconds(), now.getMilliseconds()].join('');
        else hash=++lastHash;

        var id = widgetType + '_' + hash;
        if ($(id).length > 0) {
            throw new Error('create uniqueid failed!');
        }
        return id;
    }


    //export

    exports.Point = Point;
    exports.Offset = Offset;
    exports.Size = Size;
    exports.Bound = Bound;
    exports.HotspotMeta = HotspotMeta;
    exports.MenuItem = MenuItem;
    exports.Book = Book;

    exports.createImgNode = createImgNode;
    exports.createGalleryNode = createGalleryNode;
    exports.createChoiceNode = createChoiceNode;
    exports.createProc3rdNode = createProc3rdNode;
    exports.createEvalNode = createEvalNode;
    exports.createOnlineResNode=createOnlineResNode;
    exports.createFlashNode = createFlashNode;
    exports.createVideoNode = createVideoNode;
    exports.createAudioNode = createAudioNode;
    exports.createNoteNode =  createNoteNode;
    exports.createFadeCurtainNode=createFadeCurtainNode;
    exports.createICWNode = createICWNode;
    exports.createImgPaintNode = createImgPaintNode;
})