/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-8-6
 * Time: 下午5:30
 * To change this template use File | Settings | File Templates.
 */
/**
 * Idea :
 * 当一个新用户第一次登录软件的时候，
 * 需要在User文件夹下为他创建独立的文件夹以存放文件
 * 三个必须的文件夹：
 * ebook : 电子书存放文件夹，电子书以bookCode存放
 * userbook : 电子书对应资源文件夹
 * localresource : 本地资源存放文件夹
 *
 * 2014 - 07 - 12 添加 wboard文件夹 : 此文件夹存放白板上显示的笔迹，icon，手势等。
 *
 *                  ------  by yczhu
 */
define(function (require, exports) {
        var _path = require('../../common/path');
        var _shellcmd = require('../../common/shellcmd');

        function UserFolderCreator() {
            var _self = this;
            var _user = null;

            this.setUser = function (user) {
                _self.user = user;
            }
            /**
             * 创建用户目录
             */
            this.createUserDir = function () {
                var def = $.Deferred();
                _self._createUserFolders().done(function (ret1) {
                    var logfile = _path.trimPosix( _path.join(Config.binPath,"/log/userfold.log"));
                    var con = "create Dir res :: " + ret1 + "----" + new Date();
                    //添加日志文件
                    _shellcmd.savefileappent(con,logfile).done(function(){
                        if (ret1) {
                            _self._createUserDbByCopy().done(function (ret2) {
                                def.resolve(ret2);
                            });
                        }
                        else {
                            def.resolve(ret1)
                        }
                    });
                });
                return def.promise();
            }

            /**
             * 创建用户文件夹
             * @returns {boolean}
             */
            this._createUserFolders = function () {
                var def = $.Deferred();
                var userStdBookFolder = _path.trimPosix(_self.user.getStdBookBasePath());
                var userBookFolder = _path.trimPosix(_self.user.getUserBookBasePath());
                var userResourceFolder = _path.trimPosix(_self.user.getUserResourceBasePath());
                var userWBFolder = _path.trimPosix(_self.user.getUserWBPath());

                _shellcmd.createDir(userStdBookFolder).done(function (ret1) {
                    if (ret1) {
                        _shellcmd.createDir(userBookFolder).done(function (ret2) {
                            if (ret2) {
                                _shellcmd.createDir(userResourceFolder).done(function (ret3) {
                                    if (ret3) {
                                        _shellcmd.createDir(userWBFolder).done(function (ret4) {
                                           if(ret4){
                                               var _xmlstr = '<eb:page background="1.jpg" xmlns:eb="EBookLib">'+
                                                   '<eb:absolutelayout></eb:absolutelayout></eb:page>';
                                               _shellcmd.saveFile(_xmlstr,userWBFolder + "/wb.xaml");
                                               def.resolve(true);
                                           }
                                        });
                                    } else {
                                        def.resolve(false);
                                    }
                                });
                            } else {
                                def.resolve(false);
                            }
                        });
                    } else {
                        def.resolve(false);
                    }
                });
                return def.promise();
            }

            /**
             *通过文件复制的方式创建数据库
             * @returns {*}
             * @private
             */
            this._createUserDbByCopy = function () {
                var def = $.Deferred();
                var srcFile = _path.trimPosix(_self.user.getTempUserDb());
                console.log("srcFile  " + srcFile);
                var dstPath = _path.trimPosix(_self.user.getUserDbFullPath());
                console.log(dstPath);
                _shellcmd.copyFile(srcFile, dstPath).done(function () {

                    var logfile = _path.trimPosix( _path.join(Config.binPath,"/log/userfold.log"));
                    var con = "==== copyDB ====" + new Date();
                    //添加日志文件
                    _shellcmd.savefileappent(con,logfile).done(function(){
                        var content = _shellcmd.readFile(dstPath);
                        if (content && content.length >=3000) { //成功
                            def.resolve(true);
                        } else {
                            def.resolve(false);
                        }
                    });
                });
                return def.promise();
            }
        }

        UserFolderCreator.prototype = new UserFolderCreator();
        UserFolderCreator.prototype.constructor = UserFolderCreator;
        exports.Instance = new UserFolderCreator();
    }
)
;