/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-24
 * Time: 下午3:46
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var shellCmd = require("../../common/shellcmd");
    require('zebra_dialog');
    var ebookContext = require('../ebookcontext').Instance;
    var SchoolList = [];
    var regSchoolId = 0;

    var nameflag = false;
    var realnameflag = false;
    var phoneflag = false;
    var pwdflag = false;
    var pwd2flag = false;
    var schoolflag = false;
    var provinceflag = 0;
    var cityflag = 0;
    var districtflag = 0;
    var left = ($(window).width() - 524) / 2;
    var top = ($(window).height() - 623) / 2;

    var ddTpl = '<dd id="{idStr}" flag="schoolItem" class="ddHover" code="{codeStr}">{TxtStr}</dd>';

    function Register() {
        var _self = this;
        _self.Dom = {};
        _self.ready = false;
        _self.ShowActive = false;
        _self.LoginModule = null;

        _self.provinceId = "";
        _self.provinceName = "";
        _self.provinceCode = "";
        _self.cityId = "";
        _self.cityName = "";
        _self.cityCode = "";
        _self.areaId = "";
        _self.areaName = "";
        _self.areaCode = "";
        _self.schoolId = "";
        _self.schoolName = "";

        _self.phone1 = "";

        _self.timer = null;
        _self.clickFlag = false;
    }

    Register.prototype.init = function () {
        var _self = this;
        //Caution ： 初始化的时候去获取ClientToken
        //理论上在发送请求之前可以获取的到
        //但不保证
        (!app_ClientToken) && (ebookContext.getClientToken());
        //初始化页面结构
        _self.Dom.registerPanel = $($("#registerHtml")[0].innerHTML);
        _self.Dom.registerPanel.appendTo("body");
        //用户名--改为账号
        _self.Dom.NameLi = $("#regNameLi");
        _self.Dom.NameInput = $("#regName");
        _self.Dom.NameTips = $("#regNameTips");
        //真实姓名
        _self.Dom.RealNameInput = $("#realName");
        _self.Dom.RealNameTips = $("#realNameTips");
        //电话
        _self.Dom.PhoneLi = $("#regPhoneLi");
        _self.Dom.PhoneInput = $("#regPhone");
        _self.Dom.PhoneTips = $("#regPhoneTips");
        //密码
        _self.Dom.PwdLi = $("#regPwdLi");
        _self.Dom.PwdInput = $("#regPwd");
        _self.Dom.PwdTips = $("#regPwdTips");
        //确认密码
        _self.Dom.Pwd2Li = $("#regPwd2Li");
        _self.Dom.Pwd2Input = $("#regPwd2");
        _self.Dom.Pwd2Tips = $("#regPwd2Tips");
        //学校
        _self.Dom.SchoolLi = $("#SchoolLi");
        _self.Dom.SchoolInput = $("#School");
        _self.Dom.SchoolTips = $("#SchoolTips");

        _self.Dom.activeTips = $("#activeTips");

        _self.Dom.closeRegister = $("#closeRegister");

        _self.Dom.provinceSw = $("#provinceSw");
        _self.Dom.citySw = $("#citySw");
        _self.Dom.districtSw = $("#districtSw");
        _self.Dom.schoolSw = $("#schoolSw");

        _self.Dom.provinceDl = $("#provinceDl");
        _self.Dom.cityDl = $("#cityDl");
        _self.Dom.districtDl = $("#districtDl");
        _self.Dom.schoolDl = $("#regSchoolDl");

        _self.Dom.cityTxt = $("#cityTxt");
        _self.Dom.districtTxt = $("#districtTxt");
        _self.Dom.provinceTxt = $("#provinceTxt");
        _self.Dom.provinceLi = $("#provinceLi");

        _self.Dom.regRegister = $("#regRegister");
        _self.Dom.resendMsgBtn = $("#resendMsgBtn");
        _self.Dom.checkInput = $("#checkInput");
        _self.Dom.registerClose = $("#register_close");
        _self.Dom.regTips = $("#regErrorTips");

        nameflag = false;
        realnameflag = false;
        phoneflag = false;
        pwdflag = false;
        pwd2flag = false;
        schoolflag = false;
        provinceflag = 0;
        cityflag = 0;
        districtflag = 0;

        _self.bindEvnt();
        _self.ready = true;
    }

    Register.prototype.show = function () {
        var _self = this;
        //每次页面关闭之后，再次打开会重新生成DOM
        !_self.ready && _self.init();
        _self.Dom.registerPanel.css("top", top).css("left", left).show();
        _self.Dom.regTips.hide();
    }

    Register.prototype.close = function () {
        var _self = this;
        SchoolList = [];
        _self.Dom.registerPanel.remove();
        _self.ready = false;
        _self.Dom = {};
    }

    Register.prototype.bindEvnt = function () {
        var _self = this;

        _self.Dom.closeRegister.click(function () {
            _self.close();
        });
        _self.Dom.registerClose.click(function () {
            _self.close();
        });

        _self.Dom.NameInput
            .focus(function () {
                _self.Dom.NameTips.hide();
                _self.Dom.NameTips.prev().hide();
                _self.Dom.NameInput.addClass('act_input_on');
            }).blur(function () {
                _self.regCheckName(_self.Dom.NameInput.val());
                _self.Dom.NameInput.removeClass('act_input_on');
            });

        //真实姓名
        _self.Dom.RealNameInput
            .focus(function(){
                _self.Dom.RealNameTips.hide();
                _self.Dom.RealNameTips.prev().hide();
                _self.Dom.RealNameInput.addClass('act_input_on');
            }).blur(function(){
                _self.regCheckRealName(_self.Dom.RealNameInput.val());
                _self.Dom.RealNameInput.removeClass('act_input_on');
            })

        _self.Dom.PhoneInput
            .focus(function () {
                _self.Dom.PhoneTips.hide();
                _self.Dom.PhoneTips.prev().hide();
                _self.Dom.PhoneInput.addClass('act_input_on');
            }).blur(function () {
                _self.regCheckPhoneNumber(_self.Dom.PhoneInput.val());
                _self.Dom.PhoneInput.removeClass('act_input_on');
            });

        _self.Dom.PwdInput
            .focus(function () {
                _self.Dom.PwdTips.hide();
                _self.Dom.PwdTips.prev().hide();
                _self.Dom.PwdInput.addClass('act_input_on');
            }).blur(function () {
                _self.regCheckPassword(_self.Dom.PwdInput.val());
                _self.Dom.PwdInput.removeClass('act_input_on');
            });

        _self.Dom.Pwd2Input
            .focus(function () {
                _self.Dom.Pwd2Tips.hide();
                _self.Dom.Pwd2Tips.prev().hide();
                _self.Dom.Pwd2Input.addClass('act_input_on');
            }).blur(function () {
                _self.regCheckPassword2(_self.Dom.Pwd2Input.val());
                _self.Dom.Pwd2Input.removeClass('act_input_on');
            });

        _self.Dom.checkInput.blur(function () {
            _self.Dom.checkInput.removeClass('act_input_on');
        }).focus(function () {
                _self.Dom.checkInput.addClass('act_input_on');
            });

        _self.Dom.SchoolInput[0].oninput = function () {
            _self.Dom.SchoolTips.html("").show();
            _self.Dom.SchoolTips.prev().attr("class", "tips_ic_error").hide();
            _self.clickFlag = false;
            _self.schoolFuzzyMatch();
        };

        _self.Dom.SchoolInput.click(function () {
            _self.Dom.SchoolTips.html("").show();
            _self.Dom.SchoolTips.prev().attr("class", "tips_ic_error").hide();
            _self.clickFlag = false;
            _self.schoolFuzzyMatch();
        }).blur(function () {
            !_self.clickFlag && _self.regCheckSchool(_self.Dom.SchoolInput.val(), _self.provinceName, _self.cityName, _self.areaName)
        })

        _self.Dom.schoolSw.mouseout(function () {
            _self.Dom.schoolDl.hide();
        });

        _self.Dom.schoolDl.mouseover(function () {
            _self.clickFlag = true;
            _self.Dom.schoolDl.show();
        });

        _self.Dom.provinceSw.click(function () {
            _self.Dom.cityDl.hide();
            _self.Dom.districtDl.hide();
            cityflag = 0;
            districtflag = 0;
            if (provinceflag == 0) {
                _self.showProvince();
                provinceflag = 1;
            } else {
                _self.Dom.provinceDl.hide();
                provinceflag = 0;
            }
        });

        _self.Dom.citySw.click(function () {
            provinceflag = 0;
            districtflag = 0;
            _self.Dom.provinceDl.hide();
            _self.Dom.districtDl.hide();
            if (cityflag == 0) {
                _self.showCity(_self.provinceId);
                cityflag = 1;
            } else {
                _self.Dom.cityDl.hide();
                cityflag = 0;
            }
        });

        _self.Dom.districtSw.click(function () {
            cityflag = 0;
            provinceflag = 0;
            _self.Dom.provinceDl.hide();
            _self.Dom.cityDl.hide();
            if (districtflag == 0) {
                _self.showDistrict(_self.cityId);
                districtflag = 1;
            } else {
                _self.Dom.districtDl.hide();
                districtflag = 0;
            }
        });

        _self.Dom.regRegister.click(function () {
            _self.gotToRegiste(_self.Dom.NameInput.val(), _self.Dom.PhoneInput.val(),
                _self.Dom.PwdInput.val(), _self.Dom.checkInput.val(), "", _self.Dom.Pwd2Input.val(),_self.Dom.RealNameInput.val());
        });

        //联系我们
        $("#qqContactMe").click(function () {
            var QQService = require('../../common/QQService').QQService;
            QQService();
        });

        _self.Dom.resendMsgBtn.click(function () {
            var phoneNumStr = _self.Dom.PhoneInput.val();
            _self.regCheckPhoneNumber(_self.Dom.PhoneInput.val());
            if (phoneflag) {
                _self.Dom.resendMsgBtn.attr("disabled", true);
                _self.Dom.resendMsgBtn.css('cursor', 'default');
                _self.Dom.resendMsgBtn.html(AppCfg.reSendMsg + RegActiveTips.ReSendLater);
                _self.reSendActiveCountTime(AppCfg.reSendMsg);
                //记录手机号，供注册时再次验证
                _self.phone1 = phoneNumStr;

                var url = AppRemoteSvcCfg.sendPhoneMsg,
                    obj = {
                        phoneNum : phoneNumStr,
                        timeout: 30000, //设置超时
                        dataType: "json"
                    }

                shellCmd.getHttpRequest(url,obj).done(function($active){
                    if($active){
                        if ($active.errorCode == 0) {

                        }
                    }
                });
            }
        });
    }

    //用户名验证--用户名改成账号
    Register.prototype.regCheckName = function (regCheckStr) {
        var _self = this;
        var regex = /^([A-Za-z0-9_]){2,30}$/;
        if (regCheckStr == "") {
            //提示不能为空
            _self.Dom.NameTips.html(RegActiveTips.NotBeNull).show();
            _self.Dom.NameTips.prev().attr("class", "tips_ic_error").show();
            nameflag = false;
        } else if (regex.exec(regCheckStr) == null) {
            //提示输入不正确
            _self.Dom.NameTips.html(RegActiveTips.InputError).show();
            _self.Dom.NameTips.prev().attr("class", "tips_ic_error").show();
            nameflag = false;
        } else if (regCheckStr.match(/^1\d{10,10}$/)) {
            //提示输入不正确
            _self.Dom.NameTips.html(RegActiveTips.CanNotBePhone).show();
            _self.Dom.NameTips.prev().attr("class", "tips_ic_error").show();
            nameflag = false;
        } else {
            //正确
            var url = AppRemoteSvcCfg.regCheckName + regCheckStr + "&access_token=" + app_ClientToken;
            shellCmd.getHttpRequest(url).done(function ($exist) {
                if ($exist) {
                    if ($exist.return == "true") {
                        nameflag = false;
                        _self.Dom.NameTips.html(RegActiveTips.AccountExist).show();
                        _self.Dom.NameTips.prev().attr("class", "tips_ic_error").show();
                    } else {
                        nameflag = true;
                        _self.Dom.NameTips.html("").show();
                        _self.Dom.NameTips.prev().attr("class", "tips_ic_right").show();
                    }
                }
            });
        }
    }

    //真实姓名验证
    Register.prototype.regCheckRealName = function(regCheckStr){
        //TODO:正则表达式验证
        var _self = this;
        var regex = /^[A-Za-z\u4e00-\u9fa5]{2,10}$/;
        var regex1 = /^[A-Za-z]+$/;
        if(regex.exec(regCheckStr) != null && regex1.exec(regCheckStr) == null){
            //正确
            realnameflag = true;
            _self.Dom.RealNameTips.html("").show();
            _self.Dom.RealNameTips.prev().attr("class", "tips_ic_right").show();
        }else if(regCheckStr == ""){
            //提示不能为空
            _self.Dom.RealNameTips.html(RegActiveTips.NotBeNull).show();
            _self.Dom.RealNameTips.prev().attr("class", "tips_ic_error").show();
            realnameflag = false;
        }else{
            //提示输入不正确
            _self.Dom.RealNameTips.html(RegActiveTips.InputError).show();
            _self.Dom.RealNameTips.prev().attr("class", "tips_ic_error").show();
            realnameflag = false;
        }



    }

    //手机号验证
    Register.prototype.regCheckPhoneNumber = function (regCheckStr) {
        var _self = this;
        var regex = /^1[3|4|5|7|8][0-9]\d{8,8}$/;
        if (regCheckStr == "") {
            //提示不能为空
            phoneflag = false;
            _self.Dom.PhoneTips.html(RegActiveTips.NotBeNull).show();
            _self.Dom.PhoneTips.prev().attr("class", "tips_ic_error").show();
        } else if (regex.exec(regCheckStr) == null) {
            //提示输入不正确
            phoneflag = false;
            _self.Dom.PhoneTips.html(RegActiveTips.InputError).show();
            _self.Dom.PhoneTips.prev().attr("class", "tips_ic_error").show();
        } else {
            var url = AppRemoteSvcCfg.regCheckPhoneNumber + regCheckStr + "&access_token=" + app_ClientToken;
            shellCmd.getHttpRequest(url).done(function ($exist) {
                if ($exist) {
                    if ($exist.return == "true") {
                        phoneflag = false;
                        _self.Dom.PhoneTips.html(RegActiveTips.PhoneExist).show();
                        _self.Dom.PhoneTips.prev().attr("class", "tips_ic_error").show();
                    } else {
                        phoneflag = true;
                        _self.Dom.PhoneTips.html("").show();
                        _self.Dom.PhoneTips.prev().attr("class", "tips_ic_right").show()
                    }
                }
            });
        }
    }

    //密码验证
    Register.prototype.regCheckPassword = function (regCheckStr) {
        var _self = this;
        var regex = /^([A-Za-z0-9_]){6,16}$/;
        if (regCheckStr == "") {
            _self.Dom.PwdTips.html(RegActiveTips.NotBeNull).show();
            _self.Dom.PwdTips.prev().attr("class", "tips_ic_error").show();
            pwdflag = false;
        } else if (regex.exec(regCheckStr) == null) {
            _self.Dom.PwdTips.html(RegActiveTips.InputError).show();
            _self.Dom.PwdTips.prev().attr("class", "tips_ic_error").show();
            pwdflag = false;
        } else {
            _self.Dom.PwdTips.html("").show();
            _self.Dom.PwdTips.prev().hide();
            pwdflag = true;
        }
    }

    //二次密码验证
    Register.prototype.regCheckPassword2 = function (regCheckStr) {
        var _self = this;
        if (regCheckStr == "") {
            _self.Dom.Pwd2Tips.html(RegActiveTips.NotBeNull).show();
            _self.Dom.Pwd2Tips.prev().attr("class", "tips_ic_error").show();
            pwd2flag = false;
        } else if (_self.Dom.PwdInput.val() != regCheckStr) {
            _self.Dom.Pwd2Tips.html(RegActiveTips.RePwdError).show();
            _self.Dom.Pwd2Tips.prev().attr("class", "tips_ic_error").show();
            pwd2flag = false;
        } else {
            _self.Dom.Pwd2Tips.html("").show();
            _self.Dom.Pwd2Tips.prev().hide();
            pwd2flag = true;
        }
    }

    Register.prototype.regCheckSchool = function (regCheckStr, tempProvince, tempCity, tempdistrict) {
        var _self = this;
        if (tempProvince != RegActiveTips.TaiWan && tempProvince != RegActiveTips.HongKong &&
            tempProvince != RegActiveTips.Macao) {
            if ((tempProvince == "") || (tempCity == "") || (tempdistrict == "")) {
                //提示不能为空
                _self.Dom.SchoolTips.html(RegActiveTips.NoSchoolInfo).show();
                _self.Dom.SchoolTips.prev().attr("class", "tips_ic_error").show();
                schoolflag = false;
            } else {
                //判断学校是否符合要求
                var tempFlag = 0;
                for (var i = 0; i < SchoolList.length; i++) {
                    if (SchoolList[i].school_name == regCheckStr) {
                        tempFlag = 1;
                        regSchoolId = SchoolList[i].school_id;
                        break;
                    }
                }
                if (!tempFlag) {
                    //提示输入不正确
                    _self.Dom.SchoolTips.html(RegActiveTips.NoSchoolInfo).show();
                    _self.Dom.SchoolTips.prev().attr("class", "tips_ic_error").show();
                    schoolflag = false;
                } else {
                    _self.Dom.SchoolTips.html("").show();
                    _self.Dom.SchoolTips.prev().hide();
                    schoolflag = true;
                }
            }
        } else {
            //特殊处理，不提示正确，啥也不管
            _self.Dom.SchoolTips.html("").show();
            _self.Dom.SchoolTips.prev().hide();
            schoolflag = true;
        }
    }

    //获得省
    Register.prototype.showProvince = function () {
        var _self = this;
        var url = AppRemoteSvcCfg.showProvince + "&access_token=" + app_ClientToken;
        shellCmd.getHttpRequest(url).done(function ($province) {
            if ($province) {
                createDd($province, _self.Dom.provinceDl);
                var $ddlist = _self.Dom.provinceDl.find("dd");
                $ddlist.click(function () {
                    var $this = $(this);
                    _self.Dom.cityDl.empty();
                    _self.Dom.districtDl.empty();
                    _self.cityId = "";
                    SchoolList = [];
                    _self.Dom.SchoolInput.attr("disabled", true);
                    var innerTxt = $this[0].innerText;
                    _self.provinceId = $this.attr("id");
                    _self.provinceCode = $this.attr("code");
                    _self.provinceName = $this[0].innerText;
                    if (innerTxt == RegActiveTips.TaiWan || innerTxt == RegActiveTips.HongKong || innerTxt == RegActiveTips.Macao) {

                        //特殊处理，不提示正确，也不显示错误,啥也不管
                        _self.getSchoolByArea($(this).attr("id"));
                    }
                    else {
                        cityflag = 0;
                        districtflag = 0;
                        _self.showCity($(this).attr("id"));
                        _self.Dom.cityDl.show();
                    }
                    _self.Dom.cityTxt.html("市");
                    _self.Dom.districtTxt.html("县/区");
                    _self.Dom.provinceDl.hide();
                    _self.Dom.provinceTxt.html(innerTxt);
                    //取消事件冒泡
                    return false;
                });
            }
        });
    }

    //获取市
    Register.prototype.showCity = function (provinceId) {
        var _self = this;
        var url = AppRemoteSvcCfg.showCity + provinceId + "&access_token=" + app_ClientToken;
        shellCmd.getHttpRequest(url).done(function ($city) {
            if ($city) {
                console.log($city);
                //遍历并取出省份
                createDd($city, _self.Dom.cityDl);
                var $ddList = _self.Dom.cityDl.find("dd");
                $ddList.click(function () {
                    SchoolList = [];
                    var $this = $(this);
                    _self.Dom.SchoolInput.attr("disabled", true);
                    _self.cityId = $this.attr("id");
                    _self.cityName = $this[0].innerText;
                    _self.cityCode = $this.attr("code");
                    _self.Dom.districtDl.empty().show();
                    _self.showDistrict($this.attr("id"));
                    _self.Dom.cityDl.hide();
                    _self.Dom.cityTxt.html($this[0].innerText);
                    _self.Dom.districtTxt.html("县/区");
                    provinceflag = 0;
                    districtflag = 0;
                    //取消事件冒泡
                    return false;
                });
            }
        })
    }

    //获取区/县
    Register.prototype.showDistrict = function (cityId) {
        var _self = this;
        var url = AppRemoteSvcCfg.showDistrict + cityId + "&access_token=" + app_ClientToken;
        shellCmd.getHttpRequest(url).done(function ($district) {
            if ($district) {
//                console.log($district);
                createDd($district, _self.Dom.districtDl);
                var $ddList = _self.Dom.districtDl.find("dd");
                $ddList.click(function () {
                    var $this = $(this);
                    _self.areaId = $this.attr("id");
                    _self.areaName = $this[0].innerText;
                    _self.areaCode = $this.attr("code");
                    _self.getSchoolByArea($this.attr("id"));
                    _self.Dom.SchoolInput.val("");
                    _self.Dom.schoolDl.hide();
                    _self.schoolId = "";
                    _self.schoolName = "";
                    _self.Dom.districtDl.hide();
                    _self.Dom.districtTxt.html($this[0].innerText);
                    cityflag = 0;
                    provinceflag = 0;
                    return false;
                });
            }
        });
    }

    Register.prototype.gotToRegiste = function (name, phone, pwd, checkcode, activecode, pwd2,realname) {
        showLoading({tips: AppBlackBoardTipsList.Register});
        var _self = this;
        if (activecode == RegActiveTips.InputActiveCode) {
            activecode = "";
        }
        if (pwd == pwd2) {
            if (_self.Dom.SchoolInput.val() == "") {
                _self.schoolName = "";
                _self.schoolId = "";
            }
            _self.regCheckSchool(_self.Dom.SchoolInput.val(), _self.provinceName, _self.cityName, _self.areaName);
            if(_self.phone1){
                if (phone && checkcode && nameflag && realnameflag && phoneflag && schoolflag && pwd2flag && pwdflag && phone == _self.phone1) {

                    //先验证验证码
                    var postJson3 = {
                        url: AppRemoteSvcCfg.checkPhone,
                        phoneNum : phone,
                        code : checkcode
                    }
                    console.log(postJson3);
                    shellCmd.postHttpRequest(postJson3).done(function (retjson3) {
                        console.log(retjson3);
                        var retjson3Obj = JSON.parse(retjson3);
                        if(retjson3Obj.errorCode == "0"){

                            //注册参数
                            var postJson2 = {
                                url: AppRemoteSvcCfg.UserRegisterUrl,
                                email: "",
                                password: pwd,
                                regName: name,
                                username: realname,
                                phoneNum: phone,
                                qqNum: "",
                                //这一坨我知道很挫，请不要动，TMD字段是ID，存的属性确实是code  -----  by  yczhu
                                province: _self.provinceName,
                                provinceId: _self.provinceCode,
                                city: _self.cityName,
                                cityId: _self.cityCode,
                                district: _self.areaName,
                                districtCode: _self.areaCode,
                                school: _self.schoolName,
                                schoolId: _self.schoolId,
                                gradeId: "",
                                grade: "",
                                subjectId: "",
                                subject: "",
                                address: "",
                                sex: "",
                                fixedNum: "",
                                code: activecode
                            }
                            console.log(postJson2);
                            shellCmd.postHttpRequest(postJson2).done(function ($register) {
                                $register = JSON.parse($register);
                                console.log($register);
                                //获得注册结果，取消计时器
                                _self.clearTimer(false);
                                if ($register.errorCode == 0) {
                                    //注册成功后自动登录
                                    app_global_loginMgr.loginFunction(name, pwd);
                                }
                                else {
                                    hideLoading();
                                    //Caution : 这里的提示信息不在客户端
                                    _self.regShowTips($register.errorInfo);
                                }
                            })
                        }
                        else if(retjson3Obj.errorCode == "1001"){
                            hideLoading();
                            _self.regShowTips("验证码错误");
                        }
                        else if(retjson3Obj.errorCode == "1002"){
                            hideLoading();
                            _self.regShowTips("验证码过期");
                        }
                    });

                }
                else {
                    hideLoading();
                    _self.Dom.SchoolTips.html("").show();
                    _self.Dom.SchoolTips.prev().attr("class", "tips_ic_error").hide();
                    _self.regShowTips(RegActiveTips.CompleteInfo);
                }
            }
            else{
                hideLoading();
                _self.regShowTips(RegActiveTips.VerificationError);
            }
        } else {
            hideLoading();
            _self.regShowTips(RegActiveTips.RePwdError);
        }
    }

    //重新发送激活码计时器
    Register.prototype.reSendActiveCountTime = function (tempTime) {
        var _self = this;
        var tempTimeNext;
        if (_self.Dom.resendMsgBtn) {
            if (tempTime < 2) {
                _self.clearTimer(false);
            }
            else {
                tempTimeNext = tempTime - 1;
                _self.Dom.resendMsgBtn.show().html(tempTimeNext + RegActiveTips.ReSendLater);
                _self.timer = setTimeout(function () {
                    _self.reSendActiveCountTime(tempTimeNext)
                }, 1000);
            }
        }

//              为避免递归，可采用如下方法
//                 var timecount = setInterval(function(){
//                        tempTimeNext--;
//                        _self.Dom.resendMsgBtn.show().html(tempTimeNext + "秒后重新发送");
//                 },1000);
//                setTimeout(function(){
//                        clearInterval(timecount);
//                        _self.Dom.resendMsgBtn.show().html("重新发送至手机");
//                        _self.Dom.resendMsgBtn.attr("disabled",false);
//                        _self.Dom.resendMsgBtn.css('cursor','pointer');
//                },120000);
    }

    Register.prototype.clearTimer = function(boolflag){
        var _self = this;
        _self.Dom.resendMsgBtn.show().html(RegActiveTips.ResendMsg).attr("disabled", boolflag).css('cursor', 'pointer');
        clearInterval(_self.timer);
    }

    Register.prototype.schoolFuzzyMatch = function () {
        var _self = this;
        var str = _self.Dom.SchoolInput.val();
        _self.Dom.schoolDl.empty();
        var ddlistStr = "";
        //全文匹配
        if (str) {
            if (SchoolList.length > 0) {
                for (var i = 0; i < SchoolList.length; i++) {
                    if (SchoolList[i].school_name.indexOf(str) > -1) {
                        ddlistStr += ddTpl.replace("{TxtStr}", SchoolList[i].school_name).replace("{idStr}", SchoolList[i].school_id);
                    }
                }
                var ddlist = $(ddlistStr);
                _self.Dom.schoolDl.append(ddlist).show();
                ddlist.filter("dd").unbind().click(function () {
                    var $this = $(this);
                    _self.Dom.SchoolInput.val($this.text());
                    _self.clickFlag = false;
                    _self.Dom.schoolDl.hide();
                    _self.schoolId = $this.attr("id");
                    _self.schoolName = $this[0].innerText;
                    _self.Dom.SchoolInput.blur();
                });
            }
        }
        //显示全部
        else {
            if (SchoolList.length > 0) {
                for (var i = 0; i < SchoolList.length; i++) {
                    ddlistStr += ddTpl.replace("{TxtStr}", SchoolList[i].school_name).replace("{idStr}", SchoolList[i].school_id);

                }
                var ddlist = $(ddlistStr);
                _self.Dom.schoolDl.append(ddlist).show();
                ddlist.filter("dd").unbind().click(function () {
                    var $this = $(this);
                    _self.Dom.SchoolInput.val($this.text());
                    _self.Dom.schoolDl.hide();
                    _self.clickFlag = false;
                    _self.schoolId = $this.attr("id");
                    _self.schoolName = $this[0].innerText;
                    _self.Dom.SchoolInput.blur();
                });
            }
        }
    }

    Register.prototype.getSchoolByArea = function (districtId) {
        var _self = this;
        SchoolList = [];
        var url = AppRemoteSvcCfg.showSchool + districtId + "&withAllChildren=true" + "&access_token=" + app_ClientToken;
        shellCmd.getHttpRequest(url).done(function ($school) {
            if ($school) {
                for (var i = 0; i < $school.length; i++) {
                    var schoolStr = {'school_name': $school[i].schoolName, 'school_id': $school[i].schoolId};
                    SchoolList.push(schoolStr);
                }
            }
            _self.schoolFuzzyMatch();
        });
        //放开学校输入
        _self.Dom.SchoolInput.attr("disabled", false);
    }


    function createDd(list, domContainer) {
        var myOptionStr = "";
        for (var i = 0; i < list.length; i++) {
            //创建新的元素option
            myOptionStr += ddTpl.replace("{idStr}", list[i].id)
                .replace("{TxtStr}", list[i].areaName)
                .replace("{codeStr}", list[i].areaCode);
        }
        domContainer.empty().append($(myOptionStr)).show();
    }

    Register.prototype.regShowTips = function(tips) {
        var _self = this;
        _self.Dom.regTips.text(tips).show();
//        $.Zebra_Dialog(tips, {
//            'type': 'information',
//            'title': AppTips.WarmTips,
//            'buttons': [ AppTips.OkTips],
//            'zIndex': 1000
//        });
    }

    exports.Instance = new Register();
});

