/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-22
 * Time: 上午9:51
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    require('zebra_dialog');
    var CloudLogin = require("./cloudlogin").CloudLogin;
    var ChinaMobileLogin = require("./ChinaMobileLogin").ChinaMobileLogin;
    var LocalLogin = require("./locallogin").LocalLogin;
    var shellcmd = require("../../common/shellcmd");
    var register = require('./register').Instance;
    var result = require("./loginhelper").Result;
    var ebookContext = require('../ebookcontext').Instance;
    var _pageNavigatorHelper = require('../../common/pagenavigatorhelper');
    var _loginAssistor = require('./loginAssistor');
    var Md5Helper = require('../../common/md5helper');
    var _path = require('../../common/path');
    var _thirdShow = 0;
    var _oauthShow = false;
    var _commonfunc = require('../../common/commonfunc');

    function LoginMgr() {
        var _self = this;
        _self.DOM = null;
        _self.cloudLogin = new CloudLogin();
        _self.localLogin = new LocalLogin();
        _self.ChinaMobileLogin = new ChinaMobileLogin();
        _self.jahdhlist = [];
    }

    LoginMgr.prototype.initDOM = function () {
        var _self = this;
        _self.DOM = {};

        _self.DOM = {
            loginPanel: $("#loginOverlay"),
            closeBtn: $("#closeLogin"),
            loginBtn: $("#loginBtn"),
            accountTxt: $("#accountInput"),
            pwdTxt: $("#pwdInput"),
            forgetPassword: $("#forgetPassword"),
            freeRegist: $("#freeRegist"),
            loginOsk: $("#loginOsk"),
            loginTip: $("#loginTip"),
            solrLogin: $("#ESonlogin"),
            oauthList_btn: $("#oauthList_btn"),
            oauthList_main: $("#oauthList_main"),
            oauthList_main_tr: $("#oauthList_main_tr"),
            login_error: $("#login_error"),
            accountLi: $("#accountLi"),
            pwdLi: $("#pwdLi"),

            personalAuthInfoIfrm : $('#personalAuthInfoIfrm'),
            personalAuthInfoPanel : $('#personalAuthInfoPanel'),
            auth_lr_pop_tit : $('#auth_lr_pop_tit'),
            personalAuthInfoPanelMask : $('#personalAuthInfoPanelMask'),
            authClose:$('#auth_lr_pop_tit_closde')
        }

        _self.getOauthList();
        var _top = ($(window).height() - 307) / 2;
        _self.DOM.loginPanel.css("top", _top);
    }

    LoginMgr.prototype.show = function () {
        var _self = this;

        if (AppVersionCfg.AppVersion == AppVerCfg.GanSuPlat) {
            _self.thirdlogin(AppVersionCfg.otherLoginUrl, AppVersionCfg.LoginTip);
            return ;
        }

        _self.DOM.loginPanel.show();
        _self.DOM.loginTip.css("visibility", "hidden");
        _self.DOM.oauthList_main.hide();
        _thirdShow = 0;
    }

    LoginMgr.prototype.bingEventsToDOM = function () {
        var _self = this;

        _self.DOM.authClose.click(function(){
            _self.DOM.personalAuthInfoPanel.hide();
        });

        _self.DOM.closeBtn.click(function () {
            //注销身份验证成功的账户,和默认账户登录成功保持一致
            var ebuser = ebookContext.getUser();
            ebuser.setName(AppCfg.defaultuser);
            ebuser.setPassword("");
            ebuser.setUid(0);
            ebuser.setEmail("");
            ebuser.setPhoneNum("");
            ebuser.setIsActive(false);
            _self.DOM.accountTxt.val("");
            _self.DOM.pwdTxt.val("");
            _self.DOM.oauthList_main.hide();
            _thirdShow = 0;
            _self.DOM.loginPanel.hide();
        });

        _self.DOM.loginBtn.click(function () {
            var account = _self.DOM.accountTxt.val();
            var pwd = _self.DOM.pwdTxt.val();
            account = account === "用户名" ? "" : account;


            if (AppVersionCfg.AppVersion == AppVerCfg.ChinaMobile) {
                var salt = 'njxtqgjyptfromlianchuang';
                var encodingPassword = Md5Helper.b64_md5(pwd + salt);
                showLoading({tips: AppBookShelfTipsList.IsLoginning});
                _self.ChinaMobileLogin.AccountCheck(account, encodingPassword).done(function (ret1) {
                    if (ret1.responseJSON && ret1.responseJSON.error == "invalid_grant") {
                        _self.showTips(AppTips.localLoginWrongPasswordMsg);
                    }
                    else if (ret1.responseJSON == undefined && ret1.access_token == undefined) {
                        _self.showTips(AppTips.NetWorkConnectFailed);
                    }
                    else {
                        console.log(ret1.access_token);
                        if (ret1.access_token != undefined && ret1.access_token != "") {
                            var httpurl = App3rdUrl.ChinaMobileInfo + ret1.access_token;
                            shellcmd.getHttpRequest(httpurl).done(function (userInfo) {
                                console.log(userInfo);
                                var userInfoStr = {
                                    url: AppRemoteSvcCfg.ChinaMobileCheckUrl,
                                    account: account,
                                    password: pwd,
                                    name: userInfo.body.name == null ? account : userInfo.body.name,
                                    phone: userInfo.body.phone,
                                    schoolName: userInfo.body.classes[0].schoolName
                                }
                                shellcmd.postHttpRequest(userInfoStr).done(function (ret) {
                                    console.log(ret);
                                    //  _self.DOM.loginPanel.hide();
                                    _self.beforeLogin(ret, account);
                                });
                            });

                        }
                        else {
                            _self.showTips(AppTips.localLoginWrongPasswordMsg);
                        }
                    }
                });
            }
            else {
                _self.beforeLogin(account, pwd);
            }

        });

        _self.DOM.oauthList_btn.click(function () {
            if (_thirdShow == 0) {
                _self.DOM.oauthList_main.show();
                _thirdShow = 1;
            } else {
                _self.DOM.oauthList_main.hide();
                _thirdShow = 0;
            }
        });

        _self.DOM.accountTxt.focus(function () {
            _self.DOM.accountLi.addClass('click');
        });

        _self.DOM.accountTxt.blur(function () {
            _self.DOM.accountLi.removeClass('click');
        });

        _self.DOM.pwdTxt.focus(function () {
            _self.DOM.pwdLi.addClass('click');
        });

        _self.DOM.pwdTxt.blur(function () {
            _self.DOM.pwdLi.removeClass('click');
        });

        _self.DOM.loginPanel.keydown(function (e) {
            if (e.which == 13) {
                //13 是 Enter 键的键码
                _self.DOM.loginBtn.click();
            }
        });

        _self.DOM.forgetPassword.click(function () {
            shellcmd.openPageOutside(AppRemoteSvcCfg.UserForgetPasswordPageUrl);
        });

        _self.DOM.freeRegist.click(function () {
            shellcmd.checkOnline().done(function (ret) {
                if (ret) {
                    //   register.setLoginModule(this);
                    register.show();
                    _self.DOM.closeBtn.click();
                }
                else {
                    showAlertTips(AppTips.NetWorkConnectFailed);
                }
            });
        })

        _self.DOM.loginOsk.click(function () {
            shellcmd.callIme("keyboard");
        })

        _self.DOM.solrLogin.click(function () {
            shellcmd.checkOnline().done(function (ret) {
                if (ret) {
                    clearCookie();
                    _self.DOM.loginPanel.hide();
                    var solrLogin = require("./solrlogin").Instance;
                    solrLogin.show();
                }
                else {
                    showAlertTips(AppTips.NetWorkUnstable);
                }
            });
        });
    }

    LoginMgr.prototype.beforeLogin = function (account, password) {
        var _self = this;
        //检查环境
        shellcmd.checkEnvironment().done(function (isEnvironmentAllowed) {
            if (isEnvironmentAllowed) {
                shellcmd.checkRunningDiskSpace().done(function (freeSpace) {
                    console.log(freeSpace);
                    if (freeSpace < AppCfg.memoryRequired) {
                        $.Zebra_Dialog(AppTips.OutOFMemoryMsg, {
                            'type': 'question',
                            'title': AppTips.WarmTips,
                            'buttons': [AppTips.CancelTips, AppTips.OkTips],
                            'onClose': function (capition) {
                                if (capition == AppTips.OkTips) {
                                    _self.loginFunction(account, password, true);
                                } else {
                                    return;
                                }
                            }
                        });
                    } else {

                        _self.loginFunction(account, password, true);
                    }
                });
            } else {
                _self.showTips(AppTips.loginWrongMachineMsg);
            }
        });
    }

    /**
     * 登录过程函数
     * @param account  账号
     * @param pwd      密码
     * @param flag     是否注销标记（默认登录）
     * @param flag2     是否离线登录
     */
    LoginMgr.prototype.loginFunction = function (account, pwd, flag, flag2) {
        var defer = $.Deferred();
        var _self = this;
        if (!account || !pwd) {
            _self.showTips(AppTips.loginNoPasswordMsg);
            defer.resolve();
        }
        else {
            _self.cloudLogin.beforeCheckInfo(account, pwd).done(function (cloudresult) {
                if (cloudresult != result.CloudResult.webError) {
                    _self.showCloudResult(cloudresult, account, pwd, flag);
                    defer.resolve(cloudresult);
                }
                else {
                    //联网登录失败，做离线登录处理
                    _self.localLogin.checkInfo(account, pwd).done(function (localresult) {
                        _self.showLocalResult(localresult, account, pwd);
                        defer.resolve(localresult);
                    });
                }
            });
        }
        return defer.promise();
    }

    LoginMgr.prototype.showCloudResult = function (cloudresult, account, pwd, flag) {
        var _self = this;
        switch (cloudresult) {
            case result.CloudResult.webError:
                _self.showTips(AppTips.NetWorkConnectFailed);
                break;
            case result.CloudResult.accountOrPwdWrong:
                _self.showTips(AppTips.localLoginWrongPasswordMsg);
                break;
            case result.CloudResult.isDeleOrOutDate:
                _self.showTips(AppTips.accountForbiddenMsg);
                break;
            case result.CloudResult.canNotBind:
                _self.showTips(AppTips.bindOverflowMsg);
                _self.DOM.loginTip.find("#btnRempveBind").click(function () {
//                    var removeRebindUrl = AppRemoteSvcCfg.RemoveRebindUrl + "&ticket=" + ebookContext.getUser().getTicket();
//
//                    shellcmd.openPageOutside(removeRebindUrl);

                    var url = AppRemoteSvcCfg.RemoveRebindUrl + 'loginName=' + ebookContext.getUser().getName();
                    showIFrame(url, _self.DOM.personalAuthInfoIfrm, _self.DOM.personalAuthInfoPanel, _self.DOM.auth_lr_pop_tit,_self.DOM.personalAuthInfoPanelMask);
                });
                break;
            case result.CloudResult.getBindMsgError:
            case result.CloudResult.bindFail:
                _self.showTips(AppTips.bindFailMsg);
                break;
            case result.CloudResult.alreadyBind:
            case result.CloudResult.bindSuccess:
                ebookContext.getUser().setIsOnline(true);
                if (flag) {
                    //write SSO infomations into the security file when login through the dialog.
                    shellcmd.writeAESUserInfo(account + '|' + pwd);
                }
                _loginAssistor.createUserFolder(ebookContext.getUser()).done(function (ret) {
                    if (!ret) {
                        console.log("创建用户目录失败");
                        shellcmd.deleteDir(_path.trimPosix(ebookContext.getUser().getUserBasePath()));
                        _self.showTips(AppTips.loginCreateFolderFailMsg);
                        return;
                    }
                    _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser());
                });
                break;
            default :
        }
    }

    LoginMgr.prototype.showLocalResult = function (localresult, userAccount, password) {
        var _self = this;
        switch (localresult) {
            case result.LocalResult.noLicense:
                _self.showTips(AppTips.loginFailMsg);
                break;
            case result.LocalResult.accountForbidden:
                _self.showTips(AppTips.accountForbiddenMsg);
                break;
            case result.LocalResult.argumentImperfect:
                _self.showTips(AppTips.loginFailMsg);
                break;
            case result.LocalResult.accountNotMatchPwd:
                _self.showTips(AppTips.localLoginWrongPasswordMsg);
                break;
            case result.LocalResult.accountNotMatchMachineCode:
                _self.showTips(AppTips.localLoginWrongMachineMsg);
                break;
            case result.LocalResult.timeStampOver:
                _self.showTips(AppTips.timeStampOverMsg);
                break;
            case result.LocalResult.localSuccess:
                //获取isActive
                _loginAssistor.getUserInfo(userAccount).done(function (ret) {
                    var obj = JSON.parse(ret);
                    ebookContext.setUser(userAccount, password);
                    ebookContext.getUser().setIsOnline(false);
                    ebookContext.getUser().setTicket("");
                    ebookContext.getUser().setIsActive(!!(obj.data[0].isactive == "true"));
                    ebookContext.getUser().setUserName(obj.data[0].reserve1);
                    _pageNavigatorHelper.goToShelfFromLogin(ebookContext.getUser());
                });
                ebookContext.setBinPath(Config.binPath);
                break;
            default :
        }
    }

    LoginMgr.prototype.showTips = function (tips) {
        hideLoading();
        this.DOM.loginTip.html(tips).css("visibility", "visible");
    };

    LoginMgr.prototype.getOauthList = function (tips) {
        var _self = this;
        var httpurl = AppRemoteSvcCfg.getOauthList;
        var msgJson = {
            url: httpurl
        };
        shellcmd.postHttpRequest(msgJson).done(function (ret) {
            if (ret.length > 0) {
                ret = JSON.parse(ret);

                console.log(ret);
                var j = 0;
                var int = 1;
                var tr = $('<tr></tr>');
                var intSize = ret.size;
                for (var i in ret) {
                    if (i != 'size') {
                        if (j <= 3) {
                            j++
                        }
                        if (j > 3) {
                            _self.DOM.oauthList_main_tr.append(tr);
                            tr = $('<tr></tr>');
                            j = 0;
                        }
                        var a = '<td><a style="width: 73px;cursor: pointer;"  url="' + ret[i].login_url + '">' + ret[i].appName + '</a></td>';
                        tr.append(a);

                        /**
                         * 说实话，这种把地址扔在服务端的做法，我也不知好不好
                         * 但我觉得，弊大于利
                         */
                        if (ret[i].appName == AppVersionCfg.Name) {
                            AppVersionCfg.otherLoginUrl = ret[i].login_url;
                        }

                        if (int >= intSize) {
                            var a = '<td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>';
                            tr.append(a);
                            _self.DOM.oauthList_main_tr.append(tr);
                        }
                        int++;
                    }
                }
                _self.DOM.oauthList_main_tr.find("a").click(function () {
                    _self.thirdlogin($(this).attr("url"), $(this).html());
                })
            } else {
                _self.DOM.oauthList_btn.hide();
            }
        })
    }

    function clearCookie() {
        var keys = document.cookie.match(/[^ =;]+(?=\=)/g);
        if (keys) {
            for (var i = keys.length; i--;)
                document.cookie = keys[i] + '=0;expires=' + new Date(0).toUTCString()
        }
    }

    LoginMgr.prototype.thirdlogin = function (url, urlname) {
        var _self = this;
        shellcmd.checkOnline().done(function (ret) {
            if (ret) {
                clearCookie();
                _self.DOM.loginPanel.hide();
                var solrLogin = require("./solrlogin").Instance;
                solrLogin.show(url, urlname);
            }
            else {
                showAlertTips(AppTips.NetWorkUnstable);
            }
        })
    }

    function showIFrame(url,iframe,panel,tab,mask){
        panel.show();

        mask.hide();
        panel.draggable({
            handle: "#" + tab.attr("id"),
            containment: "window",
            scroll : false,
            start: function () {
                mask.show();
            },
            stop: function () {
                mask.hide();
            }
        });

        //屏幕分辩率800*600时，才放缩UI面板
        if(panel.outerHeight() > screen.height || panel.outerWidth() > screen.width){
            panel.css('-webkit-transform','scale(0.8)');
        }

        console.log("chengyang : $(window).width(): " + $(window).width());
        console.log("chengyang : panel.outerWidth()" + panel.width());
        //居中显示
        panel.css({
            position: 'absolute',
            left: ($(window).width() - panel.outerWidth()) / 2,
            top: ($(window).height() - panel.outerHeight()) / 2 + $(document).scrollTop(),
            'z-index':9999
        });

        //设置网络连接异常DIV样式
        var marginTop = (panel.height() - tab.height()) / 2;
        var marginLeft = (panel.width() - 300) / 2;
        var tipsStyle = 'position: absolute;margin-top:{0}px;margin-left:{1}px'.format(marginTop,marginLeft);
        _commonfunc.online(url,iframe,tipsStyle,panel,'',ebookContext.getUser());
    };

    exports.Instance = new LoginMgr();
});
