﻿/**
 * Created with JetBrains WebStorm.
 * User: CHANG Weijun
 * Date: 13-8-1
 * Time: 下午2:40
 * To change this template use File | Settings | File Templates.
 *
 * 主要封装登录时，需要的一些辅助方法
 */
define(function (require, exports) {
    var _userinfoAccessor = require('./userinfoAccessor');
    var _path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');

    /**
     * 联网用户登陆
     * @param account
     * @param password
     * @returns {{}}   statusCode 0=登陆成功 1=登陆失败  2=未激活
     */
    function callUserLogin(account, password) {
        var httpurl = AppRemoteSvcCfg.UserLoginUrl;
        var msgJson = {
            url: httpurl,
            account: account,
            pwd: password,
            version: AppCfg.version,
            product: AppCfg.product,
            evt: 'tryonlinelogin'
        };
        var msg = JSON.stringify(msgJson);
        console.log(msg);
        _shellcmd.asynLogin(msg);
    }

    /**
     * 用户登陆，用AJAX
     * @param account
     * @param password
     * @returns {*}
     */
    function userLogin(account, password) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.UserLoginUrl;
        var msgJson = {
            url: httpurl,
            account: account,
            pwd: password
        };
        _shellcmd.postHttpRequest(msgJson).done(function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    this.userLicDataConverter = function (dataReceived) {
        console.log("下载用户LIC:" + dataReceived);
        var retObj = {};
        retObj.statusCode = -1;
        retObj.data = '';
        if (dataReceived == null || dataReceived == "") {
            retObj.statusCode = -1;
            return   retObj
        }
        var jsonReceived = null;
        try {
            jsonReceived = JSON.parse(dataReceived);
            retObj.statusCode = parseInt(jsonReceived.statuscode);
            retObj.data = jsonReceived.license;
            return retObj;
        }
        catch (err) {
            console.log("下载用户License返回数据无法解析");
            retObj.statusCode = -1;
        }
    };

    this.userBindDataConverter = function (dataReceived) {
        var retObj = {};
        retObj.statusCode = -1;
        retObj.data = {};
        if (dataReceived == null || dataReceived == "") { //验证失败
            retObj.statusCode = -1;
            return retObj;
        }
        var jsonReceived = null;
        try {
            jsonReceived = JSON.parse(dataReceived);
            retObj.statusCode = parseInt(jsonReceived.statuscode);
            return retObj;
        }
        catch (err) {
            console.log("用户绑定返回数据无法解析");
            retObj.statusCode = -1;
            return retObj;
        }
    };

    /**
     *
     * @param jsonReceived
     * @returns {{}}
     * @private
     */
    this.parseOnlineLoginData = function (jsonReceived) {
        var retObj = {};
        retObj.statusCode = -1;
        retObj.data = {};
        if (jsonReceived == null || jsonReceived == undefined) { //验证失败
            retObj.statusCode = -1;
            return retObj;
        }
        retObj.statusCode = parseInt(jsonReceived.statuscode);
        //登陆成功，拿到用户信息
        if (retObj.statusCode == 0) {
            retObj.data.userAccount = jsonReceived.userinfo.userAccount;
            retObj.data.userEmail = jsonReceived.userinfo.email;
            retObj.data.userPhone = jsonReceived.userinfo.phoneNum;
            retObj.data.ticket = jsonReceived.ticket;
            retObj.data.name = jsonReceived.userinfo.name;
            retObj.data.id = jsonReceived.userinfo.id;
            retObj.data.photo = jsonReceived.userinfo.photo;
            retObj.data.isSuccess = jsonReceived.userinfo.isSuccess;
        }
        console.log("用户登陆返回数据转化结果：" + JSON.stringify(retObj));
        return retObj;
    }

    /**
     * 判断绑定状态
     * @param account
     * @param hdInfo
     * @param hdType
     * @returns {{}} statusCode 0=允许绑定 1=授权已满  2=该硬件授权已绑  3=获取授权信息失败
     */
    function callCheckBind(account, hdInfo, hdType, hdName) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.UserCheckBindUrl;
        var msgJson = {
            url: httpurl,
            account: account,
            hardware: hdInfo,
            hdtype: hdType,
            machinename: hdName
        };

        _shellcmd.postHttpRequest(msgJson).done(function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 绑定用户
     * @param account
     * @param hdInfo
     * @param hdType
     * @param hdName
     * @returns {{}}  statusCode 0=绑定成功 1=绑定失败
     */
    function callBindUser(account, hdInfo, hdType, hdName) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.UserBindUrl;
        var msgJson = {
            url: httpurl,
            account: account,
            hardware: hdInfo,
            machinename: hdName,
            hdtype: hdType
        };

        _shellcmd.postHttpRequest(msgJson).done(function (ret) {
            def.resolve(ret);
        });
        return def.promise();
    }

    /**
     * 获取用户授权文件
     * @param user
     * @param hdInfo
     * @param hdType
     * @returns {{}}
     */
    function callGetUserLicense(user, hdInfo, hdType) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.UserLicenseGetUrl;
        user.getPassword().done(function (pwd) {
            var msgJson = {
                url: httpurl,
                account: user.getName(),
                pwd: pwd,
                hardware: hdInfo,
                hdtype: hdType
            };
            _shellcmd.postHttpRequest(msgJson).done(function (ret) {
                def.resolve(ret);
            });
        })
        return def.promise();
    }

    /**
     * 获取用户授权文件--另外一个接口，朱晓伟那边有变动，不再踢下线
     * @param user
     * @param hdInfo
     * @param hdType
     * @returns {*}
     */
    function callGetNewUserLicense(user, hdInfo, hdType) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.UserLicenseGetNewUrl;
        user.getPassword().done(function (pwd) {
            var msgJson = {
                url: httpurl,
                account: user.getName(),
                pwd: pwd,
                hardware: hdInfo,
                hdtype: hdType
            };
            _shellcmd.postHttpRequest(msgJson).done(function (ret) {
                def.resolve(ret);
            });
        })
        return def.promise();
    }

    /**
     * 创建用户目录
     * @param folderName
     * @returns {boolean}成功返回true,否则返回false;
     */
    function createUserFolder(user) {
        var def = $.Deferred();
        var userFolderCreator = require('./userfoldercreator').Instance;
        userFolderCreator.setUser(user);
        var result = false;
        /***************************************************************************
         * 这里原本使用getUserBaseRelativePath进行检测，现在，我改做getUserBasePath
         * 我觉得相对路径的使用要慎重
         * 不知道能不能解决偶发性数据库被重置的问题
         *   ----------------   by  yczhu
         ***************************************************************************/
        _shellcmd.isDirExist(user.getUserBaseRelativePath()).done(function (isExist) {
            var logfile = _path.trimPosix( _path.join(Config.binPath,"/log/userfold.log"));
            var con = user.getUserBaseRelativePath() + "----" + isExist + "----" + new Date();
            //添加日志文件
            _shellcmd.savefileappent(con,logfile).done(function(){
                if (!isExist) {
                    userFolderCreator.createUserDir().done(function (ret) {
                        def.resolve(ret)
                    });
                } else {
                    def.resolve(true);
                }
            });

        });
        return def.promise();
    }

    /**
     * 向本地数据库添加用户信息
     * @param userInfo
     * @returns {boolean}
     */
    function addUserToLocalDb(userInfo, passwordData, rememberPasswordFlag) {
        var def = $.Deferred();
        var account = userInfo.userAccount;
        var email = userInfo.userEmail;
        var phone = userInfo.userPhone;
        var isActive = userInfo.isActive;
        var userName = userInfo.userName;
        _userinfoAccessor.getAccount(account).done(function (isAccountExist) {
            if (isAccountExist == null || isAccountExist == '' || isAccountExist == 0) {
                _userinfoAccessor.addAccount(account, email, phone, passwordData, rememberPasswordFlag, isActive, userName)
                    .done(function (ret) {
                        def.resolve(ret);
                    });
            } else {
                _userinfoAccessor.updateAccount(account, email, phone, passwordData, rememberPasswordFlag, isActive, userName)
                    .done(function (ret) {
                        def.resolve(ret);
                    });
            }
        });
        return def.promise();
    }

    /**
     * 检查授权文件是否存在
     * @returns 如果存在返回路径，不存在返回null
     */
    function checkUserLicenseExist(account) {
        var def = $.Deferred();
        checkUserFoldExist(account).done(function (isExist) {
            if (isExist) {
                var licensepath = "users/" + account + "/license.dat";
                _shellcmd.isFileExist(licensepath).done(function (isLicExist) {
                    def.resolve(isLicExist);
                });
            } else {
                def.resolve(isExist);
            }
        });
        return def.promise();
    }

    /**
     * 检查授权状态
     */
    function checkAuthorization(account, password, hardwareInfo) {
        var def = $.Deferred();
        checkUserLicenseExist(account).done(function (isExist) {
            if (isExist) {
                var licensepath = "users/" + account + "/license.dat";
                var msg = account + '|' + password + '|' + hardwareInfo + '|' + licensepath;
                console.log(msg);
                _shellcmd.checkLocalAuthorization(msg).done(function (ret) {
                    console.log(ret);
                    def.resolve(ret);
                });
            }
            else {
                def.resolve('-1');
            }
        });
        return def.promise();
    }

    function checkUserFoldExist(account) {
        var def = $.Deferred();
        var dir = "users/" + account;
        dir = _path.trimPosix(Config.binPath + dir);
        var ret = _shellcmd.isDirExist(dir).done(function (isExist) {
            def.resolve(isExist);
        });
        return def.promise();
    }

    /**
     * 将用户信息转化为用户Account
     * @param accountOrEmailOrPhone
     * @returns {*}
     */
    function getUserAccount(accountOrEmailOrPhone) {
        var def = $.Deferred();
        _userinfoAccessor.getAccount(accountOrEmailOrPhone).done(function (account) {
            def.resolve(account);
            console.log("getUserAccount:" + account);
        });
        return def.promise();
    }

    function getUserInfo(account) {
        var def = $.Deferred();
        _userinfoAccessor.getUserInfo(account).done(function (ret) {
            def.resolve(ret);
        })
        return def.promise();
    }

    function setNoWebLogin(account, flag) {
        var def = $.Deferred();
        _userinfoAccessor.updateAccount(account, "", "", "", flag, "").done(function (ret) {
            def.resolve(ret);
        })
        return def.promise();
    }

    /**
     * 验证U盘授权
     */
    function checkUAuthor(account, password, hardwareInfo, U) {
        var def = $.Deferred();
        checkULicExist(account, U).done(function (isExist) {
            if (isExist) {
                var licensepath = U + ":/iflybook_books/" + account + ".dat";
                var msg = account + '|' + password + '|' + hardwareInfo + '|' + licensepath;
                console.log(msg);
                _shellcmd.checkLocalAuthorization(msg).done(function (ret) {
                    console.log(ret);
                    def.resolve(ret);
                });
            }
            else {
                def.resolve('-1');
            }
        });
        return def.promise();
    }

    function checkULicExist(account, U) {
        var def = $.Deferred();
        var licensepath = U + ":/iflybook_books/" + account + ".dat";
        _shellcmd.isFileExist(licensepath).done(function (isLicExist) {
            def.resolve(isLicExist);
        });
        return def.promise();
    }

    /**
     * 获取U盘账户授权
     */
    function callGetUUserLic(name, p, hdInfo, hdType) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.UserLicenseGetNewUrl;
        var msgJson = {
            url: httpurl,
            account: name,
            pwd: p,
            hardware: hdInfo,
            hdtype: hdType
        };
        _shellcmd.postHttpRequest(msgJson).done(function (ret) {
            def.resolve(ret);
        });
    return def.promise();
    }


exports.parseOnlineLoginData = parseOnlineLoginData;
exports.callUserLogin = callUserLogin;
exports.callCheckBind = callCheckBind;
exports.createUserFolder = createUserFolder;

exports.checkUserLicenseExist = checkUserLicenseExist;
exports.checkAuthorization = checkAuthorization;
exports.addUserToLocalDb = addUserToLocalDb;
exports.callBindUser = callBindUser;
exports.getUserAccount = getUserAccount;
exports.callGetUserLicense = callGetUserLicense;
exports.callGetNewUserLicense = callGetNewUserLicense;
exports.checkUserFoldExist = checkUserFoldExist;
exports.userLicDataConverter = userLicDataConverter;
exports.userBindDataConverter = userBindDataConverter;
exports.userLogin = userLogin;
exports.getUserInfo = getUserInfo;
exports.setNoWebLogin = setNoWebLogin;
exports.checkUAuthor = checkUAuthor;
exports.callGetUUserLic = callGetUUserLic;
})
;