/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-22
 * Time: 上午9:51
 * 本地登录模块/离线登录
 */
;
define(function (require, exports) {

    var _loginAssistor = require('./loginAssistor');
    var result = require("./loginhelper").Result;
    var _shellcmd = require('../../common/shellcmd');

    function LocalLogin() {

    }

    LocalLogin.prototype.checkInfo = function (userAccount, password) {
        var def = $.Deferred();
        this.checkLocalInfo(userAccount, password).done(function(ret){
            def.resolve(ret);
        });
        return def.promise();
    }

    LocalLogin.prototype.checkLocalInfo = function (userAccount, password) {
        var defer = $.Deferred();
        _shellcmd.getHardwareInfo(userAccount).done(function (hdInfo) {
            //检查账号有效性
            _loginAssistor.checkAuthorization(userAccount, password, hdInfo).done(function (isValid) {
                console.log(isValid);
                switch (isValid) {
                    case '-2':
                        defer.resolve(result.LocalResult.accountForbidden);
                        break;
                    case '-1':
                        defer.resolve(result.LocalResult.noLicense);
                        break;
                    case '0':
                        defer.resolve(result.LocalResult.argumentImperfect);
                        break;
                    case '1':
                        defer.resolve(result.LocalResult.accountNotMatchPwd);
                        break;
                    case '2':
                        defer.resolve(result.LocalResult.accountNotMatchMachineCode);
                        break;
                    case '3':
                        defer.resolve(result.LocalResult.timeStampOver);
                        break;
                    case '4':
                            _loginAssistor.setNoWebLogin(userAccount, 1).done(function () {
                                defer.resolve(result.LocalResult.localSuccess);
                            });
                        break;
                    default:
                        defer.resolve(result.LocalResult.localFail);
                }
            });
        });
        return defer.promise();
    }

    exports.LocalLogin = LocalLogin;
});
