/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-21
 * Time: 下午1:56
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var _path = require('../../common/path');
    var result = require("./loginhelper").Result;
    var shellcmd = require("../../common/shellcmd");
    var ebookContext = require('../ebookcontext').Instance;
    var _loginAssistor = require('./loginAssistor');

    function CloudLogin() {

    }

    CloudLogin.prototype.beforeCheckInfo = function (account, pwd) {
        var _self = this;
        var def = $.Deferred();
        ebookContext.getClientToken().done(function (ret) {
            var logfile = _path.trimPosix(_path.join(Config.binPath, "/log/userfold.log"));
            var con = "getLoginToken ret :: " + ret + "----" + new Date() + "========";
            //添加日志文件
            shellcmd.savefileappent(con, logfile).done(function () {
                if (ret) {
                    _self.checkInfo(account, pwd).done(function (ret_1) {
                        def.resolve(ret_1);
                    });
                }
                else {
                    def.resolve(result.CloudResult.webError);
                }
            });
        });
        return def.promise();
    }

    CloudLogin.prototype.checkInfo = function (account, pwd) {
        var def = $.Deferred();
        var _self = this;
        _self.checkCloudInfo(account, pwd).done(function (ret1) {

            var logfile = _path.trimPosix(_path.join(Config.binPath, "/log/userfold.log"));
            var con = "checkCloudInfo :: " + ret1 + "----" + new Date();
            //添加日志文件
            shellcmd.savefileappent(con, logfile).done(function () {
                if (ret1 === result.CloudResult.accountPwdRight) {
                    //账号存在
                    _self.checkEshopInfo(ebookContext.getUser().getName(), pwd).done(function (ret2) {
                        con = "checkEshopInfo :: " + ret2 + "----" + new Date();
                        //添加日志文件
                        shellcmd.savefileappent(con, logfile).done(function () {
                            if (ret2 === result.CloudResult.isNormal) {
                                var curUser = ebookContext.getUser();
                                //可用
                                var userInfo = {
                                    userAccount: curUser.getName(),
                                    userEmail: curUser.getEmail(),
                                    userPhone: curUser.getPhoneNum(),
                                    isActive: curUser.getIsActive(),
                                    userName: curUser.getUserName()
                                }
                                shellcmd.desEncrpty(pwd, curUser.getName()).done(function (passwordData) {
                                    _loginAssistor.addUserToLocalDb(userInfo, passwordData, 1).done(function () {
                                        _self.checkBindInfo(ebookContext.getUser().getName(), pwd).done(function (ret3) {
                                            con = "checkEshopInfo :: " + ret3 + "----" + new Date();
                                            //添加日志文件
                                            shellcmd.savefileappent(con, logfile).done(function () {
                                                def.resolve(ret3);
                                            });
                                        });
                                    });
                                });
                            }
                            else {
                                def.resolve(ret2);
                            }
                        });
                    });
                }
                else {
                    def.resolve(ret1);
                }
            });

        });
        return def.promise();
    }

    CloudLogin.prototype.checkCloudInfo = function (account, pwd) {
        var def = $.Deferred();
        // 发送至Cloud验证
        var httpurl = AppRemoteSvcCfg.checkAccount + "&access_token=" + app_ClientToken + "&key=loginName&value=" + account + "&password=" + pwd;
        shellcmd.getHttpRequest(httpurl).done(function (ret1) {
            console.log(ret1);
            if (ret1) {
                var ret1Obj = ret1;
                var res = (ret1Obj.statusCode === 1) ? result.CloudResult.accountPwdRight : result.CloudResult.accountOrPwdWrong;
                if (ret1Obj.statusCode === 1) {
                    ebookContext.setBinPath(Config.binPath);
                    ebookContext.setUser(ret1Obj.userInfo.loginName, pwd);
                    ebookContext.setUserBaseInfo(ret1Obj.userInfo.id, ret1Obj.userInfo.email,
                        ret1Obj.userInfo.mobile, ret1Obj.userInfo.userName);
                    ret1Obj.userInfo.userExt && ebookContext.getUser().setProvince(ret1Obj.userInfo.userExt.provinceName);
                }
            }
            def.resolve(ret1 ? res : result.CloudResult.webError);
        });
        return def.promise();
    }

    CloudLogin.prototype.checkEshopInfo = function (account, pwd) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.isActive;
        var msgJson = {
            url: httpurl,
            loginName: account
        };
        shellcmd.postHttpRequest(msgJson).done(function (ret) {
            var retObj , _res;
            ret && (retObj = JSON.parse(ret));
            console.log(retObj ? retObj : ret);
            //返回[],新账号
            if (retObj instanceof Array && retObj.length == 0) {
                if (ebookContext.getUser().getPhoneNum()) {
                    ebookContext.getUser().setIsActive(true);
                }
                def.resolve(result.CloudResult.isNormal);
            }
            else {
                //返回对象，有值
                _res = retObj.isDelete === 1 ? result.CloudResult.isDeleOrOutDate : result.CloudResult.isNormal;
                var nowDate = new Date();
                var retDate = Date.parse(retObj.outDate);
                _res = (nowDate < retDate ) ? _res : result.CloudResult.isDeleOrOutDate;
                ebookContext.getUser().setIsActive(!!(retObj.isActive == 1));
            }
            def.resolve(ret ? _res : result.CloudResult.webError);
        });
        return def.promise();
    }

    CloudLogin.prototype.checkBindInfo = function (account, pwd) {
        var def = $.Deferred();
        var getHdTypeTask = shellcmd.getHardwareType();
        var getHdInfoTask = shellcmd.getHardwareInfo(account);
        var hdNameTask = shellcmd.getHardwareName();
        $.when(getHdTypeTask, getHdInfoTask, hdNameTask).done(function (hdType, hdInfo, hdName) {
            var httpurl = AppRemoteSvcCfg.checkBindandBind;
            var msgJson = {
                url: httpurl,
                account: account,
                hardware: hdInfo,
                machinename: hdName,
                hdtype: hdType,
                password: pwd
            };
            shellcmd.postHttpRequest(msgJson).done(function (ret) {
                var retResult = null;
                console.log(ret);
                var retObj = JSON.parse(ret);
                switch (parseInt(retObj.statuscode)) {
                    case 0:
                        retObj.userLoginName && (ebookContext.getUser().setUserLoginName(retObj.userLoginName));
                        retObj.userFrom && (ebookContext.getUser().setLoginFrom(retObj.userFrom));
                        retObj.ticket && (ebookContext.getUser().setSSOTicket(retObj.ticket));
                        if (retObj.bindcode == 0) retResult = result.CloudResult.bindSuccess;
                        if (retObj.bindcode == 1) retResult = result.CloudResult.bindFail;
                        break;
                    case 1:
                        retResult = result.CloudResult.canNotBind;
                        break;
                    case 2:
                        retResult = result.CloudResult.alreadyBind;
                        retObj.userLoginName && (ebookContext.getUser().setUserLoginName(retObj.userLoginName));
                        retObj.userFrom && (ebookContext.getUser().setLoginFrom(retObj.userFrom));
                        retObj.ticket && (ebookContext.getUser().setSSOTicket(retObj.ticket));
                        break;
                    case 3:
                        retResult = result.CloudResult.getBindMsgError;
                        break;
                }
                def.resolve(ret ? retResult : result.CloudResult.webError);
            });
        });
        return def.promise();
    }

    exports.CloudLogin = CloudLogin;
});
