/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-30
 * Time: 上午8:22
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    var ebookContext = require('../ebookcontext').Instance;
    var shellCmd = require("../../common/shellcmd");

    var left = ($(window).width() - 524) / 2;
    var top = ($(window).height() - 239) / 2;
    var phoneNum = '';
    var phoneflag = false;
    var phonecheckflag = false;

    function SimpleActive() {
        this.Dom = {};
        this.ready = false;

        this.phone1 = "";
        this.timer = null;
    }

    SimpleActive.prototype.init = function () {
        //初始化DOM
        phoneNum = ebookContext.getUser().getPhoneNum();
        var _self = this;
        //激活面板
        _self.Dom.activePanel = $($("#activeHtml")[0].innerHTML);
        _self.Dom.activePanel.appendTo("body");
        //发送验证码按钮
        _self.Dom.resendMsgBtn = $("#sResendMsgBtn");
        //验证码输入框
        _self.Dom.codeInput = $("#sCodeInput");
        //手机号输入框
        _self.Dom.phoneNum = $("#phoneNum");
        //右上角关闭按钮
        _self.Dom.closeActive = $("#closeActive");
        //激活按钮
        _self.Dom.sActive = $("#sActive");
        //提示信息
        _self.Dom.activeTips = $("#activeTips");
        //手机验证提示
        _self.Dom.phoneTips = $("#active_phoneTips");

        _self.Dom.activeBase = $("#activeBase");
        _self.Dom.activeSuccess = $("#activeSuccess");
        _self.Dom.activeClose = $("#activeClose");

        _self.bindEvent();
        _self.ready = true;
    }

    SimpleActive.prototype.show = function () {
        var _self = this;
        !_self.ready && _self.init();

        _self.showTips(RegActiveTips.initAcTips);
        //初始化界面
        _self.Dom.activePanel.css("top", top).css("left", left).show();
        _self.Dom.activeBase.show();
        _self.Dom.activeSuccess.hide();
        if (phoneNum != '' && phoneNum != null && phoneNum != 'null') {
            _self.Dom.phoneNum.val(phoneNum);
            _self.Dom.phoneNum.attr("disabled", true);
            phonecheckflag = true;
        } else {
            _self.Dom.phoneNum.val("");
            _self.Dom.phoneNum.attr("disabled", false);
        }
    }

    SimpleActive.prototype.close = function () {
        var _self = this;
        _self.Dom.activePanel.remove();
        _self.Dom = {};
        _self.ready = false;
    }

    SimpleActive.prototype.bindEvent = function () {
        var _self = this;

        _self.Dom.phoneNum.blur(function () {
            var regex = /^1[3|4|5|7|8][0-9]\d{8,8}$/;
            var phoneNumStr = _self.Dom.phoneNum.val();
            if (phoneNumStr == "") {
                //提示不能为空
                _self.Dom.phoneTips.html(RegActiveTips.NotBeNull).show();
                _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
                phonecheckflag = false;
            } else if (regex.exec(phoneNumStr) == null) {
                //提示输入不正确
                _self.Dom.phoneTips.html(RegActiveTips.InputError).show();
                _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
                phonecheckflag = false;
            } else {
                ebookContext.getClientToken().done(function (ret) {
                    var url = AppRemoteSvcCfg.regCheckPhoneNumber + phoneNumStr + "&access_token=" + app_ClientToken;
                    shellCmd.getHttpRequest(url).done(function ($exist) {
                        if ($exist) {
                            if ($exist.return == "true") {
                                _self.Dom.phoneTips.html(RegActiveTips.PhoneExist).show();
                                _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
                                phonecheckflag = false;
                            } else {
                                _self.Dom.phoneTips.html("").show();
                                _self.Dom.phoneTips.prev().attr("class", "tips_ic_right").show()
                                phonecheckflag = true;
                            }
                        }
                    });
                });
            }
        });

        _self.Dom.closeActive.click(function () {
            _self.close();
        });

        _self.Dom.activeClose.click(function () {
            _self.close();
        });

        _self.Dom.resendMsgBtn.click(function () {
            var regex = /^1[3|4|5|7|8][0-9]\d{8,8}$/;
            var phoneNumStr = _self.Dom.phoneNum.val();
            //Caution : 这块只有在手机号验证成功后才会进入
            //导致有些时候需要单击两次按钮
            if (!(phoneNumStr == "" || phoneNumStr == RegActiveTips.phoneNum) && !(regex.exec(phoneNumStr) == null) && phonecheckflag) {
                _self.Dom.resendMsgBtn.attr("disabled", true);
                _self.Dom.resendMsgBtn.css('cursor', 'default');
                _self.Dom.resendMsgBtn.html(AppCfg.reSendMsg + RegActiveTips.ReSendLater);
                _self.reSendActiveCountTime(AppCfg.reSendMsg);
                _self.Dom.phoneTips.html("").show();
                _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").hide();

                _self.phone1 = phoneNumStr;

                var url = AppRemoteSvcCfg.sendPhoneMsg;
                var obj = {
                    phoneNum : phoneNumStr,
                    timeout: 30000, //设置超时
                    dataType: "json"
                }

                shellCmd.getHttpRequest(url,obj).done(function($active){
                    console.log($active);
                    if($active){
                        if ($active.errorCode == 0) {
                            phoneflag = true;

                        }
                    }
                });

            } else if (phoneNumStr == "") {
                _self.Dom.phoneTips.html(RegActiveTips.NotBeNull).show();
                _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
            } else if (regex.exec(phoneNumStr) == null) {
                _self.Dom.phoneTips.html(RegActiveTips.InputError).show();
                _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
            }
        });

        _self.Dom.sActive.click(function () {
            //这块估计是想防止验证号被删除  ----  by  yczhu  （不是我写的）
            if (phoneflag && _self.Dom.codeInput.val() != "") {
                phoneflag = true;
            } else {
                phoneflag = false;
            }
            _self.regCheckActiveCode();
        });

    }

    SimpleActive.prototype.regCheckActiveCode = function (regWantActive) {
        var _self = this;
        _self.goToActive(ebookContext.getUser().getName(), _self.Dom.codeInput.val(), "", _self.Dom.phoneNum.val());

    }

    //手机号验证
    SimpleActive.prototype.regCheckPhoneNumber = function (regCheckStr) {
        var _self = this;
        var regex = /^1[3|4|5|7|8][0-9]\d{8,8}$/;
        if (regCheckStr == "") {
            //提示不能为空
            _self.Dom.phoneTips.html(RegActiveTips.NotBeNull).show();
            _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
        } else if (regex.exec(regCheckStr) == null) {
            //提示输入不正确
            _self.Dom.phoneTips.html(RegActiveTips.InputError).show();
            _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").show();
        } else {
            _self.Dom.phoneTips.html("").show();
            _self.Dom.phoneTips.prev().attr("class", "tips_ic_error").hide();
            _self.goToPhoneActive(ebookContext.getUser().getName(), _self.Dom.codeInput.val(), "", regCheckStr);
        }
    }

    SimpleActive.prototype.goToActive = function (regName, phoneCode, code, phoneNum) {
        var _self = this;
        if (phoneflag && phoneNum == _self.phone1) {
            ebookContext.getUser().getPassword().done(function (password) {
                showLoading({tips: AppBlackBoardTipsList.Active});
                var msgJson = {
                    url: AppRemoteSvcCfg.simpleActive,
                    regName: regName,
                    phoneCode: phoneCode,
                    code: code,
                    phoneNum: phoneNum,
                    password: password
                };
                shellCmd.postHttpRequest(msgJson).done(function ($register) {
                    hideLoading();
                    $register = JSON.parse($register);
                    _self.stopTimer(false);
                    //此处添加激活后的提示
                    if ($register.errorCode == 0) {
                        //验证激活码成功
                        ebookContext.getUser().setIsActive(true);

                        //这儿要给提示！！！！
                    //    $("#active_wrap_c").empty().append("<div style='height:175px;text-align: center;font-size: 25px'>激活成功</div>");

                        _self.Dom.activeBase.hide();
                        _self.Dom.activeSuccess.show();
                        ebookContext.getUser().getPointsThenSet();
                        $("#okAccount").show(),$("#inAccount").hide();
                        $(".btn_login_warp").hide();
                    }
                    _self.showTips($register.errorInfo);
                });
            });
        } else {
            _self.showTips(RegActiveTips.inputCode);
        }
    }


    //重新发送激活码计时器
    SimpleActive.prototype.reSendActiveCountTime = function (tempTime) {
        var _self = this;
        var tempTimeNext;
        if (_self.Dom.resendMsgBtn) {
            if (tempTime < 2) {
                _self.stopTimer(false);
            }
            else {
                tempTimeNext = tempTime - 1;
                _self.Dom.resendMsgBtn.html(tempTimeNext + "秒后重新发送");

                _self.timer = setTimeout(function () {
                    _self.reSendActiveCountTime(tempTimeNext)
                }, 1000);
            }
        }
    }

    SimpleActive.prototype.stopTimer = function(boolFlag){
        var _self = this;
        _self.Dom.resendMsgBtn.show().html("重新发送").attr("disabled", boolFlag).css('cursor', 'pointer');
        clearInterval(_self.timer);
    }

    SimpleActive.prototype.showTips = function(tips){
        var _self = this;
        _self.Dom.activeTips.html(tips);
    }

    exports.Instance = new SimpleActive();
});
